/*  
   xmms-sid - SIDPlay input plugin for X MultiMedia System (XMMS)

   Main header file

   Written by Matti "ccr" Hamalainen <mhamalai@ratol.fi>
   (few bits may still be by Willem Monsuwe)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 #define DEBUG
*/

#ifndef _XMMS_SID_H
#define _XMMS_SID_H

#ifdef __cplusplus
extern "C" {
#endif

#include <glib.h>
#include <xmms/plugin.h>

extern InputPlugin xmms_sid_ip;

/*
 *	Configuration structure
 */
#define XMMS_SID_CONFIG_IDENT		"XMMS-SID"
#define XMMS_SID_BUFSIZE		4096
#define XMMS_SID_NAME			"xmms-sid"

#define XMMS_SID_CHN_MONO		0
#define XMMS_SID_CHN_STEREO		1
#define XMMS_SID_CHN_AUTOPAN		2

#define XMMS_SID_CLOCK_PAL		1
#define XMMS_SID_CLOCK_NTSC		2

#define XMMS_SID_DEFAULT_FILTERFS	400.0
#define XMMS_SID_DEFAULT_FILTERFM	60.0
#define XMMS_SID_DEFAULT_FILTERFT	0.05

#define XMMS_SID_MPU_BANK_SWITCHING		1
#define XMMS_SID_MPU_TRANSPARENT_ROM		2
#define XMMS_SID_MPU_PLAYSID_ENVIRONMENT	3

extern struct T_sid_cfg {
	gint bitsPerSample;
	gint channels;
	gint frequency;
	gboolean mos8580;
	gboolean emulateFilter;
	gfloat filterFs;
	gfloat filterFm;
	gfloat filterFt;
	gint memoryMode;
	gint clockSpeed;
	gboolean forceSpeed;
	gboolean detectMagic;
	gboolean usestil;
	gchar *stilpath;
	gchar *fileInfo;
} xs_cfg;


/*
 *	Configuration specific stuff
 */
enum {
	ATYPE_INT = 1,
	ATYPE_FLOAT,
	ATYPE_STR,
	ATYPE_BOOL
};


typedef struct {
	int	atype;
	void	*adata;
	gchar	*aname;
} T_sid_cfg_entry;


/*
 *	General plugin function prototypes
 */
void	xs_init(void);
int	xs_is_our_file(char *);
void	xs_play_file(char *);
void	xs_stop(void);
void	xs_pause(short);
void	xs_seek(int);
int	xs_get_time(void);
void	xs_get_song_info(char *, char **, int *);
void	xs_file_info_box(char *);
void	xs_configure(void);
void	xs_get_configure(void);
void	xs_aboutbox(void);
int	xs_stil_get(gchar *);

int	xs_strcalloc(gchar **, gchar *);
void	xs_stil_clear(void);

/*
 *	STIL information specific
 */
#define XMMS_SID_STIL_MAXENTRY	64

typedef struct {
	gchar *title;
	gchar *name;
	gchar *artist;
	gchar *comment;
} T_sid_stil_subtune;


extern struct T_sid_stil_info {
	T_sid_stil_subtune subtune[XMMS_SID_STIL_MAXENTRY];	
} xs_stil_info;


/*
 * Debugging and error handling macros
 */
#ifdef DEBUG
#define XSDEBUG(x...) { fprintf(stderr, "XSDEBUG [%s:%d]: ", __FILE__, (int) __LINE__); fprintf(stderr, ## x); }
#else
#define XSDEBUG(x...) /* foo */
#endif

#define XSERR(x...) { fprintf(stderr, XMMS_SID_NAME ": "); fprintf(stderr, ## x); }


#ifdef __cplusplus
}
#endif
#endif /* _XMMS_SID_H */
