#ifndef radio_h
#define radio_h

#define APPNAME "xmradio"
#define APPCLASS "XMradio"
#define APPTITLE "xmradio"
#define APPVERSION "1.2"

#define SAMPLEFMT   AFMT_S16_LE
#define SAMPLENUMCH 0
#define SAMPLESPEED 11025
// #define SAMPLESPEED 22050
#define REFRESHRATE 25

#define MINFREQ 8750
#define MAXFREQ 10800 
//#define MINFREQ 0
//#define MAXFREQ 90000
#define FREQSTEP 5

#define UP   1 
#define DOWN -1

typedef struct
{
 char **name;
 int *freq;
 int *def;
 int cnt;
} Stations;

/* station list */
extern Stations station;
extern const char *global_station_name;

typedef struct 
{
 int *pos; /* positions in station.freq */
 int cnt;    
} StationButtons;

/* station button list */
extern StationButtons station_buttons;

#define BUF_SIZE 8192 
signed short audio_buffer[BUF_SIZE];

typedef struct
{
 int format, stereo, speed, bufsize, bps;
 void (*func)();
} sampleStruct;

int SetMute(int on);
int SetFrequency(int);
int SampleStart(sampleStruct *ss);
int SampleEnd();
Boolean Sample();
void SkinToWidgets(Widget w, Pixmap skin);
void AddTooltipsToWidgets();
void UpdateTitle();
void SortStationList();
void MakeStationButtonWidgets(int realize);
void GeneratePopupMenu(int realize);
void SaveRCFile();
void SeekChannel(int direction);
void lcdDisconnectCB(const char *reason);
void version_check(int result, char *description);
void version_enable_button(int onoff);

Display *dpy;
GC gc;
Widget toplevel;
Cursor workingCursor;
Pixmap icon_pm, icon_pm_mask;
Pixel fg;
int debug;

extern const char *global_station_name;
int frequency;

#ifdef HAS_XPM
Pixmap skin;
#endif

#endif /* radio_h */
