.\" $XConsortium: xinit.man,v 1.18 91/07/31 18:48:25 gildea Exp $
.TH XINIT 1 "Release 5" "X Version 11"
.SH NAME
xmxinit \- X multiplexor initializer
.SH SYNOPSIS
.B xmxinit
[ [
.I client
]
.I options
] [
.B \-\^\-
[
.I multiplexor
] [
.I display
]
.I options
]
.SH DESCRIPTION
The \fIxmxinit\fP program is used to start an X multiplexor and a first
client program.
When this first client exits, 
\fIxmxinit\fP will kill the X multiplexor and then terminate.
.PP
If no specific client program is given on the command line,
\fIxmxinit\fP will look for a file in the user's home directory
called \fI.xmxinitrc\fP to run as a shell script to start up client programs.
If no such file exists, \fIxinit\fP will use the following as a default:
.sp
	xterm  \-geometry  +1+1  \-n  login  \-display  :0
.sp
.PP
If no specific multiplexor program is given on the command line,
\fIxmxinit\fP will look for a file in the user's home directory
called \fI.xmxserverrc\fP to run as a shell script to start up the
multiplexor.
If no such file exists, \fIxmxinit\fP uses the executable named by
the XMX environment variable.  If it is not set, \fIxmxinit\fP will use
the following as a default:
.sp
	xmx  :1
.sp
Note that this assumes that there is a program named \fIxmx\fP in the current
search path.
.PP
An important point is that programs which are run by \fI\.xmxinitrc\fP
should be run in the background if they do 
not exit right away, so that they don't prevent other programs from
starting up.
However, the last long-lived program started (usually
a window manager or terminal emulator) should be
left in the foreground so that the script won't exit (which
indicates that the user is done and that \fIxmxinit\fP should exit).
.PP
An alternate client and/or multiplexor may be specified on the
command line.  The desired client program and its arguments should be given
as the first command line arguments to \fIxmxinit\fP.  To specify a particular
multiplexor command line, append a double dash (\-\^\-) to the \fIxmxinit\fP
command line (after any client and arguments) followed by the desired
multiplexor command.
.PP
Both the client program name and the multiplexor program name must begin with
a slash (/) or a period (.).  Otherwise, they are treated as arguments to be
appended to their respective startup lines.  This makes it possible to 
add arguments (for example, foreground and background colors) without 
having to retype the whole command line.
.PP
If an explicit multiplexor name is not given and the first argument following
the double dash (\-\^\-) is a colon followed by a digit, \fIxmxinit\fP will
use that number as the display 
number instead of one.  All remaining arguments are appended to the multiplexor 
command line.
.PP
.SH EXAMPLES
Below are several examples of how command line arguments in \fIxmxinit\fP are
used.
.TP 8
.B "xmxinit"
This will start up a multiplexor named \fIxmx\fP and run the user's
\fI\.xmxinitrc\fP, if it exists, or else start an \fIxterm\fP.
.TP 8
.B "xmxinit \-\^\- /usr/local/bin/xmx2 :1"
This is how one could start a specific type of multiplexor on an alternate
display.
.TP 8
.B "xmxinit \-geometry =80x65+10+10 \-fn 8x13 \-j \-fg white \-bg navy"
This will start up a multiplexor named \fIxmx\fP, and will append the given
arguments to the default \fIxterm\fP command.  It will ignore \fI\.xmxinitrc\fP.
.TP 8
.B "xmxinit \-e widgets \-\^\- ./xmx \-debug pn"
This will use the command \fI\.\/xmx \-debug pn\fP to start the multiplexor
and will append the arguments \fI\-e widgets\fP to the default \fIxterm\fP
command.
.TP 8
.B "xmxinit /usr/ucb/rsh fasthost cpupig \-display ws:1 \-\^\-  :1 \-a 2 \-t 5"
This will start a multiplexor named \fIxmx\fP on display 1 with the arguments
\fI\-a 2 \-t 5\fP.  It will then start a remote shell on the machine
\fBfasthost\fP in which it will run the command \fIcpupig\fP, telling it
to display back on the local workstation.
.PP
Below is a sample \fI\.xmxinitrc\fP that starts a clock, a terminal,
a multiplexor session manager, and leaves the window manager running as
the ``last'' application.  Assuming that the window manager has been
configured properly, the user then chooses the ``Exit'' menu item to
shut down the session.
.sp
.in +8
.nf
xrdb \-load $HOME/.Xresources
xsetroot \-solid gray &
xclock \-g 50x50\-0+0 \-bw 0 &
xmtg \-g +0+0 &
xterm \-g 80x24+0\-0 &
twm
.fi
.in -8
.sp
.SH "ENVIRONMENT VARIABLES"
.TP 15
.B DISPLAY
This variable gets set to the name of the display to which clients should
connect.
.TP 15
.B XMX
This variable specifies the name of the X multiplexor to invoke, if none
is specified on the command line.  The default value is ``xmx''.
.TP 15
.B XMXINITRC
This variable specifies an init file containing shell commands to start up the
initial windows.  By default, \fI\.xmxinitrc\fP in the home directory will be 
used.
.SH FILES
.TP 15
.I .xmxinitrc
default client script
.TP 15
.I xterm
client to run if \fI.xmxinitrc\fP does not exist
.TP 15
.I .xmxserverrc
default multiplexor script
.TP 15
.I xmx
multiplexor to run if \fI.xmxserverrc\fP does not exist
.SH "SEE ALSO"
.IR X (1),
.IR xmx (1),
.IR Xserver (1),
.IR xterm (1)
.SH COPYRIGHT
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX\fP(1) for a full statement of rights and permissions.
.SH AUTHOR
Bob Scheifler, MIT Laboratory for Computer Science
.br
Modified from xinit source by John Bazik, Brown Univ Dept of Computer Science
