/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*  xmclib.h								*
*									*
*	Header file for the C language interface library to the		*
*	X Multiplexor Control Protocol (XMCP).				*
*									*
************************************************************************/
#ifndef XMCLIB_H
#define XMCLIB_H

#include <xmc.h>

#ifndef FUNCPROTO
#if __STDC__ || defined(__cplusplus) || defined(c_plusplus)
#define FUNCPROTO
#endif
#endif

/************************************************************************
*									*
*  Constants								*
*									*
************************************************************************/
/*
**	Options for XmcEventsQueued
*/
#define XmcQueuedAlready	0
#define XmcQueuedAfterFlush	1
#define XmcQueuedAfterReading	2

/************************************************************************
*									*
*  Macros								*
*									*
************************************************************************/
#define XmcFree(x)		free(x)
#define XmcConnectionNum(mux)	((mux)->fd)

#define DefaultTelepointer(mux)	((mux)->deftpID)
#define ConfigMode(mux)		((mux)->configMode)

/************************************************************************
*									*
*  Types								*
*									*
************************************************************************/
typedef unsigned long int XMCID;

typedef XMCID DispId;
typedef XMCID TptrId;
typedef unsigned long int Emask;
typedef unsigned long int PMask;

typedef unsigned long int XId;
typedef unsigned long int RegId;
typedef unsigned long int XEmask;

typedef struct {
   unsigned int		n;
   unsigned int		sz;
   char *		bp;
   char *		cp;
}XmcBuf;

typedef struct {
   int family;
   int length;
   char *address;
}XmcHostAddress;

typedef struct {
   unsigned short	namelen;
   char *		name;
   unsigned short	datalen;
   char *		data;
}XmcCookie;

typedef struct {
   int			mode;
   int			screen;
   int			display;
   int			family;
   int			addrlen;
   char *		addrp;
   char *		tag;
   TptrId		tpID;
   XId			window;
}XmcDispInfo;

typedef struct {
   int			depth;
   unsigned int		visualclass;
}XmcDepthType;

/*
**  This is the same as XColor.
*/
typedef struct {
   unsigned long pixel;
   unsigned short red, green, blue;
   unsigned char flags;
   char pad;
}XmcColor;

/************************************************************************
*									*
*  Event structures							*
*									*
************************************************************************/
typedef struct {
   int			type;
   unsigned long	serial;
   DispId		id;
}XmcDisplayIdEvent;

typedef XmcDisplayIdEvent	XmcDisplayInEvent;
typedef XmcDisplayIdEvent	XmcDisplayRefusedEvent;
typedef XmcDisplayIdEvent	XmcDisplayOutEvent;

typedef XmcDisplayIdEvent	XmcModeFloorEvent;
typedef XmcDisplayIdEvent	XmcModeSeatEvent;
typedef XmcDisplayIdEvent	XmcModeViewEvent;

typedef XmcDisplayIdEvent	XmcPointerGrabEvent;
typedef XmcDisplayIdEvent	XmcPointerNoGrabEvent;
typedef XmcDisplayIdEvent	XmcPointerUngrabEvent;
typedef XmcDisplayIdEvent	XmcKeyboardGrabEvent;
typedef XmcDisplayIdEvent	XmcKeyboardNoGrabEvent;
typedef XmcDisplayIdEvent	XmcKeyboardUngrabEvent;

typedef XmcDisplayIdEvent	XmcShareSelectionsEvent;
typedef XmcDisplayIdEvent	XmcUnshareSelectionsEvent;

typedef struct {
   int			type;
   unsigned long	serial;
   DispId		id;
   TptrId		tptrID;
}XmcTptrAssignEvent;

typedef struct {
   int			type;
   unsigned long	serial;
   TptrId		tptrID;
}XmcTptrIdEvent;

typedef XmcTptrIdEvent		XmcTptrShowEvent;
typedef XmcTptrIdEvent		XmcTptrHideEvent;

typedef struct {
   int			type;
   unsigned long	serial;
   int			mode;
}XmcConfigModeEvent;

typedef struct {
   int			type;
   unsigned long	serial;
   DispId		id;
   XId			window;
   XId			subwindow;
   unsigned long int	time;
   short int		x, y;
   short int		x_root, y_root;
   unsigned int		state;
   unsigned int		button;
}XmcButtonEvent;

typedef XmcButtonEvent XmcButtonPressedEvent;
typedef XmcButtonEvent XmcButtonReleasedEvent;

typedef struct {
   int			type;
   unsigned long	serial;
   DispId		id;
   XId			window;
   XId			subwindow;
   unsigned long int	time;
   short int		x, y;
   short int		x_root, y_root;
   unsigned int		state;
   unsigned int		keycode;
}XmcKeyEvent;

typedef XmcKeyEvent XmcKeyPressedEvent;
typedef XmcKeyEvent XmcKeyReleasedEvent;

typedef struct {
   int			type;
   unsigned long	serial;
   int			errorCode;
   int			opcode;
   unsigned long	data;
}XmcError;

typedef union {
   int			type;
   XmcDisplayIdEvent	display;
   XmcTptrAssignEvent	tptrassign;
   XmcTptrIdEvent	tptrvis;
   XmcConfigModeEvent	config;
   XmcKeyEvent		key;
   XmcButtonEvent	button;
   XmcError		error;
}XmcEvent;

typedef struct _XmcEventList {
   XmcEvent		event;
   struct _XmcEventList	*next;
}XmcEventList;

/*
**  A Mux is opaque to applications
*/
typedef struct {
   int			fd;
   char *		hostname;
   XmcBuf 		inbuf;
   XmcBuf 		outbuf;
   unsigned short int	outseqno;
   unsigned short int	inseqno;
   unsigned long int	base;
   unsigned long int	mask;
   int			configMode;
   int			shift;
   TptrId		deftpID;
   int			qlen;
   XmcEventList *	qhead;
   XmcEventList *	qtail;
}Mux;

typedef int (*XmcErrorHandler) (
#ifdef FUNCPROTO
   Mux *		/* mux */,
   XmcError *		/* ep */
#endif
);

typedef int (*XmcIOErrorHandler) (
#ifdef FUNCPROTO
   Mux *		/* mux */
#endif
);

/************************************************************************
*									*
*  Library functions							*
*									*
************************************************************************/
#ifdef FUNCPROTO

extern Mux *		XmcOpen(char *, XmcCookie *);
extern void		XmcClose(Mux *);
extern RegId		XmcRegister(Mux *, XmcHostAddress *, int, char *,
						char *, char *);
extern void		XmcUnregister(Mux *, RegId);
extern void		XmcSetAuth(Mux *, XmcCookie *, PMask);
extern int		XmcGetAuth(Mux *, XmcCookie *, PMask *);
extern DispId		XmcAddDisplay(Mux *, char *, XmcCookie *, char *,
						XId, int, char *, TptrId);
extern void		XmcSetDisplayTag(Mux *, DispId, char *);
extern XmcDispInfo *	XmcQueryDisplay(Mux *, DispId);
extern DispId *		XmcListDisplays(Mux *, int *);
extern void		XmcFreeDisplayList(DispId *);
extern DispId *		XmcListDisplaysWithInfo(Mux *, int *, XmcDispInfo **);
extern void		XmcFreeDisplayInfo(XmcDispInfo *, int);
extern void		XmcDropDisplay(Mux *, DispId);
extern int		XmcSync(Mux *);
extern void		XmcSetConfig(Mux *, unsigned int, unsigned int, int,
						XmcDepthType *, int, char **);
extern int		XmcGetConfig(Mux *, unsigned int *, unsigned int *,
				int *, XmcDepthType **, int *, char ***);
extern void		XmcSetConfigMode(Mux *, int);
extern void		XmcChangeInputMode(Mux *, DispId, int);
extern void		XmcSetEventMask(Mux *, Emask);
extern int		XmcGetEventMask(Mux *, Emask *);
extern void		XmcSetXEventMask(Mux *, XId, XEmask);
extern int		XmcGetXEventMask(Mux *, XId, XEmask *);
extern int		XmcEventsQueued(Mux *, int);
extern int		XmcGetEvent(Mux *, XmcEvent *);
extern void		XmcGrabPointer(Mux *, DispId);
extern void		XmcUngrabPointer(Mux *, DispId);
extern void		XmcGrabKeyboard(Mux *, DispId);
extern void		XmcUngrabKeyboard(Mux *, DispId);
extern void		XmcShareSelections(Mux *, DispId);
extern void		XmcUnshareSelections(Mux *, DispId);
extern void		XmcFlush(Mux *);
extern XmcErrorHandler	XmcSetErrorHandler(XmcErrorHandler);
extern XmcIOErrorHandler	XmcSetIOErrorHandler(XmcIOErrorHandler);
extern TptrId		XmcCreatePixmapTptr(Mux *, unsigned int, XId, XId,
					int, int, XmcColor *, XmcColor *);
extern TptrId		XmcCreateGlyphTptr(Mux *, unsigned int, XId, XId,
					unsigned int, unsigned int,
					XmcColor *, XmcColor *);
extern void		XmcDestroyTptr(Mux *, TptrId);
extern void		XmcAssignTptr(Mux *, DispId, TptrId);
extern void		XmcHideTptr(Mux *, TptrId);
extern void		XmcShowTptr(Mux *, TptrId);

#else

extern Mux *		XmcOpen();
extern void		XmcClose();
extern RegId		XmcRegister();
extern void		XmcUnregister();
extern void		XmcSetAuth();
extern int		XmcGetAuth();
extern DispId		XmcAddDisplay();
extern void		XmcSetDisplayTag();
extern XmcDispInfo *	XmcQueryDisplay();
extern DispId *		XmcListDisplays();
extern void		XmcFreeDisplayList();
extern DispId *		XmcListDisplaysWithInfo();
extern void		XmcFreeDisplayInfo();
extern void		XmcDropDisplay();
extern int		XmcSync();
extern void		XmcSetConfig();
extern int		XmcGetConfig();
extern void		XmcSetConfigMode();
extern void		XmcChangeInputMode();
extern void		XmcSetEventMask();
extern int		XmcGetEventMask();
extern void		XmcSetXEventMask();
extern int		XmcGetXEventMask();
extern int		XmcEventsQueued();
extern int		XmcGetEvent();
extern void		XmcGrabPointer();
extern void		XmcUngrabPointer();
extern void		XmcGrabKeyboard();
extern void		XmcUngrabKeyboard();
extern void		XmcShareSelections();
extern void		XmcUnshareSelections();
extern void		XmcFlush();
extern XmcErrorHandler	XmcSetErrorHandler();
extern XmcIOErrorHandler	XmcSetIOErrorHandler();
extern TptrId		XmcCreatePixmapTptr();
extern TptrId		XmcCreateGlyphTptr();
extern void		XmcDestroyTptr();
extern void		XmcAssignTptr();
extern void		XmcHideTptr();
extern void		XmcShowTptr();

#endif

#endif /* XMCLIB_H */
