/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

DispId
XmcAddDisplay
   AL((muxp, display, cookie, geom_str, window, mode, tag, tpId))
   DB Mux *muxp
   DD char *display
   DD XmcCookie *cookie
   DD char *geom_str
   DD XId window
   DD int mode
   DD char *tag
   DD TptrId tpId
   DE
{
   char *hostname;
   int taglen, geomlen, totlen;
   int dno, scrno, decnet;
   int family, length;
   char *address;
   char *cp;
   xmcAddDisplayReq *p;

   if (Xmc_parse_display(display, &hostname, &dno, &scrno, &decnet))
      return -1;

   if (hostname == 0 || strcmp(hostname, "unix") == 0) {
      if (hostname)
         free(hostname);
      hostname = Xmc_host_me();
   }
   if (Xmc_host_addr(hostname, &family, &length, &address))
      return -1;
   /*
   **  figure out the sizes of everything
   */
   taglen = tag ? strlen(tag) : 0;
   geomlen = geom_str ? strlen(geom_str) : 0;

   totlen = sz_xmcAddDisplayReq + length + taglen + geomlen;
   if (cookie)
      totlen += cookie->namelen + cookie->datalen;

   totlen += PAD(totlen);
   /*
   **  allocate and fill in the structure
   */
   p = (xmcAddDisplayReq *)Xmc_allocout(muxp, totlen);

   p->code = XMC_AddDisplay;
   p->mode = (CARD_8)mode;
   p->length = totlen;
   p->dispID = Xmc_newId(muxp);
   p->screen = scrno;
   p->family = family;
   p->configMode = muxp->configMode;
   p->nBytesAddress = length;
   p->displayNumber = dno;
   p->window = window;
   p->nBytesGeom = geomlen;
   p->nBytesTag = taglen;
   if (cookie) {
      p->nBytesName = cookie->namelen;
      p->nBytesData = cookie->datalen;
   }
   else {
      p->nBytesName = 0;
      p->nBytesData = 0;
   }
   p->tpID = tpId;

   cp = (char *)(p+1);
   /*
   **  add host address
   */
   bcopy(address, cp, length);
   cp += length;
   /*
   **  add geometry string, if given
   */
   if (geomlen) {
      bcopy(geom_str, cp, geomlen);
      cp += geomlen;
   }
   /*
   **  add tag if given
   */
   if (taglen) {
      bcopy(tag, cp, taglen);
      cp += taglen;
   }
   /*
   **  add cookie if given
   */
   if (cookie) {
      bcopy(cookie->name, cp, cookie->namelen);
      cp += cookie->namelen;
      bcopy(cookie->data, cp, cookie->datalen);
   }
   muxp->outseqno++;

   return p->dispID;
}
