/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <stdio.h>
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

#ifdef USE_STDARG
#include <stdarg.h>
#else
#include <varargs.h>
#endif

static FUNC(int, default_eh, (Mux *, XmcError *));
static FUNC(int, default_io_eh, (Mux *));

static XmcErrorHandler error_handler = default_eh;
static XmcIOErrorHandler io_error_handler = default_io_eh;

XmcErrorHandler
XmcSetErrorHandler
   AL((handler))
   DB XmcErrorHandler handler
   DE
{
   if (handler)
      error_handler = handler;
   else
      error_handler = default_eh;
}

XmcIOErrorHandler
XmcSetIOErrorHandler
   AL((handler))
   DB XmcIOErrorHandler handler
   DE
{
   if (handler)
      io_error_handler = handler;
   else
      io_error_handler = default_io_eh;
}

void
XmcGetErrorText
   AL((muxp, code, cp, len))
   DB Mux *muxp
   DD int code
   DD char *cp
   DD int len
   DE
{
}

/*VARARGS*/
void
warn
   VARARG((char *fstr, ...))
{
   VA1(pvar, char *,fstr);

   vfprintf(stderr, fstr, pvar);
}

void
Xmc_error
   AL((muxp, erp))
   DB Mux *muxp
   DD xmcError *erp
   DE
{
   XmcError error;

   error.type = erp->code;
   error.serial = Xmc_seq2serial(erp->seqNo);
   error.opcode = erp->opcode;
   error.errorCode = erp->errorCode;
   error.data = erp->data;

   (*error_handler)(muxp, &error);
}

void
Xmc_io_error
   AL((muxp))
   DB Mux *muxp
   DE
{
   (*io_error_handler)(muxp);
   exit(1);
}

static int
default_eh
   AL((muxp, ep))
   DB Mux *muxp
   DD XmcError *ep
   DE
{
   fprintf(stderr, "XMC Protocol Error:\n");
   fprintf(stderr, "\tcode %d\n", ep->errorCode);
   fprintf(stderr, "\trequest code %d\n", ep->opcode);
   fprintf(stderr, "\tdata 0x%08x\n", ep->data);
   exit(1);
}

static int
default_io_eh
   AL((muxp))
   DB Mux *muxp
   DE
{
   perror("io error");
}
