/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

DispId *
XmcListDisplays
   AL((muxp, ndisp))
   DB Mux *muxp
   DD int *ndisp
   DE
{
   register int sz;
   xmcListDisplaysReq *p;
   xmcListDisplaysReply *r;
   register DispId *dp;

   p = (xmcListDisplaysReq *)Xmc_allocout(muxp, sz_xmcListDisplaysReq);

   p->code = XMC_ListDisplays;
   p->length = sz_xmcListDisplaysReq;

   muxp->outseqno++;

   Xmc_flush(muxp);

   if ((r = (xmcListDisplaysReply *)Xmc_reply(muxp)) == 0)
      return 0;

   sz = r->length - sz_xmcListDisplaysReply;
   if (dp = (DispId *)malloc(sz)) {
      bcopy((char *)(r+1), (char *)dp, sz);
      *ndisp = r->nDisplays;
   }
   Xmc_inclear(muxp, r->length);
   return dp;
}
