/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

RegId
XmcRegister
   AL((muxp, host, port, name, url, about))
   DB Mux *muxp
   DD XmcHostAddress *host
   DD int port
   DD char *name
   DD char *url
   DD char *about
   DE
{
   register int namelen, urllen, desclen, totlen;
   register char *cp;
   xmcRegisterReq *p;
   static RegId regid;

   namelen = name ? strlen(name) : 0;
   urllen = url ? strlen(url) : 0;
   desclen = about ? strlen(about) : 0;

   totlen = sz_xmcRegisterReq + namelen + urllen + desclen;
   totlen += PAD(totlen);

   p = (xmcRegisterReq *)Xmc_allocout(muxp, totlen);

   p->code = XMC_Register;
   p->family = host->family;
   p->length = sz_xmcRegisterReq;
   p->regID = ++regid;
   p->port = port;
   p->nBytesAddress = host->length;
   p->nBytesName = namelen;
   p->nBytesURL = urllen;
   p->nBytesDesc = desclen;

   cp = (char *)(p + 1);
   if (namelen) {
      bcopy(name, cp, namelen);
      cp += namelen;
   }
   if (urllen) {
      bcopy(url, cp, urllen);
      cp += urllen;
   }
   if (desclen) {
      bcopy(about, cp, desclen);
      cp += desclen;
   }
   muxp->outseqno++;

   return regid;
}
