/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

void
XmcSetConfig
   AL((muxp, width, height, ndepthtypes, depthtypesp, nexts, extsp))
   DB Mux *muxp
   DD unsigned int width
   DD unsigned int height
   DD int ndepthtypes
   DD XmcDepthType *depthtypesp
   DD int nexts
   DD char **extsp
   DE
{
   register int i;
   register int len, totlen;
   xmcSetConfigReq *p;
   xmcDepthType *dtp;
   register char *cp;

   totlen = sz_xmcSetConfigReq;

   totlen += ndepthtypes * sz_xmcDepthType;

   for (i=0; i<nexts; i++)
      totlen += strlen(extsp[i]) + 1;

   totlen += PAD(totlen);

   p = (xmcSetConfigReq *)Xmc_allocout(muxp, totlen);

   p->code = XMC_SetConfig;
   p->length = sz_xmcSetConfigReq;
   p->nDepthTypes = ndepthtypes;
   p->nExtensions = nexts;

   dtp = (xmcDepthType *)(p + 1);

   for (i=0; i<ndepthtypes; i++) {
      dtp[i].depth = depthtypesp[i].depth;
      dtp[i].visualClass = depthtypesp[i].visualclass;
   }
   cp = (char *)&dtp[i];

   for (i=0; i<nexts; i++) {
      len = strlen(extsp[i]);
      *cp++ = len;
      bcopy(extsp[i], cp, len);
      cp += len;
   }
   muxp->outseqno++;
}
