.TH XMX LOCAL "6 May 1998"
.SH NAME
xmx  \- an X protocol multiplexor
.SH SYNOPSIS
.B xmx
[:displaynum] [-option ...]
.SH DESCRIPTION
Xmx is an X protocol multiplexor.  It lets users at different
locations share a single X Window System session in real time.
Xmx is a standalone program that works with existing, unmodified
X servers and X clients.
.PP
Xmx connects to X servers as a client, then accepts connections,
like an X server, from X clients.  Xmx presents a "virtual server"
to each client, and a "virtual client" to each server it talks to.
.PP
[More explanation needed here]
.SH "DISPLAYS"
Xmx always presents a single screen to clients, even when running
on multi-screen machines.  Explicitely specifying the screen
number of a display causes xmx to use only that screen of that display.
.PP
Xmx extends the normal syntax for specifying X displays in two
ways.  It is not necessary to specify the display number in a
display string, zero is assumed if only a hostname is given.
Xmx will optionally take over a window if its X id is appended
to the display string.  So, for instance, the display
.B blort:0.1.0x340000d
tells xmx to connect to hostname blort, display 0, screen 1 and
use the window whose id is 0x340000d as the virtual root window.
This is useful for applications that would like xmx to manage
one of their subwindows.
.SH "OPTIONS"
Xmx accepts all standard X11 server options, plus a few of its own.
Those options which actually do something are described below.  Running
xmx with the -help option lists all options, used and ignored.
.TP 8
.B :displaynum
Specifies the display number for which to be an X server.  This number
need not correspond to a real display - in fact it must not if a real
X server is running on the same machine.
.TP 8
.B \-af filename
Read command line arguments from filename.
.TP 8
.B \-auth path
Select authorization file.
.TP 8
.B \-bs
Disable any backing store support.
.TP 8
.B \-cc #
Sets the visual of root windows of color screens. (currently ignored)
.TP 8
.B \-co filename
Sets name of RGB color database.
.TP 8
.B \-ctp
Make the default telepointer constant, so that it does not assume the
images or colors of cursors assigned to the windows it tracks over.
.TP 8
.B \-dc
Delay calculation of virtual configuration.  Causes the server
config mode to initially be ConfigDelay.  Connections to servers
are initiated, but no virtual root windows are created until an XMC
client sets the config mode to ConfigAllow.
.TP 8
.B \-debug levels
Sets the debug message level.  Possible levels are:

.RS 8
1	trace incoming client X protocol
.br
2	trace outgoing virtual client X protocol
.br
3	trace incoming server X protocol
.br
4	trace outgoing virtual server X protocol
.br
a	trace access/authority operations
.br
A	trace server add operations
.br
b	trace buffer management operations
.br
c	trace chunk operations
.br
C	trace color operations
.br
d	trace protocol details
.br
e	print errors (default)
.br
E	trace exposure queue operations
.br
f	trace focus processing
.br
g	trace grab processing
.br
h	trace hash table operations
.br
i	trace image processing operations
.br
k	trace key and pointer mapping operations
.br
l	trace list operations
.br
m	trace pixel mapping
.br
n	trace networking operations
.br
p	trace all X protocol (same as 1234)
.br
P	painful tracing
.br
q	trace protocol to and from query server
.br
r	print 'soft' reply errors
.br
s	trace sequence number mapping operations
.br
S	trace selection processing
.br
t	trace request translation processing
.br
v	trace virtual configuration operations
.br
V	run internal verification checks
.br
w	trace byte swapping operations
.br
x	trace XMC protocol
.br
?	print the list of debug levels
.RE
.TP 8
.B \-display display...
Equivalent to -floor, but implies -nodpy.
.TP 8
.B \-dpi #
Sets the resolution of the screen in dots per inch.
.TP 8
.B \-floor disp...
The following displays will provide input to shared X clients.
See the discussion of displays, above.
.TP 8
.B \-geometry geom
Size and position of virtual root window.  Xmx extends the standard
X geometry syntax in several ways.  A horizontal or vertical size
may be expressed as a fraction of the screen size.  For example,
1/1x1/2 is a window that covers the full width of the screen, but
only half its height.  If the 'x' is left out of the screen size,
the value given is used for both width and height.
.IP
The location of the window may be expressed as 'c' for centered.
So the location +c+0 is centered horizontally at the top of the
screen.  If only one offset (positive, negative or 'c') is given,
it is used to postion the window both horizontally and vertically.
.IP
The default geometry is 23/40 (proportionally 1/3 of the screen
size, no position).
.TP 8
.B \-glob
Do hostname wildcarding.  Hostnames given on the command line that
contain wildcard characters (*?[]) are considered to be patterns and
are expanded to a list of all hostnames in the local machine's hosts
database that match.  The pattern matching rules are the same as for
filename globbing in csh(1).  This is useful for specifying a large number
of machines with similar names (e.g. lab01, lab02, etc., would be "lab??").
.TP 8
.B \-help
Print message with these options.
.TP 8
.B \-I
Ignore remaining command line arguments.
.TP 8
.B \-install
Bypass window manager and install colormaps.  Only use this if there
is no window manager or you know what you're doing.
.TP 8
.B \-mdpynum #
Display number on which to listen for XMC protocol.
.TP 8
.B \-maxcols #
Maximum number of colors to allocate in root colormap.
.TP 8
.B \-nodpy
Ignore DISPLAY environment variable.
.TP 8
.B \-notp
No default telepointer.
.TP 8
.B \-noresize
Don't allow resizing of virtual root windows.
.TP 8
.B \-noxmc
Don't listen for multiplexor control clients.
.TP 8
.B \-owncmap
Don't share default root colormaps.
.TP 8
.B \-quiet
Suppress information and warning messages.
.TP 8
.B \-sto #
Sets default server connection timeout in seconds.
.TP 8
.B \-su
Disables save under support.
.TP 8
.B \-seat disp...
Input events from the following displays are directed, via XMC events,
to X multiplexor clients that want them.
See the discussion of displays, above.
.TP 8
.B \-t #
Sets pointer acceleration threshold.
.TP 8
.B \-to #
Sets default client connection timeout in seconds.
.TP 8
.B \-wm
Forces default backing store to WhenMapped.
.TP 8
.B \-view disp...
Input events from the following displays are ignored.
See the discussion of displays, above.
.SH "SEE ALSO"
X(1), Xserver(1)
.SH "BUGS"
Fewer than before.
.SH "VERSION"
This page describes XMX Version 2.1 Alpha.
.SH "AUTHOR"
John Bazik
.br
jsb@cs.brown.edu
