/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   am.c								*
*									*
*	Mapping routines for atoms used by xmx when talking to the	*
*	X servers.  Because all these atoms are defined a priori,	*
*	there is no bounds checking done here.				*
*									*
*	All these atoms are defined in am.h.				*
*									*
************************************************************************/
#define AM_C

#include "xmx.h"
#include "am.h"
#include "incl/am.pvt.h"

/************************************************************************
*									*
*   am_alloc								*
*									*
************************************************************************/
atom_t *
am_alloc
   VOID
{
   atom_t *amp;

   if (MALLOC(amp, atom_t *, NUM_MAPPED_ATOMS * sizeof(atom_t *)))
      quit(-1, "am_alloc: fatal...\n");

   return amp;
}

/************************************************************************
*									*
*   am_free								*
*									*
************************************************************************/
void
am_free
   AL((amp))
   DB  atom_t *amp
   DE
{
   free(amp);
}

/************************************************************************
*									*
*   am_store								*
*									*
************************************************************************/
void
am_store
   AL((amp, local, remote))
   DB atom_t *amp
   DD atom_t local
   DD atom_t remote
   DE
{
   amp[local] = remote;
}

/************************************************************************
*									*
*   am_map								*
*									*
************************************************************************/
atom_t
am_map
   AL((amp, atom))
   DB atom_t *amp
   DD atom_t atom
   DE
{
   return amp[atom];
}

/************************************************************************
*									*
*   am_unmap								*
*									*
*	Not sure I'd ever actually need this.				*
*									*
************************************************************************/
atom_t
am_unmap
   AL((amp, atom))
   DB atom_t *amp
   DD atom_t atom
   DE
{
   register atom_t i;

   for (i=0; i<NUM_MAPPED_ATOMS; i++)
      if (amp[i] == atom)
         return i;
}
