/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   error.c								*
*									*
************************************************************************/
#include <stdio.h>
#include <errno.h>

#include "xmx.h"
#include "incl/error.pvt.h"

#ifdef USE_STDARG
#include <stdarg.h>
#else
#include <varargs.h>
#endif

extern int sys_nerr;
extern char *sys_errlist[];

extern uint_t debug;

/************************************************************************
*									*
*	warn - non-fatal error to stdout				*
*									*
************************************************************************/
/*VARARGS*/
void
warn
   VARARG((char *fstr, ...))
{
   VA1(pvar, char *,fstr);

   if (debug) vfprintf(stderr, fstr, pvar);
}

/************************************************************************
*									*
*	pwarn - non-fatal error to stdout				*
*									*
************************************************************************/
/*VARARGS*/
void
pwarn
   VARARG((char *fstr, ...))
{
   char *msg;
   VA1(pvar, char *,fstr);

   if (debug) {
      if (errno < 0 || errno > sys_nerr)
         msg = "unknown error";
      else
         msg = sys_errlist[errno];
      vfprintf(stderr, fstr, pvar);
      fprintf(stderr, ": %s\n", msg);
   }
}

/************************************************************************
*									*
*	quit - fatal error to stdout and abort				*
*									*
************************************************************************/
/*VARARGS*/
void
quit
   VARARG((int code, char *fstr, ...))
{
   VA2(pvar, int,code, char *,fstr);

   vfprintf(stderr, fstr, pvar);
   socket_cleanup();
#ifdef DEBUG
   abort();
#else
   exit(code);
#endif
}

/************************************************************************
*									*
*	err - non-fatal error to stdout return given value		*
*									*
************************************************************************/
/*VARARGS*/
int
err
   VARARG((int code, char *fstr, ...))
{
   VA2(pvar, int,code, char *,fstr);

   if (debug) vfprintf(stderr, fstr, pvar);
   return code;
}

/************************************************************************
*									*
*	pquit - fatal system error to stdout and abort			*
*									*
************************************************************************/
/*VARARGS*/
void
pquit
   VARARG((int code, char *fstr, ...))
{
   char *msg;
   VA2(pvar, int,code, char *,fstr);

   if (debug) {
      if (errno < 0 || errno > sys_nerr)
         msg = "unknown error";
      else
         msg = sys_errlist[errno];
      vfprintf(stderr, fstr, pvar);
      fprintf(stderr, ": %s\n", msg);
   }
   socket_cleanup();
#ifdef DEBUG
   abort();
#else
   exit(code);
#endif
}

/************************************************************************
*									*
*	perr - non-fatal system error to stdout and return given value	*
*									*
************************************************************************/
/*VARARGS*/
int
perr
   VARARG((int code, char *fstr, ...))
{
   char *msg;
   VA2(pvar, int,code, char *,fstr);

   if (debug) {
      if (errno < 0 || errno > sys_nerr)
         msg = "unknown error";
      else
         msg = sys_errlist[errno];
      vfprintf(stderr, fstr, pvar);
      fprintf(stderr, ": %s\n", msg);
   }
   return code;
}
