/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   kpm.h								*
*									*
*	Keyboard/pointer mapping module definitions.			*
*									*
************************************************************************/
#define FIRSTKEYCODE	8		/* these are X protocol invariants */
#define KEYCODESZ	256
#define MAXKEYCODES	(KEYCODESZ - FIRSTKEYCODE)
#define VKMAPINC	8		/* incr for alloc'ing the kmaps list */
#define NBUCKET		8		/* hash table bucket size */

/*
**  per server mapping information
*/
typedef struct _ktm_t {
   int		vkm;			/* index of virtual keymap */
   kcode_t	keymap[KEYCODESZ];	/* keycode-to-keycode map */
   u8_t		modmap[KEYCODESZ];	/* keycode-to-modmask map */
   int		butmapsz;		/* size of button map */
   u8_t *	butmap;			/* button-to-button map */
}ktm_xxx;	/* ktm_t defined in xmx.h */

/*
**  virtual kmap keycode ref entry
*/
typedef struct {
   u8_t		modmask;
   u8_t		refs;
}kref_t;

/*
**  keysym hash table entry
*/
typedef struct _khash_t {
   kcode_t		kc[NBUCKET];
   struct _khash_t *	next;
}khash_t;

/*
**  virtual keycode-keysym map
*/
typedef struct {
   int		maxref;			/* largest referenced keycode */
   int		minfree;		/* index of smallest free keycode */
   int		nfree;			/* number of free keycodes */
   int		modmapsz;		/* actual size of modmap */
   uint_t	nspc;			/* number of keysyms per keycode */
   uint_t	ncpm;			/* number of keycodes per modifier */
   ksym_t *	keymap;			/* the keyboard mapping */
   kcode_t *	modmap;			/* modifier mapping */
   kref_t	krefs[KEYCODESZ];	/* keycode refs & modmasks */
   khash_t 	khash[KEYCODESZ];
}kmap_t;
