/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   mitauth.c								*
*									*
*	Do that wacky mit magic cookie thing.				*
*									*
************************************************************************/
#include "xmx.h"
#include "incl/mitauth.pvt.h"

typedef struct _mit_t {
   char *		data;
   u16_t		len;
   struct _mit_t *	next;
}mit_t;

static mit_t *list;

int
mitauth_add
   AL((data, len))
   DB char *data
   DD u16_t len
   DE
{
   register mit_t *np;

   if (MALLOC(np, mit_t *, sizeof(mit_t)))
      return -1;

   if (MALLOC(np->data, char *, len))
      return -1;

   np->len = len;
   bcopy(data, np->data, len);
   np->next = list;
   list = np;

   return 0;
}

int
mitauth_check
   AL((data, len))
   DB char *data
   DD u16_t len
   DE
{
   register mit_t *np;

   for (np=list; np; np=np->next)
      if (len == np->len && bcmp(data, np->data, len) == 0)
         return 1;

   return 0;
}

int
mitauth_remove
   AL((data, len))
   DB char *data
   DD u16_t len
   DE
{
   register mit_t *np, *lp;

   lp = 0;
   for (np=list; np; np=np->next) {
      if (len == np->len && bcmp(data, np->data, len) == 0) {
         if (lp)
            lp->next = np->next;
         else
            list = np->next;
         free(np->data);
         free(np);
         return 0;
      }
      lp = np;
   }
   return -1;
}

int
mitauth_reset
   VOID
{
   register mit_t *np, *lp;

   for (lp=list; lp;) {
      np = lp->next;
      free(lp->data);
      free(lp);
      lp = np;
   }
   return 0;
}
