/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   plist.c								*
*									*
*	Generic pointer list type.					*
*									*
************************************************************************/
#include "xmx.h"
#include "incl/plist.pvt.h"

static plist_t *lfree;	/* plist_t free list */

/************************************************************************
*									*
*   plist_add								*
*									*
************************************************************************/
plist_t *
plist_add
   AL((olp, ptr))
   DB plist_t *olp
   DD void *ptr
   DE
{
   plist_t *lp;

   if (lfree) {
      lp = lfree;
      lfree = lfree->next;
   }
   else if (MALLOC(lp, plist_t *, sizeof(plist_t)))
      return 0;

   lp->ptr = ptr;
   lp->next = olp;

   return lp;
}


/************************************************************************
*									*
*   plist_find								*
*									*
************************************************************************/
int
plist_find
   AL((lp, ptr))
   DB plist_t *lp
   DD void *ptr
   DE
{
   for (; lp; lp=lp->next)
      if (lp->ptr == ptr)
         return 1;

   return 0;
}

/************************************************************************
*									*
*   plist_delete							*
*									*
************************************************************************/
plist_t *
plist_delete
   AL((lp, ptr, fp))
   DB plist_t *lp
   DD void *ptr
   DD int *fp
   DE
{
   plist_t *nlp, *llp;

   for (llp=0, nlp=lp; nlp; llp=nlp, nlp=nlp->next)
      if (nlp->ptr == ptr) {
         if (llp)
            llp->next = nlp->next;
         else
            lp = nlp->next;
         nlp->next = lfree;
         lfree = nlp;
         break;			/* loop exit */
      }
   if (fp)
      *fp = nlp ? 1 : 0;

   return lp;
}

/************************************************************************
*									*
*   plist_free								*
*									*
************************************************************************/
void
plist_free
   AL((lp))
   DB plist_t *lp
   DE
{
   plist_t *nlp;

   while (lp) {
      nlp = lp->next;
      lp->next = lfree;
      lfree = lp;
      lp = nlp;
   }
}

/************************************************************************
*									*
*   plist_free_freelist							*
*									*
************************************************************************/
void
plist_free_freelist
   VOID
{
   plist_t *llp, *lp;

   for (lp=lfree; llp=lp;) {
      lp = lp->next;
      free(llp);
   }
   lfree = 0;
}
