/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   res.h								*
*									*
*	Some structures not needed in quite so many places.		*
*									*
************************************************************************/

typedef struct _image_t {
   iord_t		iord;
   char *		data;
}image_t;

typedef struct _pixmap_t {
   drawable_t		dwb;		/* drawable info */
   rid_t		cid;
   rid_t		vid;
   u16_t		refs;
   u16_t		cached;		/* valid cache? */
   image_t *		imp;
   struct _pixmap_t *	next;
   struct _pixmap_t *	last;
}pixmap_xxx;	/* pixmap_t defined in xmx.h */

typedef struct _font_t {
   resource_t		res;
   rid_t		cid;
   rid_t		vid;
   u16_t		refs;
   u16_t		namelen;
   char *		name;
   struct _font_t *	last;
   struct _font_t *	next;
}font_xxx;	/* font_t defined in xmx.h */

typedef struct _gc_t {
   resource_t		res;		/* common block header */
   u8_t			depth;
   u16_t		refs;
   rid_t		cid;
   rid_t		vid;
   pixmap_t *		tilepxp;
   pixmap_t *		stipplepxp;
   pixmap_t *		clipmaskpxp;
   font_t *		fp;
   u32_t		atts[23];
   window_t *		wp;
   struct _gc_t *	next;
   struct _gc_t *	last;
}gc_t;

typedef struct _cursor_t {
   resource_t           res;		/* common block header */
   rid_t		cid;
   rid_t		vid;
   u16_t		foreRed, foreGreen, foreBlue;
   u16_t		backRed, backGreen, backBlue;
   u16_t		refs;
   u16_t		isglyph;
   union {
      struct {
         pixmap_t *	spxp;
         pixmap_t *	mpxp;
         u16_t		x, y;
      }pixmap;

      struct {
         font_t *	sfp;
         font_t *	mfp;
         u16_t		csrc;
         u16_t		cmsk;
      }glyph;
   }u;
   tpim_t *		tpimp;	/* telepointer image sources */
   struct _cursor_t *	next;
   struct _cursor_t *	last;
}cursor_xxx;	/* cursor_t defined in xmx.h */
