/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   shape.c								*
*									*
*	Implement the SHAPE extension.					*
*									*
************************************************************************/
#define NEED_EVENTS
#define NEED_REPLIES
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/extensions/shape.h>
#include "xmx.h"
#include "ptc.h"
#include "incl/shape.pvt.h"

/************************************************************************
*									*
*   shape_init								*
*									*
************************************************************************/
void
shape_init
   VOID
{
}

/************************************************************************
*									*
*   shape_init								*
*									*
************************************************************************/
int
shape_request_process
   AL((cp, rp, left))
   DB client_t *cp
   DD xReq *rp
   DD uint_t left
   DE
{
   switch (rp->data) {
      case X_ShapeQueryVersion:
         break;
      case X_ShapeRectangles:
         break;
      case X_ShapeMask:
         break;
      case X_ShapeCombine:
         break;
      case X_ShapeOffset:
         break;
      case X_ShapeQueryExtents:
         break;
      case X_ShapeSelectInput:
         break;
      case X_ShapeInputSelected:
         break;
      case X_ShapeGetRectangles:
         break;
   }
}

/************************************************************************
*									*
*   shape_gets_reply							*
*									*
************************************************************************/
int
shape_gets_reply
   AL((code))
   DB u16_t code
   DE
{
   switch (code) {
      case X_ShapeQueryVersion:
      case X_ShapeQueryExtents:
      case X_ShapeInputSelected:
      case X_ShapeGetRectangles:
         return 1;
      case X_ShapeRectangles:
      case X_ShapeMask:
      case X_ShapeCombine:
      case X_ShapeOffset:
      case X_ShapeSelectInput:
         return 0;
   }
   warn("shape_gets_reply: bad shape opcode [%d]\n", code);
   return 0;
}

/************************************************************************
*									*
*   shape_ptc								*
*									*
************************************************************************/
int
shape_ptc
   AL((op, sp, chp))
   DB op_extension_t *op
   DD server_t *sp
   DD chunk_t *chp
   DE
{
}

/************************************************************************
*									*
*   shape_event_mask							*
*									*
************************************************************************/
int
shape_event_mask
   VOID
{
}

/************************************************************************
*									*
*   shape_unmap_reply							*
*									*
************************************************************************/
int
shape_unmap_reply
   AL((bp, sp, code, seqno))
   DB buffer_t *bp
   DD server_t *sp
   DD u16_t code
   DD u16_t seqno
   DE
{
}

/************************************************************************
*									*
*   shape_ketchup							*
*									*
************************************************************************/
int
shape_ketchup
   VOID
{
}

/************************************************************************
*									*
*   shape_request_swap							*
*									*
************************************************************************/
int
shape_request_swap
   AL((rp, left))
   DB xReq *rp
   DD uint_t left
   DE
{
}

/************************************************************************
*									*
*   shape_error_swap							*
*									*
************************************************************************/
int
shape_error_swap
   AL((ep))
   DB xError *ep
   DE
{
}

/************************************************************************
*									*
*   shape_event_swap							*
*									*
************************************************************************/
int
shape_event_swap
   AL((ep))
   DB xEvent *ep
   DE
{
}

/************************************************************************
*									*
*   shape_reply_swap							*
*									*
************************************************************************/
int
shape_reply_swap
   AL((rp, code))
   DB xGenericReply *rp
   DD u16_t code
   DE
{
}
