/*******************************************************************************
*                                                                              *
* help_data.h --  Nirvana Editor help module data                              *
*                                                                              *
                 Generated on Feb 7, 2025 (Do NOT edit!)
                 Source of content from file help.etx
*                                                                              *
* Copyright (c) 1999-2025 Mark Edel                                            *
*                                                                              *
* This is free software; you can redistribute it and/or modify it under the    *
* terms of the GNU General Public License as published by the Free Software    *
* Foundation; either version 2 of the License, or (at your option) any later   *
* version.                                                                     *
*                                                                              *
* This software is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or        *
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License        *
* for more details.                                                            *
*                                                                              *
* In addition, as a special exception to the GNU GPL, the copyright holders    *
* give permission to link the code of this program with the Motif and Open     *
* Motif libraries (or with modified versions of these that use the same        *
* license), and distribute linked combinations including the two. You must     *
* obey the GNU General Public License in all respects for all of the code used *
* other than linking with Motif/Open Motif. If you modify this file, you may   *
* extend this exception to your version of the file, but you are not obligated *
* to do so. If you do not wish to do so, delete this exception statement from  *
* your version.                                                                *
*                                                                              *
* You should have received a copy of the GNU General Public License along with *
* software; if not, write to the Free Software Foundation, Inc., 59 Temple     *
* Place, Suite 330, Boston, MA  02111-1307 USA                                 *
*                                                                              *
* Nirvana Text Editor                                                          *
* September 10, 1991                                                           *
*                                                                              *
* Written by Mark Edel                                                         *
*                                                                              *
*******************************************************************************/

char *HelpTitles[] = {
    "Getting Started",
    "Selecting Text",
    "Finding and Replacing Text",
    "Cut and Paste",
    "Using the Mouse",
    "Keyboard Shortcuts",
    "Multi-cursor Editing",
    "Shifting and Filling",
    "Tabbed Editing",
    "File Format",
    "Programming with XNEdit",
    "Tab Stops/Emulated Tab Stops",
    "Auto/Smart Indent",
    "Syntax Highlighting",
    "Finding Declarations (ctags)",
    "Calltips",
    "Basic Regular Expression Syntax",
    "Metacharacters",
    "Parenthetical Constructs",
    "Advanced Topics",
    "Example Regular Expressions",
    "Shell Commands and Filters",
    "Input/Output Filters",
    "Learn/Replay",
    "Macro Language",
    "Macro Subroutines",
    "Rangesets",
    "Highlighting Information",
    "Action Routines",
    "Customizing XNEdit",
    "Preferences",
    "X Resources",
    "Key Binding",
    "Highlighting Patterns",
    "Smart Indent Macros",
    "XNEdit Command Line",
    "Client/Server Mode",
    "Crash Recovery",
    "Version",
    "License",
    "Support",
    "Problems/Defects",
    "Tabs Dialog",
    "Customize Window Title Dialog",
    NULL
};

static char * htxt_start [] = {
"\01IWelcome to XNEdit! ",
"\n\n",
"XNEdit is a standard GUI (Graphical User Interface) style text editor for ",
"programs and plain-text files.  Users of Macintosh and MS Windows based text ",
"editors should find XNEdit a familiar and comfortable environment.  XNEdit ",
"provides all of the standard menu, dialog, editing, and mouse support, as ",
"well as all of the standard shortcuts to which the users of modern GUI based ",
"environments are accustomed.  For users of older style Unix editors, welcome ",
"to the world of mouse-based editing! ",
"\n\n",
"Help sections of interest to new users are listed under the \"Basic Operation\" ",
"heading in the top-level Help menu: ",
"\n\n",
"\01A      \01QSelecting Text\01A\n",
"      \01QFinding and Replacing Text\01A\n",
"      \01QCut and Paste\01A\n",
"      \01QUsing the Mouse\01A\n",
"      \01QKeyboard Shortcuts\01A\n",
"      \01QShifting and Filling\01A\n",
"\01I\n",
"Programmers should also read the introductory section under the \"Features for ",
"Programming\" section: ",
"\n\n",
"\01A      \01QProgramming with XNEdit\01A\n",
"\01I\n",
"If you get into trouble, the Undo command in the Edit menu can reverse any ",
"modifications that you make.  XNEdit does not change the file you are editing ",
"until you tell it to Save. ",
"\n\n",
"\01REditing an Existing File\01I",
"\n\n",
"To open an existing file, choose Open... from the file menu. Select the file ",
"that you want to open in the pop-up dialog that appears and click on OK.  You ",
"may open any number of files at the same time.  Depending on your settings ",
"(cf. \"\01QTabbed Editing\01I\") each file can appear in its own editor window, or it ",
"can appear under a tab in the same editor window.  Using Open... rather than ",
"re-typing the XNEdit command and running additional copies of XNEdit, will give ",
"you quick access to all of the files you have open via the Windows menu, and ",
"ensure that you don't accidentally open the same file twice.  XNEdit has no ",
"\"main\" window.  It remains running as long as at least one editor window is ",
"open. ",
"\n\n",
"\01RCreating a New File\01I",
"\n\n",
"If you already have an empty (Untitled) window displayed, just begin typing ",
"in the window.  To create a new Untitled window, choose New Window or New Tab ",
"from the File menu.   To give the file a name and save its contents to the ",
"disk, choose Save or Save As... from the File menu. ",
"\n\n",
"\01RBackup Files\01I",
"\n\n",
"XNEdit maintains periodic backups of the file you are editing so that you can ",
"recover the file in the event of a problem such as a system crash, network ",
"failure, or X server crash.  These files are saved under the name `~filename`, ",
"where filename is the name of the file you were editing.  If an XNEdit process ",
"is killed, some of these backup files may remain in your directory.  (To ",
"remove one of these files on Unix, you may have to prefix the `~' (tilde) ",
"character with a (backslash) to prevent the shell from interpreting it as a ",
"special character.) ",
"\n\n",
"\01RShortcuts\01I",
"\n\n",
"As you become more familiar with XNEdit, substitute the control and function ",
"keys shown on the right side of the menus for pulling down menus with the ",
"mouse. ",
"\n\n",
"Dialogs are also streamlined so you can enter information quickly and without ",
"using the mouse*.  To move the keyboard focus around a dialog, use the tab ",
"and arrow keys.  One of the buttons in a dialog is usually drawn with a ",
"thick, indented, outline.  This button can be activated by pressing Return or ",
"Enter.  The Cancel or Dismiss button can be activated by pressing escape. ",
"For example, to replace the string \"thing\" with \"things\" type: ",
"\n\n",
"\01A      <ctrl-r>thing<tab>things<return>\n",
"\01I\n",
"To open a file named \"whole_earth.c\", type: ",
"\n\n",
"\01A      <ctrl-o>who<return>\n",
"\01I\n",
"(how much of the filename you need to type depends on the other files in the ",
"directory).  See the section called \"\01QKeyboard Shortcuts\01I\" for more details. ",
"\n\n",
"* Users who have set their keyboard focus mode to \"pointer\" should set ",
"\"Popups Under Pointer\" in the Default Settings menu to avoid the additional ",
"step of moving the mouse into the dialog. ",
NULL
};

static char * htxt_select [] = {
"\01IXNEdit has two general types of selections, primary (highlighted text), and ",
"secondary (underlined text). Selections can cover either a simple range of ",
"text between two points in the file, or they can cover a rectangular area of ",
"the file. Rectangular selections are only useful with non-proportional (fixed ",
"spacing) fonts. ",
"\n\n",
"To select text for copying, deleting, or replacing, press the left mouse ",
"button with the pointer at one end of the text you want to select, and drag ",
"it to the other end. The text will become highlighted. To select a whole ",
"word, double click (click twice quickly in succession). Double clicking and ",
"then dragging the mouse will select a number of words. Similarly, you can ",
"select a whole line or a number of lines by triple clicking or triple ",
"clicking and dragging. Quadruple clicking selects the whole file. After ",
"releasing the mouse button, you can still adjust a selection by holding down ",
"the shift key and dragging on either end of the selection. To delete the ",
"selected text, press delete or backspace. To replace it, begin typing. ",
"\n\n",
"To select a rectangle or column of text, hold the Ctrl key while dragging the ",
"mouse. Rectangular selections can be used in any context that normal ",
"selections can be used, including cutting and pasting, filling, shifting, ",
"dragging, and searching. Operations on rectangular selections automatically ",
"fill in tabs and spaces to maintain alignment of text within and to the right ",
"of the selection. Note that the interpretation of rectangular selections by ",
"Fill Paragraph is slightly different from that of other commands, the section ",
"titled \"\01QShifting and Filling\01I\" has details. ",
"\n\n",
"The middle mouse button can be used to make an additional selection (called ",
"the secondary selection). As soon as the button is released, the contents of ",
"this selection will be copied to the insert position of the window where the ",
"mouse was last clicked (the destination window). This position is marked by a ",
"caret shaped cursor when the mouse is outside of the destination window.  If ",
"there is a (primary) selection, adjacent to the cursor in the window, the new ",
"text will replace the selected text. Holding the shift key while making the ",
"secondary selection will move the text, deleting it at the site of the ",
"secondary selection, rather than copying it. ",
"\n\n",
"Selected text can also be dragged to a new location in the file using the ",
"middle mouse button. Holding the shift key while dragging the text will copy ",
"the selected text, leaving the original text in place. Holding the control ",
"key will drag the text in overlay mode. ",
"\n\n",
"Normally, dragging moves text by removing it from the selected position at ",
"the start of the drag, and inserting it at a new position relative to the ",
"mouse. Dragging a block of text over existing characters, displaces the ",
"characters to the end of the selection. In overlay mode, characters which are ",
"occluded by blocks of text being dragged are simply removed. When dragging ",
"non-rectangular selections, overlay mode also converts the selection to ",
"rectangular form, allowing it to be dragged outside of the bounds of the ",
"existing text. ",
"\n\n",
"The section \"\01QUsing the Mouse\01I\" summarizes the mouse commands for making primary ",
"and secondary selections. Primary selections can also be made via keyboard ",
"commands, see \"\01QKeyboard Shortcuts\01I\". ",
NULL
};

static char * htxt_search [] = {
"\01IThe Search menu contains a number of commands for finding and replacing text. ",
"\n\n",
"The Find... and Replace... commands present dialogs for entering text for ",
"searching and replacing.  These dialogs also allow you to choose whether you ",
"want the search to be sensitive to upper and lower case, or whether to use ",
"the standard Unix pattern matching characters (regular expressions). ",
"Searches begin at the current text insertion position. ",
"\n\n",
"Find Again and Replace Again repeat the last find or replace command without ",
"prompting for search strings.  To selectively replace text, use the two ",
"commands in combination: Find Again, then Replace Again if the highlighted ",
"string should be replaced, or Find Again again to go to the next string. ",
"\n\n",
"Find Selection searches for the text contained in the current primary ",
"selection (see \01QSelecting Text\01I).  The selected text does not have to be in the ",
"current editor window, it may even be in another program.  For example, if ",
"the word dog appears somewhere in a window on your screen, and you want to ",
"find it in the file you are editing, select the word dog by dragging the ",
"mouse across it, switch to your XNEdit window and choose Find Selection from ",
"the Search menu. ",
"\n\n",
"Find Incremental, which opens the interactive search bar, is yet another variation ",
"on searching, where every character typed triggers a new search.  After you've ",
"completed the search string, the next occurrence in the buffer is found by hitting ",
"the Return key, or by clicking on the icon to the left (magnifying glass). Holding ",
"a Shift key down finds the previous occurrences.  To the right there is a clear ",
"button with an icon resembling \"|<\". Clicking on it empties the search text widget ",
"without disturbing selections.  A middle click on the clear button copies the ",
"content of any existing selection into the search text widget and triggers a new ",
"search. ",
"\n\n",
"\01RSearching Backwards\01I",
"\n\n",
"Holding down the shift key while choosing any of the search or replace ",
"commands from the menu (or using the keyboard shortcut), will search in the ",
"reverse direction.  Users who have set the search direction using the buttons ",
"in the search dialog, may find it a bit confusing that Find Again and Replace ",
"Again don't continue in the same direction as the original search (for ",
"experienced users, consistency of the direction implied by the shift key is ",
"more important). ",
"\n\n",
"\01RSelective Replacement\01I",
"\n\n",
"To replace only some occurrences of a string within a file, choose Replace... ",
"from the Search menu, enter the string to search for and the string to ",
"substitute, and finish by pressing the Find button.  When the first ",
"occurrence is highlighted, use either Replace Again (^T) to replace it, or ",
"Find Again (^G) to move to the next occurrence without replacing it, and ",
"continue in such a manner through all occurrences of interest. ",
"\n\n",
"To replace all occurrences of a string within some range of text, select the ",
"range (see \01QSelecting Text\01I), choose Replace... from the Search menu, type the ",
"string to search for and the string to substitute, and press the \"R. in ",
"Selection\" button in the dialog.  Note that selecting text in the Replace... ",
"dialog will unselect the text in the window. ",
"\n\n",
"\01RReplacement in Multiple Documents\01I",
"\n\n",
"You can do the same replacement in more than one document at the same time. ",
"To do that, enter the search and replacement string in the replacement dialog ",
"as usual, then press the 'Multiple Documents...' button. XNEdit will open ",
"another dialog where you can pick any document in which the replacement should ",
"take place. Then press 'Replace' in this dialog to do the replacement. All ",
"attributes (Regular Expression, Case, etc.) are used as selected in the main ",
"dialog. ",
"\n\n",
NULL
};

static char * htxt_clipboard [] = {
"\01IThe easiest way to copy and move text around in your file or between windows, ",
"is to use the clipboard, an imaginary area that temporarily stores text and ",
"data.  The Cut command removes the selected text (see \01QSelecting Text\01I) from ",
"your file and places it in the clipboard.  Once text is in the clipboard, the ",
"Paste command will copy it to the insert position in the current window.  For ",
"example, to move some text from one place to another, select it by dragging ",
"the mouse over it, choose Cut to remove it, click the pointer to move the ",
"insert point where you want the text inserted, then choose Paste to insert ",
"it.  Copy copies text to the clipboard without deleting it from your file. ",
"You can also use the clipboard to transfer text to and from other Motif ",
"programs and X programs which make proper use of the clipboard. ",
"\n\n",
"There are many other methods for copying and moving text within XNEdit windows ",
"and between XNEdit and other programs.  The most common such method is ",
"clicking the middle mouse button to copy the primary selection (to the ",
"clicked position).  Copying the selection by clicking the middle mouse button ",
"in many cases is the only way to transfer data to and from many X programs. ",
"Holding the Shift key while clicking the middle mouse button moves the text, ",
"deleting it from its original position, rather than copying it.  Other ",
"methods for transferring text include secondary selections, primary selection ",
"dragging, keyboard-based selection copying, and drag and drop.  These are ",
"described in detail in the sections: \"\01QSelecting Text\01I\", \"\01QUsing the Mouse\01I\", ",
"and \"\01QKeyboard Shortcuts\01I\". ",
NULL
};

static char * htxt_mouse [] = {
"\01IMouse-based editing is what XNEdit is all about, and learning to use the more ",
"advanced features like secondary selections and primary selection dragging ",
"will be well worth your while. ",
"\n\n",
"If you don't have time to learn everything, you can get by adequately with ",
"just the left mouse button:  Clicking the left button moves the cursor. ",
"Dragging with the left button makes a selection.  Holding the shift key while ",
"clicking extends the existing selection, or begins a selection between the ",
"cursor and the mouse.  Double or triple clicking selects a whole word or a ",
"whole line. ",
"\n\n",
"This section will make more sense if you also read the section called, ",
"\"\01QSelecting Text\01I\", which explains the terminology of selections, that is, ",
"what is meant by primary, secondary, rectangular, etc. ",
"\n\n",
"\01RButton and Modifier Key Summary\01I",
"\n\n",
"General meaning of mouse buttons and modifier keys: ",
"\n\n",
"\01S  Buttons\01I",
"\n\n",
"\01A      Button 1 (left)    Cursor position and primary selection\n",
"\01I\n",
"\01A      Button 2 (middle)  Secondary selections, and dragging and\n",
"                         copying the primary selection\n",
"\01I\n",
"\01A      Button 3 (right)   Quick-access programmable menu and pan\n",
"                         scrolling\n",
"\01I\n",
"\01S  Modifier keys\01I",
"\n\n",
"\01A      Shift   On primary selections, (left mouse button):\n",
"                 Extends selection to the mouse pointer\n",
"              On secondary and copy operations, (middle):\n",
"                 Toggles between move and copy\n",
"\01I\n",
"\01A      Ctrl    Makes selection rectangular or insertion\n",
"              columnar\n",
"\01I\n",
"\01A      Alt*    (on release) Exchange primary and secondary\n",
"              selections.\n",
"\01I\n",
"\01RLeft Mouse Button\01I",
"\n\n",
"The left mouse button is used to position the cursor and to make primary ",
"selections. ",
"\n\n",
"\01A    Click         Moves the cursor\n",
"\01I\n",
"\01A    Double Click  Selects a whole word\n",
"\01I\n",
"\01A    Triple Click  Selects a whole line\n",
"\01I\n",
"\01A    Quad Click    Selects the whole file\n",
"\01I\n",
"\01A    Shift Click   Adjusts (extends or shrinks) the\n",
"                  selection, or if there is no existing\n",
"                  selection, begins a new selection\n",
"                  between the cursor and the mouse.\n",
"\01I\n",
"\01A    Ctrl+Shift+   Adjusts (extends or shrinks) the\n",
"    Click         selection rectangularly.\n",
"\01I\n",
"\01A    Drag          Selects text between where the mouse\n",
"                  was pressed and where it was released.\n",
"\01I\n",
"\01A    Ctrl+Drag     Selects rectangle between where the\n",
"                  mouse was pressed and where it was\n",
"                  released.\n",
"\01I\n",
"\01RRight Mouse Button\01I",
"\n\n",
"The right mouse button posts a programmable menu for frequently used commands. ",
"\n\n",
"\01A    Click/Drag    Pops up the background menu (programmed\n",
"                  from Preferences -> Default Settings ->\n",
"                  Customize Menus -> Window Background).\n",
"\01I\n",
"\01A    Ctrl+Drag     Pan scrolling.  Scrolls the window\n",
"                  both vertically and horizontally, as if\n",
"                  you had grabbed it with your mouse.\n",
"\01I\n",
"\01RMiddle Mouse Button\01I",
"\n\n",
"The middle mouse button is for making secondary selections, and copying and ",
"dragging the primary selection. ",
"\n\n",
"\01A    Click         Copies the primary selection to the\n",
"                  clicked position.\n",
"\01I\n",
"\01A    Shift+Click   Moves the primary selection to the\n",
"                  clicked position, deleting it from its\n",
"                  original position.\n",
"\01I\n",
"\01A    Drag          1) Outside of the primary selection:\n",
"                      Begins a secondary selection.\n",
"                  2) Inside of the primary selection:\n",
"                      Moves the selection by dragging.\n",
"\01I\n",
"\01A    Ctrl+Drag     1) Outside of the primary selection:\n",
"                      Begins a rectangular secondary\n",
"                      selection.\n",
"                  2) Inside of the primary selection:\n",
"                      Drags the selection in overlay\n",
"                      mode (see below).\n",
"\01I\n",
"When the mouse button is released after creating a secondary selection: ",
"\n\n",
"\01A    No Modifiers  If there is a primary selection,\n",
"                  replaces it with the secondary\n",
"                  selection.  Otherwise, inserts the\n",
"                  secondary selection at the cursor\n",
"                  position.\n",
"\01I\n",
"\01A    Shift         Move the secondary selection, deleting\n",
"                  it from its original position.  If\n",
"                  there is a primary selection, the move\n",
"                  will replace the primary selection\n",
"                  with the secondary selection.\n",
"                  Otherwise, moves the secondary\n",
"                  selection to the cursor position.\n",
"\01I\n",
"\01A    Alt*          Exchange the primary and secondary\n",
"                  selections.\n",
"\01I\n",
"While moving the primary selection by dragging with the middle mouse button: ",
"\n\n",
"\01A    Shift         Leaves a copy of the original\n",
"                  selection in place rather than\n",
"                  removing it or blanking the area.\n",
"\01I\n",
"\01A    Ctrl          Changes from insert mode to overlay\n",
"                  mode (see below).\n",
"\01I\n",
"\01A    Escape        Cancels drag in progress.\n",
"\01I\n",
"Overlay Mode: Normally, dragging moves text by removing it from the selected ",
"position at the start of the drag, and inserting it at a new position ",
"relative to the mouse. When you drag a block of text over existing ",
"characters, the existing characters are displaced to the end of the ",
"selection.  In overlay mode, characters which are occluded by blocks of text ",
"being dragged are simply removed.  When dragging non-rectangular selections, ",
"overlay mode also converts the selection to rectangular form, allowing it to ",
"be dragged outside of the bounds of the existing text. ",
"\n\n",
"Mouse buttons 4 and 5 are usually represented by a mouse wheel nowadays. ",
"They are used to scroll up or down in the text window. ",
"\n\n",
"* The Alt key may be labeled Meta or Compose-Character on some keyboards. ",
"Some window managers, including default configurations of mwm, bind ",
"combinations of the Alt key and mouse buttons to window manager operations. ",
"In XNEdit, Alt is only used on button release, so regardless of the window ",
"manager bindings for Alt-modified mouse buttons, you can still do the ",
"corresponding XNEdit operation by using the Alt key AFTER the initial mouse ",
"press, so that Alt is held while you release the mouse button.  If you find ",
"this difficult or annoying, you can re-configure most window managers to skip ",
"this binding, or you can re-configure XNEdit to use a different key ",
"combination. ",
NULL
};

static char * htxt_keyboard [] = {
"\01IMost of the keyboard shortcuts in XNEdit are shown on the right hand sides of ",
"the pull-down menus.  However, there are more which are not as obvious.  These ",
"include; dialog button shortcuts; menu and dialog mnemonics; labeled keyboard ",
"keys, such as the arrows, page-up, page-down, and home; and optional Shift ",
"modifiers on accelerator keys, like [Shift]Ctrl+F. ",
"\n\n",
"\01RMenu Accelerators\01I",
"\n\n",
"Pressing the key combinations shown on the right of the menu items is a ",
"shortcut for selecting the menu item with the mouse.  Some items have the shift ",
"key enclosed in brackets, such as [Shift]Ctrl+F.  This indicates that the shift ",
"key is optional.  In search commands, including the shift key reverses the ",
"direction of the search.  In Shift commands, it makes the command shift the ",
"selected text by a whole tab stop rather than by single characters. ",
"\n\n",
"\01RMenu Mnemonics\01I",
"\n\n",
"Pressing the Alt key in combination with one of the underlined characters in ",
"the menu bar pulls down that menu.  Once the menu is pulled down, typing the ",
"underlined characters in a menu item (without the Alt key) activates that ",
"item.  With a menu pulled down, you can also use the arrow keys to select menu ",
"items, and the Space or Enter keys to activate them. ",
"\n\n",
"\01RKeyboard Shortcuts within Dialogs\01I",
"\n\n",
"One button in a dialog is usually marked with a thick indented outline. ",
"Pressing the Return or Enter key activates this button. ",
"\n\n",
"All dialogs have either a Cancel or Dismiss button.  This button can be ",
"activated by pressing the Escape (or Esc) key. ",
"\n\n",
"Pressing the tab key moves the keyboard focus to the next item in a dialog. ",
"Within an associated group of buttons, the arrow keys move the focus among the ",
"buttons.  Shift+Tab moves backward through the items. ",
"\n\n",
"Most items in dialogs have an underline under one character in their name. ",
"Pressing the Alt key along with this character, activates a button as if you ",
"had pressed it with the mouse, or moves the keyboard focus to the associated ",
"text field or list. ",
"\n\n",
"You can select items from a list by using the arrow keys to move the ",
"selection and space to select. ",
"\n\n",
"In file selection dialogs, you can type the beginning characters of the file ",
"name or directory in the list to select files ",
"\n\n",
"\01RLabeled Function Keys\01I",
"\n\n",
"The labeled function keys on standard workstation and PC keyboards, like the ",
"arrows, and page-up and page-down, are active in XNEdit, though not shown in the ",
"pull-down menus. ",
"\n\n",
"Holding down the control key while pressing a named key extends the scope of ",
"the action that it performs.  For example, Home normally moves the insert ",
"cursor the beginning of a line.  Ctrl+Home moves it to the beginning of the ",
"file. Backspace deletes one character, Ctrl+Backspace deletes one word. ",
"\n\n",
"Holding down the shift key while pressing a named key begins or extends a ",
"selection.  Combining the shift and control keys combines their actions.  For ",
"example, to select a word without using the mouse, position the cursor at the ",
"beginning of the word and press Ctrl+Shift+RightArrow.  The Alt key modifies ",
"selection commands to make the selection rectangular. ",
"\n\n",
"Under X and Motif, there are several levels of translation between keyboard ",
"keys and the actions they perform in a program.  The \"\01QCustomizing XNEdit\01I\", and ",
"\"\01QX Resources\01I\" sections of the Help menu have more information on this subject. ",
"Because of all of this configurability, and since keyboards and standards for ",
"the meaning of some keys vary from machine to machine, the mappings may be ",
"changed from the defaults listed below. ",
"\n\n",
"\01RModifier Keys (in general)\01I",
"\n\n",
"\01A    Ctrl   Extends the scope of the action that the key\n",
"           would otherwise perform.  For example, Home\n",
"           normally moves the insert cursor to the beginning\n",
"           of a line. Ctrl+Home moves it to the beginning of\n",
"           the file.  Backspace deletes one character, Ctrl+\n",
"           Backspace deletes one word.\n",
"\01I\n",
"\01A    Shift  Extends the selection to the cursor position. If\n",
"           there's no selection, begins one between the old\n",
"           and new cursor positions.\n",
"\01I\n",
"\01A    Alt    When modifying a selection, makes the selection\n",
"           rectangular.\n",
"\01I\n",
"(For the effects of modifier keys on mouse button presses, see the section ",
"titled \"\01QUsing the Mouse\01I\") ",
"\n\n",
"\01RAll Keyboards\01I",
"\n\n",
"\01A    Escape        Cancels operation in progress: menu\n",
"                  selection, drag, selection, etc.  Also\n",
"                  equivalent to cancel button in dialogs.\n",
"\01I\n",
"\01A    Backspace     Delete the character before the cursor\n",
"\01I\n",
"\01A    Ctrl+BS       Delete the word before the cursor\n",
"\01I\n",
"\01A    Arrows --\n",
"\01I\n",
"\01A      Left        Move the cursor to the left one character\n",
"\01I\n",
"\01A      Ctrl+Left   Move the cursor backward one word\n",
"                  (Word delimiters are settable, see\n",
"                  \"\01QCustomizing XNEdit\01A\", and \"\01QX Resources\01A\")\n",
"\01I\n",
"\01A      Right       Move the cursor to the right one character\n",
"\01I\n",
"\01A      Ctrl+Right  Move the cursor forward one word\n",
"\01I\n",
"\01A      Up          Move the cursor up one line\n",
"\01I\n",
"\01A      Ctrl+Up     Move the cursor up one paragraph.\n",
"                  (Paragraphs are delimited by blank lines)\n",
"\01I\n",
"\01A      Down        Move the cursor down one line.\n",
"\01I\n",
"\01A      Ctrl+Down   Move the cursor down one paragraph.\n",
"\01I\n",
"\01A    Ctrl+Return   Return with automatic indent, regardless\n",
"                  of the setting of Auto Indent.\n",
"\01I\n",
"\01A    Shift+Return  Return without automatic indent,\n",
"                  regardless of the setting of Auto Indent.\n",
"\01I\n",
"\01A    Ctrl+Tab      Insert an ASCII tab character, without\n",
"                  processing emulated tabs.\n",
"\01I\n",
"\01A    Alt+Ctrl+<c>  Insert the control-code equivalent of\n",
"                  a key <c>\n",
"\01I\n",
"\01A    Ctrl+/        Select everything (same as Select\n",
"                  All menu item or ^A)\n",
"\01I\n",
"\01A    Ctrl+\\        Unselect\n",
"\01I\n",
"\01A    Ctrl+U        Delete to start of line\n",
"\01I\n",
"\01RPC Standard Keyboard\01I",
"\n\n",
"\01A    Ctrl+Insert   Copy the primary selection to the\n",
"                  clipboard (same as Copy menu item or ^C)\n",
"                  for compatibility with Motif standard key\n",
"                  binding\n",
"    Shift+Ctrl+\n",
"    Insert        Copy the primary selection to the cursor\n",
"                  location.\n",
"\01I\n",
"\01A    Delete        Delete the character before the cursor.\n",
"                  (Can be configured to delete the character\n",
"                  after the cursor, see \"\01QCustomizing XNEdit\01A\",\n",
"                  and \"\01QX Resources\01A\")\n",
"\01I\n",
"\01A    Ctrl+Delete   Delete to end of line.\n",
"\01I\n",
"\01A    Shift+Delete  Cut, remove the currently selected text\n",
"                  and place it in the clipboard. (same as\n",
"                  Cut menu item or ^X) for compatibility\n",
"                  with Motif standard key binding\n",
"    Shift+Ctrl+\n",
"    Delete        Cut the primary selection to the cursor\n",
"                  location.\n",
"\01I\n",
"\01A    Home          Move the cursor to the beginning of the\n",
"                  line\n",
"\01I\n",
"\01A    Ctrl+Home     Move the cursor to the beginning of the\n",
"                  file\n",
"\01I\n",
"\01A    End           Move the cursor to the end of the line\n",
"\01I\n",
"\01A    Ctrl+End      Move the cursor to the end of the file\n",
"\01I\n",
"\01A    PageUp        Scroll and move the cursor up by one page.\n",
"\01I\n",
"\01A    PageDown      Scroll and move the cursor down by one\n",
"                  page.\n",
"\01I\n",
"\01A    F10           Make the menu bar active for keyboard\n",
"                  input (Arrow Keys, Return, Escape,\n",
"                  and the Space Bar)\n",
"\01I\n",
"\01A    Alt+Home      Switch to the previously active document.\n",
"\01I\n",
"\01A    Ctrl+PageUp   Switch to the previous document.\n",
"\01I\n",
"\01A    Ctrl+PageDown Switch to the next document.\n",
"\01I\n",
"\01RSpecialty Keyboards\01I",
"\n\n",
"On machines with different styles of keyboards, generally, text editing ",
"actions are properly matched to the labeled keys, such as Remove, ",
"Next-screen, etc..  If you prefer different key bindings, see the section ",
"titled \"\01QKey Binding\01I\" under the Customizing heading in the Help menu. ",
NULL
};

static char * htxt_multicursor [] = {
"\01IXNEdit supports multi-cursor editing, which allows doing the same text editing ",
"operation at multiple positions simultaneously. ",
"\n\n",
"To add a new cursor, press and hold Ctrl and left-click on the desired ",
"position of the new cursor. You can remove a specific cursor with ",
"Ctrl + left click on the existing cursor. To return to the normal single ",
"cursor operation, press Escape or do a left click without Ctrl to any text ",
"position. ",
"\n\n",
"An alternative way to add cursors is Ctrl+Super+Up to add a cursor above ",
"the most top cursor or Ctrl+Super+Down to add a cursor below the last ",
"cursor. ",
"\n\n",
"Most operations like inserting text, moving cursors by character, word or ",
"paragraph and undo/redo support multi-cursor editing. Text Selection and ",
"pasting text as column is unsupported. ",
"\n\n",
"The following actions support multiple cursors: ",
"\n\n",
"\01A\01Bdelete_next_character()\01A\n",
"\01Bdelete_previous_character()\01A\n",
"\01Bdelete_next_word()\01A\n",
"\01Bdelete_previous_word()\01A\n",
"\01Bforward_character()\01A\n",
"\01Bforward_paragraph()\01A\n",
"\01Bforward_word()\01A\n",
"\01Bbackward_character()\01A\n",
"\01Bbackward_word()\01A\n",
"\01Bbackward_paragraph()\01A\n",
"\01Binsert_string()\01A\n",
"\01Bself_insert()\01A\n",
"\01Bnewline()\01A\n",
"\01Bprocess_tab()\01A\n",
"\01Bprocess_up()\01A\n",
"\01Bprocess_down()\01A\n",
"\01Bbeginning_of_line()\01A\n",
"\01Bend_of_line()\01A\n",
NULL
};

static char * htxt_fill [] = {
"\01RShift Left, Shift Right\01I",
"\n\n",
"While shifting blocks of text is most important for programmers (See Features ",
"for Programming), it is also useful for other tasks, such as creating ",
"indented paragraphs. ",
"\n\n",
"To shift a block of text one tab stop to the right, select the text, then ",
"choose Shift Right from the Edit menu.  Note that the accelerator keys for ",
"these menu items are Ctrl+9 and Ctrl+0, which correspond to the right and ",
"left parenthesis on most keyboards.  Remember them as adjusting the text in ",
"the direction pointed to by the parenthesis character.  Holding the Shift key ",
"while selecting either Shift Left or Shift Right will shift the text by one ",
"character. ",
"\n\n",
"It is also possible to shift blocks of text by selecting the text ",
"rectangularly, and dragging it left or right (and up or down as well).  Using ",
"a rectangular selection also causes tabs within the selection to be ",
"recalculated and substituted, such that the non-whitespace characters remain ",
"stationary with respect to the selection. ",
"\n\n",
"\01RFilling\01I",
"\n\n",
"Text filling using the Fill Paragraph command in the Edit menu is one of the ",
"most important concepts in XNEdit.  And it will be well worth your while to ",
"understand how to use it properly. ",
"\n\n",
"In plain text files, unlike word-processor files, there is no way to tell ",
"which lines are continuations of other lines, and which lines are meant to be ",
"separate, because there is no distinction in meaning between newline ",
"characters which separate lines in a paragraph, and ones which separate ",
"paragraphs from other text.  This makes it impossible for a text editor like ",
"XNEdit to tell parts of the text which belong together as a paragraph from ",
"carefully arranged individual lines. ",
"\n\n",
"In continuous wrap mode (Preferences -> Wrap -> Continuous), lines ",
"automatically wrap and unwrap themselves to line up properly at the right ",
"margin.  In this mode, you simply omit the newlines within paragraphs and let ",
"XNEdit make the line breaks as needed.  Unfortunately, continuous wrap mode is ",
"not appropriate in the majority of situations, because files with extremely ",
"long lines are not common under Unix and may not be compatible with all ",
"tools, and because you can't achieve effects like indented sections, columns, ",
"or program comments, and still take advantage of the automatic wrapping. ",
"\n\n",
"Without continuous wrapping, paragraph filling is not entirely automatic. ",
"Auto-Newline wrapping keeps paragraphs lined up as you type, but once ",
"entered, XNEdit can no longer distinguish newlines which join wrapped text, ",
"and newlines which must be preserved.  Therefore, editing in the middle of a ",
"paragraph will often leave the right margin messy and uneven. ",
"\n\n",
"Since XNEdit can't act automatically to keep your text lined up, you need to ",
"tell it explicitly where to operate, and that is what Fill Paragraph is for. ",
"It arranges lines to fill the space between two margins, wrapping the lines ",
"neatly at word boundaries.  Normally, the left margin for filling is inferred ",
"from the text being filled.  The first line of each paragraph is considered ",
"special, and its left indentation is maintained separately from the remaining ",
"lines (for leading indents, bullet points, numbered paragraphs, etc.). ",
"Otherwise, the left margin is determined by the furthest left non-whitespace ",
"character.  The right margin is either the Wrap Margin, set in the ",
"preferences menu (by default, the right edge of the window), or can also be ",
"chosen on the fly by using a rectangular selection (see below). ",
"\n\n",
"There are three ways to use Fill Paragraph.  The simplest is, while you are ",
"typing text, and there is no selection, simply select Fill Paragraph (or type ",
"Ctrl+J), and XNEdit will arrange the text in the paragraph adjacent to the ",
"cursor.  A paragraph, in this case, means an area of text delimited by blank ",
"lines. ",
"\n\n",
"The second way to use Fill Paragraph is with a selection.  If you select a ",
"range of text and then chose Fill Paragraph, all of the text in the selection ",
"will be filled.  Again, continuous text between blank lines is interpreted as ",
"paragraphs and filled individually, respecting leading indents and blank ",
"lines. ",
"\n\n",
"The third, and most versatile, way to use Fill Paragraph is with a ",
"rectangular selection.  Fill Paragraph treats rectangular selections ",
"differently from other commands.  Instead of simply filling the text inside ",
"the rectangular selection, XNEdit interprets the right edge of the selection ",
"as the requested wrap margin.  Text to the left of the selection is not ",
"disturbed (the usual interpretation of a rectangular selection), but text to ",
"the right of the selection is included in the operation and is pulled in to ",
"the selected region.  This method enables you to fill text to an arbitrary ",
"right margin, without going back and forth to the wrap-margin dialog, as well ",
"as to exclude text to the left of the selection such as comment bars or other ",
"text columns. ",
NULL
};

static char * htxt_interface [] = {
"\01IXNEdit is able to display files in distinct editor windows, or to display files ",
"under tabs in the same editor window.  The Options for controlling the tabbed ",
"interface are found under Preferences -> Default Settings -> Tabbed Editing ",
"(cf. \"\01QPreferences\01I\", also \"\01QXNEdit Command Line\01I\"). ",
"\n\n",
"Notice that you can re-group tabs at any time by detaching and attaching them, ",
"or moving them, to other windows. This can be done using the Windows menu, or ",
"using the context menu, which pops up when right clicking on a tab. ",
"\n\n",
"You can switch to a tab by simply clicking on it, or you can use the keyboard. ",
"The default keybindings to switch tabs (which are Ctrl+PageUp/-Down and Alt+Home, ",
"see \"\01QKeyboard Shortcuts\01I\") can be changed using the actions previous_document(), ",
"next_document() and last_document(). ",
"\n\n",
NULL
};

static char * htxt_format [] = {
"\01IWhile plain-text is probably the simplest and most interchangeable file ",
"format in the computer world, there is still variation in what plain-text ",
"means from system to system.  Plain-text files can differ in character set, ",
"line termination, and wrapping. ",
"\n\n",
"While character set differences are the most obvious and pose the most ",
"challenge to portability, they affect XNEdit only indirectly via the same font ",
"and localization mechanisms common to all X applications.  If your system is ",
"set up properly, you will probably never see character-set related problems ",
"in XNEdit. ",
"\n\n",
"The primary difference between an MS DOS format file and a Unix format file, ",
"is how the lines are terminated.  Unix uses a single newline character.  MS ",
"DOS uses a carriage-return and a newline.  XNEdit can read and write both file ",
"formats, but internally, it uses the single character Unix standard.  XNEdit ",
"auto-detects MS DOS format files based on the line termination at the start ",
"of the file.  Files are judged to be DOS format if all of the first five line ",
"terminators, within a maximum range, are DOS-style.  To change the format in ",
"which XNEdit writes a file from DOS to Unix or visa versa, use the Save As... ",
"command and check or un-check the MS DOS Format button. ",
"\n\n",
"Wrapping within text files can vary among individual users, as well as from ",
"system to system.  Both Windows and MacOS make frequent use of plain text ",
"files with no implicit right margin.  In these files, wrapping is determined ",
"by the tool which displays them.  Files of this style also exist on Unix ",
"systems, despite the fact that they are not supported by all Unix utilities. ",
"To display this kind of file properly in XNEdit, you have to select the wrap ",
"style called Continuous.  Wrapping modes are discussed in the sections: ",
"Customizing -> Preferences, and Basic Operation -> Shifting and Filling. ",
"\n\n",
"The last and most minute of format differences is the terminating newline. ",
"Some Unix compilers and utilities require a final terminating newline on all ",
"files they read and fail in various ways on files which do not have it.  Vi ",
"and approximately half of Unix editors enforce the terminating newline on all ",
"files that they write; Emacs does not enforce this rule.  Users are divided ",
"on which is best.  XNEdit makes the final terminating newline optional ",
"(Preferences -> Default Settings -> Terminate with Line Break on Save). ",
NULL
};

static char * htxt_programmer [] = {
"\01IThough general in appearance, XNEdit has many features intended specifically ",
"for programmers.  Major programming-related topics are listed in separate ",
"sections under the heading: \"Features for Programming\": \01QSyntax Highlighting\01I, ",
"\01QTab Stops/Emulated Tab Stops\01I, \01QFinding Declarations (ctags)\01I, \01QCalltips\01I, and ",
"\01QAuto/Smart Indent\01I.  Minor topics related to programming are discussed below: ",
"\n\n",
"\01RLanguage Modes\01I",
"\n\n",
"When XNEdit initially reads a file, it attempts to determine whether the file ",
"is in one of the computer languages that it knows about.  Knowing what language ",
"a file is written in allows XNEdit to assign highlight patterns and smart indent ",
"macros, and to set language specific preferences like word delimiters, tab ",
"emulation, and auto-indent.  Language mode can be recognized from both the file ",
"name and from the first 200 characters of content.  Language mode recognition ",
"and language-specific preferences are configured in: Preferences -> Default ",
"Settings -> Language Modes.... ",
"\n\n",
"You can set the language mode manually for a window, by selecting it from the ",
"menu: Preferences -> Language Modes. ",
"\n\n",
"\01RBacklighting [EXPERIMENTAL]\01I",
"\n\n",
"XNEdit can be made to set the background color of particular classes of ",
"characters to allow easy identification of those characters. This is ",
"particularly useful if you need to be able to distinguish between tabs ",
"and spaces in a file where the difference is important. The colors used ",
"for backlighting are specified by a resource, \"nedit*backlightCharTypes\". ",
"You can turn backlighting on and off through the ",
"Preferences -> Apply Backlighting menu entry. ",
"\n\n",
"If you prefer to have backlighting turned on for all new windows, use ",
"the Preferences -> Default Settings -> Apply Backlighting menu entry. ",
"This settings can be saved along with other preferences using ",
"Preferences -> Save Defaults. ",
"\n\n",
"\01JImportant:\01I In future versions of XNEdit, the backlighting feature will be ",
"extended and reworked such that it becomes easier to configure. The current ",
"way of controlling it through a resource is generally considered to be below ",
"XNEdit's usability standards. These future changes are likely to be ",
"incompatible with the current format of the \"nedit*backlightCharTypes\" ",
"resource, though. Therefore, it is expected that there will be no automatic ",
"migration path for users who customize the resource. ",
"\n\n",
"\01RLine Numbers\01I",
"\n\n",
"To find a particular line in a source file by line number, choose Goto Line ",
"#... from the Search menu.  You can also directly select the line number text ",
"in the compiler message in the terminal emulator window (xterm, decterm, ",
"winterm, etc.) where you ran the compiler, and choose Goto Selected from the ",
"Search menu. ",
"\n\n",
"To find out the line number of a particular line in your file, turn on ",
"Statistics Line in the Preferences menu and position the insertion point ",
"anywhere on the line.  The statistics line continuously updates the line number ",
"of the line containing the cursor. ",
"\n\n",
"To go to a specific column on a given line, choose Goto Line #... from the ",
"Search menu and enter a line number and a column number separated by a ",
"comma.  (e.g. Enter \"100,12\" for line 100 column 12.)  If you want to go to ",
"a column on the current line just leave out the line number.  (e.g. Enter ",
"\",45\" to go the column 45 on the current line.) ",
"\n\n",
"\01RMatching Parentheses\01I",
"\n\n",
"To help you inspect nested parentheses, brackets, braces, quotes, and other ",
"characters, XNEdit has both an automatic parenthesis matching mode, and a Goto ",
"Matching command.  Automatic parenthesis matching is activated when you type, ",
"or move the insertion cursor after a parenthesis, bracket, or brace.  It ",
"momentarily highlights either the opposite character ('Delimiter') or the ",
"entire expression ('Range') when the opposite character is visible in the ",
"window. To find a matching character anywhere in the file, select it or ",
"position the cursor after it, and choose Goto Matching from the Search menu. ",
"If the character matches itself, such as a quote or slash, select the first ",
"character of the pair.  XNEdit will match {, (, [, <, \", ', `, /, and \\. ",
"Holding the Shift key while typing the accelerator key (Shift+Ctrl+M, by ",
"default), will select all of the text between the matching characters. ",
"\n\n",
"When syntax highlighting is enabled, the matching routines can optionally ",
"make use of the syntax information for improved accuracy. In that case, ",
"a brace inside a highlighted string will not match a brace inside a comment, ",
"for instance. ",
"\n\n",
"\01ROpening Included Files\01I",
"\n\n",
"The Open Selected command in the File menu understands the C preprocessor's ",
"#include syntax, so selecting an #include line and invoking Open Selected will ",
"generally find the file referred to, unless doing so depends on the settings of ",
"compiler switches or other information not available to XNEdit. ",
"\n\n",
"\01RInterface to Programming Tools\01I",
"\n\n",
"Integrated software development environments such as SGI's CaseVision and ",
"Centerline Software's Code Center, can be interfaced directly with XNEdit via ",
"the client server interface.  These tools allow you to click directly on ",
"compiler and runtime error messages and request XNEdit to open files, and select ",
"lines of interest.  The easiest method is usually to use the tool's interface ",
"for character-based editors like vi, to invoke xnc, but programmatic interfaces ",
"can also be derived using the source code for xnc. ",
"\n\n",
"There are also some simple compile/review, grep, ctree, and ctags browsers ",
"available in the XNEdit contrib directory on ftp.nedit.org. ",
NULL
};

static char * htxt_tabs [] = {
"\01RChanging the Tab Stop Distance\01I",
"\n\n",
"Tab stops are important for programming in languages which use indentation to ",
"show nesting, as short-hand for producing white-space for leading indents. ",
"As a programmer, you have to decide how to use indentation, and how or whether ",
"tab characters map to your indentation scheme. ",
"\n\n",
"Ideally, tab characters map directly to the amount of indent that you use to ",
"distinguish nesting levels in your code.  Unfortunately, the Unix standard ",
"for interpretation of tab characters is eight characters (probably dating ",
"back to mechanical capabilities of the original teletype), which is usually ",
"too coarse for a single indent. ",
"\n\n",
"Most text editors, XNEdit included, allow you to change the interpretation of ",
"the tab character, and many programmers take advantage of this, and set their ",
"tab stops to 3 or 4 characters to match their programming style.  In XNEdit you ",
"set the hardware tab distance in Preferences -> Tab Stops... for the current ",
"window, or Preferences -> Default Settings -> Tab Stops... (general), or ",
"Preferences -> Default Settings -> Language Modes... (language-specific) to ",
"change the defaults for future windows. ",
"\n\n",
"Changing the meaning of the tab character makes programming much easier while ",
"you're in the editor, but can cause you headaches outside of the editor, ",
"because there is no way to pass along the tab setting as part of a plain-text ",
"file.  All of the other tools which display, print, and otherwise process ",
"your source code have to be made aware of how the tab stops are set, and must ",
"be able to handle the change.  Non-standard tab stops can also confuse other ",
"programmers, or make editing your code difficult for them if their text ",
"editors don't support changes in tab stop distance. ",
"\n\n",
"\01REmulated Tab Stops\01I",
"\n\n",
"An alternative to changing the interpretation of the tab character is tab stop ",
"emulation.  In the Tab Stops... dialog(s), turning on Emulated Tabs causes the ",
"Tab key to insert the correct number of spaces and/or tabs to bring the cursor ",
"the next emulated tab stop, as if tabs were set at the emulated tab distance ",
"rather than the hardware tab distance. Backspacing immediately after entering ",
"an emulated tab will delete the fictitious tab as a unit, but as soon as you ",
"move the cursor away from the spot, XNEdit will forget that the collection of ",
"spaces and tabs is a tab, and will treat it as separate characters.  To enter ",
"a real tab character with \"Emulate Tabs\" turned on, use Ctrl+Tab. ",
"\n\n",
"It is also possible to tell XNEdit not to insert ANY tab characters at all in ",
"the course of processing emulated tabs, and in shifting and rectangular ",
"insertion/deletion operations, for programmers who worry about the ",
"misinterpretation of tab characters on other systems. ",
NULL
};

static char * htxt_indent [] = {
"\01IProgrammers who use structured languages usually require some form of ",
"automatic indent, so that they don't have to continually re-type the ",
"sequences of tabs and/or spaces needed to maintain lengthy running indents. ",
"XNEdit therefore offers \"smart\" indent, in addition to the traditional ",
"automatic indent which simply lines up the cursor position with the previous ",
"line. ",
"\n\n",
"\01RSmart Indent\01I",
"\n\n",
"Smart indent macros are only available by default for C and C++, and while ",
"these can easily be configured for different default indentation distances, ",
"they may not conform to everyone's exact C programming style.  Smart indent ",
"is programmed in terms of macros in the XNEdit macro language which can be ",
"entered in: Preferences -> Default Settings -> Indent -> Program Smart ",
"Indent.  Hooks are provided for intervening at the point that a newline is ",
"entered, either via the user pressing the Enter key, or through ",
"auto-wrapping; and for arbitrary type-in to act on specific characters typed. ",
"\n\n",
"To type a newline character without invoking smart-indent when operating in ",
"smart-indent mode, hold the Shift key while pressing the Return or Enter key. ",
"\n\n",
"\01RAuto-Indent\01I",
"\n\n",
"With Indent set to Auto (the default), XNEdit keeps a running indent.  When ",
"you press the Return or Enter key, spaces and tabs are inserted to line up ",
"the insert point under the start of the previous line. ",
"\n\n",
"Regardless of indent-mode, Ctrl+Return always does the automatic indent; ",
"Shift+Return always does a return without indent. ",
"\n\n",
"\01RBlock Indentation Adjustment\01I",
"\n\n",
"The Shift Left and Shift Right commands as well as rectangular dragging can ",
"be used to adjust the indentation for several lines at once.  To shift a ",
"block of text one character to the right, select the text, then choose Shift ",
"Right from the Edit menu.  Note that the accelerator keys for these menu ",
"items are Ctrl+9 and Ctrl+0, which correspond to  the right and left ",
"parenthesis on most keyboards.  Remember them as adjusting the text in the ",
"direction pointed to by the parenthesis character.  Holding the Shift key ",
"while selecting either Shift Left or Shift Right will shift the text by one ",
"tab stop (or by one emulated tab stop if tab emulation is turned on).  The ",
"help section \"Shifting and Filling\" under \"Basic Operation\" has details. ",
NULL
};

static char * htxt_syntax [] = {
"\01ISyntax Highlighting means using colors and fonts to help distinguish language ",
"elements in programming languages and other types of structured files. ",
"Programmers use syntax highlighting to understand code faster and better, and ",
"to spot many kinds of syntax errors more quickly. ",
"\n\n",
"To use syntax highlighting in XNEdit, select Highlight Syntax in the ",
"Preferences menu.  If XNEdit recognizes the computer language that you are ",
"using, and highlighting rules (patterns) are available for that language, it ",
"will highlight your text, and maintain the highlighting, automatically, as ",
"you type. ",
"\n\n",
"If XNEdit doesn't correctly recognize the type of the file you are editing, ",
"you can manually select a language mode from Language Modes in the ",
"Preferences menu.  You can also program the method that XNEdit uses to ",
"recognize language modes in Preferences -> Default Settings -> Language ",
"Modes.... ",
"\n\n",
"If no highlighting patterns are available for the language that you want to ",
"use, you can create new patterns relatively quickly.  The Help section ",
"\"\01QHighlighting Patterns\01I\" under \"Customizing\", has details. ",
"\n\n",
"If you are satisfied with what XNEdit is highlighting, but would like it to ",
"use different colors or fonts, you can change these by selecting Preferences ",
"-> Default Settings -> Syntax Highlighting -> Text Drawing Styles. ",
"Highlighting patterns are connected with font and color information through a ",
"common set of styles so that colorings defined for one language will be ",
"similar across others, and patterns within the same language which are meant ",
"to appear identical can be changed in the same place.  To understand which ",
"styles are used to highlight the language you are interested in, you may need ",
"to look at \"\01QHighlighting Patterns\01I\" section, as well. ",
"\n\n",
"Syntax highlighting is CPU intensive, and under some circumstances can affect ",
"XNEdit's responsiveness.  If you have a particularly slow system, or work with ",
"very large files, you may not want to use it all of the time.  Syntax ",
"highlighting introduces two kinds of delays.  The first is an initial parsing ",
"delay, proportional to the size of the file.  This delay is also incurred ",
"when pasting large sections of text, filtering text through shell commands, ",
"and other circumstances involving changes to large amounts of text.  The ",
"second kind of delay happens when text which has not previously been visible ",
"is scrolled in to view.  Depending on your system, and the highlight patterns ",
"you are using, this may or may not be noticeable.  A typing delay is also ",
"possible, but unlikely if you are only using the built-in patterns. ",
NULL
};

static char * htxt_tags [] = {
"\01IXNEdit can process tags files generated using the Unix ctags command or the ",
"Exuberant Ctags program.  Ctags creates index files correlating names of ",
"functions and declarations with their locations in C, Fortran, or Pascal source ",
"code files. (See the ctags manual page for more information).  Ctags produces a ",
"file called \"tags\" which can be loaded by XNEdit.  XNEdit can manage any number ",
"of tags files simultaneously.  Tag collisions are handled with a popup menu to ",
"let the user decide which tag to use.  In 'Smart' mode XNEdit will automatically ",
"choose the desired tag based on the scope of the file or module. Once loaded, ",
"the information in the tags file enables XNEdit to go directly to the ",
"declaration of a highlighted function or data structure name with a single ",
"command.  To load a tags file, select \"Load Tags File\" from the File menu and ",
"choose a tags file to load, or specify the name of the tags file on the XNEdit ",
"command line: ",
"\n\n",
"\01A      xnedit -tags tags\n",
"\01I\n",
"XNEdit can also be set to load a tags file automatically when it starts up. ",
"Setting the X resource nedit.tagFile to the name of a tag file tells XNEdit to ",
"look for that file at startup time (see \"\01QCustomizing XNEdit\01I\").  The file name ",
"can be either a complete path name, in which case XNEdit will always load the ",
"same tags file, or a file name without a path or with a relative path, in ",
"which case XNEdit will load it starting from the current directory.  The ",
"second option allows you to have different tags files for different projects, ",
"each automatically loaded depending on the directory you're in when you start ",
"XNEdit.  Setting the name to \"tags\" is an obvious choice since this is the ",
"name that ctags uses. XNEdit normally evaluates relative path tag file ",
"specifications every time a file is opened. All accessible tag files are ",
"loaded at this time. To disable the automatic loading of tag files specified ",
"as relative paths, set the X resource nedit.alwaysCheckRelativeTagsSpecs to ",
"False. ",
"\n\n",
"To unload a tags file, select \"Un-load Tags File\" from the File menu and ",
"choose from the list of tags files.  XNEdit will keep track of tags file updates ",
"by checking the timestamp on the files, and automatically update the tags ",
"cache. ",
"\n\n",
"To find the definition of a function or data structure once a tags file is ",
"loaded, select the name anywhere it appears in your program (see ",
"\"\01QSelecting Text\01I\") and choose \"Find Definition\" from the Search menu. ",
NULL
};

static char * htxt_calltips [] = {
"\01ICalltips are little yellow boxes that pop up to remind you what the arguments ",
"and return type of a function are.  More generally, they're a UI mechanism to ",
"present a small amount of crucial information in a prominent location.  To ",
"display a calltip, select some text and choose \"Show Calltip\" from the Search ",
"menu.  To kill a displayed calltip, hit Esc. ",
"\n\n",
"Calltips get their information from one of two places -- either a tags file (see ",
"\"\01QFinding Declarations (ctags)\01I\") or a calltips file.  First, any loaded calltips ",
"files are searched for a definition, and if nothing is found then the tags ",
"database is searched.  If a tag is found that matches the highlighted text then ",
"a calltip is displayed with the first few lines of the definition -- usually ",
"enough to show you what the arguments of a function are. ",
"\n\n",
"You can load a calltips file by using choosing \"Load Calltips File\" from the ",
"File menu.  You can unload a calltips file by selecting it from the ",
"\"Unload Calltips File\" submenu of the File menu.  You can also choose one or ",
"more default calltips files to be loaded for each language mode using the ",
"\"Default calltips file(s)\" field of the Language Modes dialog. ",
"\n\n",
"The calltips file format is very simple.  calltips files are organized in blocks ",
"separated by blank lines.  The first line of the block is the key, which is the ",
"word that is matched when a calltip is requested.  The rest of the block is ",
"displayed as the calltip. ",
"\n\n",
"Almost any text at all can appear in a calltip key or a calltip.  There are no ",
"special characters that need to be escaped.  The only issues to note are that ",
"trailing whitespace is ignored, and you cannot have a blank line inside a ",
"calltip.  (Use a single period instead --  it'll be nearly invisible.)  You should ",
"also avoid calltip keys that begin and end with '*' characters, since those are ",
"used to mark special blocks. ",
"\n\n",
"There are five special block types--comment, include, language, alias, and ",
"version--which are distinguished by their first lines, \"* comment *\", ",
"\"* include *\", \"* language *\", \"* alias *\", and \"* version *\" respectively ",
"(without quotes). ",
"\n\n",
"Comment blocks are ignored when reading calltips files. ",
"\n\n",
"Include blocks specify additional calltips files to load, one per line.  The ~ ",
"character can be used for your $HOME directory, but other shell shortcuts like ",
"* and ? can't be used. Include blocks allow you to make a calltips file for your ",
"project that includes, say, the calltips files for C, Motif, and Xt. ",
"\n\n",
"Language blocks specify which language mode the calltips should be used with. ",
"When a calltip is requested it won't match tips from languages other than the ",
"current language mode.  Language blocks only affect the tips listed after the ",
"block. ",
"\n\n",
"Alias blocks allow a calltip to have multiple keys.  The first line of the block ",
"is the key for the calltip to be displayed, and the rest of the lines are ",
"additional keys, one per line, that should also show the calltip. ",
"\n\n",
"Version blocks are ignored for the time being. ",
"\n\n",
"You can use calltips in your own macros using the calltip() and kill_calltip() ",
"macro subroutines and the $calltip_ID macro variable.  See the ",
"\01QMacro Subroutines\01I section for details. ",
NULL
};

static char * htxt_basicSyntax [] = {
"\01IRegular expressions (regex's) are useful as a way to match inexact sequences ",
"of characters.  They can be used in the `Find...' and `Replace...' search ",
"dialogs and are at the core of Color Syntax Highlighting patterns.  To specify ",
"a regular expression in a search dialog, simply click on the `Regular ",
"Expression' radio button in the dialog. ",
"\n\n",
"A regex is a specification of a pattern to be matched in the searched text. ",
"This pattern consists of a sequence of tokens, each being able to match a ",
"single character or a sequence of characters in the text, or assert that a ",
"specific position within the text has been reached (the latter is called an ",
"anchor.)  Tokens (also called atoms) can be modified by adding one of a number ",
"of special quantifier tokens immediately after the token.  A quantifier token ",
"specifies how many times the previous token must be matched (see below.) ",
"\n\n",
"Tokens can be grouped together using one of a number of grouping constructs, ",
"the most common being plain parentheses.  Tokens that are grouped in this way ",
"are also collectively considered to be a regex atom, since this new larger ",
"atom may also be modified by a quantifier. ",
"\n\n",
"A regex can also be organized into a list of alternatives by separating each ",
"alternative with pipe characters, `|'.  This is called alternation.  A match ",
"will be attempted for each alternative listed, in the order specified, until a ",
"match results or the list of alternatives is exhausted (see \01QAlternation\01I ",
"section below.) ",
"\n\n",
"\01RThe 'Any' Character\01I",
"\n\n",
"If a dot (`.') appears in a regex, it means to match any character exactly ",
"once.  By default, dot will not match a newline character, but this behavior ",
"can be changed (see help topic \01QParenthetical Constructs\01I, under the ",
"heading, Matching Newlines). ",
"\n\n",
"\01RCharacter Classes\01I",
"\n\n",
"A character class, or range, matches exactly one character of text, but the ",
"candidates for matching are limited to those specified by the class.  Classes ",
"come in two flavors as described below: ",
"\n\n",
"\01A     [...]   Regular class, match only characters listed.\n",
"     [^...]  Negated class, match only characters \01Cnot\01A listed.\n",
"\01I\n",
"As with the dot token, by default negated character classes do not match ",
"newline, but can be made to do so. ",
"\n\n",
"The characters that are considered special within a class specification are ",
"different than the rest of regex syntax as follows. If the first character in ",
"a class is the `]' character (second character if the first character is `^') ",
"it is a literal character and part of the class character set.  This also ",
"applies if the first or last character is `-'.  Outside of these rules, two ",
"characters separated by `-' form a character range which includes all the ",
"characters between the two characters as well.  For example, `[^f-j]' is the ",
"same as `[^fghij]' and means to match any character that is not `f', `g', ",
"`h', `i', or `j'. ",
"\n\n",
"\01RAnchors\01I",
"\n\n",
"Anchors are assertions that you are at a very specific position within the ",
"search text.  XNEdit regular expressions support the following anchor tokens: ",
"\n\n",
"\01A     ^    Beginning of line\n",
"     $    End of line\n",
"     <    Left word boundary\n",
"     >    Right word boundary\n",
"     \\B   Not a word boundary\n",
"\01I\n",
"Note that the \\B token ensures that neither the left nor the right character ",
"are delimiters, \01Jor\01I that both left and right characters are delimiters. ",
"The left word anchor checks whether the previous character is a delimiter and ",
"the next character is not. The right word anchor works in a similar way. ",
"\n\n",
"Note that word delimiters are user-settable, and defined by the X resource ",
"wordDelimiters, cf. \01QX Resources\01I. ",
"\n\n",
"\01RQuantifiers\01I",
"\n\n",
"Quantifiers specify how many times the previous regular expression atom may ",
"be matched in the search text.  Some quantifiers can produce a large ",
"performance penalty, and can in some instances completely lock up XNEdit.  To ",
"prevent this, avoid nested quantifiers, especially those of the maximal ",
"matching type (see below.) ",
"\n\n",
"The following quantifiers are maximal matching, or \"greedy\", in that they ",
"match as much text as possible (but don't exclude shorter matches if that ",
"is necessary to achieve an overall match). ",
"\n\n",
"\01A     *   Match zero or more\n",
"     +   Match one  or more\n",
"     ?   Match zero or one\n",
"\01I\n",
"The following quantifiers are minimal matching, or \"lazy\", in that they match ",
"as little text as possible (but don't exclude longer matches if that is ",
"necessary to achieve an overall match). ",
"\n\n",
"\01A     *?   Match zero or more\n",
"     +?   Match one  or more\n",
"     ??   Match zero or one\n",
"\01I\n",
"One final quantifier is the counting quantifier, or brace quantifier. It ",
"takes the following basic form: ",
"\n\n",
"\01A     {min,max}  Match from `min' to `max' times the\n",
"                previous regular expression atom.\n",
"\01I\n",
"If `min' is omitted, it is assumed to be zero.  If `max' is omitted, it is ",
"assumed to be infinity.  Whether specified or assumed, `min' must be less ",
"than or equal to `max'.  Note that both `min' and `max' are limited to ",
"65535.  If both are omitted, then the construct is the same as `*'.   Note ",
"that `{,}' and `{}' are both valid brace constructs.  A single number ",
"appearing without a comma, e.g. `{3}' is short for the `{min,min}' construct, ",
"or to match exactly `min' number of times. ",
"\n\n",
"The quantifiers `{1}' and `{1,1}' are accepted by the syntax, but are ",
"optimized away since they mean to match exactly once, which is redundant ",
"information.  Also, for efficiency, certain combinations of `min' and `max' ",
"are converted to either `*', `+', or `?' as follows: ",
"\n\n",
"\01A     {} {,} {0,}    *\n",
"     {1,}           +\n",
"     {,1} {0,1}     ?\n",
"\01I\n",
"Note that {0} and {0,0} are meaningless and will generate an error message at ",
"regular expression compile time. ",
"\n\n",
"Brace quantifiers can also be \"lazy\".  For example {2,5}? would try to match ",
"2 times if possible, and will only match 3, 4, or 5 times if that is what is ",
"necessary to achieve an overall match. ",
"\n\n",
"\01RAlternation\01I",
"\n\n",
"A series of alternative patterns to match can be specified by separating them ",
"with vertical pipes, `|'.  An example of alternation would be `a|be|sea'. ",
"This will match `a', or `be', or `sea'. Each alternative can be an ",
"arbitrarily complex regular expression. The alternatives are attempted in ",
"the order specified.  An empty alternative can be specified if desired, e.g. ",
"`a|b|'.  Since an empty alternative can match nothingness (the empty string), ",
"this guarantees that the expression will match. ",
"\n\n",
"\01RComments\01I",
"\n\n",
"Comments are of the form `(?#<comment text>)' and can be inserted anywhere ",
"and have no effect on the execution of the regular expression.  They can be ",
"handy for documenting very complex regular expressions.  Note that a comment ",
"begins with `(?#' and ends at the first occurrence of an ending parenthesis, ",
"or the end of the regular expression... period.  Comments do not recognize ",
"any escape sequences. ",
NULL
};

static char * htxt_escapeSequences [] = {
"\01REscaping Metacharacters\01I",
"\n\n",
"In a regular expression (regex), most ordinary characters match themselves. ",
"For example, `ab%' would match anywhere `a' followed by `b' followed by `%' ",
"appeared in the text.  Other characters don't match themselves, but are ",
"metacharacters. For example, backslash is a special metacharacter which ",
"'escapes' or changes the meaning of the character following it. Thus, to ",
"match a literal backslash would require a regular expression to have two ",
"backslashes in sequence. XNEdit provides the following escape sequences so ",
"that metacharacters that are used by the regex syntax can be specified as ",
"ordinary characters. ",
"\n\n",
"\01A     \\(  \\)  \\-  \\[  \\]  \\<  \\>  \\{  \\}\n",
"     \\.  \\|  \\^  \\$  \\*  \\+  \\?  \\&  \\\\\n",
"\01I\n",
"\01RSpecial Control Characters\01I",
"\n\n",
"There are some special characters that are  difficult or impossible to type. ",
"Many of these characters can be constructed as a sort of metacharacter or ",
"sequence by preceding a literal character with a backslash. XNEdit recognizes ",
"the following special character sequences: ",
"\n\n",
"\01A     \\a  alert (bell)\n",
"     \\b  backspace\n",
"     \\e  ASCII escape character (***)\n",
"     \\f  form feed (new page)\n",
"     \\n  newline\n",
"     \\r  carriage return\n",
"     \\t  horizontal tab\n",
"     \\v  vertical tab\n",
"\01I\n",
"\01A     *** For environments that use the EBCDIC character set,\n",
"         when compiling XNEdit set the EBCDIC_CHARSET compiler\n",
"         symbol to get the EBCDIC equivalent escape\n",
"         character.)\n",
"\01I\n",
"\01ROctal and Hex Escape Sequences\01I",
"\n\n",
"Any ASCII (or EBCDIC) character, except null, can be specified by using ",
"either an octal escape or a hexadecimal escape, each beginning with \\0 or \\x ",
"(or \\X), respectively.  For example, \\052 and \\X2A both specify the `*' ",
"character.  Escapes for null (\\00 or \\x0) are not valid and will generate an ",
"error message.  Also, any escape that exceeds \\0377 or \\xFF will either cause ",
"an error or have any additional character(s) interpreted literally. For ",
"example, \\0777 will be interpreted as \\077 (a `?' character) followed by `7' ",
"since \\0777 is greater than \\0377. ",
"\n\n",
"An invalid digit will also end an octal or hexadecimal escape.  For example, ",
"\\091 will cause an error since `9' is not within an octal escape's range of ",
"allowable digits (0-7) and truncation before the `9' yields \\0 which is ",
"invalid. ",
"\n\n",
"\01RShortcut Escape Sequences\01I",
"\n\n",
"XNEdit defines some escape sequences that are handy shortcuts for commonly ",
"used character classes. ",
"\n\n",
"\01A   \\d  digits            0-9\n",
"   \\l  letters           a-z, A-Z, and locale dependent letters\n",
"   \\s  whitespace        \\t, \\r, \\v, \\f, and space\n",
"   \\w  word characters   letters, digits, and underscore, `_'\n",
"\01I\n",
"\\D, \\L, \\S, and \\W are the same as the lowercase versions except that the ",
"resulting character class is negated.  For example, \\d is equivalent to ",
"`[0-9]', while \\D is equivalent to `[^0-9]'. ",
"\n\n",
"These escape sequences can also be used within a character class.  For ",
"example, `[\\l_]' is the same as `[a-zA-Z_]', extended with possible locale ",
"dependent letters. The escape sequences for special characters, and octal ",
"and hexadecimal escapes are also valid within a class. ",
"\n\n",
"\01RWord Delimiter Tokens\01I",
"\n\n",
"Although not strictly a character class, the following escape sequences ",
"behave similarly to character classes: ",
"\n\n",
"\01A     \\y   Word delimiter character\n",
"     \\Y   Not a word delimiter character\n",
"\01I\n",
"The `\\y' token matches any single character that is one of the characters ",
"that XNEdit recognizes as a word delimiter character, while the `\\Y' token ",
"matches any character that is \01Knot\01I a word delimiter character.  Word ",
"delimiter characters are dynamic in nature, meaning that the user can change ",
"them through preference settings.  For this reason, they must be handled ",
"differently by the regular expression engine.  As a consequence of this, ",
"`\\y' and `\\Y' cannot be used within a character class specification. ",
NULL
};

static char * htxt_parenConstructs [] = {
"\01RCapturing Parentheses\01I",
"\n\n",
"Capturing Parentheses are of the form `(<regex>)' and can be used to group ",
"arbitrarily complex regular expressions.  Parentheses can be nested, but the ",
"total number of parentheses, nested or otherwise, is limited to 50 pairs. ",
"The text that is matched by the regular expression between a matched set of ",
"parentheses is captured and available for text substitutions and ",
"backreferences (see below.)  Capturing parentheses carry a fairly high ",
"overhead both in terms of memory used and execution speed, especially if ",
"quantified by `*' or `+'. ",
"\n\n",
"\01RNon-Capturing Parentheses\01I",
"\n\n",
"Non-Capturing Parentheses are of the form `(?:<regex>)' and facilitate ",
"grouping only and do not incur the overhead of normal capturing parentheses. ",
"They should not be counted when determining numbers for capturing parentheses ",
"which are used with backreferences and substitutions.  Because of the limit ",
"on the number of capturing parentheses allowed in a regex, it is advisable to ",
"use non-capturing parentheses when possible. ",
"\n\n",
"\01RPositive Look-Ahead\01I",
"\n\n",
"Positive look-ahead constructs are of the form `(?=<regex>)' and implement a ",
"zero width assertion of the enclosed regular expression.  In other words, a ",
"match of the regular expression contained in the positive look-ahead ",
"construct is attempted.  If it succeeds, control is passed to the next ",
"regular expression atom, but the text that was consumed by the positive ",
"look-ahead is first unmatched (backtracked) to the place in the text where ",
"the positive look-ahead was first encountered. ",
"\n\n",
"One application of positive look-ahead is the manual implementation of a ",
"first character discrimination optimization.  You can include a positive ",
"look-ahead that contains a character class which lists every character that ",
"the following (potentially complex) regular expression could possibly start ",
"with.  This will quickly filter out match attempts that cannot possibly ",
"succeed. ",
"\n\n",
"\01RNegative Look-Ahead\01I",
"\n\n",
"Negative look-ahead takes the form `(?!<regex>)' and is exactly the same as ",
"positive look-ahead except that the enclosed regular expression must NOT ",
"match.  This can be particularly useful when you have an expression that is ",
"general, and you want to exclude some special cases.  Simply precede the ",
"general expression with a negative look-ahead that covers the special cases ",
"that need to be filtered out. ",
"\n\n",
"\01RPositive Look-Behind\01I",
"\n\n",
"Positive look-behind constructs are of the form `(?<=<regex>)' and implement ",
"a zero width assertion of the enclosed regular expression in front of the ",
"current matching position.  It is similar to a positive look-ahead assertion, ",
"except for the fact that the match is attempted on the text preceding the ",
"current position, possibly even in front of the start of the matching range ",
"of the entire regular expression. ",
"\n\n",
"A restriction on look-behind expressions is the fact that the expression ",
"must match a string of a bounded size.  In other words, `*', `+', and `{n,}' ",
"quantifiers are not allowed inside the look-behind expression. Moreover, ",
"matching performance is sensitive to the difference between the upper and ",
"lower bound on the matching size.  The smaller the difference, the better the ",
"performance.  This is especially important for regular expressions used in ",
"highlight patterns. ",
"\n\n",
"Positive look-behind has similar applications as positive look-ahead. ",
"\n\n",
"\01RNegative Look-Behind\01I",
"\n\n",
"Negative look-behind takes the form `(?<!<regex>)' and is exactly the same as ",
"positive look-behind except that the enclosed regular expression must ",
"\01Knot\01I match. The same restrictions apply. ",
"\n\n",
"Note however, that performance is even more sensitive to the distance ",
"between the size boundaries: a negative look-behind must not match for ",
"\01Jany\01I possible size, so the matching engine must check \01Jevery\01I size. ",
"\n\n",
"\01RCase Sensitivity\01I",
"\n\n",
"There are two parenthetical constructs that control case sensitivity: ",
"\n\n",
"\01A     (?i<regex>)   Case insensitive; `AbcD' and `aBCd' are\n",
"                   equivalent.\n",
"\01I\n",
"\01A     (?I<regex>)   Case sensitive;   `AbcD' and `aBCd' are\n",
"                   different.\n",
"\01I\n",
"Regular expressions are case sensitive by default, that is, `(?I<regex>)' is ",
"assumed.  All regular expression token types respond appropriately to case ",
"insensitivity including character classes and backreferences.  There is some ",
"extra overhead involved when case insensitivity is in effect, but only to the ",
"extent of converting each character compared to lower case. ",
"\n\n",
"\01RMatching Newlines\01I",
"\n\n",
"XNEdit regular expressions by default handle the matching of newlines in a way ",
"that should seem natural for most editing tasks.  There are situations, ",
"however, that require finer control over how newlines are matched by some ",
"regular expression tokens. ",
"\n\n",
"By default, XNEdit regular expressions will \01Knot\01I match a newline character for ",
"the following regex tokens: dot (`.'); a negated character class (`[^...]'); ",
"and the following shortcuts for character classes: ",
"\n\n",
"\01A     `\\d', `\\D', `\\l', `\\L', `\\s', `\\S', `\\w', `\\W', `\\Y'\n",
"\01I\n",
"The matching of newlines can be controlled for the `.' token, negated ",
"character classes, and the `\\s' and `\\S' shortcuts by using one of the ",
"following parenthetical constructs: ",
"\n\n",
"\01A     (?n<regex>)  `.', `[^...]', `\\s', `\\S' match newlines\n",
"\01I\n",
"\01A     (?N<regex>)  `.', `[^...]', `\\s', `\\S' don't match\n",
"                                            newlines\n",
"\01I\n",
"`(?N<regex>)' is the default behavior. ",
"\n\n",
"\01RNotes on New Parenthetical Constructs\01I",
"\n\n",
"Except for plain parentheses, none of the parenthetical constructs capture ",
"text.  If that is desired, the construct must be wrapped with capturing ",
"parentheses, e.g. `((?i<regex))'. ",
"\n\n",
"All parenthetical constructs can be nested as deeply as desired, except for ",
"capturing parentheses which have a limit of 50 sets of parentheses, ",
"regardless of nesting level. ",
"\n\n",
"\01RBack References\01I",
"\n\n",
"Backreferences allow you to match text captured by a set of capturing ",
"parenthesis at some later position in your regular expression.  A ",
"backreference is specified using a single backslash followed by a single ",
"digit from 1 to 9 (example: \\3).  Backreferences have similar syntax to ",
"substitutions (see below), but are different from substitutions in that they ",
"appear within the regular expression, not the substitution string. The number ",
"specified with a backreference identifies which set of text capturing ",
"parentheses the backreference is associated with. The text that was most ",
"recently captured by these parentheses is used by the backreference to ",
"attempt a match.  As with substitutions, open parentheses are counted from ",
"left to right beginning with 1.  So the backreference `\\3' will try to match ",
"another occurrence of the text most recently matched by the third set of ",
"capturing parentheses.  As an example, the regular expression `(\\d)\\1' could ",
"match `22', `33', or `00', but wouldn't match `19' or `01'. ",
"\n\n",
"A backreference must be associated with a parenthetical expression that is ",
"complete.  The expression `(\\w(\\1))' contains an invalid backreference since ",
"the first set of parentheses are not complete at the point where the ",
"backreference appears. ",
"\n\n",
"\01RSubstitution\01I",
"\n\n",
"Substitution strings are used to replace text matched by a set of capturing ",
"parentheses.  The substitution string is mostly interpreted as ordinary text ",
"except as follows. ",
"\n\n",
"The escape sequences described above for special characters, and octal and ",
"hexadecimal escapes are treated the same way by a substitution string. When ",
"the substitution string contains the `&' character, XNEdit will substitute the ",
"entire string that was matched by the `Find...' operation. Any of the first ",
"nine sub-expressions of the match string can also be inserted into the ",
"replacement string.  This is done by inserting a `\\' followed by a digit from ",
"1 to 9 that represents the string matched by a parenthesized expression ",
"within the regular expression.  These expressions are numbered left-to-right ",
"in order of their opening parentheses. ",
"\n\n",
"The capitalization of text inserted by `&' or `\\1', `\\2', ... `\\9' can be ",
"altered by preceding them with `\\U', `\\u', `\\L', or `\\l'.  `\\u' and `\\l' ",
"change only the first character of the inserted entity, while `\\U' and `\\L' ",
"change the entire entity to upper or lower case, respectively. ",
NULL
};

static char * htxt_advancedTopics [] = {
"\01RSubstitutions\01I",
"\n\n",
"Regular expression substitution can be used to program automatic editing ",
"operations.  For example, the following are search and replace strings to find ",
"occurrences of the `C' language subroutine `get_x', reverse the first and ",
"second parameters, add a third parameter of NULL, and change the name to ",
"`new_get_x': ",
"\n\n",
"\01A     Search string:   `get_x *\\( *([^ ,]*), *([^\\)]*)\\)'\n",
"     Replace string:  `new_get_x(\\2, \\1, NULL)'\n",
"\01I\n",
"\01RAmbiguity\01I",
"\n\n",
"If a regular expression could match two different parts of the text, it will ",
"match the one which begins earliest.  If both begin in the same place but ",
"match different lengths, or match the same length in different ways, life ",
"gets messier, as follows. ",
"\n\n",
"In general, the possibilities in a list of alternatives are considered in ",
"left-to-right order.  The possibilities for `*', `+', and `?' are considered ",
"longest-first, nested constructs are considered from the outermost in, and ",
"concatenated constructs are considered leftmost-first. The match that will be ",
"chosen is the one that uses the earliest possibility in the first choice that ",
"has to be made.  If there is more than one choice, the next will be made in ",
"the same manner (earliest possibility) subject to the decision on the first ",
"choice.  And so forth. ",
"\n\n",
"For example, `(ab|a)b*c' could match `abc' in one of two ways.  The first ",
"choice is between `ab' and `a'; since `ab' is earlier, and does lead to a ",
"successful overall match, it is chosen.  Since the `b' is already spoken for, ",
"the `b*' must match its last possibility, the empty string, since it must ",
"respect the earlier choice. ",
"\n\n",
"In the particular case where no `|'s are present and there is only one `*', ",
"`+', or `?', the net effect is that the longest possible match will be ",
"chosen.  So `ab*', presented with `xabbbby', will match `abbbb'.  Note that ",
"if `ab*' is tried against `xabyabbbz', it will match `ab' just after `x', due ",
"to the begins-earliest rule.  (In effect, the decision on where to start the ",
"match is the first choice to be made, hence subsequent choices must respect ",
"it even if this leads them to less-preferred alternatives.) ",
"\n\n",
"\01RReferences\01I",
"\n\n",
"An excellent book on the care and feeding of regular expressions is ",
"\n\n",
"\01A          Mastering Regular Expressions, 3rd Edition\n",
"          Jeffrey E. F. Friedl\n",
"          August 2006, O'Reilly & Associates\n",
"          ISBN 0-596-52812-4\n",
"\01I\n",
"The first end second editions of this book are still useful for basic ",
"introduction to regexes and contain many useful tips and tricks. ",
NULL
};

static char * htxt_examples [] = {
"\01IThe following are regular expression examples which will match: ",
"\n\n",
"    * An entire line.\n",
"\01A        ^.*$\n",
"\01I\n",
"    * Blank lines.\n",
"\01A        ^$\n",
"\01I\n",
"    * Whitespace on a line.\n",
"\01A        \\s+\n",
"\01I\n",
"    * Whitespace across lines.\n",
"\01A        (?n\\s+)\n",
"\01I\n",
"    * Whitespace that spans at least two lines. Note minimal matching `*?' quantifier.\n",
"\01A        (?n\\s*?\\n\\s*)\n",
"\01I\n",
"    * IP address (not robust).\n",
"\01A        (?:\\d{1,3}(?:\\.\\d{1,3}){3})\n",
"\01I\n",
"    * Two character US Postal state abbreviations (includes territories).\n",
"\01A        [ACDF-IK-PR-W][A-Z]\n",
"\01I\n",
"    * Web addresses.\n",
"\01A        (?:http://)?www\\.\\S+\n",
"\01I\n",
"    * Case insensitive double words across line breaks.\n",
"\01A        (?i(?n<(\\S+)\\s+\\1>))\n",
"\01I\n",
"    * Upper case words with possible punctuation.\n",
"\01A        <[A-Z][^a-z\\s]*>\n",
"\01I\n",
NULL
};

static char * htxt_shell [] = {
"\01IThe Shell menu (Unix versions only) allows you to execute Unix shell commands ",
"from within XNEdit.  You can add items to the menu to extend XNEdit's command ",
"set or to incorporate custom automatic editing features using shell commands ",
"or editing languages like awk and sed.  To add items to the menu, select ",
"Preferences -> Default Settings Customize Menus -> Shell Menu.  XNEdit comes ",
"pre-configured with a few useful Unix commands like spell and sort, but we ",
"encourage you to add your own custom extensions. ",
"\n\n",
"Filter Selection... prompts you for a Unix command to use to process the ",
"currently selected text.  The output from this command replaces the contents ",
"of the selection. ",
"\n\n",
"Execute Command... prompts you for a Unix command and replaces the current ",
"selection with the output of the command.  If there is no  selection, it ",
"deposits the output at the current insertion point. In the Shell Command ",
"field, the % character expands to the name (including directory path), and ",
"the # character expands to the current line number of the file in the window. ",
"To include a % or # character in the command, use %% or ##, respectively. ",
"\n\n",
"Execute Command Line uses the position of the cursor in the window to ",
"indicate a line to execute as a shell command line.  The cursor may be ",
"positioned anywhere on the line.  This command allows you to use an XNEdit ",
"window as an editable command window for saving output and saving commands ",
"for re-execution. Note that the same character expansions described above ",
"in Execute Command also occur with this command. ",
"\n\n",
"The X resource called nedit.shell (See \"\01QCustomizing XNEdit\01I\") determines which ",
"Unix shell is used to execute commands.  The default value for this resource ",
"is the user's login shell. ",
NULL
};

static char * htxt_filters [] = {
"\01IInput/Output Filters are filter commands executed when opening or saving ",
"files. ",
"\n\n",
"File Pattern: A glob pattern used to automatically select filters in the ",
"Open/Save File dialog. When a file that matches a file pattern is selected, ",
"the filter is automatically applied. ",
"\n\n",
"Default Extension: The default file extension is automatically added to a file ",
"name when a filter is selected in the \"Save File As\" dialog. ",
"\n\n",
"Input Filter Command: The command line executed when a filter is selected in ",
"the Open File dialog and the file is opened. The command receives the file ",
"content as input, and a document with the command's output is opened. ",
"\n\n",
"Output Filter Command: The command line executed when a file is saved and a ",
"filter was selected, either in the \"Save File As\" dialog or previously when ",
"the document was opened with a filter. The command receives the document ",
"content as input, and the output of the command is written to the file. ",
NULL
};

static char * htxt_learn [] = {
"\01ISelecting Learn Keystrokes from the Macro menu puts XNEdit in learn mode.  In ",
"learn mode, keystrokes and menu commands are recorded, to be played back ",
"later, using the Replay Keystrokes command, or pasted into a macro in the ",
"Macro Commands dialog of the Default Settings menu in Preferences. ",
"\n\n",
"Note that only keyboard and menu commands are recorded, not mouse clicks or ",
"mouse movements since these have no absolute point of reference, such as ",
"cursor or selection position.  When you do a mouse-based operation in learn ",
"mode, XNEdit will beep (repeatedly) to remind you that the operation was not ",
"recorded. ",
"\n\n",
"Learn mode is also the quickest and easiest method for writing macros.  The ",
"dialog for creating macro commands contains a button labeled \"Paste Learn / ",
"Replay Macro\", which will deposit the last sequence learned into the body of ",
"the macro. ",
"\n\n",
"\01RRepeating Actions and Learn/Replay Sequences\01I",
"\n\n",
"You can repeat the last (keyboard-based) command, or learn/replay sequence ",
"with the Repeat... command in the Macro menu.  To repeat an action, first do ",
"the action (that is, insert a character, do a search, move the cursor), then ",
"select Repeat..., decide how or how many times you want it repeated, and ",
"click OK.  For example, to move down 30 lines through a file, you could type: ",
"<Down Arrow> Ctrl+, 29 <Return>.  To repeat a learn/replay sequence, first ",
"learn it, then select Repeat..., click on Learn/Replay and how you want it ",
"repeated, then click OK. ",
"\n\n",
"If the commands you are repeating advance the cursor through the file, you ",
"can also repeat them within a range of characters, or from the current cursor ",
"position to the end of the file.  To iterate over a range of characters, use ",
"the primary selection (drag the left mouse button over the text) to mark the ",
"range you want to operate on, and select \"In Selection\" in the Repeat dialog. ",
"\n\n",
"When using In \"Selection\" or \"To End\" with a learned sequence, try to do ",
"cursor movement as the last step in the sequence, since testing of the cursor ",
"position is only done at the end of the sequence execution.  If you do cursor ",
"movement first, for example searching for a particular word then doing a ",
"modification, the position of the cursor won't be checked until the sequence ",
"has potentially gone far beyond the end of your desired range. ",
"\n\n",
"It's easy for a repeated command to get out of hand, and you can easily ",
"generate an infinite loop by using range iteration on a command which doesn't ",
"progress.  To cancel a repeating command in progress, type Ctrl+. (period), ",
"or select Cancel Macro from the Macro menu. ",
NULL
};

static char * htxt_macro_lang [] = {
"\01IMacros can be called from Macro menu commands, window background menu ",
"commands, within the smart-indent framework, from the autoload macro file, ",
"cf. \01QPreferences\01I, and from the command line. ",
"Macro menu and window background menu commands are defined under Preferences ",
"-> Default Settings -> Customize Menus.  Help on creating items in these ",
"menus can be found in the section \01QPreferences\01I. ",
"\n\n",
"XNEdit's macro language is a simple interpreter with integer arithmetic, ",
"dynamic strings, and C-style looping constructs (very similar to the ",
"procedural portion of the Unix awk program).  From the macro language, you ",
"can call the same action routines which are bound to keyboard keys and menu ",
"items, as well additional subroutines for accessing and manipulating editor ",
"data, which are specific to the macro language (these are listed in the ",
"sections titled \"\01QMacro Subroutines\01I\", and \"\01QAction Routines\01I\"). ",
"\n\n",
"\01RSyntax\01I",
"\n\n",
"An XNEdit macro language program consists of a list of statements, each ",
"terminated by a newline.  Groups of statements which are executed together ",
"conditionally, such as the body of a loop, are surrounded by curly braces ",
"\"{}\". ",
"\n\n",
"Blank lines and comments are also allowed.  Comments begin with a \"#\" and end ",
"with a newline, and can appear either on a line by themselves, or at the end ",
"of a statement. ",
"\n\n",
"Statements which are too long to fit on a single line may be split across ",
"several lines, by placing a backslash \"\\\" character at the end of each line ",
"to be continued. ",
"\n\n",
"\01RData Types\01I",
"\n\n",
"The XNEdit macro language recognizes only three data types, dynamic character ",
"strings, integer values and associative arrays. In general strings and ",
"integers can be used interchangeably. If a string represents an integer ",
"value, it can be used as an integer. Integers can be compared and ",
"concatenated with strings. Arrays may contain integers, strings, or arrays. ",
"Arrays are stored key/value pairs. Keys are always stored as strings. ",
"\n\n",
"\01SInteger Constants\01I",
"\n\n",
"Integers are non-fractional numbers in the range of -2147483647 to ",
"2147483647.  Integer constants must be in decimal.  For example: ",
"\n\n",
"\01A    a = -1\n",
"    b = 1000\n",
"\01I\n",
"\01SCharacter String Constants\01I",
"\n\n",
"Character string constants are enclosed in double quotes.  For example: ",
"\n\n",
"\01A     a = \"a string\"\n",
"     dialog(\"Hi there!\", \"OK\")\n",
"\01I\n",
"Strings may also include C-language style escape sequences: ",
"\n\n",
"\01A     \\\\ Backslash     \\t Tab              \\f Form feed\n",
"     \\\" Double quote  \\b Backspace        \\a Alert\n",
"     \\n Newline       \\r Carriage return  \\v Vertical tab\n",
"\01I\n",
"Also allowed is the escape control character sequence: ",
"\n\n",
"\01A     \\e Escape (ASCII or EBCDIC,\n",
"                depending on XNEdit compilation settings)\n",
"\01I\n",
"For example, to send output to the terminal from which XNEdit was started, a ",
"newline character is necessary because, like printf, t_print requires ",
"explicit newlines, and also buffers its output on a per-line basis: ",
"\n\n",
"\01A     t_print(\"a = \" a \"\\n\")\n",
"\01I\n",
"Other characters can be expressed as backslash-escape sequences in macro ",
"strings. The format is the same as for regular expressions, described in the ",
"paragraphs headed \"Octal and Hex Escape Sequences\" of the section ",
"\"\01QMetacharacters\01I\", except that an octal escape sequence can start with any ",
"octal digit, not just 0, so the single character string \"\\0033\" is the same ",
"as \"\\33\", \"\\x1B\" and \"\\e\" (for an ASCII version of XNEdit). ",
"\n\n",
"Note that if you want to define a regular expression in a macro string, ",
"you need to \"double-up\" the backslashes for the metacharacters with ",
"special meaning in regular expressions. For example, the expression ",
"\n\n",
"\01A     (?N(\\s|/\\*(?n(?:(?!\\*/).)*)\\*/|//.*\\n|\\n)+)\n",
"\01I\n",
"which matches whitespace or C/C++/Java-style comments, should be written as ",
"a macro string as ",
"\n\n",
"\01A     \"(?N(\\\\s|/\\\\*(?n(?:(?!\\\\*/).)*)\\\\*/|//.*\\n|\\n)+)\"\n",
"\01I\n",
"(The \"\\n\"s towards the end add literal newline characters to the string. The ",
"regular expression interpretation treats the newlines as themselves. It can ",
"also interpret the sequence \"\\\\n\" as a newline, although the macro string here ",
"would then contain a literal backslash followed by a lowercase `N'.) ",
"\n\n",
"\01RVariables\01I",
"\n\n",
"Variable names must begin either with a letter (local variables), or a $ ",
"(global variables).  Beyond the first character, variables may also contain ",
"numbers and underscores `_'.  Variables are called in to existence just by ",
"setting them (no explicit declarations are necessary). ",
"\n\n",
"Local variables are limited in scope to the subroutine (or menu item ",
"definition) in which they appear.  Global variables are accessible from all ",
"routines, and their values persist beyond the call which created them, until ",
"reset. ",
"\n\n",
"\01SBuilt-in Variables\01I",
"\n\n",
"XNEdit has a number of permanently defined variables, which are used to access ",
"global editor information and information about the window in which the ",
"macro is executing.  These are listed along with the built in functions in ",
"the section titled \"\01QMacro Subroutines\01I\". ",
"\n\n",
"\01RFunctions and Subroutines\01I",
"\n\n",
"The syntax of a function or subroutine call is: ",
"\n\n",
"\01A     function_name(arg1, arg2, ...)\n",
"\01I\n",
"where arg1, arg2, etc. represent the argument values which are passed to ",
"the routine being called.  A function or subroutine call can be on a line by ",
"itself, as above, or if it returns a value, can be invoked within a character ",
"or numeric expression: ",
"\n\n",
"\01A     a = fn1(b, c) + fn2(d)\n",
"     dialog(\"fn3 says: \" fn3())\n",
"\01I\n",
"Arguments are passed by value.  This means that you cannot return values via ",
"the argument list, only through the function value or indirectly through ",
"agreed-upon global variables. ",
"\n\n",
"\01SBuilt-in Functions\01I",
"\n\n",
"XNEdit has a wide range of built in functions which can be called from the ",
"macro language.  These routines are divided into two classes, macro-language ",
"functions, and editor action routines.  Editor action routines are more ",
"flexible, in that they may be called either from the macro language, or bound ",
"directly to keys via translation tables.  They are also limited, however, in ",
"that they cannot return values.  Macro language routines can return values, ",
"but cannot be bound to keys in translation tables. ",
"\n\n",
"Nearly all of the built-in subroutines operate on an implied window, which is ",
"initially the window from which the macro was started.  To manipulate the ",
"contents of other windows, use the focus_window subroutine to change the ",
"focus to the ones you wish to modify.  focus_window can also be used to ",
"iterate over all of the currently open windows, using the special keyword ",
"names, \"last\" and \"next\". ",
"\n\n",
"For backwards compatibility, hyphenated action routine names are allowed, and ",
"most of the existing action routines names which contain underscores have an ",
"equivalent version containing hyphens ('-') instead of underscores.  Use of ",
"these names is discouraged.  The macro parser resolves the ambiguity between ",
"'-' as the subtraction/negation operator, and - as part of an action routine ",
"name by assuming subtraction unless the symbol specifically matches an action ",
"routine name. ",
"\n\n",
"\01SUser Defined Functions\01I",
"\n\n",
"Users can define their own macro subroutines, using the define keyword: ",
"\n\n",
"\01A     define subroutine_name {\n",
"        < body of subroutine >\n",
"     }\n",
"\01I\n",
"Subroutine definitions cannot appear within other definitions, nor within ",
"macro menu item definitions.  They can only appear in (macro) files, such as ",
"the autoload macro file, cf. \01QPreferences\01I. Macro files can be loaded with ",
"File -> Load Macro File or with the load_macro_file() action. ",
"\n\n",
"The arguments with which a user-defined subroutine or function was invoked, ",
"are presented as $1, $2, ... , $9 or $args[expr], where expr can be evaluated ",
"to an integer from 1 to the number of arguments.  The number of arguments can ",
"be read from $n_args or $args[]. The array $args[expr] is the only way to ",
"access arguments beyond the first 9. ",
"\n\n",
"To return a value from a subroutine, and/or to exit from the subroutine ",
"before the end of the subroutine body, use the return statement: ",
"\n\n",
"\01A     return <value to return>\n",
"\01I\n",
"\01ROperators and Expressions\01I",
"\n\n",
"Operators have the same meaning and precedence that they do in C, except for ",
"^, which raises a number to a power (y^x means y to the x power), rather than ",
"bitwise exclusive OR.  The table below lists operators in decreasing order of ",
"precedence. ",
"\n\n",
"\01A     Operators                Associativity\n",
"     ()\n",
"     ^                        right to left\n",
"     - ! ++ --                (unary)\n",
"     * / %                    left to right\n",
"     + -                      left to right\n",
"     > >= < <= == !=          left to right\n",
"     &                        left to right\n",
"     |                        left to right\n",
"     &&                       left to right\n",
"     ||                       left to right\n",
"     (concatenation)          left to right\n",
"     = += -= *= /= %=, &= |=  right to left\n",
"\01I\n",
"The order in which operands are evaluated in an expression is undefined, ",
"except for && and ||, which like C, evaluate operands left to right, but stop ",
"when further evaluation would no longer change the result. ",
"\n\n",
"\01SNumerical Operators\01I",
"\n\n",
"The numeric operators supported by the XNEdit macro language are listed below: ",
"\n\n",
"\01A     + addition\n",
"     - subtraction or negation\n",
"     * multiplication\n",
"     / division\n",
"     % modulo\n",
"     ^ power\n",
"     & bitwise and\n",
"     | bitwise or\n",
"\01I\n",
"Increment (++) and decrement (--) operators can also be appended or prepended ",
"to variables within an expression.  Prepended increment/decrement operators ",
"act before the variable is evaluated.  Appended increment/decrement operators ",
"act after the variable is evaluated. ",
"\n\n",
"\01SLogical and Comparison Operators\01I",
"\n\n",
"Logical operations produce a result of 0 (for false) or 1 (for true).  In a ",
"logical operation, any non-zero value is recognized to mean true.  The ",
"logical and comparison operators allowed in the XNEdit macro language are ",
"listed below: ",
"\n\n",
"\01A     && logical and\n",
"     || logical or\n",
"     !  not\n",
"     >  greater\n",
"     <  less\n",
"     >= greater or equal\n",
"     <= less or equal\n",
"     == equal (integers and/or strings)\n",
"     != not equal (integers and/or strings)\n",
"\01I\n",
"\01SCharacter String Operators\01I",
"\n\n",
"The \"operator\" for concatenating two strings is the absence of an operator. ",
"Adjoining character strings with no operator in between means concatenation: ",
"\n\n",
"\01A     d = a b \"string\" c\n",
"     t_print(\"the value of a is: \" a)\n",
"\01I\n",
"Comparison between character strings is done with the == and != operators, ",
"(as with integers).  There are a number of useful built-in routines for ",
"working with character strings, which are listed in the section called ",
"\"\01QMacro Subroutines\01I\". ",
"\n\n",
"\01SArrays and Array Operators\01I",
"\n\n",
"Arrays may contain either strings, integers, or other arrays. Arrays are ",
"associative, which means that they relate two pieces of information, the key ",
"and  the value. The key is always a string; if you use an integer it is ",
"converted to a string. ",
"\n\n",
"To determine if a given key is in an array, use the 'in' keyword. ",
"\n\n",
"\01A      if (\"6\" in x)\n",
"          <body>\n",
"\01I\n",
"If the left side of the in keyword is an array, the result is true if every ",
"key in the left array is in the right array. Array values are not compared. ",
"\n\n",
"To iterate through all the keys of an array use the 'for' looping construct. ",
"Keys are not guaranteed in any particular order: ",
"\n\n",
"\01A      for (aKey in x)\n",
"          <body>\n",
"\01I\n",
"Elements can be removed from an array using the delete command: ",
"\n\n",
"\01A      delete x[3] # deletes element with key 3\n",
"      delete x[]  # deletes all elements\n",
"\01I\n",
"The number of elements in an array can be determined by referencing the ",
"array with no indices: ",
"\n\n",
"\01A      dialog(\"array x has \" x[] \" elements\", \"OK\")\n",
"\01I\n",
"Arrays can be combined with some operators. All the following operators only ",
"compare the keys of the arrays. ",
"\n\n",
"\01A      result = x + y   (Merge arrays)\n",
"\01I\n",
"The 'result' is a new array containing keys from both x and y. If ",
"duplicates are present values from y are used. ",
"\n\n",
"\01A      result = x - y   (Remove keys)\n",
"\01I\n",
"The 'result' is a new array containing all keys from x that are not in y. ",
"\n\n",
"\01A      result = x & y   (Common keys)\n",
"\01I\n",
"The 'result' is a new array containing all keys which are in both x and y. ",
"The values from y are used. ",
"\n\n",
"\01A      result = x | y   (Unique keys)\n",
"\01I\n",
"The 'result' is a new array containing keys which exist in either x or y, ",
"but not both. ",
"\n\n",
"When duplicate keys are encountered using the + and & operators, the values ",
"from the array on the right side of the operators are used for the result. ",
"All  of the above operators are array only, meaning both the left and right ",
"sides of the operator must be arrays. The results are also arrays. ",
"\n\n",
"Array keys can also contain multiple dimensions: ",
"\n\n",
"\01A      x[1, 1, 1] = \"string\"\n",
"\01I\n",
"These are used in the expected way, e.g.: ",
"\n\n",
"\01A      for (i = 1; i < 3; i++)\n",
"      {\n",
"          for (j = 1; j < 3; j++)\n",
"          {\n",
"              x[i, j] = k++\n",
"          }\n",
"      }\n",
"\01I\n",
"gives the following array: ",
"\n\n",
"\01A      x[1, 1] = 0\n",
"      x[1, 2] = 1\n",
"      x[2, 1] = 2\n",
"      x[2, 2] = 3\n",
"\01I\n",
"Internally all indices are part of one string, separated by the string ",
"$sub_sep (ASCII 0x1c, 'FS'). The first key in the above example is in ",
"fact: ",
"\n\n",
"\01A      [\"1\" $sub_sep \"1\"]\n",
"\01I\n",
"If you need to extract one of the keys, you can use split(), using ",
"$sub_sep as the separator. ",
"\n\n",
"You can also check for the existence of multi-dimensional array by ",
"looking for $sub_sep in the key. ",
"\n\n",
"Last, you need $sub_sep if you want to use the 'in' keyword. ",
"\n\n",
"\01A      if ((1,2) in myArray)\n",
"      {..}\n",
"\01I\n",
"doesn't work, but ",
"\n\n",
"\01A      if ((\"1\" $sub_sep \"2\") in myArray)\n",
"      {..}\n",
"\01I\n",
"does work. ",
"\n\n",
"\01RLooping and Conditionals\01I",
"\n\n",
"XNEdit supports looping constructs: for and while, and conditional statements: ",
"if and else, with essentially the same syntax as C: ",
"\n\n",
"\01A     for (<init>, ...; <condition>; <increment>, ...) <body>\n",
"\01I\n",
"\01A     while (<condition>) <body>\n",
"\01I\n",
"\01A     if (<condition>) <body>\n",
"\01I\n",
"\01A     if (<condition>) <body> else <body>\n",
"\01I\n",
"<body>, as in C, can be a single statement, or a list of statements enclosed ",
"in curly braces ({}).  <condition> is an expression which must evaluate to ",
"true for the statements in <body> to be executed.  for loops may also contain ",
"initialization statements, <init>, executed once at the beginning of the ",
"loop, and increment/decrement statements (or any arbitrary statement), which ",
"are executed at the end of the loop, before the condition is evaluated again. ",
"\n\n",
"Examples: ",
"\n\n",
"\01A    for (i=0; i<100; i++)\n",
"       j = i * 2\n",
"\01I\n",
"\01A    for (i=0, j=20; i<20; i++, j--) {\n",
"       k = i * j\n",
"       t_print(i, j, k)\n",
"    }\n",
"\01I\n",
"\01A    while (k > 0)\n",
"    {\n",
"       k = k - 1\n",
"       t_print(k)\n",
"    }\n",
"\01I\n",
"\01A    for (;;) {\n",
"       if (i-- < 1)\n",
"           break\n",
"    }\n",
"\01I\n",
"Loops may contain break and continue statements.  A \01Jbreak\01I statement ",
"causes an exit from the innermost loop, a \01Jcontinue\01I statement transfers ",
"control to the end of the loop. ",
NULL
};

static char * htxt_macro_subrs [] = {
"\01RBuilt in Variables\01I",
"\n\n",
"These variables are read-only and cannot be changed by direct assignment. ",
"\n\n",
"\01A\01B$1\01A, \01B$2\01A, \01B$3\01A, \01B$4\01A, \01B$5\01A, \01B$6\01A, \01B$7\01A, \01B$8\01A, \01B$9\01A\n",
"\01B$args\01A[\01Cexpr\01A]\n",
"\01B$n_args\01A\n",
"\01IArgument information. The first 9 arguments (if there are that many) can ",
"be referenced as read-only values using the shorthand form. All arguments ",
"can be accessed as values in the \01J$args\01I array, using a numeric index ",
"starting at 1. The total number of arguments received by a function is ",
"given by \01J$n_args\01I or \01J$args[]\01I. ",
"\n\n",
"\01A\01B$active_pane\01A\n",
"\01IIndex of the current pane. ",
"\n\n",
"\01A\01B$auto_indent\01A\n",
"\01IContains the current preference for auto indent. ",
"Can be  \"off\", \"on\", or \"smart\". ",
"\n\n",
"\01A\01B$calltip_ID\01A\n",
"\01IEquals the ID of the currently displayed calltip, or 0 if no calltip is ",
"being displayed. ",
"\n\n",
"\01A\01B$cursor\01A\n",
"\01IPosition of the cursor in the current window. ",
"\n\n",
"\01A\01B$column\01A\n",
"\01IColumn number of the cursor position in the current window. ",
"\n\n",
"\01A\01B$display_width\01A\n",
"\01IWidth of the current pane in pixels. ",
"\n\n",
"\01A\01B$em_tab_dist\01A\n",
"\01IIf tab stop emulation is turned on in the Tab Stops... ",
"dialog of the Preferences menu, the value is the ",
"distance between emulated tab stops. If tab ",
"emulation is turned off, the value is 0. ",
"\n\n",
"\01A\01B$empty_array\01A\n",
"\01IAn array with no elements. This can be used to initialize ",
"an array to an empty state. ",
"\n\n",
"\01A\01B$file_format\01A\n",
"\01ICurrent newline format that the file will be saved with. Can ",
"be \"unix\", \"dos\" or \"macintosh\". ",
"\n\n",
"\01A\01B$file_name\01A\n",
"\01IName of the file being edited in the current ",
"window, stripped of directory component. ",
"\n\n",
"\01A\01B$file_path\01A\n",
"\01IDirectory component of file being edited in the current window. ",
"\n\n",
"\01A\01B$font_name\01A\n",
"\01IContains the current plain text font name. ",
"\n\n",
"\01A\01B$font_name_bold\01A\n",
"\01IContains the current bold text font name. ",
"\n\n",
"\01A\01B$font_name_bold_italic\01A\n",
"\01IContains the current bold-italic text font name. ",
"\n\n",
"\01A\01B$font_name_italic\01A\n",
"\01IContains the current italic text font name. ",
"\n\n",
"\01A\01B$highlight_syntax\01A\n",
"\01IWhether syntax highlighting is turned on. ",
"\n\n",
"\01A\01B$incremental_backup\01A\n",
"\01IContains 1 if incremental auto saving is on, otherwise 0. ",
"\n\n",
"\01A\01B$incremental_search_line\01A\n",
"\01IHas a value of 1 if the preference is ",
"selected to always show the incremental search line, otherwise 0. ",
"\n\n",
"\01A\01B$language_mode\01A\n",
"\01IName of language mode set in the current window. ",
"\n\n",
"\01A\01B$line\01A\n",
"\01ILine number of the cursor position in the current window. ",
"\n\n",
"\01A\01B$locked\01A\n",
"\01ITrue if the file has been locked by the user. ",
"\n\n",
"\01A\01B$make_backup_copy\01A\n",
"\01IHas a value of 1 if original file is kept in a ",
"backup file on save, otherwise 0. ",
"\n\n",
"\01A\01B$max_font_width\01A\n",
"\01IThe maximum font width of all the active styles. ",
"Syntax highlighting styles are only considered if syntax highlighting ",
"is turned on. ",
"\n\n",
"\01A\01B$min_font_width\01A\n",
"\01IThe minimum font width of all the active styles. ",
"Syntax highlighting styles are only considered if syntax highlighting ",
"is turned on. ",
"\n\n",
"\01A\01B$modified\01A\n",
"\01ITrue if the file in the current window has ",
"been modified and the modifications have not ",
"yet been saved. ",
"\n\n",
"\01A\01B$VERSION\01A\n",
"\01IReturns XNEdit's version number ('5006' for XNEdit 5.6). ",
"\n\n",
"\01A\01B$n_display_lines\01A\n",
"\01IThe number of lines visible in the currently active pane. ",
"\n\n",
"\01A\01B$n_panes\01A\n",
"\01IThe number of panes in the current window. ",
"\n\n",
"\01A\01B$overtype_mode\01A\n",
"\01ITrue if in Overtype mode. ",
"\n\n",
"\01A\01B$read_only\01A\n",
"\01ITrue if the file is read only. ",
"\n\n",
"\01A\01B$selection_start, $selection_end\01A\n",
"\01IBeginning and ending positions of the ",
"primary selection in the current window, or ",
"-1 if there is no text selected in the current window. ",
"\n\n",
"\01A\01B$selection_left, $selection_right\01A\n",
"\01ILeft and right character offsets of the rectangular (primary) selection in ",
"the current window, or -1 if there is no selection or it is not rectangular. ",
"\n\n",
"\01A\01B$server_name\01A\n",
"\01IName of the current XNEdit server. ",
"\n\n",
"\01A\01B$show_line_numbers\01A\n",
"\01IWhether line numbers are shown next to the text. ",
"\n\n",
"\01A\01B$show_matching\01A\n",
"\01IContains the current preference for showing matching pairs, ",
"such as \"[]\" and \"{}\" pairs. Can be \"off\", \"delimiter\", or \"range\". ",
"\n\n",
"\01A\01B$match_syntax_based\01A\n",
"\01IWhether pair matching should use syntax information, if available. ",
"\n\n",
"\01A\01B$statistics_line\01A\n",
"\01IHas a value of 1 if the statistics line is shown, otherwise 0. ",
"\n\n",
"\01A\01B$sub_sep\01A\n",
"\01IContains the value of the array sub-script separation string. ",
"\n\n",
"\01A\01B$tab_dist\01A\n",
"\01IThe distance between tab stops for a ",
"hardware tab character, as set in the ",
"Tab Stops... dialog of the Preferences menu. ",
"\n\n",
"\01A\01B$text_length\01A\n",
"\01IThe length of the text in the current document. ",
"\n\n",
"\01A\01B$top_line\01A\n",
"\01IThe line number of the top line of the currently active pane. ",
"\n\n",
"\01A\01B$use_tabs\01A\n",
"\01IWhether the user is allowing the XNEdit to insert tab characters to maintain ",
"spacing in tab emulation and rectangular dragging operations. (The setting of ",
"the \"Use tab characters in padding and emulated tabs\" button in the ",
"Tab Stops... dialog of the Preferences menu.) ",
"\n\n",
"\01A\01B$wrap_margin\01A\n",
"\01IThe right margin in the current window for text wrapping and filling. ",
"\n\n",
"\01A\01B$wrap_text\01A\n",
"\01IThe current wrap text mode. Values are \"none\", \"auto\" or \"continuous\". ",
"\n\n",
"\01RBuilt-in Subroutines\01I",
"\n\n",
"\01A\01Bappend_file( string, filename )\01A\n",
"\01IAppends a string to a named file. Returns 1 on successful write, or 0 if ",
"unsuccessful. ",
"\n\n",
"\01A\01Bbeep()\01A\n",
"\01IRing the bell. ",
"\n\n",
"\01A\01Bcalltip( \"text_or_key\" [, pos [, mode or position_modifier, ...]] )\01A\n",
"\01IPops up a calltip. <pos> is an optional position in the buffer where the tip ",
"will be displayed. Passing -1 for <pos> is equivalent to not specifying a ",
"position, and it guarantees that the tip will appear on-screen somewhere even ",
"if the cursor is not. The upper-left corner of the calltip will appear below ",
"where the cursor would appear if it were at this position. ",
"\n\n",
"<mode> is one of \"tipText\" (default), \"tipKey\", or \"tagKey\". \"tipText\" ",
"displays the text as-is, \"tagKey\" uses it as the key to look up a tag, then ",
"converts the tag to a calltip, and \"tipKey\" uses it as the key to look up a ",
"calltip, then falls back to \"tagKey\" behavior if that fails. You'll usually ",
"use \"tipKey\" or \"tipText\". ",
"\n\n",
"Finally, you can modify the placement of the calltip relative to the cursor ",
"position (or <pos>) with one or more of these optional position modifiers: ",
"\"center\" aligns the center of the calltip with the position. \"right\" aligns ",
"the right edge of the calltip with the position. (\"center\" and \"right\" may ",
"not both be used.) \"above\" places the calltip above the position. \"strict\" ",
"does not allow the calltip to move from its position in order to avoid going ",
"off-screen or obscuring the cursor. ",
"\n\n",
"Returns the ID of the calltip if it was found and/or displayed correctly, ",
"0 otherwise. ",
"\n\n",
"\01A\01Bclipboard_to_string()\01A\n",
"\01IReturns the contents of the clipboard as a macro string. Returns empty ",
"string on error. ",
"\n\n",
"\01A\01Bdialog( message, btn_1_label, btn_2_label, ... )\01A\n",
"\01IPop up a dialog for querying and presenting information to the user. First ",
"argument is a string to show in the message area of the dialog. ",
"Additional optional arguments represent labels for buttons to appear along ",
"the bottom of the dialog. Returns the number of the button pressed (the ",
"first button is number 1), or 0 if the user closed the dialog via the window ",
"close box. ",
"\n\n",
"\01A\01Bfilename_dialog( [title[, mode[, defaultPath[, filter[, defaultName]]]]] )\01A\n",
"\01IPresents a file selection dialog with the given title to the user that ",
"prompts for a new or existing file. ",
"\n\n",
"Options are: \01Ktitle\01I will be the title of the dialog, defaults to \"Choose ",
"file\". If \01Kmode\01I is set to \"exist\" (default), the \"New File Name\"TextField ",
"of the FSB will be unmanaged. If \"new\", the TextField will be managed. ",
"\01KdefaultPath\01I is the default path to use. Default (or \"\") will use the ",
"active document's directory. \01Kfilter\01I is the file glob which determines ",
"which files to display. Is set to \"*\" if filter is \"\" and by default. ",
"\01KdefaultName\01I is the default filename that is filled in automatically. ",
"(\01JNote\01I that the default_filename argument does not work on all Motif ",
"implementations.) ",
"\n\n",
"Returns \"\" if the user cancelled the dialog, otherwise returns the ",
"fully-qualified path, including the filename. ",
"\n\n",
"\01A\01Bfocus_window( window_name )\01A  \n",
"\01ISets the window on which subsequent macro commands operate. window_name can ",
"be either a fully qualified file name, or a relative filename (which will ",
"be completed from XNEdit's working directory) or one of \"last\" for the last ",
"window created, or \"next\" for the next window in the chain from the currently ",
"focused window (the first window being the one returned from calling ",
"focus_window(\"last\"). Returns the name of the newly-focused window, or an ",
"empty string if the requested window was not found. ",
"\n\n",
"\01A\01Bget_character( position )\01A\n",
"\01IReturns the single character at the position ",
"indicated by the first argument to the routine from the current window. ",
"\n\n",
"\01A\01Bget_range( start, end )\01A\n",
"\01IReturns the text between a starting and ending position from the current ",
"window. ",
"\n\n",
"\01A\01Bget_selection()\01A\n",
"\01IReturns a string containing the text currently selected by the primary ",
"selection either from the current window (no keyword), or from anywhere on ",
"the screen (keyword \"any\"). ",
"\n\n",
"\01A\01Bgetenv( name )\01A\n",
"\01IGets the value of an environment variable. ",
"\n\n",
"\01A\01Bkill_calltip( [calltip_ID] )\01A\n",
"\01IKills any calltip that is being displayed in the window in which the macro is ",
"running.  If there is no displayed calltip this does nothing.  If a calltip ",
"ID is supplied then the calltip is killed only if its ID is calltip_ID. ",
"\n\n",
"\01A\01Blength( string )\01A\n",
"\01IReturns the length of a string ",
"\n\n",
"\01A\01Blist_dialog( message, text, btn_1_label, btn_2_label, ... )\01A\n",
"\01IPop up a dialog for prompting the user to choose a line from the given text ",
"string. The first argument is a message string to be used as a title for the ",
"fixed text describing the list. The second string provides the list data: ",
"this is a text string in which list entries are separated by newline ",
"characters. Additional optional arguments represent labels for ",
"buttons to appear along the bottom of the dialog. Returns the line of text ",
"selected by the user as the function value (without any newline separator) or ",
"the empty string if none was selected, and number of the button pressed (the ",
"first button is number 1), in $list_dialog_button. If the user closes the ",
"dialog via the window close box, the function returns the empty string, and ",
"$list_dialog_button returns 0. ",
"\n\n",
"\01A\01Bmax( n1, n2, ... )\01A\n",
"\01IReturns the maximum value of all of its arguments ",
"\n\n",
"\01A\01Bmin( n1, n2, ... )\01A\n",
"\01IReturns the minimum value of all of its arguments ",
"\n\n",
"\01A\01Bread_file( filename )\01A  \n",
"\01IReads the contents of a text file into a string. On success, returns 1 in ",
"$read_status, and the contents of the file as a string in the subroutine ",
"return value. On failure, returns the empty string \"\" and an 0 $read_status. ",
"\n\n",
"\01A\01Breplace_in_string( string, search_for, replace_with [, type, \"copy\"] )\01A\n",
"\01IReplaces all occurrences of a search string in a string with a replacement ",
"string. Arguments are 1: string to search in, 2: string to search for, 3: ",
"replacement string.  There are two optional arguments.  One is a search type, ",
"either \"literal\", \"case\", \"word\", \"caseWord\", \"regex\", or \"regexNoCase\". ",
"The default search type is \"literal\".  If the optional \"copy\" argument is ",
"specified, a copy of the input string is returned when no replacements were ",
"performed.  By default an empty string (\"\") will be returned in this case. ",
"Returns a new string with all of the replacements done. ",
"\n\n",
"\01A\01Breplace_range( start, end, string )\01A\n",
"\01IReplaces all the text between two positions in the current window. If the ",
"cursor position is between start and end it will be set to start. ",
"\n\n",
"\01A\01Breplace_selection( string )\01A\n",
"\01IReplaces the primary-selection selected text in the current window. ",
"\n\n",
"\01A\01Breplace_substring( string, start, end, replace_with )\01A\n",
"\01IReplacing a substring between two positions in a string within another string. ",
"\n\n",
"\01A\01Brevert_to_saved()\01A\n",
"\01IReloads the file, discarding all changes done to the document by the user ",
"since the last save. ",
"\n\n",
"\01A\01Bsearch( search_for, start [, search_type, wrap, direction] )\01A\n",
"\01ISearches silently in a window without dialogs, beeps, or changes to the ",
"selection. Arguments are: 1: string to search for, 2: starting position. ",
"Optional arguments may include the strings: \"wrap\" to make the search wrap ",
"around the beginning or end of the string, \"backward\" or \"forward\" to change ",
"the search direction (\"forward\" is the default), \"literal\", \"case\", \"word\", ",
"\"caseWord\", \"regex\", or \"regexNoCase\" to change the search  type  (default is ",
"\"literal\"). Returns the starting position of the  match, or -1 if nothing ",
"matched. Also returns the ending position  of the match in $search_end. ",
"\n\n",
"\01A\01Bsearch_string( string, search_for, start [, search_type, direction] )\01A\n",
"\01IBuilt-in macro subroutine for searching a string. Arguments are 1: string to ",
"search in, 2: string to search for, 3: starting position. Optional arguments ",
"may include the strings: \"wrap\" to make the search wrap around the beginning ",
"or end of the string, \"backward\" or \"forward\" to change the search direction ",
"(\"forward\" is the default), \"literal\", \"case\", \"word\", \"caseWord\", \"regex\", ",
"or \"regexNoCase\" to change the search type (default is \"literal\"). Returns ",
"the starting position of the match, or -1 if nothing matched. Also returns ",
"the ending position of the match in $search_end. ",
"\n\n",
"\01A\01Bselect( start, end )\01A\n",
"\01ISelects (with the primary selection) text in the current buffer between a ",
"starting and ending position. ",
"\n\n",
"\01A\01Bselect_rectangle( start, end, left, right )\01A\n",
"\01ISelects a rectangular area of text between a starting and ending position, ",
"and confined horizontally to characters displayed between positions \"left\", ",
"and \"right\". ",
"\n\n",
"\01A\01Bset_cursor_pos( position )\01A\n",
"\01ISet the cursor position for the current window. ",
"\n\n",
"\01A\01Bshell_command( command, input_string )\01A\n",
"\01IExecutes a shell command, feeding it input from input_string. On completion, ",
"output from the command is returned as the function value, and the command's ",
"exit status is returned in the global variable $shell_cmd_status. ",
"\n\n",
"\01A\01Bsplit(string, separation_string [, search_type])\01A\n",
"\01ISplits a string using the separator specified. Optionally the search_type ",
"argument can specify how the separation_string is interpreted. The default ",
"is \"literal\". The returned value is an array with keys beginning at 0. ",
"\n\n",
"\01A\01Bstring_dialog( message, btn_1_label, btn_2_label, ... )\01A\n",
"\01IPops up a dialog prompting the user to enter information. The first argument ",
"is a string to show in the message area of the dialog. Additional ",
"optional arguments represent labels for buttons to appear along the bottom of ",
"the dialog. Returns the string entered by the user as the function value, ",
"and number of the button pressed (the first button is number 1), in ",
"$string_dialog_button. If the user closes the dialog via the window close ",
"box, the function returns the empty string, and $string_dialog_button returns ",
"0. ",
"\n\n",
"\01A\01Bstring_compare(string1, string2 [, consider-case])\01A\n",
"\01ICompare two  strings and return 0 if they are equal, -1 if string1 is less ",
"than  string2 or 1 if string1 is greater than string2. The values for the ",
"optional consider-case argument is either \"case\" or \"nocase\". The default ",
"is to do a case sensitive comparison. ",
"\n\n",
"\01A\01Bstring_to_clipboard( string )\01A\n",
"\01ICopy the contents of a macro string to the clipboard. ",
"\n\n",
"\01A\01Bsubstring( string, start [, end] )\01A\n",
"\01IReturns the portion of a string between a start and end position (with the ",
"position of the beginning of the string being 0).  If end is missing, the ",
"position of the end of the string is used. If either of the positions are ",
"negative, they are treated as relative to the end of the string.  A position ",
"specified either before the start of the string or after the end of the string ",
"is repositioned to the nearest valid string position.  If the start position ",
"is beyond the end position, the empty string is returned. ",
"\n\n",
"\01A\01Bt_print( string1, string2, ... )\01A\n",
"\01IWrites strings to the terminal (stdout) from which XNEdit was started. ",
"\n\n",
"\01A\01Btolower( string )\01A\n",
"\01IReturn an all lower-case version of string. ",
"\n\n",
"\01A\01Btoupper( string )\01A\n",
"\01IReturn an all upper-case version of string. ",
"\n\n",
"\01A\01Bvalid_number( string )\01A\n",
"\01IReturns 1 if the string can be converted to a number without error ",
"following the same rules that the implicit conversion would. Otherwise 0. ",
"\n\n",
"\01A\01Bwrite_file( string, filename )\01A\n",
"\01IWrites a string (parameter 1) to a file named in parameter 2. Returns 1 on ",
"successful write, or 0 if unsuccessful. ",
"\n\n",
"\01RDeprecated Functions\01I",
"\n\n",
"Some functions are included only for supporting legacy macros. You should not ",
"use any of these functions in any new macro you write. Among these are all ",
"action routines with hyphens in their names; use underscores instead ",
"('find-dialog' -> 'find_dialog'). ",
"\n\n",
"\01A\01Bmatch()\01A\n",
"\01I\01JDEPRECATED\01I Use select_to_matching() instead. ",
"\n\n",
NULL
};

static char * htxt_rangeset [] = {
"\01IRangesets are a tool of the macro language to tag parts, or ranges, of the ",
"text, which shall be viewed as a group. A range is merely a contiguous range ",
"of characters between a start and an end position in the document, and a set ",
"of ranges belonging together is called a rangeset. So, a rangeset is nothing ",
"but an in general non-contiguous part of the text. ",
"\n\n",
"Rangesets can be assigned a background color to make them visible: characters ",
"within all ranges of a rangeset will have the background color of the ",
"rangeset. (If more than one rangeset includes a given character, its ",
"background color will be that of the most recently created rangeset which has ",
"a color defined.) ",
"\n\n",
"Applications of rangesets are for example: ",
"\n\n",
"    * Showing differences between two versions of a file. Then, one rangeset would be those parts of the current file that are not in the prior version.\n",
"    * Highlighting all occurrences of a particular pattern, e.g. showing all the strings 'foobar' in the file.\n",
"    * Highlighting spelling mistakes found by a spell-checker.\n",
"\n",
"Rangesets are manipulated only through macro routines. Rangesets must be ",
"created first using the rangeset_create() function, which will return an ",
"identifier for the newly-created (empty) rangeset. This identifier is then ",
"passed to the other rangeset functions to manipulate the rangeset. For ",
"example, ranges are added to a rangeset with the rangeset_add() function. ",
"\n\n",
"Notice that the ranges inside a rangeset do not have a particular identity. ",
"Only, they are given a (dynamically changing) numeric index, counting from 1, ",
"in the order of appearance in the text buffer. The ranges are adjusted when ",
"modifications are made to the text buffer: they shift around when characters ",
"are added or deleted staying with the original strings of characters. ",
"However, ranges within a set will coalesce if the characters between them are ",
"removed, or a new range is added to  the set which bridges or overlaps ",
"others. For more on this, see \"How rangesets change with modifications\". ",
"\n\n",
"There is a limit to the number of rangesets which can exist at any time - ",
"currently up to 63 in each document. Care should be taken to destroy any ",
"rangesets which are no longer needed, by using the rangeset_destroy() ",
"function, if this limit is attained. ",
"\n\n",
"Rangesets can be named: this is useful for macros which need a fixed ",
"identification for rangesets which are used for the same purpose in different ",
"documents. Although a new rangeset's number is arbitrary, its name can be ",
"fixed.  This is done using the rangeset_set_name() function. Note that ",
"rangeset names within a particular document may not be unique. For this ",
"reason, the rangeset_get_by_name() function returns an array of identifiers, ",
"which will be empty if the name has not been associated with a rangeset. ",
"\n\n",
"\01SHow rangesets change with modifications\01I",
"\n\n",
"When changes are made to the document text, ranges within each set are altered ",
"with it, according to their behavioral mode.  If changes are made outside of ",
"the ranges in a rangeset, each range simply maintains its size and adjusts its ",
"position to match the changes.  When text within a range is deleted, the ",
"range's length is reduced by the same amount. When changes involving new text ",
"are made within a range of the set, or to one of the extremities of a range, ",
"different behaviours may be desirable. The rangeset_set_mode() function allows ",
"these modes to be chosen. ",
"\n\n",
"Note that the precise behaviour of these modes may change in future versions ",
"of XNEdit. ",
"\n\n",
"The available modes are: ",
"\n\n",
"\01Jmaintain\01I or \01Jins_del\01I - ",
"Both these modes have the same behaviour.  New text added at the front of a ",
"range in a set is not added to the range; new text added within the range or ",
"at the end extends the range.  Replacement overlapping an extremity of the ",
"set acts as if the new text were added first, then the old text deleted. ",
"This causes curtailment at the front of the range, extension at the end. ",
"Replacement of the full text of the range removes the range from the set. ",
"The default behaviour for a newly created rangeset is \01Jmaintain\01I. ",
"\n\n",
"\01Jdel_ins\01I - ",
"New text added at the front or end of a range in a set is not added to the ",
"range; new text added within the range extends the range.  Replacement ",
"overlapping an extremity of the set acts as if the old text were deleted ",
"first, then the new text added. This causes curtailment at either end. ",
"Replacement of the full text of the range removes the range from the set. ",
"\n\n",
"\01Jinclude\01I - ",
"New text added at the front or end of a range in a set extends the range, as ",
"does new text added within the range.  Replacement overlapping an extremity ",
"of the set acts as if the new text were added first, then the old text ",
"deleted.  This causes curtailment at the front of the range, extension at ",
"the end.  Replacement of the full text of the range adds the new text to the ",
"range if the start position of the replacement is at the range's start ",
"point. ",
"\n\n",
"\01Jexclude\01I - ",
"New text added at the front or end of a range in a set does not extend the ",
"range; new text added within the range extends the range.  Replacement ",
"overlapping an extremity causes curtailment of the range.  Replacement of ",
"the full text of the range removes the range from the set. ",
"\n\n",
"\01Jbreak\01I - ",
"New text added at the front or end of a range in a set does not extend the ",
"range; new text added within the range will split the range.  Replacement ",
"overlapping an extremity causes curtailment of the range.  Replacement of ",
"the full text of the range removes the range from the set. ",
"\n\n",
"\01SNotes\01I",
"\n\n",
"A rangeset is manipulated \01Konly\01I through macro routines. Rangesets ",
"can easily become very large, and may exceed the capacity of the running ",
"process.  Coloring relies on proper color names or specifications (such as ",
"the \"#rrggbb\" hexadecimal digit strings), and appropriate hardware support. If ",
"an invalid color name is given, the default background color is used instead. ",
"Behaviours set using rangeset_set_mode() are subject to change in future ",
"versions. ",
"\n\n",
"\01RRangeset read-only variables\01I",
"\n\n",
"\01A\01B$rangeset_list\01A\n",
"\01Iarray of active rangeset identifiers, with integer keys starting at 0, ",
"in the order the rangesets were defined. ",
"\n\n",
"\01RRangeset functions\01I",
"\n\n",
"\01A\01Brangeset_create()\01A\n",
"\01Brangeset_create( n )\01A\n",
"\01ICreates one or more new rangesets. The first form creates a single range ",
"set and returns its identifier; if there are no rangesets available it ",
"returns 0. The second form creates n new rangesets, and returns an array ",
"of the rangeset identifiers with keys beginning at 0. If the requested ",
"number of rangesets is not available it returns an empty array. ",
"\n\n",
"\01A\01Brangeset_destroy( r )\01A\n",
"\01Brangeset_destroy( array )\01A\n",
"\01IDeletes all information about a rangeset or a number of rangesets. The ",
"first form destroys the rangeset identified by r. The second form should ",
"be passed an array of rangeset identifiers with keys beginning at 0 (i.e. ",
"the same form of array returned by rangeset_create(n); it destroys all the ",
"rangesets appearing in the array. If any of the rangesets do not exist, ",
"the function continues without errors. Does not return a value. ",
"\n\n",
"\01A\01Brangeset_add( r )\01A\n",
"\01Brangeset_add( r, start, end )\01A\n",
"\01Brangeset_add( r, r0 )\01A\n",
"\01IAdds to the rangeset r. The first form adds the range identified by the ",
"current primary selection to the rangeset, unless the selection is ",
"rectangular. The second form adds the range defined by the start and end ",
"positions given. The third form adds all ranges in the rangeset r0 to the ",
"rangeset r, and returns 0. ",
"\n\n",
"Returns the index of the newly-added range within the rangeset. ",
"\n\n",
"\01A\01Brangeset_subtract( r, [start, end] )\01A\n",
"\01Brangeset_subtract( r, r0 )\01A\n",
"\01IRemoves from the rangeset r. The first form removes the range identified by ",
"the current primary selection from the rangeset, unless start and end are ",
"defined, in which case the range they define is removed. The second form ",
"removes all ranges in the rangeset r0 from the rangeset r. Does not return ",
"a value. ",
"\n\n",
"\01A\01Brangeset_invert( r )\01A\n",
"\01IChanges the rangeset r so that it contains all ranges not in r. Does not ",
"return a value. ",
"\n\n",
"\01A\01Brangeset_get_by_name( name )\01A\n",
"\01IReturns an array of active rangeset identifiers, with integer keys starting at 0, ",
"whose name matches name. ",
"\n\n",
"\01A\01Brangeset_info( r )\01A\n",
"\01IReturns an array containing information about the rangeset r. The array ",
"has the following keys: \01Jdefined\01I (whether a rangeset with identifier ",
"r is defined), \01Jcount\01I (the number of ranges in the rangeset), \01Jcolor\01I ",
"(the current background color of the rangeset, an empty string if the ",
"rangeset has no color), \01Jname\01I (the user supplied name of the rangeset, ",
"an empty string if the rangeset has no name), and \01Jmode\01I (the name of the ",
"modify-response mode of the rangeset). ",
"\n\n",
"\01A\01Brangeset_range( r, [index] )\01A\n",
"\01IReturns details of a specific range in the rangeset r.  The range is ",
"specified by index, which should be between 1 and n (inclusive), where ",
"n is the number of ranges in the rangeset.  The return value is an array ",
"containing the keys \01Jstart\01I (the start position of the range) and \01Jend\01I ",
"(the end position of the range).  If index is not supplied, the region ",
"returned is the span of the entire rangeset (the region starting at the ",
"start of the first range and ending at the end of the last).  If index ",
"is outside the correct range of values, the function returns an empty array. ",
"\n\n",
"\01A\01Brangeset_includes( r, pos )\01A\n",
"\01IReturns the index of the range in rangeset r which includes pos; returns ",
"0 if pos is not contained in any of the ranges of r.  This can also be used ",
"as a simple true/false function which returns true if pos is contained in ",
"the rangeset. ",
"\n\n",
"\01A\01Brangeset_set_color( r, color )\01A\n",
"\01IAttempts to apply the color as a background color to the ranges of r. If ",
"color is at empty string, removes the coloring of r.  No check is made ",
"regarding the validity of color: if the color is invalid (a bad name, ",
"or not supported by the hardware) this has unpredictable effects. ",
"\n\n",
"\01A\01Brangeset_set_name( r, name )\01A\n",
"\01IApply the name to the rangeset r. ",
"\n\n",
"\01A\01Brangeset_set_mode( r, type )\01A\n",
"\01IChanges the behaviour of the rangeset r when modifications to the text ",
"buffer occur.  type can be one of the following: \"maintain\" (the default), ",
"\"break\", \"include\", \"exclude\", \"ins_del\" or \"del_ins\". (These modes are ",
"described above.) ",
NULL
};

static char * htxt_hiliteInfo [] = {
"\01IThe user can interrogate the current window to determine the color ",
"highlighting used on a particular piece of text. The following functions ",
"provide information on the highlighting pattern against which text at a ",
"particular position has been matched, its style, color and font attributes ",
"(whether the font is supposed to be bold and/or italic). ",
"\n\n",
"These macro functions permit macro writers to generate formatted output which ",
"allows XNEdit highlighting to be reproduced. This is suitable for the ",
"generation of HTML or Postscript output, for example. ",
"\n\n",
"Note that if any of the functions is used while in Plain mode or while syntax ",
"highlighting is off, the behaviour is undefined. ",
"\n\n",
"\01A\01Bget_pattern_by_name( pattern_name )\01A\n",
"\01IReturns an array containing the pattern attributes for pattern 'pattern_name'. ",
"The elements in this array are: ",
"\n\n",
"    * \01Jstyle\01I -- Highlight style name\n",
"\n",
"If 'pattern_name' is invalid, an empty array is returned. ",
"\n\n",
"\01A\01Bget_pattern_at_pos( pos )\01A\n",
"\01IReturns an array containing the pattern attributes of the character at ",
"position 'pos'. The elements in this array are: ",
"\n\n",
"    * \01Jpattern\01I -- Highlight pattern name\n",
"    * \01Jstyle\01I -- Highlight style name\n",
"    * \01Jextent\01I -- The length in the text which uses the same highlighting pattern\n",
"\n",
"The 'extent' value is measured from position 'pos' going right/down (forward ",
"in the file) only. ",
"\n\n",
"If 'pos' is invalid, an empty array is returned. ",
"\n\n",
"\01A\01Bget_style_by_name( style_name )\01A\n",
"\01IReturns an array containing the style attributes for style 'style_name'. ",
"The elements in this array are: ",
"\n\n",
"    * \01Jbold\01I -- '1' if style is bold, '0' otherwise\n",
"    * \01Jitalic\01I -- '1' if style is italic, '0' otherwise\n",
"    * \01Jcolor\01I -- Name of the style's color\n",
"    * \01Jbackground\01I -- Name of the background color, if any\n",
"\n",
"The colors use the names specified in the color definitions for the style. ",
"These will either be names matching those the X server recognises, or RGB ",
"(red/green/blue) specifications. ",
"\n\n",
"If 'style_name' is invalid, an empty array is returned. ",
"\n\n",
"\01A\01Bget_style_at_pos( pos )\01A\n",
"\01IReturns an array containing the style attributes of the character at ",
"position 'pos'. The elements in this array are: ",
"\n\n",
"    * \01Jstyle\01I -- Name of the highlight style\n",
"    * \01Jbold\01I -- '1' if style is bold, '0' otherwise\n",
"    * \01Jitalic\01I -- '1' if style is italic, '0' otherwise\n",
"    * \01Jcolor\01I -- Name of the style's color\n",
"    * \01Jrgb\01I -- Color's RGB values ('#rrggbb')\n",
"    * \01Jbackground\01I -- Name of the background color, if any\n",
"    * \01Jback_rgb\01I -- Background color's RGB values ('#rrggbb')\n",
"    * \01Jextent\01I -- The length in the text which uses the same highlight style\n",
"\n",
"The colors use the names specified in the color definitions for the style. ",
"These will either be names matching those the X server recognises, or RGB ",
"specifications. The values for 'rgb' and 'back_rgb' contain the actual color ",
"values allocated by the X server for the window. If the X server cannot ",
"allocate the specified (named) color exactly, the RGB values in these ",
"entries may not match the specified ones. ",
"\n\n",
"The 'extent' value is measured from position 'pos' going right/down (forward ",
"in the file) only. ",
"\n\n",
"If 'pos' is invalid, an empty array is returned. ",
"\n\n",
NULL
};

static char * htxt_actions [] = {
"\01IAll of the editing capabilities of XNEdit are represented as a special type of ",
"subroutine, called an action routine, which can be invoked from both macros ",
"and translation table entries (see \"\01QKey Binding\01I\" in the ",
"Customizing section of the Help menu). ",
"\n\n",
"\01RActions Representing Menu Commands\01I",
"\n\n",
"\01A    File Menu                 Search Menu\n",
"    -----------------------   -------------------------\n",
"    new()                     find()\n",
"    open()                    find_dialog()\n",
"    open_dialog()             find_again()\n",
"    open_selected()           find_selection()\n",
"    close()                   replace()\n",
"    save()                    replace_dialog()\n",
"    save_as()                 replace_all()\n",
"    save_as_dialog()          replace_in_selection()\n",
"    revert_to_saved_dialog()  replace_again()\n",
"    include_file()            goto_line_number()\n",
"    include_file_dialog()     goto_line_number_dialog()\n",
"    load_macro_file()         goto_selected()\n",
"    load_macro_file_dialog()  mark()\n",
"    load_tags_file()          mark_dialog()\n",
"    load_tags_file_dialog()   goto_mark()\n",
"    unload_tags_file()        goto_mark_dialog()\n",
"    load_tips_file()          goto_matching()\n",
"    load_tips_file_dialog()   select_to_matching()\n",
"    unload_tips_file()        find_definition()\n",
"    print()                   show_tip()\n",
"    print_selection()\n",
"    exit()                    Shell Menu\n",
"                              -------------------------\n",
"    Edit Menu                 filter_selection_dialog()\n",
"    -----------------------   filter_selection()\n",
"    undo()                    execute_command()\n",
"    redo()                    execute_command_dialog()\n",
"    delete()                  execute_command_line()\n",
"    select_all()              shell_menu_command()\n",
"    shift_left()\n",
"    shift_left_by_tab()       Macro Menu\n",
"    shift_right()             -------------------------\n",
"    shift_right_by_tab()      macro_menu_command()\n",
"    uppercase()               repeat_macro()\n",
"    lowercase()               repeat_dialog()\n",
"    fill_paragraph()\n",
"    control_code_dialog()     Windows Menu\n",
"                              -------------------------\n",
"                              split_pane()\n",
"                              close_pane()\n",
"                              detach_document()\n",
"                              move_document_dialog()\n",
"\01I\n",
"An action representing a menu command is usually named the same as its ",
"corresponding menu item except that all punctuation is removed, all letters ",
"are changed to lower case, and spaces are replaced with underscores.  To ",
"present a dialog to ask the user for input, use the actions with the ",
"`_dialog` suffix. Actions without the `_dialog` suffix take the information ",
"from the routine's arguments (see below). ",
"\n\n",
"\01RMenu Action Routine Arguments\01I",
"\n\n",
"Arguments are text strings enclosed in quotes. Below are the menu action ",
"routines which take arguments.  Optional arguments are enclosed in []. ",
"\n\n",
"\01A    \01Bnew\01A( [\"tab\" | \"window\" | \"prefs\" | \"opposite\"] )\n",
"\01I\n",
"\01A    \01Bclose\01A( [\"prompt\" | \"save\" | \"nosave\"] )\n",
"\01I\n",
"\01A    \01Bexecute_command\01A( shell-command )\n",
"\01I\n",
"\01A    \01Bfilter_selection\01A( shell-command )\n",
"\01I\n",
"\01A    \01Bfind\01A( search-string [, \01Csearch-direction\01A] [, \01Csearch-type\01A]\n",
"       [, \01Csearch-wrap\01A] )\n",
"\01I\n",
"\01A    \01Bfind_again\01A( [\01Csearch-direction\01A] [, \01Csearch-wrap\01A] )\n",
"\01I\n",
"\01A    \01Bfind_definition\01A( [tag-name] )\n",
"\01I\n",
"\01A    \01Bfind_dialog\01A( [\01Csearch-direction\01A] [, \01Csearch-type\01A]\n",
"       [, \01Ckeep-dialog\01A] )\n",
"\01I\n",
"\01A    \01Bfind_selection\01A( [\01Csearch-direction\01A] [, \01Csearch-wrap\01A]\n",
"       [, \01Cnon-regex-search-type\01A] )\n",
"\01I\n",
"\01A    \01Bgoto_line_number\01A( [\01Cline-number\01A] [, \01Ccolumn-number\01A] )\n",
"\01I\n",
"\01A    \01Bgoto_mark\01A( \01Cmark-letter\01A )\n",
"\01I\n",
"\01A    \01Binclude_file\01A( \01Cfilename\01A )\n",
"\01I\n",
"\01A    \01Bload_tags_file\01A( \01Cfilename\01A )\n",
"\01I\n",
"\01A    \01Bmacro_menu_command\01A( \01Cmacro-menu-item-name\01A )\n",
"\01I\n",
"\01A    \01Bmark\01A( \01Cmark-letter\01A )\n",
"\01I\n",
"\01A    \01Bopen\01A( \01Cfilename\01A )\n",
"\01I\n",
"\01A    \01Breplace\01A( search-string, replace-string,\n",
"       [, \01Csearch-direction\01A] [, \01Csearch-type\01A] [, \01Csearch-wrap\01A] )\n",
"\01I\n",
"\01A    \01Breplace_again\01A( [\01Csearch-direction\01A] [, \01Csearch-wrap\01A] )\n",
"\01I\n",
"\01A    \01Breplace_all\01A( search-string, replace-string [, \01Csearch-type\01A] )\n",
"\01I\n",
"\01A    \01Breplace_dialog\01A( [\01Csearch-direction\01A] [, \01Csearch-type\01A]\n",
"       [, \01Ckeep-dialog\01A] )\n",
"\01I\n",
"\01A    \01Breplace_in_selection\01A( search-string,\n",
"       replace-string [, \01Csearch-type\01A] )\n",
"\01I\n",
"\01A    \01Bsave_as\01A( \01Cfilename\01A )\n",
"\01I\n",
"\01A    \01Bshell_menu_command\01A( \01Cshell-menu-item-name\01A )\n",
"\01I\n",
"\01A    \01Bunload_tags_file\01A( \01Cfilename\01A )\n",
"\01I\n",
"\01A    \01B----------- Some notes on argument types above -----------\01A\n",
"\01I\n",
"\01A    \01CArguments to new()\01A\n",
"                   \"tab\":      Open a new tab\n",
"                   \"window\":   Open a new window\n",
"                   \"prefs\":    Follow the user's tab/window\n",
"                               preference\n",
"                   \"opposite\": Opposite of user's tab/window\n",
"                               preference\n",
"                   Default behaviour is \"prefs\".\n",
"\01I\n",
"\01A    \01Cfilename\01A       Path names are relative to the directory from\n",
"                   which XNEdit was started. Shell interpreted\n",
"                   wildcards and `~' are not expanded.\n",
"\01I\n",
"\01A    \01Ckeep-dialog\01A    Either \"keep\" or \"nokeep\".\n",
"\01I\n",
"\01A    \01Cmark-letter\01A   The mark command limits users to single letters. Inside\n",
"                    of macros, single digits are allowed as marks. These\n",
"                    won't interfere with marks set by the user.\n",
"\01I\n",
"\01A    \01Cmacro-menu-item-name\01A\n",
"                   Name of the command exactly as specified in\n",
"                   the Macro Menu dialogs.\n",
"\01I\n",
"\01A    \01Cnon-regex-search-type\01A\n",
"                   Either \"literal\", \"case\", \"word\", or\n",
"                   \"caseWord\".\n",
"\01I\n",
"\01A    \01Csearch-direction\01A\n",
"                   Either \"forward\" or \"backward\".\n",
"\01I\n",
"\01A    \01Csearch-type\01A    Either \"literal\", \"case\", \"word\",\n",
"                   \"caseWord\", \"regex\", or \"regexNoCase\".\n",
"\01I\n",
"\01A    \01Csearch-wrap\01A    Either \"wrap\" or \"nowrap\".\n",
"\01I\n",
"\01A    \01Cshell-menu-item-name\01A\n",
"                   Name of the command exactly as specified in\n",
"                   the Shell Menu dialogs.\n",
"\01I\n",
"\01RWindow Preferences Actions\01I",
"\n\n",
"\01A\01Bset_auto_indent( \"off\" | \"on\" | \"smart\" )\01A\n",
"\01ISet auto indent mode for the current window. ",
"\n\n",
"\01A\01Bset_em_tab_dist( em-tab-distance )\01A\n",
"\01ISet the emulated tab size. An em-tab-distance value of ",
"0 or less translates to no emulated tabs. Em-tab-distance must ",
"be smaller than 1000. ",
"\n\n",
"\01A\01Bset_fonts( font-name, italic-font-name, bold-font-name, bold-italic-font-name )\01A\n",
"\01ISet all the fonts used for the current window. ",
"\n\n",
"\01A\01Bset_highlight_syntax( [0 | 1] )\01A\n",
"\01ISet syntax highlighting mode for the current window. ",
"A value of 0 turns it off and a value of 1 turns it on. ",
"If no parameters are supplied the option is toggled. ",
"\n\n",
"\01A\01Bset_incremental_backup( [0 | 1] )\01A\n",
"\01ISet incremental backup mode for the current window. ",
"A value of 0 turns it off and a value of 1 turns it on. ",
"If no parameters are supplied the option is toggled. ",
"\n\n",
"\01A\01Bset_incremental_search_line( [0 | 1] )\01A\n",
"\01IShow or hide the incremental search line for the current window. ",
"A value of 0 turns it off and a value of 1 turns it on. ",
"If no parameters are supplied the option is toggled. ",
"\n\n",
"\01A\01Bset_language_mode( language-mode )\01A\n",
"\01ISet the language mode for the current window. If the language mode is ",
"\"\" or unrecognized, it will be set to Plain. ",
"\n\n",
"\01A\01Bset_locked( [0 | 1] )\01A\n",
"\01IThis only affects the locked status of a file, not its read-only ",
"status. Permissions are \01Knot\01I changed. ",
"A value of 0 turns it off and a value of 1 turns it on. ",
"If no parameters are supplied the option is toggled. ",
"\n\n",
"\01A\01Bset_make_backup_copy( [0 | 1] )\01A\n",
"\01ISet whether backup copies are made during saves for the current window. ",
"A value of 0 turns it off and a value of 1 turns it on. ",
"If no parameters are supplied the option is toggled. ",
"\n\n",
"\01A\01Bset_overtype_mode( [0 | 1] )\01A\n",
"\01ISet overtype mode for the current window. ",
"A value of 0 turns it off and a value of 1 turns it on. ",
"If no parameters are supplied the option is toggled. ",
"\n\n",
"\01A\01Bset_show_line_numbers( [0 | 1] )\01A\n",
"\01IShow or hide line numbers for the current window. ",
"A value of 0 turns it off and a value of 1 turns it on. ",
"If no parameters are supplied the option is toggled. ",
"\n\n",
"\01A\01Bset_show_matching( \"off\" | \"delimiter\" | \"range\" )\01A\n",
"\01ISet show matching (...) mode for the current window. ",
"\n\n",
"\01A\01Bset_match_syntax_based( [0 | 1] )\01A\n",
"\01ISet whether matching should be syntax based for the current window. ",
"\n\n",
"\01A\01Bset_statistics_line( [0 | 1] )\01A\n",
"\01IShow or hide the statistics line for the current window. ",
"A value of 0 turns it off and a value of 1 turns it on. ",
"If no parameters are supplied the option is toggled. ",
"\n\n",
"\01A\01Bset_tab_dist( tab-distance )\01A\n",
"\01ISet the size of hardware tab spacing. Tab-distance must ",
"be a value greater than 0 and no greater than 20. ",
"\n\n",
"\01A\01Bset_use_tabs( [0 | 1] )\01A\n",
"\01ISet whether tab characters are used for the current window. A value of 0 ",
"turns it off (using space characters instead) and a value of 1 turns it on. ",
"If no parameters are supplied the option is toggled. ",
"\n\n",
"\01A\01Bset_wrap_margin( wrap-width )\01A\n",
"\01ISet the wrap width for text wrapping of the current window. A value ",
"of 0 means to wrap at window width. ",
"\n\n",
"\01A\01Bset_wrap_text( \"none\" | \"auto\" | \"continuous\" )\01A\n",
"\01ISet wrap text mode for the current window. ",
"\n\n",
"\01RKeyboard-Only Actions\01I",
"\n\n",
"In addition to the arguments listed in the call descriptions below, any ",
"routine involving cursor movement can take the argument \"extend\", meaning, ",
"adjust the primary selection to the new cursor position. Routines which take ",
"the \"extend\" argument as well as mouse dragging operations for both primary ",
"and secondary selections can take the optional keyword \"rect\", meaning, make ",
"the selection rectangular. Any routine that accepts the \"scrollbar\" argument ",
"will move the display but not the cursor or selection. Routines that accept ",
"the \"nobell\" argument will fail silently without beeping, when that argument ",
"is supplied. ",
"\n\n",
"\01A\01Bbackward_character( [\"nobell\"] )\01A\n",
"\01IMoves the cursor one character to the left. ",
"\n\n",
"\01A\01Bbackward_paragraph([\"nobell\"] )\01A\n",
"\01IMoves the cursor to the beginning of the paragraph, or ",
"if the cursor is already at the beginning of a paragraph, moves the cursor to ",
"the beginning of the previous paragraph.  Paragraphs are defined as regions ",
"of text delimited by one or more blank lines. ",
"\n\n",
"\01A\01Bbackward_word( [\"nobell\"] )\01A\n",
"\01IMoves the cursor to the beginning of a word, or, if the ",
"cursor is already at the beginning of a word, moves the cursor to the ",
"beginning of the previous word.  Word delimiters are user-settable, and ",
"defined by the X resource wordDelimiters. ",
"\n\n",
"\01A\01Bbeginning_of_file( [\"scrollbar\"] )\01A\n",
"\01IMoves the cursor to the beginning of the file. ",
"\n\n",
"\01A\01Bbeginning_of_line( [\"absolute\"] )\01A\n",
"\01IMoves the cursor to the beginning of the line. If ",
"\"absolute\" is given, always moves to the absolute beginning of line, ",
"regardless of the text wrapping mode. ",
"\n\n",
"\01A\01Bbeginning_of_selection()\01A\n",
"\01IMoves the cursor to the beginning of the selection ",
"without disturbing the selection. ",
"\n\n",
"\01A\01Bcopy_clipboard()\01A\n",
"\01ICopies the current selection to the clipboard. ",
"\n\n",
"\01A\01Bcopy_primary()\01A\n",
"\01ICopies the primary selection to the cursor. ",
"\n\n",
"\01A\01Bcopy_to()\01A\n",
"\01IIf a secondary selection exists, copies the secondary selection to ",
"the cursor.  If no secondary selection exists, copies the primary selection ",
"to the pointer location. ",
"\n\n",
"\01A\01Bcopy_to_or_end_drag()\01A\n",
"\01ICompletes either a secondary selection operation, or a ",
"primary drag.  If the user is dragging the mouse to adjust a secondary ",
"selection, the selection is copied and either inserted at the cursor ",
"location, or, if pending-delete is on and a primary selection exists in the ",
"window, replaces the primary selection.  If the user is dragging a block of ",
"text (primary selection), completes the drag operation and leaves the text at ",
"its current location. ",
"\n\n",
"\01A\01Bcut_clipboard()\01A\n",
"\01IDeletes the text in the primary selection and places it in ",
"the clipboard. ",
"\n\n",
"\01A\01Bcut_primary()\01A\n",
"\01ICopies the primary selection to the cursor and deletes it at ",
"its original location. ",
"\n\n",
"\01A\01Bdelete_selection()\01A\n",
"\01IDeletes the contents of the primary selection. ",
"\n\n",
"\01A\01Bdelete_next_character( [\"nobell\"] )\01A\n",
"\01IIf a primary selection exists, deletes its contents. ",
"Otherwise, deletes the character following the cursor. ",
"\n\n",
"\01A\01Bdelete_previous_character( [\"nobell\"] )\01A\n",
"\01IIf a primary selection exists, deletes its ",
"contents.  Otherwise, deletes the character before the cursor. ",
"\n\n",
"\01A\01Bdelete_next_word( [\"nobell\"] )\01A\n",
"\01IIf a primary selection exists, deletes its contents. ",
"Otherwise, deletes the word following the cursor. ",
"\n\n",
"\01A\01Bdelete_previous_word( [\"nobell\"] )\01A\n",
"\01IIf a primary selection exists, deletes its contents. ",
"Otherwise, deletes the word before the cursor. ",
"\n\n",
"\01A\01Bdelete_to_start_of_line( [\"nobell\", \"wrap\"] )\01A\n",
"\01IIf a primary selection exists, deletes its contents.  Otherwise, deletes the ",
"characters between the cursor and the start of the line. If \"wrap\" is ",
"given, deletes to the previous wrap point or beginning of line, whichever ",
"is closest. ",
"\n\n",
"\01A\01Bdelete_to_end_of_line( [\"nobell\", \"absolute\"] )\01A\n",
"\01IIf a primary selection exists, deletes its contents. ",
"Otherwise, deletes the characters between the cursor and the end of the line. ",
"If \"absolute\" is given, always deletes to the absolute end of line, regardless ",
"of the text wrapping mode. ",
"\n\n",
"\01A\01Bdeselect_all()\01A\n",
"\01IDe-selects the primary selection. ",
"\n\n",
"\01A\01Bend_of_file( [\"scrollbar\"] )\01A\n",
"\01IMoves the cursor to the end of the file. ",
"\n\n",
"\01A\01Bend_of_line( [\"absolute\"] )\01A\n",
"\01IMoves the cursor to the end of the line.  If ",
"\"absolute\" is given, always moves to the absolute end of line, regardless ",
"of the text wrapping mode. ",
"\n\n",
"\01A\01Bend_of_selection()\01A\n",
"\01IMoves the cursor to the end of the selection without ",
"disturbing the selection. ",
"\n\n",
"\01A\01Bexchange( [\"nobell\"] )\01A\n",
"\01IExchange the primary and secondary selections. ",
"\n\n",
"\01A\01Bextend_adjust()\01A\n",
"\01IAttached mouse-movement events to begin a selection between ",
"the cursor and the mouse, or extend the primary selection to the mouse ",
"position. ",
"\n\n",
"\01A\01Bextend_end()\01A\n",
"\01ICompletes a primary drag-selection operation. ",
"\n\n",
"\01A\01Bextend_start()\01A\n",
"\01IBegins a selection between the cursor and the mouse.  A ",
"drag-selection operation can be started with either extend_start or ",
"grab_focus. ",
"\n\n",
"\01A\01Bfocus_pane( [relative-pane] | [positive-index] | [negative-index] )\01A\n",
"\01IMove the focus to the requested pane. ",
"Arguments can be specified in the form of a relative-pane ",
"(\"first\", \"last\", \"next\", \"previous\"), a positive-index ",
"(numbers greater than 0, 1 is the same as \"first\") or a ",
"negative-index (numbers less than 0, -1 is the same as \"last\"). ",
"\n\n",
"\01A\01Bforward_character()\01A\n",
"\01IMoves the cursor one character to the right. ",
"\n\n",
"\01A\01Bforward_paragraph( [\"nobell\"] )\01A\n",
"\01IMoves the cursor to the beginning of the next paragraph. ",
"Paragraphs are defined as regions of text delimited by one or more blank ",
"lines. ",
"\n\n",
"\01A\01Bforward_word( [\"tail\"] [\"nobell\"] )\01A\n",
"\01IMoves the cursor to the beginning of the next word.  Word ",
"delimiters are user-settable, and defined by the X resource wordDelimiters. ",
"If the \"tail\" argument is supplied the cursor will be moved to ",
"the end of the current word or the end of the next word, if the ",
"cursor is between words. ",
"\n\n",
"\01A\01Bgrab_focus()\01A\n",
"\01IMoves the cursor to the mouse pointer location, and prepares for ",
"a possible drag-selection operation (bound to extend_adjust), or multi-click ",
"operation (a further grab_focus action).  If a second invocation of grab ",
"focus follows immediately, it selects a whole word, or a third, a whole line. ",
"\n\n",
"\01A\01Binsert_string( \"string\" )\01A\n",
"\01IIf pending delete is on and the cursor is inside the ",
"selection, replaces the selection with \"string\".  Otherwise, inserts \"string\" ",
"at the cursor location. ",
"\n\n",
"\01A\01Bkey_select( \"direction\" [,\"nobell\"] )\01A\n",
"\01IMoves the cursor one character in \"direction\" ",
"(\"left\", \"right\", \"up\", or \"down\") and extends the selection.  Same as ",
"forward/backward-character(\"extend\"), or process-up/down(\"extend\"), for ",
"compatibility with previous versions. ",
"\n\n",
"\01A\01Bmove-destination()\01A\n",
"\01IMoves the cursor to the pointer location without ",
"disturbing the selection.  (This is an unusual way of working.  We left it in ",
"for compatibility with previous versions, but if you actually use this ",
"capability, please send us some mail, otherwise it is likely to disappear in ",
"the future. ",
"\n\n",
"\01A\01Bmove_to()\01A\n",
"\01IIf a secondary selection exists, deletes the contents of the ",
"secondary selection and inserts it at the cursor, or if pending-delete is on ",
"and there is a primary selection, replaces the primary selection.  If no ",
"secondary selection exists, moves the primary selection to the pointer ",
"location, deleting it from its original position. ",
"\n\n",
"\01A\01Bmove_to_or_end_drag()\01A\n",
"\01ICompletes either a secondary selection operation, or a ",
"primary drag.  If the user is dragging the mouse to adjust a secondary ",
"selection, the selection is deleted and either inserted at the cursor ",
"location, or, if pending-delete is on and a primary selection exists in the ",
"window, replaces the primary selection.  If the user is dragging a block of ",
"text (primary selection), completes the drag operation and deletes the text ",
"from its current location. ",
"\n\n",
"\01A\01Bnewline()\01A\n",
"\01IInserts a newline character.  If Auto Indent is on, lines up the ",
"indentation of the cursor with the current line. ",
"\n\n",
"\01A\01Bnewline_and_indent()\01A\n",
"\01IInserts a newline character and lines up the indentation ",
"of the cursor with the current line, regardless of the setting of Auto ",
"Indent. ",
"\n\n",
"\01A\01Bnewline_no_indent()\01A\n",
"\01IInserts a newline character, without automatic ",
"indentation, regardless of the setting of Auto Indent. ",
"\n\n",
"\01A\01Bnext_page( [\"stutter\"] [\"column\"] [\"scrollbar\"] [\"nobell\"] )\01A\n",
"\01IMoves the cursor and scroll forward one page. ",
"The parameter \"stutter\" moves the cursor to the bottom of the display, ",
"unless it is already there, otherwise it will page down. ",
"The parameter \"column\" will maintain the preferred column while ",
"moving the cursor. ",
"\n\n",
"\01A\01Bpage_left( [\"scrollbar\"] [\"nobell\"] )\01A\n",
"\01IMove the cursor and scroll left one page. ",
"\n\n",
"\01A\01Bpage_right( [\"scrollbar\"] [\"nobell\"] )\01A\n",
"\01IMove the cursor and scroll right one page. ",
"\n\n",
"\01A\01Bpaste_clipboard()\01A\n",
"\01IInsert the contents of the clipboard at the cursor, or if ",
"pending delete is on, replace the primary selection with the contents of the ",
"clipboard. ",
"\n\n",
"\01A\01Bprevious_page( [\"stutter\"] [\"column\"] [\"scrollbar\"] [\"nobell\"] )\01A\n",
"\01IMoves the cursor and scroll backward one page. ",
"The parameter \"stutter\" moves the cursor to the top of the display, ",
"unless it is already there, otherwise it will page up. ",
"The parameter \"column\" will maintain the preferred column while ",
"moving the cursor. ",
"\n\n",
"\01A\01Bprocess_bdrag()\01A\n",
"\01ISame as secondary_or_drag_start for compatibility with previous versions. ",
"\n\n",
"\01A\01Bprocess_cancel()\01A\n",
"\01ICancels the current extend_adjust, secondary_adjust, or ",
"secondary_or_drag_adjust in progress. ",
"\n\n",
"\01A\01Bprocess_down( [\"nobell\", \"absolute\"] )\01A\n",
"\01IMoves the cursor down one line.  If \"absolute\" is given, always moves to the ",
"next line in the text buffer, regardless of wrapping. ",
"\n\n",
"\01A\01Bprocess_return()\01A\n",
"\01ISame as newline for compatibility with previous versions. ",
"\n\n",
"\01A\01Bprocess_shift_down( [\"nobell\", \"absolute\"] )\01A\n",
"\01ISame as process_down(\"extend\") for compatibility with previous versions. ",
"\n\n",
"\01A\01Bprocess_shift_up( [\"nobell\", \"absolute\"] )\01A\n",
"\01ISame as process_up(\"extend\") for compatibility with previous versions. ",
"\n\n",
"\01A\01Bprocess_tab()\01A\n",
"\01IIf tab emulation is turned on, inserts an emulated tab, ",
"otherwise inserts a tab character. ",
"\n\n",
"\01A\01Bprocess_up( [\"nobell\", \"absolute\"] )\01A\n",
"\01IMoves the cursor up one line.  If \"absolute\" is given, always moves to the ",
"previous line in the text buffer, regardless of wrapping. ",
"\n\n",
"\01A\01Braise_window([relative-window] | [positive-index] | [negative-index] [, \"focus\" | \"nofocus\"])\01A\n",
"\01IRaise the current focused window to the front if no argument is supplied. ",
"Arguments can be specified in the form of a relative-window ",
"(\"first\", \"last\", \"next\", \"previous\"), a positive-index ",
"(numbers greater than 0, 1 is the same as \"last\") or a ",
"negative-index (numbers less than 0, -1 is the same as \"first\"). ",
"\n\n",
"Moreover, it can be specified whether or not the raised window should ",
"request the X input focus. By default, it depends on the setting of the ",
"nedit.focusOnRaise resource (see the section \"\01QX Resources\01I\") whether or not ",
"the input focus is requested. ",
"\n\n",
"\01A\01Bscroll_down( nUnits, [\"lines\" | \"pages\"] )\01A\n",
"\01IScroll the display down (towards the end of the file) by a given ",
"number of units, units being lines or pages. Default units are lines. ",
"\n\n",
"\01A\01Bscroll_left( nPixels )\01A\n",
"\01IScroll the display left by nPixels. ",
"\n\n",
"\01A\01Bscroll_right( nPixels )\01A\n",
"\01IScroll the display right by nPixels. ",
"\n\n",
"\01A\01Bscroll_up( nUnits, [\"lines\" | \"pages\"] )\01A\n",
"\01IScroll the display up (towards the beginning of the file) by a given ",
"number of units, units being lines or pages. Default units are lines. ",
"\n\n",
"\01A\01Bscroll_to_line( lineNum )\01A\n",
"\01IScroll to position line number lineNum at the top of ",
"the pane.  The first line of a file is line 1. ",
"\n\n",
"\01A\01Bsecondary_adjust()\01A\n",
"\01IAttached mouse-movement events to extend the secondary ",
"selection to the mouse position. ",
"\n\n",
"\01A\01Bsecondary_or_drag_adjust()\01A\n",
"\01IAttached mouse-movement events to extend the ",
"secondary selection, or reposition the primary text being dragged.  Takes two ",
"optional arguments, \"copy\", and \"overlay\".  \"copy\" leaves a copy of the ",
"dragged text at the site at which the drag began.  \"overlay\" does the drag in ",
"overlay mode, meaning the dragged text is laid on top of the existing text, ",
"obscuring and ultimately deleting it when the drag is complete. ",
"\n\n",
"\01A\01Bsecondary_or_drag_start()\01A\n",
"\01ITo be attached to a mouse down event.  Begins drag ",
"selecting a secondary selection, or dragging the contents of the primary ",
"selection, depending on whether the mouse is pressed inside of an existing ",
"primary selection. ",
"\n\n",
"\01A\01Bsecondary_start()\01A\n",
"\01ITo be attached to a mouse down event.  Begin drag selecting ",
"a secondary selection. ",
"\n\n",
"\01A\01Bselect_all()\01A\n",
"\01ISelect the entire file. ",
"\n\n",
"\01A\01Bself_insert()\01A\n",
"\01ITo be attached to a key-press event, inserts the character ",
"equivalent of the key pressed. ",
"\n\n",
NULL
};

static char * htxt_customize [] = {
"\01IXNEdit can be customized in many different ways.  The most important ",
"user-settable options are presented in the Preferences menu, including all ",
"options that users might need to change during an editing session.  Options ",
"set in the Default Settings sub-menu of the Preferences menu can be preserved ",
"between sessions by selecting Save Defaults, which writes the changes to the ",
"preferences file.  See the section titled \"\01QPreferences\01I\" for more details. ",
"\n\n",
"User defined commands can be added to XNEdit's Shell, Macro, and window ",
"background menus.  Dialogs for creating items in these menus can be found ",
"under Customize Menus in the Default Settings sub menu of the Preferences ",
"menu. ",
"\n\n",
"For users who depend on XNEdit every day and want to tune every excruciating ",
"detail, there are also X resources for tuning a vast number of such details, ",
"down to the color of each individual button.  See the section \"\01QX Resources\01I\" ",
"for more information, as well as a list of selected resources. ",
"\n\n",
"The most common reason for customizing your X resources for XNEdit, however, is ",
"key binding.  While limited key binding can be done through Preferences ",
"settings (Preferences -> Default Settings -> Customize Menus), you can really ",
"only add keys this way, and each key must have a corresponding menu item. ",
"Any significant changes to key binding should be made via the Translations ",
"resource and menu accelerator resources.  The sections titled \"\01QKey Binding\01I\" ",
"and \"\01QX Resources\01I\" have more information. ",
NULL
};

static char * htxt_preferences [] = {
"\01IThe Preferences menu allows you to set options for both the current editing ",
"window, and default values for newly created windows and future XNEdit ",
"sessions.  Options in the Preferences menu itself (not in the Default ",
"Settings sub-menu) take effect immediately and refer to the current window ",
"only.  Options in the Default Settings sub-menu provide initial settings for ",
"future windows created using the New or Open commands; options affecting all ",
"windows are also set here. ",
"\n\n",
"Preferences set in the Default Settings sub-menu are saved in a file that ",
"XNEdit reads at startup time, cf. \01QAutoload Files\01I, by selecting Save Defaults. ",
"\n\n",
"\01RPreferences Menu\01I",
"\n\n",
"\01A\01BDefault Settings\01A\n",
"\01IMenu of initial settings for future windows.  Generally the same as the ",
"options in the main part of the menu, but apply as defaults for future ",
"windows created during this XNEdit session.  These settings can be saved using ",
"the Save Defaults command below, to be loaded automatically each time XNEdit ",
"is started. ",
"\n\n",
"\01A\01BSave Defaults\01A\n",
"\01ISave the default options as set under Default Settings for future XNEdit ",
"sessions. ",
"\n\n",
"\01A\01BStatistics Line\01A\n",
"\01IShow the full file name, line number, and length of the file being edited. ",
"\n\n",
"\01A\01BIncremental Search Line\01A\n",
"\01IKeep the incremental search bar (Search -> Find Incremental) permanently ",
"displayed at the top of the window. ",
"\n\n",
"\01A\01BShow Line Numbers\01A\n",
"\01IDisplay line numbers to the right of the text. ",
"\n\n",
"\01A\01BLanguage Mode\01A\n",
"\01ITells XNEdit what language (if any) to assume, for selecting language-specific ",
"features such as highlight patterns and smart indent macros, and setting ",
"language specific preferences like word delimiters, tab emulation, and ",
"auto-indent.  See \01QProgramming with XNEdit\01I for more information. ",
"\n\n",
"\01A\01BAuto Indent\01A\n",
"\01ISetting Auto Indent \"on\" maintains a running indent (pressing the Return key ",
"will line up the cursor with the indent level of the previous line).  If ",
"smart indent macros are available for the current language mode, smart indent ",
"can be selected and XNEdit will attempt to guess proper language indentation ",
"for each new line, cf. \01QAuto/Smart Indent\01I. ",
"\n\n",
"\01A\01BWrap\01A\n",
"\01IChoose between two styles of automatic wrapping or none.  Auto Newline wrap, ",
"wraps text at word boundaries when the cursor reaches the right margin, by ",
"replacing the space or tab at the last word boundary with a newline ",
"character.  Continuous Wrap wraps long lines which extend past the right ",
"margin. Continuous Wrap mode is typically used to produce files where ",
"newlines are omitted within paragraphs, to make text filling automatic (a ",
"kind of poor-man's word processor).  Text of this style is common on Macs and ",
"PCs but is not necessarily supported very well under Unix (except in programs ",
"which deal with e-mail, for which it is often the format of choice). ",
"\n\n",
"\01A\01BWrap Margin\01A\n",
"\01ISet margin for Auto Newline Wrap, Continuous Wrap, and Fill Paragraph.  Lines ",
"may, be wrapped at the right margin of the window, or the margin can be set ",
"at a specific column. ",
"\n\n",
"\01A\01BTab Stops\01A\n",
"\01ISet the tab distance (number of characters between tab stops) for tab ",
"characters, and control tab emulation and use of tab characters in padding ",
"and emulated tabs. ",
"\n\n",
"\01A\01BText Font...\01A\n",
"\01IChange the font(s) used to display text (fonts for menus and dialogs must be ",
"set using X resources for the text area of the window). See below for more ",
"information. ",
"\n\n",
"\01A\01BHighlight Syntax\01A\n",
"\01IIf XNEdit recognizes the language being edited, and highlighting patterns are ",
"available for that language, use fonts and colors to enhance viewing of the ",
"file.  (See \01QSyntax Highlighting\01I for more information.) ",
"\n\n",
"\01A\01BMake Backup Copy\01A\n",
"\01IOn Save, write a backup copy of the file as it existed before the Save ",
"command with the extension .bck (Unix only). ",
"\n\n",
"\01A\01BIncremental Backup\01A\n",
"\01IPeriodically make a backup copy of the file being edited under the name ",
"`~filename`. ",
"\n\n",
"\01A\01BShow Matching (..)\01A\n",
"\01IMomentarily highlight matching parenthesis, brackets, and braces, or the ",
"range between them, when one of these characters is typed, or when the ",
"insertion cursor is positioned after it. Delimiter only highlights the ",
"matching delimiter, while Range highlights the whole range of text between ",
"the matching delimiters. ",
"\n\n",
"Optionally, the matching can make use of syntax information if syntax ",
"highlighting is enabled. Alternatively, the matching is purely character ",
"based. In general, syntax based matching results in fewer false matches. ",
"\n\n",
"\01A\01BOvertype\01A\n",
"\01IIn overtype mode, new characters entered replace the characters in front of ",
"the insertion cursor, rather than being inserted before them. ",
"\n\n",
"\01A\01BRead Only\01A\n",
"\01ILock the file against accidental modification.  This temporarily prevents the ",
"file from being modified in this XNEdit session. Note that this is different ",
"from setting the file protection. ",
"\n\n",
"\01RPreferences -> Default Settings Menu\01I",
"\n\n",
"Options in the Preferences -> Default Settings menu have the same meaning as ",
"those in the top-level Preferences menu, except that they apply to future ",
"XNEdit windows and future XNEdit sessions if saved with the Save Defaults ",
"command.  Additional options which appear in this menu are: ",
"\n\n",
"\01A\01BLanguage Modes\01A\n",
"\01IDefine language recognition information (for determining language mode from ",
"file name or content) and set language specific preferences. ",
"\n\n",
"\01A\01BTag Collisions\01A\n",
"\01IHow to react to multiple tags for the same name.  Tags are described in the ",
"section: \01QFinding Declarations (ctags)\01I.  In Show All mode, all matching tags ",
"are displayed in a dialog.  In Smart mode, if one of the matching tags is in ",
"the current window, that tag is chosen, without displaying the dialog. ",
"\n\n",
"\01A\01BCommand Shell...\01A\n",
"\01ISet the shell used to run programs from the shell_command() macro function ",
"and from the Shell menu. This defaults to the user's login shell. ",
"\n\n",
"\01A\01BColors...\01A\n",
"\01IChange the colors used to display text.  The \"Matching (..)\" fields change the ",
"colors that matching parens, brackets and braces are flashed when the \"Show ",
"Matching (..)\" option is enabled.  Note that the foreground colors for plain ",
"text, selected text, and matching paren flashing only apply when syntax ",
"highlighting is disabled.  When syntax highlighting is enabled, text (even ",
"text that appears plain) will always be colored according to its highlighting ",
"style. (For information on changing syntax highlighting styles and matching ",
"patterns use see \01QSyntax Highlighting\01I.) ",
"\n\n",
"\01A\01BCustomize Menus\01A\n",
"\01IAdd/remove items from the Shell, Macro, and window background menus (see ",
"below). ",
"\n\n",
"\01A\01BCustomize Window Title\01A\n",
"\01IOpens a dialog where the information to be displayed in the window's title ",
"field can be defined and tested. The dialog contains a Help button, providing ",
"further information about the options available. ",
"\n\n",
"\01A\01BSearching\01A\n",
"\01IOptions for controlling the behavior of Find and Replace commands: ",
"\n\n",
"\01KVerbose\01I - ",
"Presents search results in dialog form, asks before wrapping a ",
"search back around the beginning (or end) of the file ",
"(unless Beep On Search Wrap is turned on). ",
"\n\n",
"\01KWrap Around\01I - ",
"Search and Replace operations wrap around the beginning (or end) of the file. ",
"\n\n",
"\01KBeep On Search Wrap\01I - ",
"Beep when Search and Replace operations wrap around the beginning (or end) of ",
"the file (only if Wrap Around is turned on). ",
"\n\n",
"\01KKeep Dialogs Up\01I - ",
"Don't pop down Replace and Find boxes after searching. ",
"\n\n",
"\01KDefault Search Style\01I - ",
"Initial setting for search type in Find and Replace dialogs. ",
"\n\n",
"\01KDefault Replace Scope\01I - ",
"[THIS OPTION IS ONLY PRESENT WHEN NEDIT WAS COMPILED WITH THE ",
"\01A   -DREPLACE_SCOPE FLAG TO SELECT AN ALTERNATIVE REPLACE DIALOG LAYOUT.]\n",
"\01I\n",
"Initial setting for the scope in the Replace/Find dialog, when a selection ",
"exists. It can be either \"In Window\", \"In Selection\", or \"Smart\". \"Smart\" ",
"results in \"In Window\" if the size of the selection is smaller than 1 line, ",
"and to \"In Selection\" otherwise. ",
"\n\n",
"\01A\01BSyntax Highlighting\01A\n",
"\01IProgram and configure enhanced text display for new or supported languages. ",
"(See \01QSyntax Highlighting\01I.) ",
"\n\n",
"\01A\01BTabbed Editing\01A\n",
"\01IOptions for controlling the tabbed interface: ",
"\n\n",
"\01KOpen File in New Tab\01I - ",
"Open files in new tabs, else open files in new windows. ",
"\n\n",
"\01KShow Tab Bar\01I - ",
"Show/Hide the tab bar. ",
"\n\n",
"\01KHide Tab Bar when only one Document is open\01I ",
"\n\n",
"\01KNext/Prev Tabs Across Windows\01I - ",
"Suppose there are two windows with three tabs in the first window and two tabs in ",
"the second window.  Enabling this option, if you are on the third tab in the ",
"first window, hitting Ctrl+PageDown would switch to the first tab in the second ",
"window (instead of switching to the first tab in the first window). ",
"\n\n",
"\01KSort Tabs Alphabetically\01I ",
"\n\n",
"\01A\01BShow Tooltips\01A\n",
"\01IShow file name and path in a tooltip when moving the mouse pointer over a tab. ",
"(See \01QTabbed Editing\01I.) ",
"\n\n",
"\01A\01BTerminate with Line Break on Save\01A\n",
"\01ISome UNIX tools expect that files end with a line feed. If this option is ",
"activated, XNEdit will append one if required. ",
"\n\n",
"\01A\01BSort Open Prev. Menu\01A\n",
"\01IOption to order the File -> Open Previous menu alphabetically, versus in ",
"order of last access. ",
"\n\n",
"\01A\01BPopups Under Pointer\01A\n",
"\01IDisplay pop-up dialogs centered on the current mouse position, as opposed to ",
"centered on the parent window.  This generally speeds interaction, and is ",
"essential for users who set their window managers so keyboard focus ",
"follows the mouse. ",
"\n\n",
"\01A\01BAuto-Scroll Near Window Top/Bottom\01A\n",
"\01IWhen this option is enabled the window will automatically scroll when the ",
"cursor comes 4 lines from the top or bottom of the window (except at the ",
"beginning of the file).  The number of lines can be customized with the ",
"nedit.autoScrollVPadding resource. ",
"\n\n",
"\01A\01BWarnings\01A\n",
"\01IOptions for controlling the popping up of warning dialogs: ",
"\n\n",
"\01KFile Modified Externally\01I - ",
"Pop up a warning dialog when files get changed external to XNEdit. ",
"\n\n",
"\01KCheck Modified File Contents\01I - ",
"If external file modification warnings are requested, also check the file ",
"contents iso. only the modification date. ",
"\n\n",
"\01KOn Exit\01I - ",
"Ask before exiting when two or more files are open in an XNEdit session ",
"or before closing a window with two or more tabs. ",
"\n\n",
"\01A\01BInitial Window Size\01A\n",
"\01IDefault size for new windows. ",
"\n\n",
"\01RChanging Font(s)\01I",
"\n\n",
"The font used to display text in XNEdit is set under Preferences -> Text Font ",
"(for the current window), or Preferences -> Default Settings Text Font (for ",
"future windows).  These dialogs also allow you to set fonts for syntax ",
"highlighting.  If you don't intend to use syntax highlighting, you can ignore ",
"most of the dialog, and just set the field labeled Primary Font. ",
"\n\n",
"Unless you are absolutely certain about the types of files that you will be ",
"editing with XNEdit, you should choose a fixed-spacing font.  Many, if not ",
"most, plain-text files are written expecting to be viewed with fixed ",
"character spacing, and will look wrong with proportional spacing.  XNEdit's ",
"filling, wrapping, and rectangular operations will also work strangely if you ",
"choose a proportional font. ",
"\n\n",
"Note that in the font browser (the dialog brought up by the Browse... ",
"button), the subset of fonts which are shown is narrowed depending on the ",
"characteristics already selected.  It is therefore important to know that you ",
"can unselect characteristics from the lists by clicking on the selected items ",
"a second time. ",
"\n\n",
"Fonts for syntax highlighting should ideally match the primary font in both ",
"height and spacing.  A mismatch in spacing will result in similar distortions ",
"as choosing a proportional font: column alignment will sometimes look wrong, ",
"and rectangular operations, wrapping, and filling will behave strangely.  A ",
"mismatch in height will cause windows to re-size themselves slightly when ",
"syntax highlighting is turned on or off, and increase the inter-line spacing ",
"of the text.  Unfortunately, on some systems it is hard to find sets of fonts ",
"which match exactly in height. ",
"\n\n",
"\01RCustomizing Menus\01I",
"\n\n",
"You can add or change items in the Shell, Macro, and window background menus ",
"under Preferences -> Default Settings -> Customize Menus.  When you choose ",
"one of these, you will see a dialog with a list of the current ",
"user-configurable items from the menu on the left.  To change an existing ",
"item, select it from the list, and its properties will appear in the ",
"remaining fields of the dialog, where you may change them.  Selecting the ",
"item \"New\" from the list allows you to enter new items in the menu. ",
"\n\n",
"Hopefully most of the characteristics are self explanatory, but here are a ",
"few things to note: ",
"\n\n",
"Accelerator keys are keyboard shortcuts which appear on the right hand side ",
"of the menus, and allow you avoid pulling down the menu and activate the ",
"command with a single keystroke.  Enter accelerators by typing the keys ",
"exactly as you would to activate the command. ",
"\n\n",
"Mnemonics are a single letter which should be part of the menu item name, ",
"which allow users to traverse and activate menu items by typing keys when the ",
"menu is pulled down. ",
"\n\n",
"In the Shell Command field of the Shell Commands dialog, the % character ",
"expands to the name (including directory path) of the file in the window.  To ",
"include a % character in the command, use %%. ",
"\n\n",
"The Menu Entry field can contain special characters for constructing ",
"hierarchical sub-menus, and for making items which appear only in certain ",
"language modes.  The right angle bracket character \">\" creates a sub-menu. ",
"The name of the item itself should be the last element of the path formed ",
"from successive sub-menu names joined with \">\".  Menu panes are called in to ",
"existence simply by naming them as part of a Menu Entry name.  To put several ",
"items in the same sub-menu, repeat the same hierarchical sequence for each. ",
"For example, in the Macro Commands dialog, two items with menu entries: a>b>c ",
"and a>b>d would create a single sub menu under the macro menu called \"a\", ",
"which would contain a single sub-menu, b, holding the actual items, c and d: ",
"\n\n",
"\01A      +---++---++---+\n",
"      |a >||b >||c  |\n",
"      +---++---+|d  |\n",
"                +---+\n",
"\01I\n",
"To qualify a menu entry with a language mode, simply add an at-sign \"@\" at ",
"the end of the menu command, followed (no space) by a language mode name.  To ",
"make a menu item which appears in several language modes, append additional ",
"@s and language mode names.  For example, an item with the menu entry: ",
"\n\n",
"\01A    Make C Prototypes@C@C++\n",
"\01I\n",
"would appear only in C and C++ language modes, and: ",
"\n\n",
"\01A    Make Class Template@C++\n",
"\01I\n",
"would appear only in C++ mode. ",
"\n\n",
"Menu items with no qualification appear in all language modes. ",
"\n\n",
"If a menu item is followed by the single language qualification \"@*\", that ",
"item will appear only if there are no applicable language-specific items of ",
"the same name in the same submenu.  For example, if you have the following ",
"three entries in the same menu: ",
"\n\n",
"\01A    Make Prototypes@C@C++\n",
"    Make Prototypes@Java\n",
"    Make Prototypes@*\n",
"\01I\n",
"The first will be available when the language mode is C or C++, the second ",
"when the language mode is Java, and for all other language modes (including ",
"the \"Plain\" non-language mode).  If the entry: ",
"\n\n",
"\01A    Make Prototypes\n",
"\01I\n",
"also exists, this will always appear, meaning that the menu will always have ",
"two \"Make Prototypes\" entries, whatever the language mode. ",
"\n\n",
"\01RThe XNEdit Autoload Files\01I",
"\n\n",
"At startup time, XNEdit automatically reads the preferences file ",
"`nedit.rc', the autoload macro file `autoload.nm', and the history data base ",
"`nedit.history'.  The preferences file contains saved preferences (menu ",
"settings) in the format of an X resource file.  The autoload macro file is a ",
"macro file containing macro commands and definitions that XNEdit will ",
"execute at startup.  (XNEdit doesn't create this file automatically.) ",
"Moreover, XNEdit saves a list of the recently opened files, which appear under ",
"the Open Previous menu, in the history data base. ",
"\n\n",
"By default the location of these files is '$HOME/.xnedit/'.  A different ",
"directory can be given by letting the environment variable NEDIT_HOME ",
"point to it. ",
"\n\n",
"The contents of the preferences file can be moved into another X resource ",
"file (see \01QX Resources\01I).  One reason for doing so would be to attach server ",
"specific preferences, such as a default font, to a particular X server. ",
"Another reason for moving preferences into an X resource file would be to ",
"keep preferences menu options and X resource settable options together in ",
"one place.  Though the files are the same format, additional resources ",
"should not be added to the preferences file, since XNEdit modifies that file ",
"by overwriting it completely.  Note also that the contents of the ",
"preferences file takes precedence over the values in an X resource file. ",
"Using Save Defaults after moving the contents of your preferences file to ",
"your .Xdefaults file will re-create the preferences file, interfering with ",
"the options that you have moved. ",
"\n\n",
"\01RSharing Customizations with Other XNEdit Users\01I",
"\n\n",
"If you have written macro or shell menu commands, highlight patterns, or ",
"smart-indent macros that you want to share with other XNEdit users, you can ",
"make a file which they can load into their XNEdit environment. ",
"\n\n",
"To load such a file, start XNEdit with the command: ",
"\n\n",
"\01A     xnedit -import <file>\n",
"\01I\n",
"In the new XNEdit session, verify that the imported patterns or macros do what ",
"you want, then select Preferences -> Save Defaults.  Saving incorporates the ",
"changes into the XNEdit preferences file, so the next time you run XNEdit, you ",
"will not have to import the distribution file. ",
"\n\n",
"Loading a customization file is automated, but creating one is not.  To ",
"produce a file to be imported by other users, you must make a copy of your own ",
"preferences file, and edit it, by hand, to remove everything but the ",
"few items of interest to the recipient.  Leave only the individual ",
"resource(s), and within those resources, only the particular macro, pattern, ",
"style, etc, that you wish to exchange. ",
"\n\n",
"For example, to share a highlighting pattern set, you would include the ",
"patterns, any new styles you added, and language mode information only if the ",
"patterns are intended to support a new language rather than updating an ",
"existing one. For example: ",
"\n\n",
"\01A     nedit.highlightPatterns:\\\n",
"          My Language:1:0{\\n\\\n",
"                  Comment:\"#\":\"$\"::Comment::\\n\\\n",
"                  Loop Header:\"^[ \\\\t]*loop:\":::Loop::\\n\\\n",
"          }\n",
"     nedit.languageModes: My Language:.my::::::\n",
"     nedit.styles: Loop:blue:Bold\n",
"\01I\n",
"Resources are in the format of X resource files, but the format of text ",
"within multiple-item resources like highlight patterns, language modes, ",
"macros, styles, etc., are private to XNEdit.  Each resource is a string which ",
"ends at the first newline character not escaped with \\, so you must be ",
"careful about how you treat ends of lines.  While you can generally just cut ",
"and paste indented sections, if something which was originally in the middle ",
"of a resource string is now at the end, you must remove the \\ line ",
"continuation character(s) so it will not join the next line into the ",
"resource.  Conversely, if something which was originally at the end of a ",
"resource is now in the middle, you'll have to add continuation character(s) ",
"to make sure that the resource string is properly continued from beginning to ",
"end, and possibly newline character(s) (\\n) to make sure that it is properly ",
"separated from the next item. ",
NULL
};

static char * htxt_resources [] = {
"\01IXNEdit has additional options to those provided in the Preferences menu which ",
"are set using X resources.  Like most other X programs, XNEdit can be ",
"customized to vastly unnecessary proportions, from initial window positions ",
"down to the font and shadow colors of each individual button (A complete ",
"discussion of how to do this is left to books on the X Window System).  Key ",
"binding (see \"\01QKey Binding\01I\" is one of the most useful of these resource ",
"settable options. ",
"\n\n",
"X resources are usually specified in a file called .Xdefaults or .Xresources ",
"in your home directory. On some systems, this file is read and its information ",
"attached to the X server (your screen) when you start X.  On other systems, ",
"the .Xdefaults file is read each time you run an X program.  When X resource ",
"values are attached to the X server, changes to the resource file are not ",
"available to application programs until you either run the xrdb program with ",
"the appropriate file as input, or re-start the X server. ",
"\n\n",
"\01RSelected X Resource Names\01I",
"\n\n",
"The following are selected XNEdit resource names and default values for XNEdit ",
"options not settable via the Preferences menu (for preference resource names, ",
"see your XNEdit preference file): ",
"\n\n",
"\01A\01Bnedit.tagFile\01A: (not defined)\n",
"\01I\n",
"This can be the name of a file, or multiple files separated by a colon (:) ",
"character, of the type produced by Exuberant Ctags or the Unix ctags ",
"command, which XNEdit will load at startup time (see \01Qctags support\01I). The tag ",
"file provides a database from which XNEdit can automatically open files ",
"containing the definition of a particular subroutine or data type. ",
"\n\n",
"\01A\01Bnedit.alwaysCheckRelativeTagsSpecs: True\01A\n",
"\01I\n",
"When this resource is set to True, and there are tag files specified (with ",
"the nedit.tagFile resource, see above) as relative paths, XNEdit will evaluate ",
"these tag value paths whenever a file is opened. All accessible tag files ",
"will be loaded at this time. When this resource value is False, relative path ",
"tag specifications will only be evaluated at XNEdit startup time. ",
"\n\n",
"\01A\01Bnedit.wordDelimiters\01A: .,/\\\\`'!@#%^&*()-=+{}[]\":;<>?\n",
"\01I\n",
"The set of characters which mark the boundaries between words. In addition ",
"to these, spaces, tabs, and newlines are always word boundaries. ",
"\n\n",
"These boundaries take effect for the move-by-word (Ctrl+Arrow) and ",
"select-word (double click) commands, and for doing regex searches using the ",
"\\B, < and > tokens. ",
"\n\n",
"Note that this default value may be overridden by the setting in ",
"Preferences -> Default Settings -> Language Modes.... ",
"\n\n",
"\01A\01Bnedit.remapDeleteKey\01A: False\n",
"\01I\n",
"Setting this resource to True forcibly maps the delete key to backspace. This ",
"can be helpful on systems where the bindings have become tangled, and in ",
"environments which mix systems with PC style keyboards and systems with DEC ",
"and Macintosh keyboards.  Theoretically, these bindings should be made using ",
"the standard X/Motif mechanisms, outside of XNEdit.  In practice, some ",
"environments where users access several different systems remotely, can be ",
"very hard to configure. If you've given up and are using a backspace key ",
"halfway off the keyboard because you can't figure out the bindings, set this ",
"to True. ",
"\n\n",
"\01A\01Bnedit.typingHidesPointer\01A: False\n",
"\01I\n",
"Setting this resource to True causes the mouse pointer to be hidden when you ",
"type in the text area. As soon as the mouse pointer is moved, it will ",
"reappear.  This is useful to stop the mouse pointer from obscuring text. ",
"\n\n",
"\01A\01Bnedit.overrideDefaultVirtualKeyBindings\01A: Auto\n",
"\01I\n",
"Motif uses a virtual key binding mechanism that shares the bindings between ",
"different Motif applications. When a first Motif application is started, it ",
"installs some default virtual key bindings and any other Motif application ",
"that runs afterwards, simply reuses them. Obviously, if the first ",
"application installs an invalid set, all others applications may have ",
"problems. ",
"\n\n",
"In the past, XNEdit has been the victim of invalid bindings installed by other ",
"applications several times. Through this resource, XNEdit can be instructed ",
"to ignore the bindings installed by other applications, and use its own ",
"private bindings. By default, XNEdit tries to detect invalid bindings ",
"and ignore them automatically (Auto). Optionally, XNEdit can be told to ",
"always keep the installed bindings (Never), or to always override them ",
"(Always). ",
"\n\n",
"\01A\01Bnedit.stdOpenDialog\01A: False\n",
"\01I\n",
"Setting this resource to True restores the standard Motif style of Open ",
"dialog.  XNEdit file open dialogs are missing a text field at the bottom of ",
"the dialog, where the file name can be entered as a string.  The field is ",
"removed in XNEdit to encourage users to type file names in the list, a ",
"non-standard, but much faster method for finding files. ",
"\n\n",
"\01A\01Bnedit.bgMenuButton\01A: ~Shift~Ctrl~Meta~Alt<Btn3Down>\n",
"\01I\n",
"Specification for mouse button / key combination to post the background menu ",
"(in the form of an X translation table event specification).  The event ",
"specification should be as specific as possible, since it will override less ",
"specific translation table entries. ",
"\n\n",
"\01A\01Bnedit.maxPrevOpenFiles\01A: 30\n",
"\01I\n",
"Number of files listed in the Open Previous sub-menu of the File menu. ",
"Setting this to zero disables the Open Previous menu item and maintenance of ",
"the XNEdit file history file. ",
"\n\n",
"\01A\01Bnedit.printCommand\01A: (system specific)\n",
"\01I\n",
"Command used by the print dialog to print a file, such as, lp, lpr, etc.. ",
"The command must be capable of accepting input via stdin (standard input). ",
"\n\n",
"\01A\01Bnedit.printCopiesOption\01A: (system specific)\n",
"\01I\n",
"Option name used to specify multiple copies to the print command.  If the ",
"option should be separated from its argument by a space, leave a trailing ",
"space. If blank, no \"Number of Copies\" item will appear in the print dialog. ",
"\n\n",
"\01A\01Bnedit.printQueueOption\01A: (system specific)\n",
"\01I\n",
"Option name used to specify a print queue to the print command.  If the ",
"option should be separated from its argument by a space, leave a trailing ",
"space. If blank, no \"Queue\" item will appear in the print dialog. ",
"\n\n",
"\01A\01Bnedit.printNameOption\01A: (system specific)\n",
"\01I\n",
"Option name used to specify a job name to the print command.  If the option ",
"should be separated from its argument by a space, leave a trailing space. If ",
"blank, no job or file name will be attached to the print job or banner page. ",
"\n\n",
"\01A\01Bnedit.printHostOption\01A: (system specific)\n",
"\01I\n",
"Option name used to specify a host name to the print command.  If the option ",
"should be separated from its argument by a space, leave a trailing space. If ",
"blank, no \"Host\" item will appear in the print dialog. ",
"\n\n",
"\01A\01Bnedit.printDefaultQueue\01A: (system specific)\n",
"\01I\n",
"The name of the default print queue.  Used only to display in the print ",
"dialog, and has no effect on printing. ",
"\n\n",
"\01A\01Bnedit.printDefaultHost\01A: (system specific)\n",
"\01I\n",
"The node name of the default print host.  Used only to display in the print ",
"dialog, and has no effect on printing. ",
"\n\n",
"\01A\01Bnedit.visualID\01A: Best\n",
"\01I\n",
"If your screen supports multiple visuals (color mapping models), this ",
"resource allows you to manually choose among them.  The default value of ",
"\"Best\" chooses the deepest (most colors) visual available. Since XNEdit does ",
"not depend on the specific characteristics of any given color model, Best ",
"probably IS the best choice for everyone, and the only reason for setting ",
"this resource would be to patch around some kind of X server problem. The ",
"resource may also be set to \"Default\", which chooses the screen's default ",
"visual (often a color-mapped, PseudoColor, visual for compatibility with ",
"older X applications).  It may also be set to a numeric visual-id value (use ",
"xdpyinfo to see the list of visuals supported by your display), or a visual ",
"class name: PseudoColor, DirectColor, TrueColor, etc.. ",
"\n\n",
"If you are running under a themed environment (like KDE or CDE) that places ",
"its colors in a shallow visual, and you'd rather have that color scheme ",
"instead of more colors available, then you may need set the visual to ",
"\"Default\" so that XNEdit doesn't choose one with more colors.  (The reason ",
"for this is: if the \"best\" visual is not the server's default, then XNEdit ",
"cannot use the colors provided by your environment.  XNEdit will fall back to ",
"its own default color scheme.) ",
"\n\n",
"\01A\01Bnedit.installColormap\01A: False\n",
"\01I\n",
"Force the installation of a private colormap.  If you have a humble 8-bit ",
"color display, and netscape is hogging all of the color cells, you may want ",
"to try turning this on.  On most systems, this will result in colors flashing ",
"wildly when you switch between XNEdit and other applications.  But a few ",
"systems (SGI) have hardware support for multiple simultaneous colormaps, and ",
"applications with installed colormaps are well behaved. ",
"\n\n",
"\01A\01Bnedit.findReplaceUsesSelection\01A: False\n",
"\01I\n",
"Controls if the Find and Replace dialogs are automatically loaded with the ",
"contents of the primary selection. ",
"\n\n",
"\01A\01Bnedit.stickyCaseSenseButton\01A: True\n",
"\01I\n",
"Controls if the \"Case Sensitive\" buttons in the Find and Replace dialogs and ",
"the incremental search bar maintain a separate state for literal and regular ",
"expression searches. Moreover, when set to True, by default literal searches ",
"are case insensitive and regular expression searches are case sensitive. When ",
"set to False, the \"Case Sensitive\" buttons are independent of the \"Regular ",
"Expression\" toggle. ",
"\n\n",
"\01A\01Bnedit.multiClickTime\01A: (system specific)\n",
"\01I\n",
"Maximum time in milliseconds allowed between mouse clicks within double and ",
"triple click actions. ",
"\n\n",
"\01A\01Bnedit.undoModifiesSelection\01A: True\n",
"\01I\n",
"By default, XNEdit selects any text inserted or changed through a undo/redo ",
"action.  Set this resource to False if you don't want your selection to be ",
"touched. ",
"\n\n",
"\01A\01Bnedit*scrollBarPlacement\01A: BOTTOM_RIGHT\n",
"\01I\n",
"How scroll bars are placed in XNEdit windows, as well as various lists and ",
"text fields in the program. Other choices are: BOTTOM_LEFT, TOP_LEFT, or ",
"TOP_RIGHT. ",
"\n\n",
"\01A\01Bnedit*text.autoWrapPastedText\01A: False\n",
"\01I\n",
"When Auto Newline Wrap is turned on, apply automatic wrapping (which ",
"normally only applies to typed text) to pasted text as well. ",
"\n\n",
"\01A\01Bnedit*text.heavyCursor\01A: False\n",
"\01I\n",
"For monitors with poor resolution or users who have difficulty seeing the ",
"cursor, makes the cursor in the text editing area of the window heavier and ",
"darker. ",
"\n\n",
"\01A\01Bnedit.autoScrollVPadding\01A: 4\n",
"\01I\n",
"Number of lines to keep the cursor away from the top or bottom line of the ",
"window when the \"Auto-Scroll Near Window Top/Bottom\" feature is enabled. ",
"Keyboard operations that would cause the cursor to get closer than ",
"this distance cause the window to scroll up or down instead, except at the ",
"beginning of the file.  Mouse operations are not affected. ",
"\n\n",
"\01A\01Bnedit*text.blinkRate\01A: 500\n",
"\01I\n",
"Blink rate of the text insertion cursor in milliseconds.  Set to zero to stop ",
"blinking. ",
"\n\n",
"\01A\01Bnedit*text.Translations\01A:\n",
"\01I\n",
"Modifies key bindings (see \"\01QKey Binding\01I\"). ",
"\n\n",
"\01A\01Bnedit*foreground\01A: black\n",
"\01I\n",
"Default foreground color for menus, dialogs, scroll bars, etc.. ",
"\n\n",
"\01A\01Bnedit*background\01A: #b3b3b3\n",
"\01I\n",
"Default background color for menus, dialogs, scroll bars, etc.. ",
"\n\n",
"\01A\01Bnedit*calltipForeground\01A: black\n",
"\01I\n",
"Foreground color for calltips ",
"\n\n",
"\01A\01Bnedit*calltipBackground\01A: LemonChiffon1\n",
"\01I\n",
"Background color for calltips ",
"\n\n",
"\01A\01Bnedit*XmLFolder.inactiveForeground\01A: #666\n",
"\01I\n",
"Foreground color for inactive tabs. ",
"\n\n",
"\01A\01Bnedit*fontList\01A: helvetica medium 12 points\n",
"\01I\n",
"Default font for menus, dialogs, scroll bars, etc.. ",
"\n\n",
"\01A\01Bnedit.helpFont\01A: helvetica medium 12 points\n",
"\01I\n",
"Font used for displaying online help. ",
"\n\n",
"\01A\01Bnedit.boldHelpFont\01A: helvetica bold 12 points\n",
"\01I\n",
"Bold font for online help. ",
"\n\n",
"\01A\01Bnedit.italicHelpFont\01A: helvetica italic 12 points\n",
"\01I\n",
"Italic font for online help. ",
"\n\n",
"\01A\01Bnedit.fixedHelpFont\01A: courier medium 12 points\n",
"\01I\n",
"Fixed font for online help. ",
"\n\n",
"\01A\01Bnedit.boldFixedHelpFont\01A: courier bold 12 points\n",
"\01I\n",
"Fixed bold for online help. ",
"\n\n",
"\01A\01Bnedit.italicFixedHelpFont\01A: courier italic 12 points\n",
"\01I\n",
"Fixed italic font for online help. ",
"\n\n",
"\01A\01Bnedit.h1HelpFont\01A: helvetica bold 14 points\n",
"\01I\n",
"Font for level-1 titles in help text. ",
"\n\n",
"\01A\01Bnedit.h2HelpFont\01A: helvetica bold italic 12 points\n",
"\01I\n",
"Font for level-2 titles in help text. ",
"\n\n",
"\01A\01Bnedit.h3HelpFont\01A: courier bold 12 points\n",
"\01I\n",
"Font for level-3 titles in help text. ",
"\n\n",
"\01A\01Bnedit.helpLinkFont\01A: helvetica medium 12 points\n",
"\01I\n",
"Font for hyperlinks in the help text ",
"\n\n",
"\01A\01Bnedit.helpLinkColor\01A: #009900\n",
"\01I\n",
"Color for hyperlinks in the help text ",
"\n\n",
"\01A\01Bnedit.backlightCharTypes\01A:  0-8,10-31,127:red;9:#dedede;32,160-255:#f0f0f0;128-159:orange\n",
"\01I\n",
"\01JNOTE: backlighting is \01Lexperimental\01J\01I (see \"\01QProgramming with XNEdit\01I\"). ",
"\n\n",
"A string specifying character classes as ranges of ASCII values followed by ",
"the color to be used as their background colors.  The format is: ",
"\n\n",
"low[-high]{,low[-high]}:color{;low-high{,low[-high]}:color} ",
"\n\n",
"where low and high are ASCII values. ",
"\n\n",
"For example: ",
"\01A    32-255:#f0f0f0;1-31,127:red;128-159:orange;9-13:#e5e5e5\n",
"\01I\n",
"\01A\01Bnedit.focusOnRaise\01A: False\n",
"\01I\n",
"This resource determines whether new text windows and text windows that are ",
"raised, should also request the input focus.  Conventionally, it is the task ",
"of the window manager to decide on which window gets the input focus. ",
"Therefore, XNEdit's default behaviour is not to request the input focus ",
"explicitly. ",
"\n\n",
"\01A\01Bnedit.forceOSConversion\01A: True\n",
"\01I\n",
"By default, XNEdit converts texts in DOS or Mac format to an internal ",
"format using simple newlines as line dividers. This is sometimes not ",
"wanted by the user and can be prevented by setting this resource to ",
"False. ",
"\n\n",
"Note: Setting this to False would supress newlines in Mac files entirely, ",
"leaving the control character <cr> where every line feed would be. Mac OS ",
"X uses Unix files and is not affected. ",
"\n\n",
"Note: Setting this to False while the option 'Terminate with Line Break ",
"on Save' is active could lead to file corruption. ",
"\n\n",
"\01A\01Bnedit.truncSubstitution\01A: Fail\n",
"\01I\n",
"XNEdit has a fixed limit on substitution result string length. This ",
"resource modifies the behaviour if this limit is exceeded. Possible ",
"values are \01KSilent\01I (will silently fail the operation), \01KFail\01I (will fail ",
"the operation and pop up a dialog informing the user), \01KWarn\01I (pops up a ",
"dialog warning the user, offering to cancel the operation) and \01KIgnore\01I ",
"(will silently conclude the operation). ",
"\n\n",
"\01JWARNING\01I: Setting this to 'Ignore' will destroy data without warning! ",
"\n\n",
"\01A\01Bnedit.honorSymlinks\01A: True\n",
"\01I\n",
"If set to True, XNEdit will open a requested file on disk even if it is a ",
"symlink pointing to a file already opened in another window. If set to false, ",
"XNEdit will try to detect these cases and just pop up the already opened ",
"document. ",
"\n\n",
"\01A\01Bnc.autoStart\01A: True \n",
"\01I\n",
"Whether the xnc program should automatically start an XNEdit server (without ",
"prompting the user) if an appropriate server is not found. ",
"\n\n",
"\01A\01Bnc.serverCommand\01A: xnedit -server\n",
"\01I\n",
"Command used by the xnc program to start an XNEdit server. ",
"\n\n",
"\01A\01Bnc.timeOut\01A: 10\n",
"\01I\n",
"Basic time-out period used in communication with an XNEdit server (seconds). ",
"\n\n",
"\01KThe following are Selected widget names (to which you may append\01I ",
"\01K.background, .foreground, .fontList, etc., to change colors, fonts\01I ",
"\01K and other characteristics):\01I ",
"\n\n",
"\01A\01Bnedit*statsAreaForm\01A\n",
"\01I\n",
"Statistics line and incremental search bar.  To get consistent results across ",
"the entire stats line and the incremental search bar, use '*' rather than '.' ",
"to separate the resource name.  For example, to set the foreground color of ",
"both components use: ",
"\01A    nedit*statsAreaForm*foreground\n",
"\01Iinstead of: ",
"\01A    nedit*statsAreaForm.foreground\n",
"\01I\n",
"\01A\01Bnedit*menuBar\01A\n",
"\01I\n",
"Top-of-window menu-bar. ",
"\n\n",
"\01A\01Bnedit*textHorScrollBar\01A\n",
"\01I\n",
"Horizontal scroll bar. ",
"\n\n",
"\01A\01Bnedit*textVertScrollBar\01A\n",
"\01I\n",
"Vertical scroll bar. ",
NULL
};

static char * htxt_binding [] = {
"\01IThere are several ways to change key bindings in XNEdit.  The easiest way to ",
"add a new key binding in XNEdit is to define a macro in Preferences -> Default ",
"Settings -> Customize Menus -> Macro Menu.  However, if you want to change ",
"existing bindings or add a significant number of new key bindings you will ",
"need to do so via X resources. ",
"\n\n",
"Before reading this section, you must understand how to set X resources (see ",
"the help section \"\01QX Resources\01I\").  Since setting X resources is tricky, it is ",
"also helpful when working on key-binding, to set some easier-to-verify ",
"resource at the same time, as a simple check that the XNEdit program is ",
"actually seeing your changes.  The appres program is also very helpful in ",
"checking that the resource settings that you make, actually reach the program ",
"for which they are intended in the correct form. ",
"\n\n",
"\01RKey Binding in General\01I",
"\n\n",
"Keyboard commands are associated with editor action routines through two ",
"separate mechanisms in XNEdit.  Commands which appear in pull-down menus have ",
"individual resources designating a keyboard equivalent to the menu command, ",
"called an accelerator key.  Commands which do not have an associated menu ",
"item are bound to keys via the X toolkit translation mechanism.  The methods ",
"for changing these two kinds of bindings are quite different. ",
"\n\n",
"\01RKey Binding Via Translations\01I",
"\n\n",
"The most general way to bind actions to keys in XNEdit is to use the ",
"translation table associated with the text widget.  To add a binding to Alt+Y ",
"to insert the string \"Hi!\", for example, add lines similar to the following ",
"to your X resource file: ",
"\n\n",
"\01A    XNEdit*text.Translations: #override \\n\\\n",
"      Alt<Key>y: insert_string(\"Hi!\") \\n\n",
"\01I\n",
"The Help topic \"\01QAction Routines\01I\" lists the actions available to be bound. ",
"\n\n",
"Translation tables map key and mouse presses, window operations, and other ",
"kinds of events, to actions. The syntax for translation tables is ",
"simplified here, so you may need to refer to a book on the X window system ",
"for more detailed information. ",
"\n\n",
"Note that accelerator resources (discussed below) override translations, and ",
"that most Ctrl+letter and Alt+letter combinations are already bound to an ",
"accelerator key.  To use one of these combinations from a translation table, ",
"therefore, you must first un-bind the original menu accelerator. ",
"\n\n",
"A resource for changing a translation table consists of a keyword; #override, ",
"#augment, or #replace; followed by lines (separated by newline characters) ",
"pairing events with actions.  Events begin with modifiers, like Ctrl, Shift, ",
"or Alt, followed by the event type in <>.  BtnDown, Btn1Down, Btn2Down, ",
"Btn1Up, Key, KeyUp are valid event types.  For key presses, the event type is ",
"followed by the name of the key.  You can specify a combination of events, ",
"such as a sequence of key presses, by separating them with commas.  The other ",
"half of the event/action pair is a set of actions.  These are separated from ",
"the event specification by a colon and from each other by spaces.  Actions ",
"are names followed by parentheses, optionally containing one or more ",
"parameters separated by comas. ",
"\n\n",
"\01RChanging Menu Accelerator Keys\01I",
"\n\n",
"The menu shortcut keys shown at the right of XNEdit menu items can also be ",
"changed via X resources.  Each menu item has two resources associated with ",
"it, accelerator, the event to trigger the menu item; and acceleratorText, the ",
"string shown in the menu.  The form of the accelerator resource is the same ",
"as events for translation table entries discussed above, though multiple keys ",
"and other subtleties are not allowed.  The resource name for a menu is the ",
"title in lower case, followed by \"Menu\", the resource name of menu item is ",
"the name in lower case, run together, with words separated by caps, and all ",
"punctuation removed.  For example, to change Cut to Ctrl+X, you would add the ",
"following to your .Xdefaults file: ",
"\n\n",
"\01A      nedit*editMenu.cut.accelerator: Ctrl<Key>x\n",
"      nedit*editMenu.cut.acceleratorText: Ctrl+X\n",
"\01I\n",
"Accelerator keys with optional shift key modifiers, like Find..., have an ",
"additional accelerator resource with Shift appended to the name.  For ",
"example: ",
"\n\n",
"\01A      nedit*searchMenu.find.acceleratorText: [Shift]Alt+F\n",
"      nedit*searchMenu.find.accelerator: Alt<Key>f\n",
"      nedit*searchMenu.findShift.accelerator: Shift Alt<Key>f\n",
NULL
};

static char * htxt_patterns [] = {
"\01RWriting Syntax Highlighting Patterns\01I",
"\n\n",
"Patterns are the mechanism by which language syntax highlighting is ",
"implemented in XNEdit (see \01QSyntax Highlighting\01I under the heading of Features ",
"for Programming). To create syntax highlighting patterns for a new ",
"language, or to modify existing patterns, select \"Recognition Patterns\" from ",
"\"Syntax Highlighting\" sub-section of the \"Default Settings\" sub-menu of the ",
"\"Preferences\" menu. ",
"\n\n",
"First, a word of caution.  As with regular expression matching in general, it ",
"is quite possible to write patterns which are so inefficient that they ",
"essentially lock up the editor as they recursively re-examine the entire ",
"contents of the file thousands of times.  With the multiplicity of patterns, ",
"the possibility of a lock-up is significantly increased in syntax ",
"highlighting.  When working on highlighting patterns, be sure to save your ",
"work frequently. ",
"\n\n",
"XNEdit's syntax highlighting is unusual in that it works in real-time (as you ",
"type), and yet is completely programmable using standard regular expression ",
"notation.  Other syntax highlighting editors usually fall either into the ",
"category of fully programmable but unable to keep up in real-time, or ",
"real-time but limited programmability.  The additional burden that XNEdit ",
"places on pattern writers in order to achieve this speed/flexibility mix, is ",
"to force them to state self-imposed limitations on the amount of context that ",
"patterns may examine when re-parsing after a change.  While the \"Pattern ",
"Context Requirements\" heading is near the end of this section, it is not ",
"optional, and must be understood before making any serious effort at ",
"pattern writing. ",
"\n\n",
"In its simplest form, a highlight pattern consists of a regular expression to ",
"match, along with a style representing the font an color for displaying any ",
"text which matches that expression.  To bold the word, \"highlight\", wherever ",
"it appears the text, the regular expression simply would be the word ",
"\"highlight\".  The style (selected from the menu under the heading of ",
"\"Highlight Style\") determines how the text will be drawn.  To bold the text, ",
"either select an existing style, such as \"Keyword\", which bolds text, or ",
"create a new style and select it under Highlight Style. ",
"\n\n",
"The full range of regular expression capabilities can be applied in such a ",
"pattern, with the single caveat that the expression must conclusively match ",
"or not match, within the pre-defined context distance (as discussed below ",
"under Pattern Context Requirements). ",
"\n\n",
"To match longer ranges of text, particularly any constructs which exceed the ",
"requested context, you must use a pattern which highlights text between a ",
"starting and ending regular expression match.  To do so, select \"Highlight ",
"text between starting and ending REs\" under \"Matching\", and enter both a ",
"starting and ending regular expression.  For example, to highlight everything ",
"between double quotes, you would enter a double quote character in both the ",
"starting and ending regular expression fields.  Patterns with both a ",
"beginning and ending expression span all characters between the two ",
"expressions, including newlines. ",
"\n\n",
"Again, the limitation for automatic parsing to operate properly is that both ",
"expressions must match within the context distance stated for the pattern ",
"set. ",
"\n\n",
"With the ability to span large distances, comes the responsibility to recover ",
"when things go wrong.  Remember that syntax highlighting is called upon to ",
"parse incorrect or incomplete syntax as often as correct syntax.  To stop a ",
"pattern short of matching its end expression, you can specify an error ",
"expression, which stops the pattern from gobbling up more than it should. ",
"For example, if the text between double quotes shouldn't contain newlines, ",
"the error expression might be \"$\".  As with both starting and ending ",
"expressions, error expressions must also match within the requested context ",
"distance. ",
"\n\n",
"\01SColoring Sub-Expressions\01I",
"\n\n",
"It is also possible to color areas of text within a regular expression ",
"match.  A pattern of this type associates a style with sub-expressions ",
"references of the parent pattern (as used in regular expression substitution ",
"patterns, see the XNEdit Help menu item on Regular Expressions). ",
"Sub-expressions of both the starting and ending patterns may be colored.  For ",
"example, if the parent pattern has a starting expression \"\\<\", and end ",
"expression \"\\>\", (for highlighting all of the text contained within angle ",
"brackets), a sub-pattern using \"&\" in both the starting and ending expression ",
"fields could color the brackets differently from the intervening text.  A ",
"quick shortcut to typing in pattern names in the Parent Pattern field is to ",
"use the middle mouse button to drag them from the Patterns list. ",
"\n\n",
"In some cases, there can be interference between coloring sub-patterns and ",
"hierarchical sub-patterns (discussed next). How this is resolved, is ",
"explained below. ",
"\n\n",
"\01SHierarchical Patterns\01I",
"\n\n",
"A hierarchical sub-pattern, is identical to a top level pattern, but is ",
"invoked only between the starting and ending expression matches of its ",
"parent pattern or, in case the parent pattern consists of a single ",
"expression, inside the text area matching that expression.  Like the ",
"sub-expression coloring patterns discussed above, it is associated with a ",
"parent pattern using the Parent Pattern field in the pattern specification. ",
"Pattern names can be dragged from the pattern list with the middle mouse ",
"button to the Parent Pattern field. ",
"\n\n",
"The matching behaviour for sub-patterns is slightly different, depending on ",
"whether the parent pattern consists of a single expression or has both a ",
"starting and an ending expression. ",
"\n\n",
"In case the parent pattern consists of a single expression, and the syntax ",
"highlighting parser finds a match for that expression, sub-patterns are ",
"matched between the start and the end of the parent match.  Sub-patterns ",
"cannot extend beyond the boundaries of the parent's match nor can they ",
"affect those boundaries (the latter can happen for starting/ending parent ",
"patterns, see below). Note that sub-patterns can \01Kpeek\01I beyond the ",
"parent's matching boundaries by means of look-ahead or look-behind ",
"expressions. ",
"\n\n",
"In case the parent pattern is a starting/ending style pattern, after the ",
"start expression of the parent pattern matches, the syntax highlighting ",
"parser searches for either the parent's end pattern or a matching ",
"sub-pattern.  When a sub-pattern matches, control is not returned to the ",
"parent pattern until the entire sub-pattern has been parsed, regardless of ",
"whether the parent's end pattern appears in the text matched by the ",
"sub-pattern.  In this way, matching of the parent's ending pattern can be ",
"postponed, in contrast to the case where the parent pattern consists of a ",
"single expression. Note that, in this case, parsing of sub-patterns starts ",
"\01Jafter\01I the match of the parent pattern's starting expression, also in ",
"contrast to the single-expression case. ",
"\n\n",
"The most common use for this capability is for coloring sub-structure of ",
"language constructs (smaller patterns embedded in larger patterns). ",
"Hierarchical patterns can also simplify parsing by having sub-patterns \"hide\" ",
"special syntax from parent patterns, such as special escape sequences or ",
"internal comments. ",
"\n\n",
"There is no depth limit in nesting hierarchical sub-patterns, but beyond the ",
"third level of nesting, automatic re-parsing will sometimes have to re-parse ",
"more than the requested context distance to guarantee a correct parse (which ",
"can slow down the maximum rate at which the user can type if large sections ",
"of text are matched only by deeply nested patterns). ",
"\n\n",
"While this is obviously not a complete hierarchical language parser it is ",
"still useful in many text coloring situations.  As a pattern writer, your ",
"goal is not to completely cover the language syntax, but to generate ",
"colorings that are useful to the programmer.  Simpler patterns are usually ",
"more efficient and also more robust when applied to incorrect code. ",
"\n\n",
"Note that in case of a single-expression parent pattern, there is a ",
"potential for conflicts between coloring-only sub-patterns and hierarchical ",
"sub-patterns (which cannot happen for starting/ending type of patterns, ",
"because sub-patterns are matched \01Jbetween\01I the starting and ending pattern ",
"(not included)).  Due to the different nature of these two kinds of ",
"sub-patterns, it is technically infeasible to follow the standard matching ",
"precedence rules, where a sub-pattern has precedence over the sub-patterns ",
"following it.  Instead, coloring-only sub-patterns are always colored last, ",
"ie., they may override the coloring for overlapping sibling sub-patterns in ",
"the overlapping parts of the matches. ",
"\n\n",
"\01SDeferred (Pass-2) Parsing\01I",
"\n\n",
"XNEdit does pattern matching for syntax highlighting in two passes.  The first ",
"pass is applied to the entire file when syntax highlighting is first turned ",
"on, and to new ranges of text when they are initially read or pasted in.  The ",
"second pass is applied only as needed when text is exposed (scrolled in to ",
"view). ",
"\n\n",
"If you have a particularly complex set of patterns, and parsing is beginning ",
"to add a noticeable delay to opening files or operations which change large ",
"regions of text, you can defer some of that parsing from startup time, to ",
"when it is actually needed for viewing the text.  Deferred parsing can only ",
"be used with single expression patterns, or begin/end patterns which match ",
"entirely within the requested context distance.  To defer the parsing of a ",
"pattern to when the text is exposed, click on the Pass-2 pattern type button ",
"in the highlight patterns dialog. ",
"\n\n",
"Sometimes a pattern can't be deferred, not because of context requirements, ",
"but because it must run concurrently with pass-1 (non-deferred) patterns.  If ",
"they didn't run concurrently, a pass-1 pattern might incorrectly match some ",
"of the characters which would normally be hidden inside of a sequence matched ",
"by the deferred pattern.  For example, C has character constants enclosed in ",
"single quotes.  These typically do not cross line boundaries, meaning they ",
"can be parsed entirely within the context distance of the C pattern set and ",
"should be good candidates for deferred parsing.  However, they can't be ",
"deferred because they can contain sequences of characters which can trigger ",
"pass-one patterns. Specifically, the sequence, '\\\"', contains a double quote ",
"character, which would be matched by the string pattern and interpreted as ",
"introducing a string. ",
"\n\n",
"\01SPattern Context Requirements\01I",
"\n\n",
"The context requirements of a pattern set state how much additional text ",
"around any change must be examined to guarantee that the patterns will match ",
"what they are intended to match.  Context requirements are a promise by XNEdit ",
"to the pattern writer, that the regular expressions in his/her patterns will ",
"be matched against at least <line context> lines and <character context> ",
"characters, around any modified text.  Combining line and character ",
"requirements guarantee that both will be met. ",
"\n\n",
"Automatic re-parsing happens on EVERY KEYSTROKE, so the amount of context ",
"which must be examined is very critical to typing efficiency.  The more ",
"complicated your patterns, the more critical the context becomes.  To cover ",
"all of the keywords in a typical language, without affecting the maximum rate ",
"at which users can enter text, you may be limited to just a few lines and/or ",
"a few hundred characters of context. ",
"\n\n",
"The default context distance is 1 line, with no minimum character ",
"requirement.  There are several benefits to sticking with this default.  One ",
"is simply that it is easy to understand and to comply with.  Regular ",
"expression notation is designed around single line matching.  To span lines ",
"in a regular expression, you must explicitly mention the newline character ",
"\"\\n\", and matches which are restricted to a single line are virtually immune ",
"to lock-ups.  Also, if you can code your patterns to work within a single ",
"line of context, without an additional character-range context requirement, ",
"the parser can take advantage the fact that patterns don't cross line ",
"boundaries, and nearly double its efficiency over a one-line and 1-character ",
"context requirement.  (In a single line context, you are allowed to match ",
"newlines, but only as the first and/or last character.) ",
NULL
};

static char * htxt_smart_indent [] = {
"\01ISmart indent macros can be written for any language, but are usually more ",
"difficult to write than highlighting patterns.  A good place to start, of ",
"course, is to look at the existing macros for C and C++. ",
"\n\n",
"Smart indent macros for a language mode consist of standard XNEdit macro ",
"language code attached to any or all of the following three activation ",
"conditions: 1) When smart indent is first turned on for a text window ",
"containing code of the language, 2) When a newline is typed and smart indent ",
"is expected, 3) after any character is typed.  To attach macro code to any of ",
"these code \"hooks\", enter it in the appropriate section in the Preferences -> ",
"Default Settings -> Auto Indent -> Program Smart Indent dialog. ",
"\n\n",
"Typically most of the code should go in the initialization section, because ",
"that is the appropriate place for subroutine definitions, and smart indent ",
"macros are complicated enough that you are not likely to want to write them ",
"as one monolithic run of code.  You may also put code in the Common/Shared ",
"Initialization section (accessible through the button in the upper left ",
"corner of the dialog).  Unfortunately, since the C/C++ macros also reside in ",
"the common/shared section, when you add code there, you run some risk of ",
"missing out on future upgrades to these macros, because your changes will ",
"override the built-in defaults. ",
"\n\n",
"The newline macro is invoked after the user types a newline, but before the ",
"newline is entered in the buffer.  It takes a single argument ($1) which is ",
"the position at which the newline will be inserted.  It must return the ",
"number of characters of indentation the line should have, or -1.  A return ",
"value of -1 means to do a standard auto-indent.  You must supply a newline ",
"macro, but the code: \"return -1\" (auto-indent), or \"return 0\" (no indent) is ",
"sufficient. ",
"\n\n",
"The type-in macro takes two arguments.  $1 is the insert position, and $2 is ",
"the character just typed, and does not return a value.  It also is invoked ",
"before the character is inserted into the buffer.  You can do just about ",
"anything here, but keep in mind that this macro is executed for every ",
"keystroke typed, so if you try to get too fancy, you may degrade performance. ",
NULL
};

static char * htxt_command_line [] = {
#ifndef VMS
"\01A   \01Bxnedit\01A [-\01Bread\01A] [-\01Bcreate\01A] [-\01Bline\01A n | +n] [-\01Bserver\01A]\n",
"      [-\01Bdo\01A command] [-\01Btags\01A file] [-\01Btabs\01A n] [-\01Bwrap\01A]\n",
"      [-\01Bnowrap\01A] [-\01Bautowrap\01A] [-\01Bautoindent\01A] [-\01Bnoautoindent\01A]\n",
"      [-\01Bautosave\01A] [-\01Bnoautosave\01A] [-\01Brows\01A n] [-\01Bcolumns\01A n]\n",
"      [-\01Bfont\01A font] [-\01Blm\01A languagemode] [-\01Bgeometry\01A geometry]\n",
"      [-\01Biconic\01A] [-\01Bnoiconic\01A] [-\01Bdisplay\01A [host]:server[.screen]\n",
"      [-\01Bxrm\01A resourcestring] [-\01Bsvrname\01A name] [-\01Bimport\01A file]\n",
"      [-\01Bbackground\01A color] [-\01Bforeground\01A color] [-\01Bh\01A|-\01Bhelp\01A]\n",
"      [-\01Btabbed\01A] [-\01Buntabbed\01A] [-\01Bgroup\01A] [-\01BV\01A|-\01Bversion\01A]\n",
"      [-bgrun] [--] [file...]\n",
"\01I\n",
"\01A\01B-read\01A\n",
"\01IOpen the file Read Only regardless of the actual file protection. ",
"\n\n",
"\01A\01B-create\01A\n",
"\01IDon't warn about file creation when a file doesn't exist. ",
"\n\n",
"\01A\01B-line n (or +n)\01A\n",
"\01IGo to line number n in the file following this switch. ",
"\n\n",
"\01A\01B-server\01A\n",
"\01IDesignate this session as an XNEdit server, for processing commands from the ",
"xnc program.  xnc can be used to interface XNEdit to code development ",
"environments, mailers, etc., or just as a quick way to open files from the ",
"shell command line without starting a new XNEdit session. ",
"\n\n",
"\01A\01B-do command\01A\n",
"\01IExecute an XNEdit macro or action on the file following the -do argument on ",
"the command line. -do is particularly useful from the xnc program, where ",
"xnc -do can remotely execute commands in an XNEdit -server session. ",
"\n\n",
"\01A\01B-tags file\01A\n",
"\01ILoad a file of directions for finding definitions of program subroutines and ",
"data objects.  The file must be of the format generated by Exuberant Ctags, ",
"or the standard Unix ctags command. ",
"\n\n",
"\01A\01B-tabs n\01A\n",
"\01ISet tab stops every n characters. ",
"\n\n",
"\01A\01B-wrap, -nowrap\01A\n",
"\01IWrap long lines at the right edge of the window rather than continuing them ",
"past it.  (Continuous Wrap mode) ",
"\n\n",
"\01A\01B-autowrap, -noautowrap\01A\n",
"\01IWrap long lines when the cursor reaches the right edge of the window by ",
"inserting newlines at word boundaries.  (Auto Newline Wrap mode) ",
"\n\n",
"\01A\01B-autoindent, -noautoindent\01A\n",
"\01IMaintain a running indent. ",
"\n\n",
"\01A\01B-autosave, -noautosave\01A\n",
"\01IMaintain a backup copy of the file being edited under the name '~filename'. ",
"\n\n",
"\01A\01B-rows n\01A\n",
"\01IDefault height in characters for an editing window. ",
"\n\n",
"\01A\01B-columns n\01A\n",
"\01IDefault width in characters for an editing window. ",
"\n\n",
"\01A\01B-font font (or -fn font)\01A\n",
"\01IFont for text being edited (Font for menus and dialogs can be set with -xrm ",
"\"*fontList:font\"). ",
"\n\n",
"\01A\01B-lm languagemode\01A\n",
"\01IInitial language mode used for editing succeeding files. ",
"\n\n",
"\01A\01B-geometry geometry (or -g geometry)\01A\n",
"\01IThe initial size and/or location of editor windows.  The argument geometry ",
"has the form: ",
"\n\n",
"\01A   [<width>x<height>][+|-][<xoffset>[+|-]<yoffset>]\n",
"\01I\n",
"where <width> and <height> are the desired width and height of the window, ",
"and <xoffset> and <yoffset> are the distance from the edge of the screen to ",
"the window, + for top or left, - for bottom or right.  -geometry can be ",
"specified for individual files on the command line. ",
"\n\n",
"\01A\01B-iconic, -noiconic\01A\n",
"\01IInitial window state for succeeding files. ",
"\n\n",
"\01A\01B-display [host]:server[.screen]\01A\n",
"\01IThe name of the X server to use.  host specifies the machine, server ",
"specifies the display server number, and screen specifies the screen number. ",
"host or screen can be omitted and default to the local machine, and screen 0. ",
"\n\n",
"\01A\01B-background color (or -bg color)\01A\n",
"\01IUser interface background color. (Background color for text can be set ",
"separately with -xrm \"nedit.textBgColor: color\" or using the Preferences -> ",
"Colors dialog). ",
"\n\n",
"\01A\01B-foreground color (or -fg color)\01A\n",
"\01IUser interface foreground color. (Foreground color for text can be set ",
"separately with -xrm \"nedit.textFgColor: color\" or using the Preferences ",
"-> Colors dialog). ",
"\n\n",
"\01A\01B-tabbed\01A\n",
"\01IOpen all subsequent files in new tabs. Resets -group option. ",
"\n\n",
"\01A\01B-untabbed\01A\n",
"\01IOpen all subsequent files in new windows. Resets -group option. Note ",
"that this only works on subsequent files in this command and does not put ",
"XNEdit in tab-less mode; for that you can use the command ",
"\01A    nedit -xrm \"nedit.openInTab: False\" -xrm \"nedit.tabBarHideOne: True\"\n",
"\01IThis will affect your default settings for the session, and will be saved ",
"if Preferences->Save Defaults... is used, which may not be desired. ",
"\n\n",
"\01A\01B-group\01A\n",
"\01IOpen all subsequent files as tabs in a new window. ",
"\n\n",
"\01A\01B-xrm resourcestring\01A\n",
"\01ISet the value of an X resource to override a default ",
"value (see \"\01QCustomizing XNEdit\01I\"). ",
"\n\n",
"\01A\01B-svrname name\01A\n",
"\01IWhen starting XNEdit in server mode, name the server, such that it responds to ",
"requests only when xnc is given a corresponding -svrname argument.  By naming ",
"servers, you can run several simultaneously, and direct files and commands ",
"specifically to any one. Specifying a non-empty name automatically designates ",
"this session as an XNEdit server, as though -server were specified. ",
"\n\n",
"\01A\01B-import file\01A\n",
"\01ILoads an additional preferences file on top of the existing defaults saved in ",
"your preferences file.  To incorporate macros, language modes, and highlight ",
"patterns and styles written by other users, run XNEdit with -import <file>, ",
"then re-save your preferences file with Preferences -> Save Defaults. ",
"\n\n",
"\01A\01B-bgrun\01A\n",
"\01IRun xnedit in a background process ",
"\n\n",
"\01A\01B-version\01A\n",
"\01IPrints out the XNEdit version information. The -V option is synonymous. ",
"\n\n",
"\01A\01B-help\01A\n",
"\01IPrints out the XNEdit command line help. The -h option is synonymous. ",
"\n\n",
"\01A\01B--\01A\n",
"\01ITreats all subsequent arguments as file names, even if they start with a ",
"dash. This is so XNEdit can access files that begin with the dash character. ",
"\n\n",
#else
"This documentation for VMS XNEdit usage should only appear in the ",
"generated help code, not in any of the printed documentation. ",
"Reasoning is that VMS usage is diminishing and there is a desire ",
"to not clutter up the printed documentation here. ",
"NEDIT [filespec[,...]] ",
"\n\n",
"The following qualifiers are accepted: ",
"\n\n",
"\01A\01B/read\01A\n",
"\01IOpen the file Read Only regardless of the actual file protection. ",
"\n\n",
"\01A\01B/create\01A\n",
"\01IDon't warn about file creation when a file doesn't exist. ",
"\n\n",
"\01A\01B/line=n\01A\n",
"\01IGo to line #n ",
"\n\n",
"\01A\01B/server\01A\n",
"\01IDesignate this session as an XNEdit server for processing commands from the xnc ",
"program. The xnc program can be used to interface XNEdit to code development ",
"environments, mailers, etc., or just as a quick way to open files from the ",
"shell command line without starting a new XNEdit session. ",
"\n\n",
"\01A\01B/do=command\01A\n",
"\01IExecute an XNEdit action routine. on each file following the /do argument on ",
"the command line.  /do is particularly useful from the xnc program, where xnc ",
"/do can remotely execute commands in an xnedit /server session. ",
"\n\n",
"\01A\01B/tags=file\01A\n",
"\01ILoad a file of directions for finding definitions of program subroutines and ",
"data objects.  The file must be of the format generated by the Unix ctags ",
"command. ",
"\n\n",
"\01A\01B/wrap, /nowrap\01A\n",
"\01IWrap long lines at the right edge of the window rather than continuing them ",
"past it.  (Continuous Wrap mode) ",
"\n\n",
"\01A\01B/autowrap, /noautowrap\01A\n",
"\01IWrap long lines when the cursor reaches the right edge of the window by ",
"inserting newlines at word boundaries.  (Auto Newline Wrap mode) ",
"\n\n",
"\01A\01B/autoindent, /noautoindent\01A\n",
"\01IMaintain a running indent. ",
"\n\n",
"\01A\01B/autosave, /noautosave\01A\n",
"\01IMaintain a backup copy of the file being edited under the name '_filename'. ",
"\n\n",
"\01A\01B/rows=n\01A\n",
"\01IDefault width in characters for an editing window. ",
"\n\n",
"\01A\01B/columns=n\01A\n",
"\01IDefault height in characters for an editing window. ",
"\n\n",
"\01A\01B/font=font (or /fn=font)\01A\n",
"\01IFont for text being edited (Font for menus and dialogs can be set with ",
"/xrm=\"*fontList:font\"). ",
"\n\n",
"\01A\01B/display [host]:server[.screen]\01A\n",
"\01IThe name of the X server to use.  host specifies the machine, server ",
"specifies the display server number, and screen specifies the screen number. ",
"host or screen can be omitted and default to the local machine, and screen 0. ",
"\n\n",
"\01A\01B/geometry=geometry (or /g=geometry)\01A\n",
"\01IThe initial size and/or location of editor windows. The argument geometry ",
"has the form: ",
"\n\n",
"\01A    [<width>x<height>][+|-][<xoffset>[+|-]<yoffset>]\n",
"\01I\n",
"where <width> and <height> are the desired width and height of the window, ",
"and <xoffset> and <yoffset> are the distance from the edge of the screen to ",
"the window, + for top or left, - for bottom or right. ",
"\n\n",
"\01A\01B/background=color (or /bg=color)\01A\n",
"\01I\n",
"Background color. (background color for text can be set separately with ",
"/xrm=\"nedit:textBgColor color\" or using the Preferences -> ",
"Colors dialog). ",
"\n\n",
"\01A\01B/foreground=color (or /fg=color)\01A\n",
"\01IForeground color. (foreground color for text can be set separately with ",
"/xrm=\"nedit:textFgColor color\" or using the Preferences -> ",
"Colors dialog). ",
"\n\n",
"\01A\01B/tabbed\01A\n",
"\01IOpen all subsequent files in new tabs. Resets /group option. ",
"\n\n",
"\01A\01B/untabbed\01A\n",
"\01IOpen all subsequent files in new windows. Resets /group option. ",
"\n\n",
"\01A\01B/group\01A\n",
"\01IOpen all subsequent files as tabs in a new window. ",
"\n\n",
"\01A\01B/xrm=resourcestring\01A\n",
"\01ISet the value of an X resource to override a default value ",
"(see Customizing XNEdit). ",
"\n\n",
"\01A\01B/svrname=name\01A\n",
"\01IWhen starting xnedit in server mode, name the server, such that it responds to ",
"requests only when xnc is given a corresponding -svrname argument.  By naming ",
"servers, you can run several simultaneously, and direct files and commands ",
"specifically to any one. ",
"\n\n",
"\01A\01B/import=file\01A\n",
"\01ILoads an additional preferences file on top of the existing defaults saved in ",
"your .nedit file.  To incorporate macros, language modes, and highlight ",
"patterns and styles written by other users, run nedit with /import=<file>, ",
"then re-save your .nedit file with Preferences -> Save Defaults. ",
"\n\n",
"Unix-style command lines (but not file names) are also acceptable: ",
"\n\n",
"\01A    nedit -rows 20 -wrap file1.c file2.c\n",
"\01I\n",
"is equivalent to: ",
"\n\n",
"\01A    nedit /rows=20/wrap file1.c, file2.c\",\n",
#endif /* VMS */
NULL
};

static char * htxt_server [] = {
"\01IXNEdit can be operated on its own, or as a two-part client/server ",
"application.  Client/server mode is useful for integrating XNEdit with ",
"software development environments, mailers, and other programs; or just as a ",
"quick way to open files from the shell command line without starting a new ",
"XNEdit session. ",
"\n\n",
"To run XNEdit in server mode, type: ",
"\n\n",
"\01A      xnedit -server\n",
"\01I\n",
"XNEdit can also be started in server mode via the XNEdit Client program ",
"(\01Jxnc\01I) when no servers are available. ",
"\n\n",
"The xnc program, which is distributed along with XNEdit, sends commands to ",
"an XNEdit server to open files or execute editor actions. It can also be ",
"used on files that are already opened. ",
"\n\n",
"Listing a file on the xnc command line means: Open it if it is not already ",
"open and bring the window to the front. ",
"\n\n",
"xnc supports the following command line options: ",
"\n\n",
"\01A    \01Bxnc\01A [\01B-read\01A] [\01B-create\01A]\n",
"       [\01B-line\01A n | \01B+\01An] [\01B-do\01A command] [\01B-lm\01A languagemode]\n",
"       [\01B-svrname\01A name] [\01B-svrcmd\01A command]\n",
"       [\01B-ask\01A] [\01B-noask\01A] [\01B-timeout\01A seconds]\n",
"       [\01B-geometry\01A geometry | \01B-g\01A geometry] [\01B-icon\01A | \01B-iconic\01A]\n",
"       [-\01Btabbed\01A] [-\01Buntabbed\01A] [-\01Bgroup\01A] [\01B-wait\01A]\n",
"       [\01B-V\01A | \01B-version\01A]\n",
"       [\01B-xrm\01A resourcestring] [\01B-display\01A [host]:server[.screen]]\n",
"       [\01B-\01A-] [file...]\n",
"\01I\n",
"\01A\01B-read\01A\n",
"\01IOpen the file read-only regardless of its actual permissions. There is no ",
"effect if the file is already open. ",
"\n\n",
"\01A\01B-create\01A\n",
"\01IDon't warn about file creation when a file doesn't exist. ",
"\n\n",
"\01A\01B-line\01A n, \01B+\01An\n",
"\01IGo to line number n. This will also affect files which are already open. ",
"\n\n",
"\01A\01B-do\01A command\n",
"\01IExecute an XNEdit macro or action on the file following the -do argument ",
"on the command line. ",
"\n\n",
"If you use this command without a filename, xnc would randomly choose one ",
"window to focus and execute the macro in. ",
"\n\n",
"\01A\01B-lm\01A languagemode\n",
"\01IInitial language mode used. ",
"\n\n",
"\01A\01B-svrname\01A name\n",
"\01IExplicitly instructs xnc which server to connect to, an instance of ",
"xnedit(1) with a corresponding -svrname argument.  By naming servers, you ",
"can run several simultaneously, and direct files and commands ",
"specifically to any one. ",
"\n\n",
"\01A\01B-svrcmd\01A command\n",
"\01IThe command which xnc uses to start an XNEdit server. It is also settable ",
"via the X resource `nc.serverCommand' (see \01QX Resources\01I). Defaults to ",
"\"xnedit -server\". ",
"\n\n",
"\01A\01B-ask\01A, \01B-noask\01A\n",
"\01IInstructs xnc to automatically start a server if one is not available.  This ",
"overrides the X resource `nc.autoStart' (see \01QX Resources\01I). ",
"\n\n",
"\01A\01B-timeout\01A seconds\n",
"\01IBasic time-out period used in communication with an XNEdit server.  The ",
"default is 10 seconds. Also settable via the X resource `nc.timeOut'. ",
"\n\n",
"Under rare conditions (such as a slow connection), it may be necessary to ",
"increase the time-out period. In most cases, the default is fine. ",
"\n\n",
"\01A\01B-geometry\01A geometry, \01B-g\01A geometry\n",
"\01IThe initial size and/or location of editor windows. See ",
"\01QXNEdit Command Line\01I for details. ",
"\n\n",
"\01A\01B-icon\01A, \01B-iconic\01A\n",
"\01IInitial window state. ",
"\n\n",
"\01A\01B-tabbed\01A\n",
"\01IOpen all subsequent files in new tabs. Resets -group option. ",
"\n\n",
"\01A\01B-untabbed\01A\n",
"\01IOpen all subsequent files in new windows. Resets -group option. ",
"\n\n",
"\01A\01B-group\01A\n",
"\01IOpen all subsequent files as tabs in a new window. ",
"\n\n",
"\01A\01B-wait\01A\n",
"\01IInstructs xnc not to return to the shell until all files given are closed. ",
"\n\n",
"Normally, xnc returns once the files given in its command line are opened ",
"by the server. When this option is given, xnc returns only after the last ",
"file given in this call is closed. ",
"\n\n",
"Note that this option affects all files in the command line, not only the ",
"ones following this option. ",
"\n\n",
"Note that xnc will wait for all files given in the command line, even if ",
"the files were already opened. ",
"\n\n",
"\01A\01B-version\01A, \01B-V\01A\n",
"\01IPrints xnc's version and build information. ",
"\n\n",
"\01A\01B-xrm\01A resourcestring\n",
"\01IContains the resourcestring passed to a newly started server. This option ",
"has no effect if the server is already started. ",
"\n\n",
"\01A\01B-display\01A [<host>]:<server>[.<screen>]\n",
"\01IThe name of the X server to use. See \01QXNEdit Command Line\01I for details. ",
"\n\n",
"\01SCommand Line Arguments\01I",
"\n\n",
"In typical Unix style, arguments affect the files which follow them on the ",
"command line, for example: ",
"\n\n",
"\01A      incorrect:   xnc file.c -line 25\n",
"      correct:     xnc -line 25 file.c\n",
"\01I\n",
"-read, -create, and -line affect all of the files which follow them on the ",
"command line. ",
"\n\n",
"The -do macro is executed only once, on the next file on the line.  -do ",
"without a file following it on the command line, executes the macro on the ",
"first available window (presumably when you give a -do command without a ",
"corresponding file or window, you intend it to do something independent of ",
"the window in which it happens to execute). ",
"\n\n",
"The -wait option affects all files named in the command line. ",
"\n\n",
"\01SMultiple Servers\01I",
"\n\n",
"Sometimes it is useful to have more than one XNEdit server running, for ",
"example to keep mail and programming work separate.  The option, -svrname, to ",
"both xnedit and xnc, allows you to start, and communicate with, separate named ",
"servers.  A named server responds only to requests with the corresponding ",
"-svrname argument.  If you use ClearCase and are within a ClearCase view, the ",
"server name will default to the name of the view (based on the value of the ",
"CLEARCASE_ROOT environment variable). ",
"\n\n",
"\01SCommunication\01I",
"\n\n",
"Communication between xnc and xnedit is done through the X display. So as long ",
"as the X Window System is set up and working properly, xnc will work properly ",
"as well. xnc uses the DISPLAY environment variable, the machine name and your ",
"user name to find the appropriate server, meaning, if you have several ",
"machines sharing a common file system, xnc will not be able to find a server ",
"that is running on a machine with a different host name, even though it may ",
"be perfectly appropriate for editing a given file. ",
"\n\n",
"The command which xnc uses to start an xnedit server is settable via the X ",
"resource nc.serverCommand, by default, \"xnedit -server\". ",
NULL
};

static char * htxt_recovery [] = {
"\01IIf a system crash, network failure, X server crash, or program error should ",
"happen while you are editing a file, you can still recover most of your ",
"work.  XNEdit maintains a backup file which it updates periodically (every 8 ",
"editing operations or 80 characters typed).  This file has the same name ",
"as the file that you are editing, but with the character `~' prefixed to the ",
"name.  To recover a file after a crash, simply rename the file to remove the ",
"tilde or underscore character, replacing the older version of the file. ",
"(Because several of the Unix shells consider the tilde to be a special ",
"character, you may have to prefix the character with a `\\' (backslash) when ",
"you move or delete an XNEdit backup file.) ",
"\n\n",
"Example, to recover the file called \"help.c\" on Unix type the command: ",
"\n\n",
"\01A      mv \\~help.c help.c\n",
"\01I\n",
"A minor caveat, is that if the file you were editing was in MS DOS format, ",
"the backup file will be in Unix format, and you will need to open the backup ",
"file in XNEdit and change the file format back to MS DOS via the Save As... ",
"dialog (or use the Unix unix2dos command outside of XNEdit). ",
NULL
};

static char * htxt_version [] = {
"\01A%s\n",
"\01I\n",
"XNEdit is based on NEdit 5.7 and developed by Olaf Wintermann. ",
"\n\n",
"NEdit developers: Tony Balinski, Arne Førlie, Nathaniel Gray, Eddy De ",
"Greef, Thorsten Haude, Andrew Hood, Scott Tringali, TK Soh, Mark Edel, ",
"Joy Kyriakopulos, Christopher Conrad, Jim Clark, Arnulfo Zepeda-Navratil, ",
"Suresh Ravoor, Max Vohlken, Yunliang Yu, Donna Reid, Steve Haehn, ",
"Steve LoBasso and Alexander Mai. ",
"\n\n",
"Additional NEdit patches by: Fredrik Jönsson, Per Grahn, Peter Kovář. ",
"\n\n",
"XNEdit contributions: Laszlo Ersek, Mike Becker, Peter Mühlenpfordt, ",
"Valerio Messina and Jack Zeal. ",
"\n\n",
"The regular expression matching routines used in XNEdit are adapted (with ",
"permission) from original code written by Henry Spencer at the ",
"University of Toronto. ",
"\n\n",
"The Microline widgets are inherited from the Mozilla project. ",
"\n\n",
"Syntax highlighting patterns and smart indent macros were contributed by: ",
"Simon T. MacDonald,  Maurice Leysens, Matt Majka, Alfred Smeenk, ",
"Alain Fargues, Christopher Conrad, Scott Markinson, Konrad Bernloehr, ",
"Ivan Herman, Patrice Venant, Christian Denat, Philippe Couton, ",
"Max Vohlken, Markus Schwarzenberg, Himanshu Gohel, Steven C. Kapp, ",
"Michael Turomsha, John Fieber, Chris Ross, Nathaniel Gray, Joachim Lous, ",
"Mike Duigou, Seak Teng-Fong, Joor Loohuis, Mark Jones and ",
"Niek van den Berg. ",
"\n\n",
"XNEdit sources, executables, additional documentation, and contributed ",
"software are available from the XNEdit web site at ",
"https://www.unixwork.de/xnedit/. ",
"\n\n",
"This program is free software; you can redistribute it and/or ",
"modify it under the terms of the GNU General Public License ",
"as published by the Free Software Foundation; either version 2 ",
"of the License, or (at your option) any later version. ",
"\n\n",
"In addition, as a special exception to the GNU GPL, the copyright holders ",
"give permission to link the code of this program with the Motif and Open ",
"Motif libraries (or with modified versions of these that use the same ",
"license), and distribute linked combinations including the two. You must ",
"obey the GNU General Public License in all respects for all of the code ",
"used other than linking with Motif/Open Motif. If you modify this file, ",
"you may extend this exception to your version of the file, but you are ",
"not obligated to do so. If you do not wish to do so, delete this ",
"exception statement from your version. ",
"\n\n",
"This program is distributed in the hope that it will be useful, ",
"but WITHOUT ANY WARRANTY; without even the implied warranty of ",
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the ",
"section on the \01QLicense\01I for more details. ",
NULL
};

static char * htxt_distribution [] = {
"\01INEdit License ",
"\n\n",
"GNU GENERAL PUBLIC LICENSE ",
"\n\n",
"Version 2, June 1991 ",
"\n\n",
"Copyright (C) 1989, 1991 Free Software Foundation, Inc. 675 Mass Ave, ",
"Cambridge, MA 02139, USA. Everyone is permitted to copy and distribute verbatim ",
"copies of this license document, but changing it is not allowed. ",
"\n\n",
"Preamble ",
"\n\n",
"The licenses for most software are designed to take away your freedom to share ",
"and change it. By contrast, the GNU General Public License is intended to ",
"guarantee your freedom to share and change free software--to make sure the ",
"software is free for all its users. This General Public License applies to most ",
"of the Free Software Foundation's software and to any other program whose ",
"authors commit to using it. (Some other Free Software Foundation software is ",
"covered by the GNU Library General Public License instead.) You can apply it to ",
"your programs, too. ",
"\n\n",
"When we speak of free software, we are referring to freedom, not price. Our ",
"General Public Licenses are designed to make sure that you have the freedom to ",
"distribute copies of free software (and charge for this service if you wish), ",
"that you receive source code or can get it if you want it, that you can change ",
"the software or use pieces of it in new free programs; and that you know you ",
"can do these things. ",
"\n\n",
"To protect your rights, we need to make restrictions that forbid anyone to deny ",
"you these rights or to ask you to surrender the rights. These restrictions ",
"translate to certain responsibilities for you if you distribute copies of the ",
"software, or if you modify it. ",
"\n\n",
"For example, if you distribute copies of such a program, whether gratis or for ",
"a fee, you must give the recipients all the rights that you have. You must make ",
"sure that they, too, receive or can get the source code. And you must show them ",
"these terms so they know their rights. ",
"\n\n",
"We protect your rights with two steps: (1) copyright the software, and (2) ",
"offer you this license which gives you legal permission to copy, distribute ",
"and/or modify the software. ",
"\n\n",
"Also, for each author's protection and ours, we want to make certain that ",
"everyone understands that there is no warranty for this free software. If the ",
"software is modified by someone else and passed on, we want its recipients to ",
"know that what they have is not the original, so that any problems introduced ",
"by others will not reflect on the original authors' reputations. ",
"\n\n",
"Finally, any free program is threatened constantly by software patents. We wish ",
"to avoid the danger that redistributors of a free program will individually ",
"obtain patent licenses, in effect making the program proprietary. To prevent ",
"this, we have made it clear that any patent must be licensed for everyone's ",
"free use or not licensed at all. ",
"\n\n",
"The precise terms and conditions for copying, distribution and modification ",
"follow. ",
"\n\n",
"\01A                     GNU GENERAL PUBLIC LICENSE\n",
"    TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n",
"\01I\n",
"0. This License applies to any program or other work which contains a notice ",
"placed by the copyright holder saying it may be distributed under the terms of ",
"this General Public License. The \"Program\", below, refers to any such program ",
"or work, and a \"work based on the Program\" means either the Program or any ",
"derivative work under copyright law: that is to say, a work containing the ",
"Program or a portion of it, either verbatim or with modifications and/or ",
"translated into another language. (Hereinafter, translation is included without ",
"limitation in the term \"modification\".) Each licensee is addressed as \"you\". ",
"\n\n",
"Activities other than copying, distribution and modification are not covered by ",
"this License; they are outside its scope. The act of running the Program is not ",
"restricted, and the output from the Program is covered only if its contents ",
"constitute a work based on the Program (independent of having been made by ",
"running the Program). Whether that is true depends on what the Program does. ",
"\n\n",
"1. You may copy and distribute verbatim copies of the Program's source code as ",
"you receive it, in any medium, provided that you conspicuously and ",
"appropriately publish on each copy an appropriate copyright notice and ",
"disclaimer of warranty; keep intact all the notices that refer to this License ",
"and to the absence of any warranty; and give any other recipients of the ",
"Program a copy of this License along with the Program. ",
"\n\n",
"You may charge a fee for the physical act of transferring a copy, and you may ",
"at your option offer warranty protection in exchange for a fee. ",
"\n\n",
"2. You may modify your copy or copies of the Program or any portion of it, thus ",
"forming a work based on the Program, and copy and distribute such modifications ",
"or work under the terms of Section 1 above, provided that you also meet all of ",
"these conditions: ",
"\n\n",
"a) You must cause the modified files to carry prominent notices stating that ",
"you changed the files and the date of any change. ",
"\n\n",
"b) You must cause any work that you distribute or publish, that in whole or in ",
"part contains or is derived from the Program or any part thereof, to be ",
"licensed as a whole at no charge to all third parties under the terms of this ",
"License. ",
"\n\n",
"c) If the modified program normally reads commands interactively when run, you ",
"must cause it, when started running for such interactive use in the most ",
"ordinary way, to print or display an announcement including an appropriate ",
"copyright notice and a notice that there is no warranty (or else, saying that ",
"you provide a warranty) and that users may redistribute the program under these ",
"conditions, and telling the user how to view a copy of this License. ",
"(Exception: if the Program itself is interactive but does not normally print ",
"such an announcement, your work based on the Program is not required to print ",
"an announcement.) ",
"\n\n",
"These requirements apply to the modified work as a whole. If identifiable ",
"sections of that work are not derived from the Program, and can be reasonably ",
"considered independent and separate works in themselves, then this License, and ",
"its terms, do not apply to those sections when you distribute them as separate ",
"works. But when you distribute the same sections as part of a whole which is a ",
"work based on the Program, the distribution of the whole must be on the terms ",
"of this License, whose permissions for other licensees extend to the entire ",
"whole, and thus to each and every part regardless of who wrote it. ",
"\n\n",
"Thus, it is not the intent of this section to claim rights or contest your ",
"rights to work written entirely by you; rather, the intent is to exercise the ",
"right to control the distribution of derivative or collective works based on ",
"the Program. ",
"\n\n",
"In addition, mere aggregation of another work not based on the Program with the ",
"Program (or with a work based on the Program) on a volume of a storage or ",
"distribution medium does not bring the other work under the scope of this ",
"License. ",
"\n\n",
"3. You may copy and distribute the Program (or a work based on it, under ",
"Section 2) in object code or executable form under the terms of Sections 1 and ",
"2 above provided that you also do one of the following: ",
"\n\n",
"a) Accompany it with the complete corresponding machine-readable source code, ",
"which must be distributed under the terms of Sections 1 and 2 above on a medium ",
"customarily used for software interchange; or, ",
"\n\n",
"b) Accompany it with a written offer, valid for at least three years, to give ",
"any third party, for a charge no more than your cost of physically performing ",
"source distribution, a complete machine-readable copy of the corresponding ",
"source code, to be distributed under the terms of Sections 1 and 2 above on a ",
"medium customarily used for software interchange; or, ",
"\n\n",
"c) Accompany it with the information you received as to the offer to distribute ",
"corresponding source code. (This alternative is allowed only for noncommercial ",
"distribution and only if you received the program in object code or executable ",
"form with such an offer, in accord with Subsection b above.) ",
"\n\n",
"The source code for a work means the preferred form of the work for making ",
"modifications to it. For an executable work, complete source code means all the ",
"source code for all modules it contains, plus any associated interface ",
"definition files, plus the scripts used to control compilation and installation ",
"of the executable. However, as a special exception, the source code distributed ",
"need not include anything that is normally distributed (in either source or ",
"binary form) with the major components (compiler, kernel, and so on) of the ",
"operating system on which the executable runs, unless that component itself ",
"accompanies the executable. ",
"\n\n",
"If distribution of executable or object code is made by offering access to copy ",
"from a designated place, then offering equivalent access to copy the source ",
"code from the same place counts as distribution of the source code, even though ",
"third parties are not compelled to copy the source along with the object code. ",
"\n\n",
"4. You may not copy, modify, sublicense, or distribute the Program except as ",
"expressly provided under this License. Any attempt otherwise to copy, modify, ",
"sublicense or distribute the Program is void, and will automatically terminate ",
"your rights under this License. However, parties who have received copies, or ",
"rights, from you under this License will not have their licenses terminated so ",
"long as such parties remain in full compliance. ",
"\n\n",
"5. You are not required to accept this License, since you have not signed it. ",
"However, nothing else grants you permission to modify or distribute the Program ",
"or its derivative works. These actions are prohibited by law if you do not ",
"accept this License. Therefore, by modifying or distributing the Program (or ",
"any work based on the Program), you indicate your acceptance of this License to ",
"do so, and all its terms and conditions for copying, distributing or modifying ",
"the Program or works based on it. ",
"\n\n",
"6. Each time you redistribute the Program (or any work based on the Program), ",
"the recipient automatically receives a license from the original licensor to ",
"copy, distribute or modify the Program subject to these terms and conditions. ",
"You may not impose any further restrictions on the recipients' exercise of the ",
"rights granted herein. You are not responsible for enforcing compliance by ",
"third parties to this License. ",
"\n\n",
"7. If, as a consequence of a court judgment or allegation of patent ",
"infringement or for any other reason (not limited to patent issues), conditions ",
"are imposed on you (whether by court order, agreement or otherwise) that ",
"contradict the conditions of this License, they do not excuse you from the ",
"conditions of this License. If you cannot distribute so as to satisfy ",
"simultaneously your obligations under this License and any other pertinent ",
"obligations, then as a consequence you may not distribute the Program at all. ",
"For example, if a patent license would not permit royalty-free redistribution ",
"of the Program by all those who receive copies directly or indirectly through ",
"you, then the only way you could satisfy both it and this License would be to ",
"refrain entirely from distribution of the Program. ",
"\n\n",
"If any portion of this section is held invalid or unenforceable under any ",
"particular circumstance, the balance of the section is intended to apply and ",
"the section as a whole is intended to apply in other circumstances. ",
"\n\n",
"It is not the purpose of this section to induce you to infringe any patents or ",
"other property right claims or to contest validity of any such claims; this ",
"section has the sole purpose of protecting the integrity of the free software ",
"distribution system, which is implemented by public license practices. Many ",
"people have made generous contributions to the wide range of software ",
"distributed through that system in reliance on consistent application of that ",
"system; it is up to the author/donor to decide if he or she is willing to ",
"distribute software through any other system and a licensee cannot impose that ",
"choice. ",
"\n\n",
"This section is intended to make thoroughly clear what is believed to be a ",
"consequence of the rest of this License. ",
"\n\n",
"8. If the distribution and/or use of the Program is restricted in certain ",
"countries either by patents or by copyrighted interfaces, the original ",
"copyright holder who places the Program under this License may add an explicit ",
"geographical distribution limitation excluding those countries, so that ",
"distribution is permitted only in or among countries not thus excluded. In such ",
"case, this License incorporates the limitation as if written in the body of ",
"this License. ",
"\n\n",
"9. The Free Software Foundation may publish revised and/or new versions of the ",
"General Public License from time to time. Such new versions will be similar in ",
"spirit to the present version, but may differ in detail to address new problems ",
"or concerns. ",
"\n\n",
"Each version is given a distinguishing version number. If the Program specifies ",
"a version number of this License which applies to it and \"any later version\", ",
"you have the option of following the terms and conditions either of that ",
"version or of any later version published by the Free Software Foundation. If ",
"the Program does not specify a version number of this License, you may choose ",
"any version ever published by the Free Software Foundation. ",
"\n\n",
"10. If you wish to incorporate parts of the Program into other free programs ",
"whose distribution conditions are different, write to the author to ask for ",
"permission. For software which is copyrighted by the Free Software Foundation, ",
"write to the Free Software Foundation; we sometimes make exceptions for this. ",
"Our decision will be guided by the two goals of preserving the free status of ",
"all derivatives of our free software and of promoting the sharing and reuse of ",
"software generally. ",
"\n\n",
"\01A                                   NO WARRANTY\n",
"\01I\n",
"11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR ",
"THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE ",
"STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE ",
"PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, ",
"INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND ",
"FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND ",
"PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE, ",
"YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. ",
"\n\n",
"12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL ",
"ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE ",
"THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY ",
"GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE ",
"OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR ",
"DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR ",
"A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH ",
"HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. ",
"\n\n",
"\01A                          END OF TERMS AND CONDITIONS\n",
"\01I\n",
"Addition ",
"\n\n",
"In addition, as a special exception to the GNU GPL, the copyright holders give ",
"permission to link the code of this program with the Motif and Open Motif ",
"libraries (or with modified versions of these that use the same license), and ",
"distribute linked combinations including the two. You must obey the GNU General ",
"Public License in all respects for all of the code used other than linking with ",
"Motif/Open Motif. If you modify this file, you may extend this exception to your ",
"version of the file, but you are not obligated to do so. If you do not wish to ",
"do so, delete this exception statement from your version. ",
"\n\n",
"Additional XNEdit LICENSE ",
"\n\n",
"Copyright 2019 Olaf Wintermann ",
"\n\n",
"Permission is hereby granted, free of charge, to any person obtaining a copy ",
"of this software and associated documentation files (the \"Software\"), to deal ",
"in the Software without restriction, including without limitation the rights ",
"to use, copy, modify, merge, publish, distribute, sublicense, and/or sell ",
"copies of the Software, and to permit persons to whom the Software is ",
"furnished to do so, subject to the following conditions: ",
"\n\n",
"The above copyright notice and this permission notice shall be included in all ",
"copies or substantial portions of the Software. ",
"\n\n",
"THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR ",
"IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, ",
"FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE ",
"AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER ",
"LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, ",
"OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE ",
"SOFTWARE. ",
"\n\n",
"OCaml Syntax Highlighting ",
"\n\n",
"Copyright (C) 2021, Red Hat, Inc. ",
"GPL-2.0-only ",
"\n\n",
"EditorConfig glob matching ",
"\n\n",
"Copyright 2024 Mike Becker - All rights reserved. ",
"\n\n",
"Redistribution and use in source and binary forms, with or without ",
"modification, are permitted provided that the following conditions are met: ",
"\n\n",
"1. Redistributions of source code must retain the above copyright ",
"notice, this list of conditions and the following disclaimer. ",
"\n\n",
"2. Redistributions in binary form must reproduce the above copyright ",
"notice, this list of conditions and the following disclaimer in the ",
"documentation and/or other materials provided with the distribution. ",
"\n\n",
"THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" ",
"AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE ",
"IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ",
"ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE ",
"LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR ",
"CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF ",
"SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS ",
"INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN ",
"CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ",
"ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE ",
"POSSIBILITY OF SUCH DAMAGE. ",
"\n\n",
NULL
};

static char * htxt_support [] = {
"\01IFor questions or general discussions, please refer to the forum at SourceForge: ",
"\n\n",
"\01A      https://sourceforge.net/p/xnedit/discussion/general/\n",
"\01I\n",
"Bug reports and feature requests can be done at at GitHub or SourceForge. ",
"\n\n",
"\01A      https://github.com/unixwork/xnedit/issues\n",
"\01I\n",
"\01A      https://sourceforge.net/projects/xnedit/\n",
"\01I\n",
NULL
};

static char * htxt_defects [] = {
"\01RSolutions to Common Problems\01I",
"\n\n",
"For a much more comprehensive list of common problems and solutions, see the ",
"XNEdit FAQ.  The latest version of the FAQ can always be found on the XNEdit ",
"web site at: ",
"\n\n",
"\01A      https://www.unixwork.de/xnedit/.\n",
"\01I\n",
"\01JP: No files are shown in the \"Files\" list in the Open... dialog.\01I ",
"\n\n",
"S: When you use the \"Filter\" field, include the file specification or a ",
"complete directory specification, including the trailing \"/\" on Unix. ",
"(See Help in the Open... dialog). ",
"\n\n",
"\01JP: Find Again and Replace Again don't continue in the same direction as the original Find or Replace.\01I ",
"\n\n",
"S: Find Again and Replace Again don't use the direction of the original ",
"search.  The Shift key controls the direction: Ctrl+G means forward, ",
"Shift+Ctrl+G means backward. ",
"\n\n",
"\01JP: Preferences specified in the Preferences menu don't seem to get saved when I select Save Defaults.\01I ",
"\n\n",
"S: XNEdit has two kinds of preferences: 1) per-window preferences, in the ",
"Preferences menu, and 2) default settings for preferences in newly created ",
"windows, in the Default Settings sub-menu of the Preferences menu. ",
"Per-window preferences are not saved by Save Defaults, only Default ",
"Settings. ",
"\n\n",
"\01JP: Columns and indentation don't line up.\01I ",
"\n\n",
"S: XNEdit is using a proportional width font.  Set the font to a fixed style ",
"(see Preferences menu). ",
"\n\n",
"\01JP: XNEdit performs poorly on very large files.\01I ",
"\n\n",
"S: Turn off Incremental Backup.  With Incremental Backup on, XNEdit ",
"periodically writes a full copy of the file to disk. ",
"\n\n",
"\01JP: Commands added to the Shell Commands menu (Unix only) don't output anything until they are finished executing.\01I ",
"\n\n",
"S: If the command output is directed to a dialog, or the input is from a ",
"selection, output is collected together and held until the command ",
"completes.  De-select both of the options and the output will be shown ",
"incrementally as the command executes. ",
"\n\n",
"\01JP: Dialogs don't automatically get keyboard focus when they pop up.\01I ",
"\n\n",
"S: Most X Window managers allow you to choose between two categories of ",
"keyboard focus models: pointer focus, and explicit focus.  Pointer focus ",
"means that as you move the mouse around the screen, the window under the ",
"mouse automatically gets the keyboard focus.  XNEdit users who use this ",
"focus model should set \"Popups Under Pointer\" in the Default Settings sub ",
"menu of the preferences menu in XNEdit.  Users with the explicit focus ",
"model, in some cases, may have problems with certain dialogs, such as Find ",
"and Replace.  In MWM this is caused by the mwm resource startupKeyFocus ",
"being set to False (generally a bad choice for explicit focus users). ",
"NCDwm users should use the focus model \"click\" instead of \"explicit\", ",
"again, unless you have set it that way to correct specific problems, this ",
"is the appropriate setting for most explicit focus users. ",
"\n\n",
"\01JP: The Backspace key doesn't work, or deletes forward rather than backward.\01I ",
"\n\n",
"S: While this is an X/Motif binding problem, and should be solved outside of ",
"XNEdit in the Motif virtual binding layer (or possibly xmodmap or ",
"translations), XNEdit provides an out.  If you set the resource: ",
"nedit.remapDeleteKey to True, XNEdit will forcibly map the delete key to ",
"backspace.  The default setting of this resource recently changed, so ",
"users who have been depending on this remapping will now have to set it ",
"explicitly (or fix their bindings). ",
"\n\n",
"\01JP: XNEdit crashes when I try to paste text in to a text field in a dialog (like Find or Replace) on my SunOS system.\01I ",
"\n\n",
"S: On many SunOS systems, you have to set up an nls directory before various ",
"inter-client communication features of Motif will function properly. ",
"There are instructions in README.sun in /pub/v5_0_2/individual/README.sun on ",
"ftp.nedit.org, as well as a tar file containing a complete nls ",
"directory: ftp://ftp.nedit.org/pub/v5_0_2/nls.tar. ",
"README.sun contains directions for setting up an nls directory, which ",
"is required by Motif for handling copy and paste to Motif text fields. ",
"\n\n",
"\01RKnown Defects\01I",
"\n\n",
"Below is the list of known defects which affect XNEdit. The defects your copy ",
"of XNEdit will exhibit depend on which system you are running and with which ",
"Motif libraries it was built. Note that there are now Motif 1.2 and/or 2.0 ",
"libraries available on ALL supported platforms, and as you can see below ",
"there are far fewer defects in Motif 1.2, so it is in your best interest to ",
"upgrade your system. ",
"\n\n",
"\01SAll Versions\01I",
"\n\n",
"\01A\01BDEFECT\01A\n",
"\01IOperations between rectangular selections on overlapping lines do nothing. ",
"\n\n",
"\01A\01CWork Around\01A\n",
"\01INone.  These operations are very complicated and rarely used. ",
"\n\n",
"\01A\01BDEFECT\01A\n",
"\01ICut and Paste menu items fail, or possibly crash, ",
"for very large (multi-megabyte) selections. ",
"\n\n",
"\01A\01CWork Around\01A\n",
"\01IUse selection copy (middle mouse button click) ",
"for transferring larger quantities of data. ",
"Cut and Paste save the copied text in server ",
"memory, which is usually limited. ",
"\n\n",
"\01RReporting Defects\01I",
"\n\n",
"Submit bugs through the web at: ",
"\n\n",
"\01A    https://sourceforge.net/p/xnedit/_list/tickets\n",
"\01I\n",
"\01A    https://github.com/unixwork/xnedit/issues\n",
"\01I\n",
"Please include the first few lines from Help > Version, which identifies ",
"XNEdit's version and other system attributes important for diagnosing your ",
"problem. ",
NULL
};

static char * htxt_tabs_dialog [] = {
"\01IThe Tabs dialog controls both the operation of the Tab key, and ",
"the interpretation of tab characters within a file. ",
"\n\n",
"The first field, Tab Spacing, controls how  XNEdit responds to ",
"tab characters in a file.  On most Unix systems the ",
"conventional interpretation of a tab character is to advance the ",
"text position to the nearest multiple of eight characters (a tab ",
"spacing of 8).  However, many programmers of C and other ",
"structured languages, when given the choice, prefer a tab ",
"spacing of 3 or 4 characters.  Setting a three or four character ",
"hardware tab spacing is useful and convenient as long as your ",
"other software tools support it.  Unfortunately, on Unix ",
"systems, system utilities, such as more, and printing software ",
"can't always properly display files with other than eight ",
"character tabs. ",
"\n\n",
"Selecting \"Emulate Tabs\" will cause the Tab key to insert the ",
"correct number of spaces or tabs to reach the next tab stop, as ",
"if the tab spacing were set at the value in the \"Emulated tab ",
"spacing\" field.  Backspacing immediately after entering an ",
"emulated tab will delete it as a unit, but as soon as you move ",
"the cursor away from the spot, XNEdit will forget that the ",
"collection of spaces and tabs is a tab, and will treat it as ",
"separate characters.  To enter a real tab character with ",
"\"Emulate Tabs\" turned on, use Ctrl+Tab. ",
"\n\n",
"In generating emulated tabs, and in Shift Left, Paste Column, ",
"and some rectangular selection operations, XNEdit inserts blank ",
"characters (spaces or tabs) to preserve the alignment of ",
"non-blank characters. The bottom toggle button in the Tabs ",
"dialog instructs XNEdit whether to insert tab characters as ",
"padding in such situations. Turning this off, will keep XNEdit ",
"from automatically inserting tabs. Some software developers ",
"prefer to keep their source code free of tabs to avoid its ",
"misinterpretation on systems with different tab character ",
"conventions. ",
NULL
};

static char * htxt_custom_title_dialog [] = {
"\01IThe Customize Window Title dialog allows you to customize ",
"and test the way information will be displayed in each window's ",
"title field. ",
"\n\n",
"\01JDefinition of the title\01I ",
"\n\n",
"The upper half of the dialog can be used to select the various ",
"components that should be displayed in the title. The layout can be ",
"fine-tuned by editing the printf() like format string below the ",
"component buttons: additional characters can be entered, or the ",
"order can be changed. ",
"\n\n",
"The following sequences are interpreted in the format string: ",
"\n\n",
"\01A   %c    ClearCase view tag (only relevant when XNEdit is\n",
"         used together with ClearCase)\n",
"   %[n]d directory, with one optional numeric digit n\n",
"         specifying the maximum number of trailing directory\n",
"         components to display. Skipped components are\n",
"         replaced by an ellipsis (...).\n",
"   %f    file name, without the path name\n",
"   %h    host name\n",
"   %s    XNEdit server name (server mode only)\n",
"   %[*]S file status, either verbose (%S) or brief (%*S).\n",
"         In verbose mode the file status is spelled out:\n",
"         read-only, locked, and modified. In brief mode,\n",
"         abbreviations and an asterisk are used for the\n",
"         respective states: RO, LO, *.\n",
"   %u    user name\n",
"\01I\n",
"The format string and the component buttons are continously synchronized. ",
"\n\n",
"The default format is: ",
"\n\n",
"\01A    {%c} [%s] %f (%S) - %d\n",
"\01I\n",
"The resulting title will only contain elements with ",
"a value. Hence, the title is compressed as follows: ",
"\n\n",
"\01A   * Elements with no value are removed.\n",
"   * Empty parenthesis pairs i.e. (), [] or {}, or parenthesis pairs containing only space(s), are removed.\n",
"   * Sequences of spaces are replaced with one space.\n",
"   * Leading spaces and dashes are removed.\n",
"   * Trailing spaces and dashes are removed.\n",
"\01IIf the server name and the ClearCase view tag are identical, only ",
"the first one specified in the format string will be displayed. ",
"\n\n",
"\01JPreviewing the settings\01I ",
"\n\n",
"The lower part of the dialog can be used to test the selected title ",
"under various conditions. For some of the components that are selected ",
"for display, various states can be enforced on the preview. ",
"\n\n",
"For instance, components that are not always active (such the ",
"XNEdit server name) can be turned on or off in the preview. ",
NULL
};

static char **HelpText[] = {
    htxt_start,
    htxt_select,
    htxt_search,
    htxt_clipboard,
    htxt_mouse,
    htxt_keyboard,
    htxt_multicursor,
    htxt_fill,
    htxt_interface,
    htxt_format,
    htxt_programmer,
    htxt_tabs,
    htxt_indent,
    htxt_syntax,
    htxt_tags,
    htxt_calltips,
    htxt_basicSyntax,
    htxt_escapeSequences,
    htxt_parenConstructs,
    htxt_advancedTopics,
    htxt_examples,
    htxt_shell,
    htxt_filters,
    htxt_learn,
    htxt_macro_lang,
    htxt_macro_subrs,
    htxt_rangeset,
    htxt_hiliteInfo,
    htxt_actions,
    htxt_customize,
    htxt_preferences,
    htxt_resources,
    htxt_binding,
    htxt_patterns,
    htxt_smart_indent,
    htxt_command_line,
    htxt_server,
    htxt_recovery,
    htxt_version,
    htxt_distribution,
    htxt_support,
    htxt_defects,
    htxt_tabs_dialog,
    htxt_custom_title_dialog
};

HelpMenu H_M [] =
{
    { &H_M[ 1], 1, HELP_START,               "start",               0, 'G', NULL },
    { &H_M[ 2], 1, HELP_none,                "basicOp",             0, 'B', "Basic Operation" },
    { &H_M[ 3], 2, HELP_SELECT,              "select",              0, 'S', NULL },
    { &H_M[ 4], 2, HELP_SEARCH,              "search",              0, 'F', NULL },
    { &H_M[ 5], 2, HELP_CLIPBOARD,           "clipboard",           0, 'C', NULL },
    { &H_M[ 6], 2, HELP_MOUSE,               "mouse",               0, 'U', NULL },
    { &H_M[ 7], 2, HELP_KEYBOARD,            "keyboard",            0, 'K', NULL },
    { &H_M[ 8], 2, HELP_MULTICURSOR,         "multicursor",         0, 'M', NULL },
    { &H_M[ 9], 2, HELP_FILL,                "fill",                0, 'h', NULL },
    { &H_M[10], 2, HELP_INTERFACE,           "interface",           0, 'T', NULL },
    { &H_M[11], 2, HELP_FORMAT,              "format",              0, 'i', NULL },
    { &H_M[12], 1, HELP_none,                "features",            0, 'F', "Features for Programming" },
    { &H_M[13], 2, HELP_PROGRAMMER,          "programmer",          0, 'P', NULL },
    { &H_M[14], 2, HELP_TABS,                "tabs",                0, 'T', NULL },
    { &H_M[15], 2, HELP_INDENT,              "indent",              0, 'A', NULL },
    { &H_M[16], 2, HELP_SYNTAX,              "syntax",              0, 'S', NULL },
    { &H_M[17], 2, HELP_TAGS,                "tags",                0, 'F', NULL },
    { &H_M[18], 2, HELP_CALLTIPS,            "calltips",            0, 'C', NULL },
    { &H_M[19], 1, HELP_none,                "regex",               0, 'R', "Regular Expressions" },
    { &H_M[20], 2, HELP_BASICSYNTAX,         "basicSyntax",         0, 'B', NULL },
    { &H_M[21], 2, HELP_ESCAPESEQUENCES,     "escapeSequences",     0, 'M', NULL },
    { &H_M[22], 2, HELP_PARENCONSTRUCTS,     "parenConstructs",     0, 'P', NULL },
    { &H_M[23], 2, HELP_ADVANCEDTOPICS,      "advancedTopics",      0, 'A', NULL },
    { &H_M[24], 2, HELP_EXAMPLES,            "examples",            0, 'E', NULL },
    { &H_M[25], 1, HELP_none,                "extensions",          0, 'M', "Macro/Shell Extensions" },
    { &H_M[26], 2, HELP_SHELL,               "shell",               1, 'S', NULL },
    { &H_M[27], 2, HELP_FILTERS,             "filters",             0, 'I', NULL },
    { &H_M[28], 2, HELP_LEARN,               "learn",               0, 'L', NULL },
    { &H_M[29], 2, HELP_MACRO_LANG,          "macro_lang",          0, 'M', NULL },
    { &H_M[30], 2, HELP_MACRO_SUBRS,         "macro_subrs",         0, 'a', NULL },
    { &H_M[31], 2, HELP_RANGESET,            "rangeset",            0, 'R', NULL },
    { &H_M[32], 2, HELP_HILITEINFO,          "hiliteInfo",          0, 'H', NULL },
    { &H_M[33], 2, HELP_ACTIONS,             "actions",             0, 'A', NULL },
    { &H_M[34], 1, HELP_none,                "customizing",         0, 'C', "Customizing" },
    { &H_M[35], 2, HELP_CUSTOMIZE,           "customize",           0, 'C', NULL },
    { &H_M[36], 2, HELP_PREFERENCES,         "preferences",         0, 'P', NULL },
    { &H_M[37], 2, HELP_RESOURCES,           "resources",           0, 'X', NULL },
    { &H_M[38], 2, HELP_BINDING,             "binding",             0, 'K', NULL },
    { &H_M[39], 2, HELP_PATTERNS,            "patterns",            0, 'H', NULL },
    { &H_M[40], 2, HELP_SMART_INDENT,        "smart_indent",        0, 'S', NULL },
    { &H_M[41], 1, HELP_COMMAND_LINE,        "command_line",        0, 'X', NULL },
    { &H_M[42], 1, HELP_SERVER,              "server",              0, 'C', NULL },
    { &H_M[43], 1, HELP_RECOVERY,            "recovery",            0, 'a', NULL },
    { &H_M[44], 1, HELP_none,                "separator1",          0, '-', NULL },
    { &H_M[45], 1, HELP_VERSION,             "version",             0, 'V', NULL },
    { &H_M[46], 1, HELP_DISTRIBUTION,        "distribution",        0, 'L', NULL },
    { &H_M[47], 1, HELP_SUPPORT,             "support",             0, 'S', NULL },
    { &H_M[48], 1, HELP_DEFECTS,             "defects",             0, 'P', NULL },
    { &H_M[49], 1, HELP_TABS_DIALOG,         "tabs_dialog",         9, 'T', NULL },
    { NULL,     1, HELP_CUSTOM_TITLE_DIALOG, "custom_title_dialog", 9, 'C', NULL }
};

Href H_R [] =
{
    {&H_R[ 1],    55, HELP_TAGS,          "ctags support"},
    {&H_R[ 2],  5904, HELP_BASICSYNTAX,   "Alternation"},
    {NULL,     14768, HELP_PREFERENCES,   "Autoload Files"}
};

static const char * NEditVersion = "XNEdit 1.6.2\nFeb 7, 2025\n";
#define XNEDIT_IS_RELEASE
