/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern char objects[BWIDTH][BHEIGHT];
extern Display *display;
extern Window win;
extern GC gc;
extern Pixmap worms[7];

bodyPart::bodyPart(char letter1, int x1, int y1, bodyPart *next1) {
  next = next1;
  x = x1;
  y = y1;
  letter = letter1;
}

bodyPart::~bodyPart() {
}

void bodyPart::remove() {
  bodyPart *temp;

  temp = this;
  while (temp->next->next != NULL) {
    temp = temp->next;
  }
  temp->next->erase();
  delete temp->next;
  temp->next = NULL;
} 

void bodyPart::erase() {
  XClearArea(display, win, x * 10, y * 10, 10, 10, False);
  objects[x][y] = 'a';
}

void bodyPart::draw(Pixmap* image) {
  objects[x][y] = letter;
  XCopyArea(display, *image, win, gc, 0, 0, 10, 10, x * 10, y * 10);
}

void bodyPart::setxy(int x1, int y1) {
  x = x1;
  y = y1;
}

int bodyPart::getX() {
  return x;
}

int bodyPart::getY() {
  return y;
}

void bodyPart::setX(int xx) {
  x = xx;
}

void bodyPart::setY(int yy) {
  y = yy;
}

bodyPart* bodyPart::getNext() {
  return next;
}

void bodyPart::setNext(bodyPart *next1) {
  next = next1;
}

void bodyPart::setLetter(char temp) {
  letter = temp;
}
