#include "common.h"

extern Pixmap deadWormXpm;

deadWorm::deadWorm(bodyPart *newWorm) {
  bodyPart *temp;

  next = NULL;
  worm = newWorm;
  temp = worm;
  while (temp != NULL) {
    temp->setLetter('x');
    temp = temp->getNext();
  }
}

deadWorm::~deadWorm() {
  bodyPart *temp;

  temp = worm;
  while (temp != NULL) {
    temp = worm->getNext();
    delete worm;
    worm = temp;
  }
  if (next != NULL)
    delete next;
}

void deadWorm::draw() {
  bodyPart *temp;

  temp = worm;
  while (temp != NULL) {
    temp->draw(&deadWormXpm);
    temp = temp->getNext();
  }
  if (next != NULL)
    next->draw();
}

void deadWorm::eraseAll() {
  bodyPart *temp;

  temp = worm;
  while (temp != NULL) {
    temp->erase();
    temp = temp->getNext();
  }
  if (next != NULL)
    next->eraseAll();
}

void deadWorm::addDeadWorm(bodyPart *newWorm) {
  if (next != NULL)
    next->addDeadWorm(newWorm);
  else
    next = new deadWorm(newWorm);
}
