#include "common.h"
#include <linux/joystick.h>

extern int quiet;
extern int joystick;
extern people *thePlayers;
extern int keys[4][2];
extern int joystickWhich;

char *jfile[] = { JOYSTICK0DEV, JOYSTICK1DEV };
int joyfd[JOYSTICKS];

void initJoystick () {
  struct JS_DATA_TYPE js;
  int i;

  if (!joystick)
    return;

  for (i = 0; i < joystick; i++) {
    joyfd[i] = open(jfile[i], O_RDONLY);
    if (joyfd[i] < 0 || read(joyfd[i], &js, JS_RETURN) != JS_RETURN) {
      if (!quiet)
        fprintf(stderr, "Joystick %d init failed.\n", i);
      joystick &= ~(i+1);
    } else
    if (!quiet)
      fprintf(stderr, "Joystick %d initialized...\n", i);
  }
}

void checkJoystick () {
  struct JS_DATA_TYPE js;
  int i;

  if (!joystick)
    return;

  for (i = 0; i < joystick; i ++) {
    if (! (joystick & (i+1)))
      continue;

    if (read (joyfd[i], &js, JS_RETURN) != JS_RETURN) {
      perror ("xnibbles/joystick");
      joystick = 0;
      return;
    }

    if (js.x < JOYSTICK_THRESHOLD)
      thePlayers->changeDir (keys[LEFT][i+joystickWhich]);
    if (js.y < JOYSTICK_THRESHOLD)
      thePlayers->changeDir (keys[UP][i+joystickWhich]);
    if (js.x > JOYSTICK_MAX - JOYSTICK_THRESHOLD)
      thePlayers->changeDir (keys[RIGHT][i+joystickWhich]);
    if (js.y > JOYSTICK_MAX - JOYSTICK_THRESHOLD)
      thePlayers->changeDir (keys[DOWN][i+joystickWhich]);
    if (js.buttons & 1)
      thePlayers->changeDir (keys[4][i+joystickWhich]);
  }
}
