/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern int drops;

timer::timer() {
  length = 10000L;
  gettimeofday(&current, NULL);
}

timer::timer(long usecs) {
  length = usecs;
  gettimeofday(&current, NULL);
}

void timer::set(long usecs) {
  length = usecs;
}

int timer::elapsed() {
  struct timeval temp;
  int foo;
  
  gettimeofday(&temp, NULL);
  foo= temp.tv_usec - current.tv_usec + 1000000 * (temp.tv_sec - current.tv_sec);
  if (foo > length) {
    drops++;
    current = temp;
    return 0;
  }
  else {
    temp.tv_usec += length - foo;
    current = temp;
    return length - foo;
  }
}

int timer::getTime() {
  return (int)current.tv_usec;
}
