/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern Display *display;
extern char objects[BWIDTH][BHEIGHT];
#ifdef __SOUND__
extern Sound snds[SOUNDS];
extern int sound;
#endif
extern Window win;
extern boni *theBoni;
extern int warpx;
extern int warpy;
extern int level;
extern int stayOnLevel;
extern int channel;
extern int classic;
extern int meltDelay;
extern int fps;
extern int lifeDone;
extern int stayOnLevel;
extern char* colors[];
extern XpmAttributes myXpmAttributes;
extern void error(int errorCode);
extern people* thePlayers;
extern walls* allWalls;
extern deadWorm* theDeadWorms;

worm::worm(int aup, int adown, int aleft, int aright, int acut, char *aName, int x1, int y1, int which, int playerNum1) {

  playerNum = playerNum1;
  lives = 4;
  score = 0;
  dscore = 0;
  numCuts = 0;
  strcpy (worm_xpm[2],colors[6*which]);
  strcpy (worm_xpm[3],colors[6*which+1]);
  strcpy (worm_xpm[4],colors[6*which+2]);
  strcpy (worm_xpm[5],colors[6*which+3]);
  strcpy (worm_xpm[6],colors[6*which+4]);
  makePixmap (worm_xpm, &wormImage);
  meltCount = MELTSIZE;
  meltFlag = meltDelay;
  myBar = new statusBar(aName, x1, y1, which);
  head = NULL;
  spareHead = head;
  warpx = warpy = 1;
  length = 1;
  growing = 5;
  up = aup;
  down = adown;
  left = aleft;
  right = aright;
  cut = acut;
  flashCount = FLASHCOUNT;
  flashDelay = fps / 8;
}

void worm::newLevel(int x1, int y1, int dx1, int dy1) {
  bodyPart *end;

  if (head != NULL) {
    while (head->getNext() != NULL) {
      end = head;
      while (end->getNext()->getNext() != NULL)
        end = end->getNext();
      delete end->getNext();
      end->setNext(NULL);
    }
  }
  delete head;
  dx = dx1;
  dy = dy1;
  growing = 5;
  already = 0;
  length = 1;
  head = new bodyPart('w', x1, y1, NULL);
  spareHead = head;
}

worm::~worm() {
  bodyPart *end;

  while (head->getNext() != NULL) {
    end = head;
    while (end->getNext()->getNext() != NULL)
      end = end->getNext();
    delete end->getNext();
    end->setNext(NULL);
  }
  XFreePixmap(display, wormImage);
  delete head;
  delete myBar;
}

void worm::showStatusMaybe() {
  int i;
  if (dscore < 0) {
    i = (int)log10(-1.0 * dscore);
    i -= 1;
    if (i<1)
      i = 0;
    i = (int)pow(10.0,(float)i);
    score -= i;
    dscore += i;
    myBar->update(lives, score, 2, numCuts);
  } else if (dscore > 0) {
    i = (int)log10((float)dscore);
    i -= 1;
    if (i<1)
      i = 0;
    i = (int)pow(10.0,(float)i);
    score += i;
    dscore -= i;
    myBar->update(lives, score, 2, numCuts);
  }
}

void worm::showStatus(int which) {
  myBar->update(lives, score, which, numCuts);
}

void worm::moveTail() {
  if (growing < 0) {
    length -= 2;
    head->remove();
    head->remove();
    growing++;
  }
  else if (!growing) {
    length--;
    head->remove();
  }
  else {
    growing--;
  }
}

int worm::move() {
  bodyPart *newHead;

  newHead = new bodyPart('w', head->getX() + dx, head->getY() + dy, head);
  length++;
  head = newHead;
  if (!hit()) {
    newHead->draw(&wormImage);
    already = 0;
    return 0;
  }
  if (objects[head->getX()][head->getY()] == 'w')
    return 1;
  head = newHead->getNext();
  delete newHead;
  return 1;
}

int worm::addPartMove() {
  bodyPart *newPart;

  newPart = new bodyPart('w', head->getX() + dx, head->getY() + dy, head);
  head = newPart;
  spareHead = head;
  if (!hit()) {
    newPart->draw(&wormImage);
    already = 0;
    return 0;
  }
  head = newPart->getNext();
  spareHead = head;
  delete newPart;
  return 1;
}

void worm::drawAll() {
  bodyPart *temp;

  temp = head;
  if (temp->getNext() != NULL)
    while (temp != NULL) {
      temp->draw(&wormImage);
      temp = temp->getNext();
    }
}

void worm::eraseAll() {
  bodyPart *temp;

  temp = head;
  growing = 0;
  while (temp != NULL) {
    temp->erase();
    temp = temp->getNext();
  }
}

/*
int worm::melt() {
  bodyPart *temp;

  temp = spareHead;
  growing = 0;
  temp->erase();
  spareHead = temp->getNext();
  if (spareHead == NULL) return 0; else return 1;
}
*/

int worm::melt() {
  bodyPart *temp;
  int count = meltCount;

  if (!meltFlag) {
    temp = head;
    while (temp != NULL) {
      if (count == (MELTSIZE-1))
        temp->erase();
      count = (count + 1) % MELTSIZE;
      temp = temp->getNext();
    }
    meltFlag = meltDelay;
    meltCount--;
    if (!meltCount) {
      meltCount = MELTSIZE;
      meltFlag = meltDelay;
      return 0;
    } else return 1;
  } else {
    meltFlag--;
    return 1;
  }
}

int worm::changeDir(int key) {
  if (already) {
    return 0;
  }
  if ((key == cut) && numCuts) {
    cutInHalfAndLeave();
    myBar->update(lives, score, 2, numCuts);
    numCuts--;
  }
  if ((key == up) && !dy) {
    dx = 0;
    dy = -1;
    already = 1;
  }
  if ((key == down) && !dy) {
    dx = 0;
    dy = 1;
    already = 1;
  }
  if ((key == left) && !dx) {
    dx = -1;
    dy = 0;
    already = 1;
  }
  if ((key == right) && !dx) {
    dx = 1;
    dy = 0;
    already = 1;
  }
  return 1;
}

int worm::hit() {
  int x, y;
  int xx, yy;
  int adjust;

  x = head->getX();
  y = head->getY();
  if (x < 0) {
    head->setX(x+BWIDTH);
    if (objects[x+BWIDTH][y]>'a' && objects[x+BWIDTH][y]<'z')
      return 1;
    else
      return 0;
  }
  if (x == BWIDTH) {
    head->setX(0);
    if (objects[0][y]>'a' && objects[x+BWIDTH][y]<'z')
      return 1;
    else
      return 0;
  }
  if (y < 0) {
    head->setY(y+BHEIGHT);
    if (objects[x][y+BHEIGHT]>'a' && objects[x+BWIDTH][y]<'z')
      return 1;
    else
      return 0;
  }
  if (y == BHEIGHT) {
    head->setY(0);
    if (objects[x][0]>'a' && objects[x+BWIDTH][y]<'z')
      return 1;
    else
      return 0;
  }
  if (objects[x][y] > 'a' && objects[x][y] < 'z') {
    lives--;
    dscore = (int)((float)score * 0.85) - score;
    return 1;
  }
  if (objects[x][y] >= 'A' && objects[x][y] <= 'J') {
    if (objects[x][y] == 'A') {
#ifdef __SOUND__
      if (sound) {
        SoundPlay(3, (channel++)%NUMCHANNELS);
      }
#endif
      theBoni->removeBonus(x, y);
      if (theBoni->getNumAs() < 10 || stayOnLevel) {
        theBoni->addBonus('A', 0);
        if (!(rand() % 10) && !classic)
          theBoni->addBonus('H', 0);
        if (stayOnLevel)
          adjust = stayOnLevel - 1;
        else
          adjust = 0;
        dscore += theBoni->getNumAs() * (level-adjust);
        myBar->update(lives, score, 2, numCuts);
        growing += (int)pow(1.6, theBoni->getNumAs() + 1) + 1;
        theBoni->drawAll();
      } else {
        dscore += theBoni ->getNumAs() * level;
        myBar->update(lives, score, 2, numCuts);
      }
    }
    if (objects[x][y] == 'B') {
#ifdef __SOUND__
      if (sound) {  
        SoundPlay(4, (channel++)%NUMCHANNELS);
      }
#endif
      do {
        xx = rand() % (BWIDTH - 2) + 1;
        yy = rand() % (BHEIGHT - 2) + 1;
      } while (objects[xx][yy] != 'a');
      head->setX(xx);
      head->setY(yy);
    }
    if (objects[x][y] == 'C') {
#ifdef __SOUND__
      if (sound) {
        SoundPlay(4, (channel++)%NUMCHANNELS);
      }
#endif
      head->setX(warpx);
      head->setY(warpy);
    }
    if (objects[x][y] == 'E') {
#ifdef __SOUND__
      if (sound) {
        SoundPlay(6, (channel++)%NUMCHANNELS);
      }
#endif
      theBoni->removeBonus(x, y);
      cutInHalf();
      myBar->update(lives, score, 2, numCuts);
    }
    if (objects[x][y] == 'F') {
#ifdef __SOUND__
      if (sound) {
        SoundPlay(7, (channel++)%NUMCHANNELS);
      }
#endif
      theBoni->removeBonus(x, y);
      doubleIt();
      myBar->update(lives, score, 2, numCuts);
    }
    if (objects[x][y] == 'G') {
#ifdef __SOUND__
      if (sound) {
        SoundPlay(8, (channel++)%NUMCHANNELS);
      }
#endif
      theBoni->removeBonus(x, y);
      if (lives < 9) {
        lives++;
        myBar->update(lives, score, 1, numCuts);
      }
    }
    if (objects[x][y] == 'H') {
#ifdef __SOUND__
      if (sound) {
        SoundPlay(9, (channel++)%NUMCHANNELS);
      }
#endif
      theBoni->removeBonus(x, y);
      reverse();
    }
    if (objects[x][y] == 'I') {
#ifdef __SOUND__
      if (sound) {
        SoundPlay(9, (channel++)%NUMCHANNELS);
      }
#endif
      theBoni->removeBonus(x, y);
      thePlayers->reverse((playerNum)?0:1);
    }
    if (objects[x][y] == 'J') {
#ifdef __SOUND__
      if (sound) {
        SoundPlay(3, (channel++)%NUMCHANNELS);
      }
#endif
      theBoni->removeBonus(x, y);
//      cutInHalfAndLeave();
      numCuts++;
      myBar->update(lives, score, 2, numCuts);
    }
  }
  return 0;
}

void worm::setGrow(int growing1) {
  growing += growing1;
}

int worm::getLives() {
  return(lives);
}

int worm::getScore() {
  return(score + dscore);
}

void worm::setLives(int alives) {
  lives = alives;
}

void worm::cutInHalf() {
  int count = 1;

  count = (length < 3) ? 0 : length >> 1;
  dscore += count * level + 5;
  myBar->update(lives, score, 2, numCuts);
  growing -= count;
}

void worm::doubleIt() {
  dscore += length * level;
  growing += length;
}

void worm::setRealScore(int fibbee) {
  score = fibbee;
}

void worm::setScore(int fibbee) {
  dscore = fibbee;
}

void worm::resetMelt() {
  meltCount = MELTSIZE;
  meltFlag = meltDelay;
}

int worm::unPause() {
  if ((length-1)&&(!lifeDone)) {
    if (!flashCount) {
      flashCount = FLASHCOUNT;
      return 1;
    }
    if (!(flashCount % 2) && !flashDelay) {
      head->erase();
      flashCount--;
      flashDelay = fps/8;
      return 0;
    }
    if (!flashDelay) {
      head->draw(&wormImage);
      flashCount--;
      flashDelay = fps/8;
      return 0;
    }
    flashDelay--;
    return 0;
  } else
    return 1;
}

void worm::reverse() {
  bodyPart *t1, *t2, *t3;

  t1 = NULL;
  t2 = head;
  t3 = head->getNext();

  while (t3 != NULL) {
    t2->setNext(t1);
    t1 = t2;
    t2 = t3;
    t3 = t3->getNext();
  }
  t2->setNext(t1);
  head = t2;
  dx = head->getX() - head->getNext()->getX();
  dy = head->getY() - head->getNext()->getY();
}

void worm::cutInHalfAndLeave() {
  bodyPart *temp, *temp2;
  int thing;

  if (length > 2) {
#ifdef __SOUND__
    if (sound)
      SoundPlay(10, (channel++)%NUMCHANNELS);
#endif
    dscore += (length / 2) * level;
    temp = head;
    thing = (length/2*2==length)?length/2:length/2+1;
    for (int i = 0; i < thing - 1; i++)
      temp = temp->getNext();
    length -= thing;
    growing = 0;
    temp2 = temp->getNext();
    temp->setNext(NULL);
    if (theDeadWorms == NULL)
      theDeadWorms = new deadWorm(temp2);
    else
      theDeadWorms->addDeadWorm(temp2);
  }
  theDeadWorms->draw();
}

bodyPart *worm::getHead() {
  return head;
}

void worm::killMe() {
  lives--;
  dscore = (int)((float)score * 0.85) - score;
}
