/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

class worm {
  private :
    bodyPart *head;
    bodyPart *spareHead;
    Pixmap wormImage;
    int dx, dy;
    int already;
    int hit();
    int growing;
    int score;
    int dscore;
    int lives;
    statusBar *myBar;
    int length; 
    int up, down, left, right, cut;
    int meltCount;
    int meltFlag;
    int flashCount;
    int flashDelay;
    int playerNum;
    int numCuts;

  public :
    worm(int, int, int, int, int, char *, int, int, int, int);
    ~worm();
    void showStatusMaybe();
    void showStatus(int);
    int move();
    int addPartMove();
    int changeDir(int);
    void drawAll();
    void eraseAll();
    void moveTail();
    void setGrow(int);
    int getLives();
    int getScore();
    bodyPart *getHead();
    void setLives(int);
    void setRealScore(int);
    void setScore(int);
    void newLevel(int, int, int, int);
    void cutInHalf();
    void doubleIt();
    int melt();
    void resetMelt();
    int unPause();
    void reverse();
    void cutInHalfAndLeave();
    void killMe();
};
