/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

/* joystick support added 23/2/98 by Bevan Schroeder bevan@foo.net
   JOYSTICK_THRESHOLD and JOYSTICK_MAX are probably wrong if it
   isn't working for you (works great with my Gravis) */

#include "common.h"

Display *display;
Window win;
GC gc;

Pixmap bonusXpms[NUMBONUS], bar, logo, pause_pict, deadWormXpm;
Colormap myColors;
XpmAttributes myXpmAttributes;

char* colors[] =
{"a	c #300000","b	c #500000","c	c #700000","d	c #900000","e	c #b00000","b	c #d00000",
 "a	c #003000","b	c #005000","c	c #007000","d	c #009000","e	c #00b000","b	c #00d000",
 "a	c #000030","b	c #000050","c	c #000070","d	c #000090","e	c #0000b0","b	c #0000d0",
 "a	c #303000","b	c #505000","c	c #707000","d	c #909000","e	c #b0b000","b	c #d0d000",
 "a	c #300030","b	c #500050","c	c #700070","d	c #900090","e	c #b000b0","b	c #d000d0",
 "a	c #003030","b	c #005050","c	c #007070","d	c #009090","e	c #00b0b0","b	c #00d0d0"};

int screenNum, sound, warpx, warpy, paused = 0, level = 1, nullRun = 20, drops,
    punishment = 4, keys[5][2], keyq, keyp, keyu, keyb, isExpose = 0, install,
    quiet, keyg, gamePending = 1, fps, newGame = 0, channel = 3, keyt, classic,
    meltDelay, unPausing = 0, flashDelay, joystick, joystickWhich, lifeDone = 0,
    stayOnLevel, randomLevels = 0;
long gameCounter = 0;
char *progName, objects[BWIDTH][BHEIGHT], displayName[20];

#ifdef __SOUND__
Sound snd[SOUNDS];
#endif

levels allLevels;
walls *allWalls;
boni *theBoni, *theWarps;
people *thePlayers;
deadWorm *theDeadWorms = NULL;
timer gameTimer;

void getGC(Window win, GC *gc);
void setupX(Window& win, GC& gc, int argc, char **argv, long mask);
void parseCommandLine(int argc, char **argv, long& speed, int& sound, int& joystick, int& joystickWhich, char *name1, char *name2, int& numPlayers, int& c1, int& c2, char *displayName, int& install, int& quiet, int& classic, int& stayOnLevel, int& randomLevels);
void printOptions(char **argv);
void setupStuff();
void destroyStuff();
void error(int errorCode);
void myQuit (int code);

void uDelay (unsigned long usec) {
  struct timeval delay;

  delay.tv_sec = usec / 1000000L;
  delay.tv_usec = usec % 1000000L;

  select (0, NULL, NULL, NULL, &delay );
}

void printBanner() {
  fprintf(stderr, "\nXNibbles 1.0 BETA 4, Copyright (C) 1998 Sean MacIsaac and Ian Peters\n");
}

int main(int argc, char **argv) {
  XEvent report;

  long speed, mask = KeyPressMask | ExposureMask | FocusChangeMask;
  char name1[MAXNAMELENGTH + 1], name2[MAXNAMELENGTH + 1];
  int keyAlready = 0, numPlayers, c1, c2, randomBonus, levelDone = 0,
      akey;

  progName = argv[0];

  parseCommandLine(argc, argv, speed, sound, joystick, joystickWhich, name1, name2, numPlayers, c1, c2, displayName, install, quiet, classic, stayOnLevel, randomLevels);
  gameTimer.set(speed);

  if (!quiet) {
    printBanner();
    fprintf(stderr,"\n");
  }

  setupX(win, gc, argc, argv, mask);
  if (!quiet)
    fprintf(stderr, "Window initialized...\n");

  if (install) {
    myColors = XCreateColormap (display, RootWindow (display, screenNum), DefaultVisual (display, screenNum), AllocNone);
    if (myColors != XDefaultColormap(display, screenNum)) {
      XSetWindowColormap (display, win, myColors);
      myXpmAttributes.colormap = myColors;
      myXpmAttributes.valuemask = XpmColormap;
      if (!quiet)
        fprintf (stderr, "Colormap installed...\n");
    } else {
      if (!quiet)
        fprintf (stderr, "Colormap NOT installed...\n");
    }
  } else {
    myXpmAttributes.colormap = DefaultColormap(display, DefaultScreen(display));
    myXpmAttributes.valuemask = XpmColormap;
  }

  setupStuff();
  if (!quiet)
    fprintf(stderr, "Pixmaps allocated...\n");

#ifdef __JOYSTICK__
  initJoystick();
#endif

  srand(gameTimer.getTime());

  keys[0][0] = XKeysymToKeycode(display, XStringToKeysym("Up"));
  keys[1][0] = XKeysymToKeycode(display, XStringToKeysym("Down"));
  keys[2][0] = XKeysymToKeycode(display, XStringToKeysym("Left"));
  keys[3][0] = XKeysymToKeycode(display, XStringToKeysym("Right"));
  keys[4][0] = XKeysymToKeycode(display, XStringToKeysym("Control_R"));
  keys[0][1] = XKeysymToKeycode(display, XStringToKeysym("w"));
  keys[1][1] = XKeysymToKeycode(display, XStringToKeysym("s"));
  keys[2][1] = XKeysymToKeycode(display, XStringToKeysym("a"));
  keys[3][1] = XKeysymToKeycode(display, XStringToKeysym("d"));
  keys[4][1] = XKeysymToKeycode(display, XStringToKeysym("Control_L"));
  keyq = XKeysymToKeycode(display, XStringToKeysym("q"));
  keyp = XKeysymToKeycode(display, XStringToKeysym("p"));
  keyu = XKeysymToKeycode(display, XStringToKeysym("u"));
  keyb = XKeysymToKeycode(display, XStringToKeysym("b"));
  keyg = XKeysymToKeycode(display, XStringToKeysym("g"));
  keyt = XKeysymToKeycode(display, XStringToKeysym("t"));
  if (!quiet)
    fprintf(stderr, "Keycodes configured...\n");

#ifdef __SOUND__
  if (sound) {
    SoundLoad(DATADIR"/sounds/start.ub",&snd[0]);
    SoundLoad(DATADIR"/sounds/destroy.ub", &snd[1]);
    SoundLoad(DATADIR"/sounds/laughter.ub",&snd[2]);
    SoundLoad(DATADIR"/sounds/gotdiamond.ub",&snd[3]);
    SoundLoad(DATADIR"/sounds/teleport.ub",&snd[4]);
    SoundLoad(DATADIR"/sounds/appear.ub",&snd[5]);
    SoundLoad(DATADIR"/sounds/half.ub",&snd[6]);
    SoundLoad(DATADIR"/sounds/double.ub",&snd[7]);
    SoundLoad(DATADIR"/sounds/life.ub",&snd[8]);
    SoundLoad(DATADIR"/sounds/spring.ub",&snd[9]);
    SoundLoad(DATADIR"/sounds/break.ub",&snd[10]);
    SoundInit(SOUNDS,snd,8000,NUMCHANNELS+1,SOUNDDEV);
    if (!quiet)
      fprintf(stderr, "Sounds loaded...\n");
  }
#endif

  XMapWindow(display, win);
  if (!quiet)
    fprintf(stderr, "Window mapped.\n\n");

  thePlayers = new people(numPlayers, name1, name2, c1, c2);
  theBoni = new boni;
  theWarps = new boni;
  if (randomLevels)
    level = random() % allLevels.getNumLevels() + 1;
  allLevels.copyLevel(level);
  allWalls = new walls();

  theBoni->addBonus('A', 0);

  for (int foo = 0; foo < BWIDTH; foo++)
    for (int bar = 0; bar < BHEIGHT; bar++)
      if (objects[foo][bar] > 'a' && objects[foo][bar] < 'm')
        allWalls->draw(objects[foo][bar], foo, bar);

  XCopyArea(display, bar, win, gc, 0, 0, 1020, 30, 0, HEIGHT-30);
  XCopyArea(display, logo, win, gc, 0, 0, 103, 20, WIDTH-170, HEIGHT-25);

  nullRun = fps;

  thePlayers->showStatus(3);
  theBoni->drawAll();
  theBoni->counterDraw();
  theWarps->drawAll();
  thePlayers->drawAll();

  while (XCheckWindowEvent(display, win, ExposureMask, &report) == True);

  while (1) {

    if (newGame && !nullRun) {
      if (theDeadWorms != NULL) {
        theDeadWorms->eraseAll();
        delete theDeadWorms;
        theDeadWorms = NULL;
      }
      theBoni->eraseAll();
      theWarps->eraseAll();
      theBoni->reset();
      theWarps->reset();
      gameCounter = 0;
      nullRun = fps;
      punishment = 5;
      newGame = 0;
      if ((!stayOnLevel && (level-1)) || randomLevels) {
        if (randomLevels)
          level = random() % allLevels.getNumLevels() + 1;
        else
          level = 1;
        XSync(display, True);
        report.type = Expose;
        XClearWindow(display, win);
        XSendEvent(display, win, False, ExposureMask, &report);
        delete thePlayers;
        thePlayers = new people(numPlayers, name1, name2, c1, c2);
      } else {
//        if (stayOnLevel)
//          level = stayOnLevel;
        thePlayers->eraseAll();
        delete thePlayers;
        thePlayers = new people(numPlayers, name1, name2, c1, c2);
        thePlayers->showStatus(3);
      }
      allLevels.copyLevel(level);
      theBoni->addBonus('A', 0);
      theBoni->drawAll();
    }

    if (newGame && nullRun)
      nullRun--;

    if (unPausing && thePlayers->unPause()) {
      unPausing = 0;
      paused = 0;
      nullRun = (nullRun > fps/2)?nullRun:fps/2;
    }

    while (XCheckWindowEvent(display, win, ExposureMask, &report) == True)
      if (report.type == Expose) isExpose=1;

    if (isExpose) {
      XCopyArea(display, bar, win, gc, 0, 0, 1020, 30, 0, HEIGHT-30);
      XCopyArea(display, logo, win, gc, 0, 0, 103, 20, WIDTH-170, HEIGHT-25);
      if (paused)
        XCopyArea(display, pause_pict, win, gc, 0, 0, 101, 20, WIDTH-320, HEIGHT-25);
      thePlayers->showStatus(3);
      for (int foo = 0; foo < BWIDTH; foo++) 
        for (int bar = 0; bar < BHEIGHT; bar++) 
          if (objects[foo][bar] > 'a' && objects[foo][bar] < 'm') 
            allWalls->draw(objects[foo][bar], foo, bar);
      if (theDeadWorms != NULL)
        theDeadWorms->draw();
      thePlayers->drawAll();
      thePlayers->resetMelt();
      theBoni->drawAll();
      theBoni->counterDraw();
      theWarps->drawAll();
      isExpose = 0;
    }

    while (XCheckWindowEvent(display, win, FocusChangeMask, &report) == True) {
      switch (report.type) {
        case FocusOut:
          if (!gamePending) {
            XCopyArea(display, pause_pict, win, gc, 0, 0, 101, 20, WIDTH-320, HEIGHT-25);
            paused = 1;
          }
        break;
      }
    }

    if (punishment < 1)
      thePlayers->subs();

    if (nullRun && !paused && !gamePending && !unPausing)
      nullRun--; else 
      if (!paused && !gamePending) {
        gameCounter++;
        theBoni->scan();
        if ((theBoni->getNumAs() != 9) && !classic) {
          randomBonus = rand() % 32000;
          if (randomBonus > 0 && randomBonus <= 40) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('E', 2);
            theBoni->drawAll();
          } else 
          if (randomBonus > 100 && randomBonus <= 121) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('F', 3);
            theBoni->drawAll();
          } else 
          if (randomBonus > 200 && randomBonus <= 211) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('G',4);
            theBoni->drawAll();
          } else
          if (randomBonus > 300 && randomBonus <= 340 && numPlayers > 1) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('I', 5);
            theBoni->drawAll();
          } else
          if (randomBonus > 400 && randomBonus <= 440 && numPlayers > 1) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('J', 6);
            theBoni->drawAll();
          } else
          if (randomBonus > 1000 && randomBonus <= 1020) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('H', 2);
            theBoni->drawAll();
          } else
          if (randomBonus > 1100 && randomBonus <= 1110) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('H', 3);
            theBoni->drawAll();
          } else
          if (randomBonus > 1200 && randomBonus <= 1205) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('H', 4);
            theBoni->drawAll();
          } else
          if (randomBonus > 1300 && randomBonus <= 1320 && numPlayers > 1) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('H', 5);
            theBoni->drawAll();
          } else
          if (randomBonus > 1400 && randomBonus <= 1420 && numPlayers > 1) {
#ifdef __SOUND__
            if (sound) {
              SoundPlay(5, (channel++)%NUMCHANNELS);
            }
#endif
            theBoni->addBonus('H', 6);
            theBoni->drawAll();
          }
        }
      }

#ifdef __JOYSTICK__
    checkJoystick();
#endif

    keyAlready = 0;
    while (!keyAlready && XCheckWindowEvent(display, win, KeyPressMask, &report) == True) {
      akey = report.xkey.keycode;
//    fprintf(stderr, "%s\n", XKeysymToString(XKeycodeToKeysym(display,akey,0)));
      if ((akey == keyp) && !gamePending) {
        if (paused) {
          XClearArea(display, win, WIDTH-320, HEIGHT-25, 101, 20, False);
          unPausing = 1;
        } else { 
          paused = 1;
          XCopyArea(display, pause_pict, win, gc, 0, 0, 101, 20, WIDTH-320, HEIGHT-25);
        }
      }
      if (akey == keyu) {
        levelDone = 1;
      }
      if (akey == keyb) {
        level -= 2;
        levelDone = 1;
      }
      if (akey == keyq) {
        myQuit (0);
      }
      if (akey == keyt) {
        (sound==0)?sound=1:sound=0;
      }
      if (akey == keyg) {
//        XSync(display, True);
        if (gamePending) {
#ifdef __SOUND__
          if (sound)
            SoundPlay (0, (channel++)%NUMCHANNELS);
#endif
          gamePending = 0;
        }
      }
      if (!paused && (!nullRun)) {
        if (!thePlayers->changeDir(akey)) {
          XPutBackEvent(display, &report);
          keyAlready = 1;
        }
      } else keyAlready=1;
    }

    if (!paused && !nullRun && !gamePending) {
      if (!lifeDone && thePlayers->moveOrGrow()) {
#ifdef __SOUND__
        if (sound)
          SoundPlay(1, (channel++)%NUMCHANNELS);
#endif
        lifeDone = 1;
      }
      if (lifeDone && !thePlayers->melt()) {
        lifeDone = 0;
        thePlayers->resetMelt();
        if (thePlayers->getLives() < 0) {
#ifdef __SOUND__
          if (sound)
            SoundPlay(2, (channel++)%NUMCHANNELS);
#endif
          gamePending = 1;
          nullRun = fps * 7;
          newGame = 1;
          thePlayers->showStatus(3);
        } else {
          theBoni->eraseAll();
          theWarps->reset();
          nullRun = fps;
          punishment = 5;
          allLevels.copyLevel(level);
          if (theDeadWorms != NULL)
            theDeadWorms->draw();
          theBoni->addBonus('A', 0);
          theBoni->drawAll();
          theBoni->counterDraw();
          thePlayers->showStatus(3);
        }
      }
    }
    if (!levelDone&&theBoni->getNumAs() > 9 && !stayOnLevel) {
      levelDone = 1;
      nullRun = fps;
    }
    if (levelDone&&nullRun <= 1) {
      levelDone=0;
      if (level < allLevels.getNumLevels() && !randomLevels)
        level++;
      else
        level = random() % allLevels.getNumLevels() + 1;
      thePlayers->drawAll();
      if (theDeadWorms != NULL) {
        delete theDeadWorms;
        theDeadWorms = NULL;
      }
      theBoni->reset();
      theWarps->reset();
      punishment = 4;
      gameCounter = 0;
      nullRun = fps;
      allLevels.copyLevel(level);
      XSync(display, True);
      report.type = Expose;
      theBoni->addBonus('A', 0);
      XClearWindow(display, win);
      XSendEvent(display, win, False, ExposureMask, &report);
    }
    XFlush(display);
    thePlayers->showStatusMaybe();
    uDelay(gameTimer.elapsed());
  }
}

void getGC(Window win, GC *gc) {
  unsigned long valuemask = 0;
  XGCValues values;
 
  *gc = XCreateGC(display, win, valuemask, &values);
  XSetForeground(display, *gc, BlackPixel(display, screenNum));
}

void setupX(Window& win, GC& gc, int argc, char **argv, long mask)
{
  char *charWindowName = "XNibbles";
  XSizeHints sizeHints;
  XWMHints wmHints;
  XClassHint classHints;
  XTextProperty windowName;
  XSetWindowAttributes winAtt;

  if ((display = XOpenDisplay(displayName)) == NULL)
  {
    fprintf(stderr, "%s: cannot connect to X server %s\n\n", progName, XDisplayName(displayName));
    exit(-1);
  }
  screenNum = DefaultScreen(display);
  win = XCreateSimpleWindow(display, RootWindow(display, screenNum), 0, 0, WIDTH, HEIGHT, 4, WhitePixel(display, screenNum), BlackPixel(display, screenNum));
  sizeHints.flags = PMinSize | PMaxSize;
  sizeHints.min_width = WIDTH;
  sizeHints.min_height = HEIGHT;
  sizeHints.max_width = WIDTH;
  sizeHints.max_height = HEIGHT;
  XStringListToTextProperty(&charWindowName, 1, &windowName);
  wmHints.initial_state = NormalState;
  wmHints.input = True;
  wmHints.flags = StateHint | InputHint;
  classHints.res_name = progName;
  classHints.res_class = charWindowName;
  XSetWMProperties(display, win, &windowName, &windowName, argv, argc, &sizeHints, &wmHints, &classHints);
  XSelectInput(display, win, mask);
  getGC(win, &gc);
  winAtt.cursor = None;
  XChangeWindowAttributes(display, win, CWCursor, &winAtt);
  XClearWindow(display, win);
  XUndefineCursor(display, win);
  XFlush(display);
}

void parseCommandLine(int argc, char **argv, long& speed, int& sound, int& joystick, int& joystickWhich, char *name1, char *name2, int& numPlayers, int &c1, int &c2, char *displayName, int& install, int& quiet, int& classic, int& stayOnLevel, int& randomLevels) {
  int loop;
  char *temp;
  char *displayEnv;

  displayEnv = getenv("DISPLAY");
  if (displayEnv != NULL)
    strcpy(displayName, displayEnv);
  else
    strcpy(displayName,":0");
  quiet = 0;
  classic = 0;
  randomLevels = 0;
  stayOnLevel = 0;
  speed = 35000L;
  sound = 1;
  joystick = 0;
  joystickWhich = 0;
  numPlayers = 1;
  install = 0;
  strcpy(name1, "cyrano");
  strcpy(name2, "bagheera");
  c1 = 5;
  c2 = 4;
  for (loop = 1; loop < argc; loop++) {
    if (strcmp(argv[loop], "-q") == 0)
      quiet = 1;
    else if (strcmp(argv[loop], "-i") == 0)
      install = 1;
    else if (strcmp(argv[loop], "-s") == 0) {
      if (loop + 1 < argc) {
        speed = strtol(argv[++loop], &temp, 0);
        speed *= 1000L;
        if (strcmp(temp, "") != 0 || speed < 20000 || speed > 100000) {
          printBanner();
          fprintf(stderr, "\nIllegal speed: \"%s\"\n", argv[loop]);
          printOptions(argv);
          exit(-1);
        }
      } else {
        printBanner();
        fprintf(stderr, "\n-s requires speed value!\n");
        printOptions(argv);
        exit(-1);
      }
    }
#ifdef __SOUND__
    else if (strcmp(argv[loop], "-ns") == 0) {
      sound = 0;
    }
#endif
#ifdef __JOYSTICK__
    else if (strcmp(argv[loop], "-j1") == 0) {
      joystick = 1;
    }
    else if (strcmp(argv[loop], "-j2") == 0) {
      if (!joystick) {
        joystickWhich = 1;
        joystick = 1;
      } else
        joystick = 3;
      numPlayers = 2;
    }
#endif
    else if (strncmp(argv[loop], "-cl", 3) == 0) {
      classic = 1;
    }
    else if (strncmp(argv[loop], "-ra", 3) == 0) {
      randomLevels = 1;
    }
    else if (strcmp(argv[loop], "-n1") == 0) {
      if (loop + 1 < argc) {
        strncpy(name1, argv[++loop], MAXNAMELENGTH);
      } else {
        printBanner();
        fprintf(stderr, "\n-n1 requires a name!\n");
        printOptions(argv);
        exit(-1);
      }
    }
    else if (strcmp(argv[loop], "-n2") == 0) {
      if (loop + 1 < argc) {
        strncpy(name2, argv[++loop], MAXNAMELENGTH);
        numPlayers = 2;
      } else {
        printBanner();
        fprintf(stderr, "\n-n2 requires a name!\n");
        printOptions(argv);
        exit(-1);
      }
    }
    else if (strcmp(argv[loop], "-2") == 0) {
      numPlayers = 2;
    }
    else if (strcmp(argv[loop], "-h") == 0 || strcmp(argv[loop], "--help") == 0) {
      printBanner();
      printOptions(argv);
      exit(-1);
    }
    else if (strcmp(argv[loop], "-c1") == 0) {
      if (loop + 1 < argc) {
        if (strncmp("red", argv[++loop], 3) == 0) c1 = 0; else
        if (strncmp("gre", argv[loop], 3) == 0) c1 = 1; else
        if (strncmp("blu", argv[loop], 3) == 0) c1 = 2; else
        if (strncmp("yel", argv[loop], 3) == 0) c1 = 3; else
        if (strncmp("pur", argv[loop], 3) == 0) c1 = 4; else
        if (strncmp("cya", argv[loop], 3) == 0) c1 = 5; else {
          printBanner();
          fprintf(stderr, "\nPlayer 1 color unknown: \"%s\"\n", argv[loop]);
          printOptions(argv);
          exit(-1);
        }
      } else {
        printBanner();
        fprintf(stderr, "\n-c1 requires a color!\n");
        printOptions(argv);
        exit(-1);
      }
    }
    else if (strcmp(argv[loop], "-c2") == 0) {
      if (loop + 1 < argc) {
        if (strncmp("red", argv[++loop], 3) == 0) c2 = 0; else
        if (strncmp("gre", argv[loop], 3) == 0) c2 = 1; else
        if (strncmp("blu", argv[loop], 3) == 0) c2 = 2; else
        if (strncmp("yel", argv[loop], 3) == 0) c2 = 3; else
        if (strncmp("pur", argv[loop], 3) == 0) c2 = 4; else
        if (strncmp("cya", argv[loop], 3) == 0) c2 = 5; else {
          printBanner();
          fprintf(stderr, "\nPlayer 2 color unknown: \"%s\"\n",argv[loop]);
          printOptions(argv);
          exit(-1);
        }
        numPlayers = 2;
      } else {
        printBanner();
        fprintf(stderr, "\n-c2 requires a color!\n");
        printOptions(argv);
        exit(-1);
      }
    }
    else if (strcmp(argv[loop], "-level") == 0) {
      if (loop + 1 < argc) {
        level= strtol(argv[++loop], &temp, 0);
        if (level > allLevels.getNumLevels() || level < 1) {
          printBanner();
          fprintf(stderr, "\nInvalid level!\n");
          printOptions(argv);
          exit(-1);
        }
        stayOnLevel = level;
      } else {
        printBanner();
        fprintf(stderr, "\n-level requires a level!\n");
        printOptions(argv);
        exit(-1);
      }
    }
    else if (strcmp(argv[loop], "-display") == 0) {
      if (loop + 1 < argc) {
        strcpy(displayName, argv[++loop]);
      } else { 
        printBanner();
        fprintf(stderr, "\n-display requires a display!\n");
        printOptions(argv);
        exit(-1);
      }
    }
    else {
      printBanner();
      fprintf(stderr, "\nIllegal option: \"%s\"\n", argv[loop]);
      printOptions(argv);
      exit(-1);
    }
  }
  if (randomLevels && stayOnLevel) {
    printBanner();
    fprintf(stderr, "\nCannot use -level and -random!\n");
    printOptions(argv);
    exit(-1);
  }
  fps = 1000000L / speed;
  meltDelay = fps / 10;
}

void printOptions(char **argv) {
  fprintf(stderr, "\nusage: %s [options]\n",argv[0]);
  fprintf(stderr, "   or: %s --help\n",argv[0]);
  fprintf(stderr, "   or: %s -h\n\n",argv[0]);
  fprintf(stderr, "Options:\n");
  fprintf(stderr, "   -s <speed>            20 (fast) to 100 (slow) [35]\n");
  fprintf(stderr, "   -n1 <name>            Set player 1's name\n");
  fprintf(stderr, "   -n2 <name>            Set player 2's name\n");
  fprintf(stderr, "   -c1 <color>           Set player 1's color\n");
  fprintf(stderr, "   -c2 <color>           Set player 2's color\n");
  fprintf(stderr, "   -classic              Classic nibbles\n");
  fprintf(stderr, "   -level <level>        Start and stay on level <level>\n");
  fprintf(stderr, "   -random               Play levels in random order\n");
  fprintf(stderr, "   -2                    2 player mode (assumed with -n2, -c2, -j2)\n");
  fprintf(stderr, "   -i                    Install private colormap\n");
  fprintf(stderr, "   -q                    Run quietly (less text output)\n");
#ifdef __SOUND__
  fprintf(stderr, "   -ns                   Disable sound\n");
#endif
#ifdef __JOYSTICK__
  fprintf(stderr, "   -j1                   Enable joystick for player 1\n");
  fprintf(stderr, "   -j2                   Enable joystick for player 2\n");
#endif
  fprintf(stderr, "   -display <display>    Set the display name\n\n");
  fprintf(stderr, "Valid colors are red, green, blue, yellow, cyan, and purple\n\n");
}

void setupStuff() {

  makePixmap(deadWorm_xpm, &deadWormXpm);
  makePixmap(target_xpm, &bonusXpms[0]);
  makePixmap(warp_xpm, &bonusXpms[1]);
  makePixmap(half_xpm, &bonusXpms[2]);
  makePixmap(double_xpm, &bonusXpms[3]);
  makePixmap(life_xpm, &bonusXpms[4]);
  makePixmap(reverse_xpm, &bonusXpms[5]);
  makePixmap(remains_xpm, &bonusXpms[6]);
  makePixmap(bar_xpm, &bar);
  makePixmap(logo_xpm, &logo);
  makePixmap(paused_xpm, &pause_pict);
}

void destroyStuff() {
  XFreePixmap(display, deadWormXpm);
  XFreePixmap(display, bonusXpms[0]);
  XFreePixmap(display, bonusXpms[1]);
  XFreePixmap(display, bonusXpms[2]);
  XFreePixmap(display, bonusXpms[3]);
  XFreePixmap(display, bonusXpms[4]);
  XFreePixmap(display, bar);
  XFreePixmap(display, logo);
  XFreePixmap(display, pause_pict);
  if (install)
    XFreeColormap (display, myColors);
}

void error(int errorCode) {
  switch (errorCode) {
    case NOCOLORS:
      fprintf(stderr, "\nThere are not enough available colors.  Try quitting some color hogging\napplications, or run with -i to install colormap.\n\n");
      myQuit(-1);
    break;
  }
}

void myQuit (int code) {
  destroyStuff();
  XFreeGC(display, gc);
  delete allWalls;
  delete thePlayers;
  delete theBoni;
  delete theWarps;
#ifdef __SOUND__
  if (sound) {
    SoundRestore();
  }
#endif
  exit(code);
}
