/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

/* joystick support added 23/2/98 by Bevan Schroeder bevan@foo.net
   JOYSTICK_THRESHOLD and JOYSTICK_MAX are probably wrong if it
   isn't working for you (works great with my Gravis) */

#include "common.h"

extern Display *display;
extern Window win;

level::level(char *alevelName) {
  FILE *in;
  int foo, bar;

  strcpy(levelFile, alevelName);
  if ((in = fopen(levelFile, "r")) == NULL) {
    loadTemplate();
    allWalls = new walls();
  } else {
    strcpy(levelFile, alevelName);
    if ((in = fopen(levelFile, "r")) == NULL) {
      fprintf(stderr, "Can't open level file %s!\n", levelFile);
      exit(-1);
    }
    allWalls = new walls();
    for (foo = 0; foo < BHEIGHT; foo++) {
      for (bar = 0; bar < BWIDTH; bar++) {
        fscanf(in, "%c", &objects[bar][foo]);
      }
      fscanf(in, "\n");
    }
  }
}

level::~level() {
  delete allWalls;
}

void level::load() {
  FILE *in;
  int foo, bar;

  if ((in = fopen(levelFile, "r")) == NULL) {
    fprintf(stderr, "Can't open level file %s!\n", levelFile);
    exit(-1);
  }
  for (foo = 0; foo < BHEIGHT; foo++) {
    for (bar = 0; bar < BWIDTH; bar++) {
      fscanf(in, "%c", &objects[bar][foo]);
    }
    fscanf(in, "\n");
  }
  fprintf(stderr, "Level loaded.\n");
}

void level::draw() {
  for (int foo = 0; foo < BWIDTH; foo++)
    for (int bar = 0; bar < BHEIGHT; bar++) {
      if (objects[foo][bar] > 'a' && objects[foo][bar] < 'q')
        allWalls->draw(objects[foo][bar], 10*foo + 30, 10*bar, 10, 10);
      else if (objects[foo][bar] == 'B')
        allWalls->draw('r', 10*foo+20, 10*bar-10, 20, 20);
      else if (objects[foo][bar] == 'C')
        allWalls->draw('q', 10*foo+20, 10*bar-10, 20, 20);
      else if (objects[foo][bar] == 'D')
        allWalls->draw('s', 10*foo+30, 10*bar, 10, 10);
    }
}

void level::write() {
  FILE *out;
  int foo, bar;

  if ((out = fopen(levelFile, "w")) == NULL) {
    fprintf(stderr, "Can't open level file %s!\n", levelFile);
    exit(-1);
  }
  for (foo = 0; foo < BHEIGHT; foo++) {
    for (bar = 0; bar < BWIDTH; bar++) {
      fprintf(out, "%c", objects[bar][foo]);
    }
    fprintf(out, "\n");
  }
  fprintf(stderr, "Level saved.\n");
}

void level::buttonPress(int x, int y, char letter) {
  if ((letter == 'r' || letter == 'q') && x < BWIDTH - 1 && y < BHEIGHT - 1) {
    buttonPress(x, y, 'a');
    buttonPress(x + 1, y, 'a');
    buttonPress(x, y + 1, 'a');
    buttonPress(x + 1, y + 1, 'a');
    if (letter == 'r') {
      objects[x+1][y+1] = 'B';
      allWalls->draw('r', 10*x+30, 10*y, 20, 20);
    }
    else if (letter == 'q') {
      objects[x+1][y+1] = 'C';
      allWalls->draw('q', 10*x+30, 10*y, 20, 20);
    }
  }
  else if (objects[x][y] == 'B' || objects[x][y] == 'C') {
    XClearArea(display, win, x*10+20, y*10-10, 20, 20, False);
    if (letter < 'q') {
      objects[x][y] = letter;
      if (letter != 'a')
        allWalls->draw(letter, x*10+30, y*10, 10, 10);
      else
        XClearArea(display, win, x*10+30, y*10, 10, 10, False);
    }
    else if (letter == 's') {
      objects[x][y] = 'D';
      allWalls->draw('s', 10*x+30, 10*y, 10, 10);
    }
  }
  else if (x < BWIDTH - 1 && (objects[x+1][y] == 'B' || objects[x+1][y] == 'C')) {
    XClearArea(display, win, x*10+30, y*10-10, 20, 20, False);
    objects[x+1][y] = 'a';
    if (letter < 'q') {
      objects[x][y] = letter;
      if (letter != 'a')
        allWalls->draw(letter, x*10+30, y*10, 10, 10);
      else
        XClearArea(display, win, x*10+30, y*10, 10, 10, False);
    }
    else if (letter == 's') {
      objects[x][y] = 'D';
      allWalls->draw('s', 10*x+30, 10*y, 10, 10);
    }
  }
  else if (y < BHEIGHT - 1 && (objects[x][y+1] == 'B' || objects[x][y+1] == 'C')) {
    XClearArea(display, win, x*10+20, y*10, 20, 20, False);
    objects[x][y+1] = 'a';
    if (letter < 'q') {
      objects[x][y] = letter;
      if (letter != 'a')
        allWalls->draw(letter, x*10+30, y*10, 10, 10);
      else
        XClearArea(display, win, x*10+30, y*10, 10, 10, False);
    }
    else if (letter == 's') {
      objects[x][y] = 'D';
      allWalls->draw('s', 10*x+30, 10*y, 10, 10);
    }
  }
  else if (x < BWIDTH - 1 && y < BHEIGHT - 1 && (objects[x+1][y+1] == 'B' || objects[x+1][y+1] == 'C')) {
    XClearArea(display, win, x*10+30, y*10, 20, 20, False);
    objects[x+1][y+1] = 'a';
    if (letter < 'q') {
      objects[x][y] = letter;
      if (letter != 'a')
        allWalls->draw(letter, x*10+30, y*10, 10, 10);
      else
        XClearArea(display, win, x*10+30, y*10, 10, 10, False);
    }
    else if (letter == 's') {
      objects[x][y] = 'D';
      allWalls->draw('s', 10*x+30, 10*y, 10, 10);
    }
  }
  else {
    if (letter < 'q') {
      objects[x][y] = letter;
      if (letter != 'a')
        allWalls->draw(letter, x*10+30, y*10, 10, 10);
      else
        XClearArea(display, win, x*10+30, y*10, 10, 10, False);
    }
    else if (letter == 's') {
      objects[x][y] = 'D';
      allWalls->draw('s', 10*x+30, 10*y, 10, 10);
    }
  }
}

char level::getObject(int x, int y) {
  if (objects[x][y] < 'q')
    return objects[x][y];
  else if (objects[x][y] == 'B')
    return 'r';
  else if (objects[x][y] == 'C')
    return 'q';
  return 's';
}

void level::loadTemplate() {
  int foo, bar;

  fprintf(stderr, "Blank level initialized.\n");
  for (foo = 0; foo < BHEIGHT; foo++)
    for (bar = 0; bar < BWIDTH; bar++)
      objects[bar][foo] = template_level[foo][bar];
}
