/* XNibbles - A simple X11 snake game
   Copyright (C) 1998 Sean MacIsaac and Ian Peters
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY of FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  
   Specific questions about this program can be addressed to the authors,
   Sean Macisaac (sjm@acm.org), and Ian Peters (ipeters@acm.org). */

#include "common.h"

extern Display *display;
extern Window win;
extern GC gc;
extern Pixmap theMask;
extern void error(int errorCode);
extern XpmAttributes myXpmAttributes;

newWalls::newWalls() {
  makePixmap(big_wall1_xpm, &images[0]);
  makePixmap(big_wall2_xpm, &images[1]);
  makePixmap(big_wall3_xpm, &images[2]);
  makePixmap(big_wall4_xpm, &images[3]);
  makePixmap(big_wall5_xpm, &images[4]);
  makePixmap(big_wall6_xpm, &images[5]);
  makePixmap(big_wall7_xpm, &images[6]);
  makePixmap(big_wall8_xpm, &images[7]);
  makePixmap(big_wall9_xpm, &images[8]);
  makePixmap(big_wall10_xpm, &images[9]);
  makePixmap(big_wall11_xpm, &images[10]);
  makePixmap(big_wormUp_xpm, &images[11]);
  makePixmap(big_wormRight_xpm, &images[14]);
  makePixmap(big_wormDown_xpm, &images[13]);
  makePixmap(big_wormLeft_xpm, &images[12]);
  makePixmap(big_warp_xpm, &images[15]);
  makePixmap(big_warpRandom_xpm, &images[16]);
  makePixmap(big_warpTarget_xpm, &images[17]);
  makePixmap(big_new_xpm, &images[18]);
  makePixmap(big_load_xpm, &images[19]);
  makePixmap(big_save_xpm, &images[20]);
  makePixmap(big_quit_xpm, &images[21]);
  makePixmap2(big_border_xpm, &images[22], &theMask);
}

void newWalls::draw(char which, int x, int y, int xsize, int ysize) {
  XCopyArea(display, images[which - 'b'], win, gc, 0, 0, xsize, ysize, x, y); 
}

newWalls::~newWalls() {
  int count;

  for (count = 0; count < 22; count++) {
    XFreePixmap(display, images[count]);
  }
}
