/*

    xpuyopuyo - pfield.h      Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Header for the playing field interface
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pfield_h_included
#define __pfield_h_included


/* Rock types */
#define P_COLOR_MASK          0x000f
#define P_TYPE_MASK           0x00f0
#define P_FLAG_MASK           0x0f00
#define P_JOIN_MASK           0xf000
#define P_NO_COLOR            0x000f
#define P_FLAG_ROCK           0x0100
#define P_FLAG_STAR           0x0200
#define P_FLAG_CLEAR          0x0400
#define P_FLAG_WALL           0x0800
#define P_FLAG_COUNTED        0x1000
#define P_TYPE_NORMAL         0x0000
#define P_TYPE_SPECIAL        0x0010


/* Specific rock types -- star is an explosion */
#define P_ROCK                (P_TYPE_SPECIAL | P_FLAG_ROCK | P_NO_COLOR)
#define P_INDESTRUCTIBLE      (P_TYPE_SPECIAL | P_NO_COLOR)
#define P_STAR                (P_TYPE_SPECIAL | P_FLAG_STAR | P_NO_COLOR)
#define P_ROCK_STAR           (P_TYPE_SPECIAL | P_FLAG_ROCK | P_FLAG_STAR | P_NO_COLOR)
#define P_CLEAR               (P_TYPE_SPECIAL | P_FLAG_CLEAR | P_NO_COLOR)
#define P_WALL                (P_TYPE_SPECIAL | P_FLAG_WALL | P_FLAG_ROCK | P_NO_COLOR)


/* Join flags */
#define P_JOIN_NORTH          0x1000
#define P_JOIN_EAST           0x2000
#define P_JOIN_SOUTH          0x4000
#define P_JOIN_WEST           0x8000
#define P_JOIN_ANY            0xf000


/* Rock macros */
#define P_IS_INDESTRUCTIBLE(c)((c) == P_INDESTRUCTIBLE)
#define P_IS_ROCK(color)      ((color) & P_FLAG_ROCK)
#define P_IS_STAR(color)      ((color) & P_FLAG_STAR)
#define P_IS_COLOR(color)     (P_COLOR_VALUE(color) != P_NO_COLOR)
#define P_IS_CLEAR(color)     ((color) & P_FLAG_CLEAR)
#define P_IS_WALL(color)      ((color) & P_FLAG_WALL)
#define P_COLOR_VALUE(color)  ((color) & P_COLOR_MASK)


/* Various available rock types */
#define P_NUM_ROCKS           4     /* Three, that's right :) */
#define P_NORMAL_ROCK         0     /* Represents one rock */
#define P_BIG_ROCK            1     /* Represents 6 rocks */
#define P_DEMON_ROCK          2     /* Represents 15 big rocks! */
#define P_BIGROCK_NUM         6     /* Number represented by a big rock */
#define P_DEMONROCK_NUM       15    /* Number represented by a really big rock */


/* Structure for storing information on the next piece */
typedef struct _nextpiece {
   int block[2];              /* Color of each blob */
} nextpiece;


/* Playing field is stored in this structure */
typedef struct _pfield pfield;
struct _pfield {
   int x;            /* For floating field, X position */
   int y;            /* For floating field, Y position */
   int width;        /* Width of field */
   int height;       /* Height of field */
   int size;         /* Width * Height, num tiles */
   int number;       /* Field ID */
   int *data;        /* Field data */
   pfield *piece;    /* Child floating field */
   int *redraw;      /* Redraw frame */
};


#define P_FIELD_SIZE(f)             ((f)->size)
#define P_FIELD_XY_P(f, x, y)       ((f)->data + (y) * (f)->width + (x))
#define P_FIELD_XY(f, x, y)         (*P_FIELD_XY_P(f, x, y))
#define P_FIELD_PIECE(f)            ((f)->piece)
#define P_FIELD_PIECE_X(f)          P_FIELD_PIECE(f)->x
#define P_FIELD_PIECE_Y(f)          P_FIELD_PIECE(f)->y
#define P_PIECE_X(p)                (p)->x
#define P_PIECE_Y(p)                (p)->y


/* Interface functions */
pfield * p_field_new(int width, int height, int num);
pfield * p_field_new_copy(const pfield *copy);
void     p_field_free(pfield **f);

int      p_field_get(const pfield *f, int x, int y);
void     p_field_set(pfield *f, int x, int y, int z);
void     p_field_clear(pfield *f);
void     p_field_copy(pfield *dest, const pfield *src);

void     p_field_redraw_none(pfield *field);
void     p_field_redraw_all(pfield *field);
void     p_field_redraw_rect(pfield *field, int rx1, int ry1, int rx2, int ry2);
void     p_field_redraw_point(pfield *field, int rx, int ry);


#endif
