/*

    xpuyopuyo - pai-gtk.c           Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org           http://chaos2.org/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <xpuyopuyo.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <pai-gtk.h>
#include <pdialog-gtk.h>
#include <psnprintf.h>


#define P_AI_GTK_NUM_COLS     16



void p_ai_gtk_list_select(GtkWidget *clist, gint row, gint col, GdkEventButton *event, gpointer data) {

   int *ai = data;
   if(ai != NULL) *ai = row - 1;
   return;

}



void p_ai_gtk_select_rule(pwindow_gtk *w, int *a) {

   p_dialog_window dw;
   gchar *strings[P_AI_GTK_NUM_COLS];
   GtkWidget *clist;
   GtkWidget *scroll;
   int tempa;
   int i;
   int j;
   
   if(a != NULL) tempa = *a;

   p_dialog_window_new(&dw, w, "AI List", 
                       a == NULL ? "AI Rule List:" : "Select a new AI rule from the list below.", 
                       a == NULL ? P_DIALOG_MESSAGE | P_DIALOG_NONMODAL : P_DIALOG_QUERY);

   scroll = gtk_scrolled_window_new(NULL, NULL);
   gtk_box_pack_start(GTK_BOX(dw.container), scroll, TRUE, TRUE, 0);

   for(i = 0; i < P_AI_GTK_NUM_COLS; i++) {
      strings[i] = (gchar *)malloc(P_GTK_STRING_BUFFER);
      *(strings[i] + P_GTK_STRING_BUFFER - 1) = '\0';
   }
   j = 0;
   p_strncpy(strings[j++], "Index", P_GTK_STRING_BUFFER - 1);
   p_strncpy(strings[j++], "AI Name", P_GTK_STRING_BUFFER - 1);
   #if USE_AIBREED
      p_strncpy(strings[j++], "Generation", P_GTK_STRING_BUFFER - 1);
   #endif /* Breeding option */
   p_strncpy(strings[j++], "Wins", P_GTK_STRING_BUFFER - 1);
   p_strncpy(strings[j++], "Losses", P_GTK_STRING_BUFFER - 1);
   #if USE_AIBREED
      p_strncpy(strings[j++], "Rule", P_GTK_STRING_BUFFER - 1);
   #endif /* Breeding option */
   clist = gtk_clist_new_with_titles(j, strings);

   gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_SINGLE);
   gtk_clist_column_titles_passive(GTK_CLIST(clist));
   gtk_clist_set_column_width(GTK_CLIST(clist), 0, 40);
   gtk_clist_set_column_width(GTK_CLIST(clist), 1, 100);
   gtk_clist_set_column_width(GTK_CLIST(clist), 2, 40);
   gtk_clist_set_column_width(GTK_CLIST(clist), 3, 40);
   #if USE_AIBREED
      gtk_clist_set_column_width(GTK_CLIST(clist), 4, 40);
      gtk_clist_set_column_width(GTK_CLIST(clist), 5, 200);
   #endif /* AI breeding option */

   gtk_clist_set_shadow_type(GTK_CLIST(clist), GTK_SHADOW_OUT);
   gtk_container_add(GTK_CONTAINER(scroll), clist);
   #if USE_AIBREED
      gtk_widget_set_usize(scroll, 550, 300);
   #else /* No breeding columns */
      gtk_widget_set_usize(scroll, 300, 200);
   #endif /* Breeding ? */

   for(i = -1; i < P_AI_COUNT; i++) {
      j = 0;
      p_snprintf(strings[j], P_GTK_STRING_BUFFER, "%5d", i + 1); j++;
      p_snprintf(strings[j], P_GTK_STRING_BUFFER, "%s",  p_ai_name_of(w->c->airules, i)); j++;
      #if USE_AIBREED
         p_snprintf(strings[j], P_GTK_STRING_BUFFER, "%5d", i < 0 ? 0 : p_ai_generation_of(w->c->airules, i)); j++;
      #endif /* AI breeding? */
      p_snprintf(strings[j], P_GTK_STRING_BUFFER, "%5d", i < 0 ? 0 : p_ai_win_count_of(w->c->airules, i)); j++;
      p_snprintf(strings[j], P_GTK_STRING_BUFFER, "%5d", i < 0 ? 0 : p_ai_loss_count_of(w->c->airules, i)); j++;
      #if USE_AIBREED
         p_snprintf(strings[j], P_GTK_STRING_BUFFER, "%s",  i < 0 ? 0 : p_ai_rule_text_of(w->c->airules, i)); j++;
      #endif /* Ai breeding? */
      gtk_clist_append(GTK_CLIST(clist), strings);
      gtk_clist_set_selectable(GTK_CLIST(clist), i + 1, a != NULL);
   }
   for(i = 0; i < P_AI_GTK_NUM_COLS; i++) free(strings[i]);

   if(a != NULL) gtk_clist_select_row(GTK_CLIST(clist), *a + 1, 0);
   gtk_signal_connect(GTK_OBJECT(clist), "select-row", GTK_SIGNAL_FUNC(p_ai_gtk_list_select), &tempa);
   if(p_dialog_window_run(&dw) && a != NULL) *a = tempa;

   return;
   
}
