/*  Copyright 2015 Ciaran Anscomb
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <SDL.h>

#include "array.h"

#include "scancodes_windows.h"

int main(int argc, char **argv) {
	(void)argc;
	(void)argv;

	puts("/* vsc table inverts scancode table from SDL2 */\n");
	puts("/* Generated by tools/scandump_windows */\n");

	printf("static const int windows_vsc_table[] = {\n");

	int nscancodes = ARRAY_N_ELEMENTS(windows_scancode_table);
	int sdl_to_vsc[SDL_NUM_SCANCODES];
	memset(sdl_to_vsc, 0, sizeof(sdl_to_vsc));
	for (int i = 0; i < nscancodes; i++) {
		if (windows_scancode_table[i] != 0) {
			if (sdl_to_vsc[windows_scancode_table[i]] == 0) {
				sdl_to_vsc[windows_scancode_table[i]] = i;
			}
		}
	}

	for (int i = 0; i < SDL_NUM_SCANCODES; i++) {
		if ((i % 8) == 0) {
			printf("\t");
		}
		printf("%3d,", sdl_to_vsc[i]);
		if ((i % 8) == 7 || (i + 1) == SDL_NUM_SCANCODES) {
			printf("\n");
		} else {
			printf(" ");
		}
	}

	puts("};\n");

	return EXIT_SUCCESS;
}
