/*-
 * Copyright (c) 2003 Allan Saddi <allan@saddi.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY ALLAN SADDI AND HIS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL ALLAN SADDI OR HIS CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: yafic-sign.c 922 2003-12-12 21:54:29Z asaddi $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "common.h"
#include "crypto.h"

#include "version.h"

#ifndef lint
static const char rcsid[] =
	"$Id: yafic-sign.c 922 2003-12-12 21:54:29Z asaddi $";
#endif /* !lint */

#define CHECK_NAME "yafic-check"
#define CHECK_NAME_LEN 11 /* strlen (CHECK_NAME) */

#if 0
static char *
filler (const char *template)
{
  int len;
  static char spaces[128];

  len = strlen (template);
  if (len > (sizeof (spaces) - 1))
    len = sizeof (spaces) - 1;
  memset (spaces, ' ', len);
  spaces[len] = '\0';

  return spaces;
}
#endif

static void
help (int isCheck)
{
  fprintf (stderr,
	   "\nOptions:\n"
	   "\t-V\tDisplay version information.\n"
	   "\t-h\tDisplay this summary.\n"
	   "\t-p\tExpect <keyfile> to be a public key instead of a\n"
	   "\t\tprivate key.\n");
  if (!isCheck)
    fprintf (stderr,
	     "\t-c\tVerify <file> against its signature.\n");
  fprintf (stderr,
	   "\n  <keyfile> is the public/private key to use.\n"
	   "\n"
	   "  <file> is the file to sign/verify.\n"
	   "\n"
	   "  Signature files have the same name as their corresponding\n"
	   "  files but with the extension .sig\n");
}

static void
usage (int isCheck)
{
  fprintf (stderr,
	   "Usage: %s [-Vhp] %s<keyfile> <file>\n",
	   prog,
	   isCheck ? "" : "[-c] ");
}

static void
cleanUp (void)
{
  CleanCrypto ();
  free (HashBuffer);
}

int
main (int argc, char *argv[])
{
  int isCheck = 0;
  int doVerify = 0;
  int pubKey = 0;
  int ch;
  int fd;

  prog = argv[0];

  if (strlen (prog) >= CHECK_NAME_LEN &&
      !strcmp (&prog[strlen (prog) - CHECK_NAME_LEN], CHECK_NAME)) {
    isCheck = 1;
    doVerify = 1;
  }

  while ((ch = getopt (argc, argv, "Vchp")) != -1) {
    switch (ch) {
    case 'V':
      fprintf (stderr, "yafic-sign version " VERSION_STRING
	       " (" VERSION_DATE ")\n");
      exit (1);
    case 'c':
      doVerify = 1;
      break;
    case 'h':
      usage (isCheck);
      help (isCheck);
      exit (2);
    case 'p':
      pubKey = 1;
      break;
    case '?':
    default:
      usage (isCheck);
      exit (2);
    }
  }
  argc -= optind;
  argv += optind;

  if (argc != 2) {
    usage (isCheck);
    exit (2);
  }

  HashBuffer = mymalloc (HASH_BUFFER_SIZE);

  atexit (cleanUp);

  InitCrypto ();

  LoadKey (argv[0], pubKey);

  if ((fd = open (argv[1], O_RDONLY)) != -1) {
    if (doVerify)
      VerifyFile (fd, argv[1], NULL);
    else {
      if (pubKey) {
	fprintf (stderr, "%s: %s\n", prog, "cannot sign with a public key");
	exit (1);
      }
      SignFile (fd, argv[1], NULL);
    }
    close (fd);
  }
  else
    yaficError (argv[1]);

  exit (0);
}
