#include <sstream>

#include "Var.h"


unordered_map<VarId, VarInfo> Var::varsInfo_;


Var::Var (const Var* v)
{
  varId_    = v->varId();
  range_    = v->range();
  evidence_ = v->getEvidence();
  index_    = Util::maxUnsigned();
}



Var::Var (VarId varId, unsigned range, int evidence)
{
  assert (range != 0);
  assert (evidence < (int) range);
  varId_    = varId;
  range_    = range;
  evidence_ = evidence;
  index_    = Util::maxUnsigned();
}



bool
Var::isValidState (int stateIndex)
{
  return stateIndex >= 0 && stateIndex < (int) range_;
}



void
Var::setEvidence (int evidence)
{
  assert (evidence < (int) range_);
  evidence_ = evidence;
}



string
Var::label (void) const
{
  if (Var::varsHaveInfo()) {
    return Var::getVarInfo (varId_).label;
  }
  stringstream ss;
  ss << "x" << varId_;
  return ss.str();
}



States
Var::states (void) const
{
  if (Var::varsHaveInfo()) {
    return Var::getVarInfo (varId_).states;
  }
  States states;
  for (unsigned i = 0; i < range_; i++) {
    stringstream ss;
    ss << i ;
    states.push_back (ss.str());
  }
  return states;
}

