/*************************************************************************
*									 *
*	 YapR Module for Yap Prolog 					 *
*									 *
*	YapR Prolog was developed at FEUP - Universidade do Porto	 *
*									 *
* Copyright Joao Azevedo and Universidade do Porto 2010-2011  		 *
*									 *
**************************************************************************
*									 *
* File:		interface.c						 *
* Last rev:								 *
* mods:									 *
* comments:	C code to interface R-project software with Yap		 *
*									 *
*************************************************************************/
#include <YapInterface.h>
#include <Rembedded.h>
#include <R.h>
#include <Rinternals.h>
#include <Rdefines.h>
#include <R_ext/Parse.h>

#define BUFSIZE 256

typedef enum {
  r_undefined,
  r_double,
  r_int,
  r_character
} r_basic_types;

extern void    init_R(void);
extern void    end_R(void);
extern double  get_double(char * expression);
extern int     get_int(char * expression);
extern YAP_Term    get_list(char * expression);
extern void    send_command(char * expression);
