:- use_module(library(plunit)).

:- begin_tests(r_tests).

:-consult('../yapr.pl').


test(t0,[true(X==[10.0,10.0])]):-
        X<-c(10,10).

test(t1,[true(Y==20.0)]):-
        x<-c(10,10),
	Y<-sum(x).


test(t2,[true(Y==20.00)]):-
        x<-c(10,10),
	Y<-round(sum(x),2).

test(t3,[true(Y==100.0)]):-
        x<-c(10,10),
	Y<-sum(x)*10/2.

test(t4,[true(X=="aa")]):-
        X <- paste("a","a",sep="").

test(t5,[true(X==["a","a"])]):-
        X<-append("a","a").


test(t6,[true(X==[200.0,200.0])]):-
        x<-c(10,10),
	y<-20,
	X<-x*y.	

test(t7,[true(X==[200,200])]):-
        x<-c(10,10),
	y<-20,
	X<-as:integer(round(x*y,0)).

test(t8):-
        r("source('test.r')").

%error handling
test(t9):-
        r("source(test)").

test(t10,[true(W=="world")]):-
	r("source('test.r')"),
	W<-hello.

test(t11):-
	r("library(actuar)").


:- end_tests(r_tests).

go:-
        run_tests,
        halt,
        !.
:-go.
