/**************************************************************************************************
	$Header: /pub/cvsroot/yencode/src/file.h,v 1.22 2002/03/21 04:58:31 bboy Exp $

	Copyright (C) 2002  Don Moore <bboy@bboy.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at Your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************************************/

#ifndef _YFILE_H
#define _YFILE_H

/* Default extensions for sorting first (in yencfile_cmp) */
#define	DEFAULT_SORT_FIRST_EXTENSIONS	"nfo,crc,sfv,m3u,par,rar,zip,arj,ace"


/* (ydecode) yEncode header information */
typedef struct _ydecode_yheader
{
	int				*part;	/* Part number (if multipart) */
	int				*total;	/* Total number of parts */
	unsigned long	*line;	/* Average line length */
	size_t			*size;	/* Final, overall file size (of all parts) */
	char				*name;	/* Name of the final output file */
	unsigned long	*begin;	/* Begin offset (should be in `part' but may appear here) */
	unsigned long	*end;		/* End offset (should be in `part' but may appear here) */
} YHEADER;


/* (ydecode) yEncode multipart file information */
typedef struct _ydecode_ypart
{
	unsigned long	*begin;
	unsigned long	*end;
	size_t			size;			/* Size of part, used by `ypost' */
} YPART;


/* (ydecode) yEncode footer information */
typedef struct _ydecode_yfooter
{
	size_t			*size;	/* If NULL, no size was specified */
	int				*part;	/* If NULL, no part was specified */
	crc32_t			*pcrc32;	/* If NULL, no pcrc32 was specified. */
	crc32_t			*crc32;	/* If NULL, no crc32 was specified */
} YFOOTER;


/* (ydecode) Structure containing information about one file */
typedef struct _ydecode_fileinfo
{
	char			*input_filename;		/* Name of the input file (if any) */
	struct stat	*input_st;				/* Input file status information */
	char			*output_filename;		/* Name of the output file */

	YHEADER		*header;					/* Header information */
	YPART			*part;					/* Multipart file information */
	YFOOTER		*footer;					/* Footer information */

	unsigned long	line_offset;		/* Line number where data begins */
	unsigned long	data_start;			/* Offset where the actual file data begins */
	int				multipart;			/* Is this a multipart file? */
} YDECFILE;


/* Special file types for a YENCFILE */
typedef enum _yencfile_special_types
{
	YSUPPORT_NOT_SPECIAL = 0,
	YSUPPORT_IS_SFV,
	YSUPPORT_IS_CRC
} ysupportfile_t;
#define	YSUPPORT_IS_SPECIAL(t)	(t != YSUPPORT_NOT_SPECIAL)

/* Part information for a single yenc part */
typedef struct _yencfile_part
{
	unsigned long begin, end;
	size_t size;
} YENCPART;

/* (yencode/ypost) Structure containing information about one file */
typedef struct _yencfile
{
	char 				*input_filename;				/* Name of input file */
	crc32_t			crc;								/* CRC of binary data */
	int				ok;								/* Did encoding succeed? */

	/* yencode only: */
	char				*output_prefix;				/* Output file name prefix */

	/* ypost only: */
	size_t			filesize;						/* Size of file */
	size_t			encsize;							/* Size of file AFTER ENCODING */
	int				enclines;						/* Number of lines of encoded data */
	size_t			totalparts;						/* Total number of parts to post for this file */
	ysupportfile_t	file_type;						/* Type of file if special */
	unsigned char	*support_data;					/* Data for special file types */
	YENCPART			**part;							/* Begin/end information for each part */
} YENCFILE;


/* Comparison function for sorting file list */
extern int ydecfile_cmp(const void *p1, const void *p2);

/* Add a file to a list of files */
extern YDECFILE *ydecfile_create(const char *filename, int strict);


/* Create and initialize a new yencfile part */
extern YENCPART *yencpart_create(void);

/* Seed the "sort first" extension list used by yencfile_cmp() */
extern void yencfile_seed_sort_first_extensions(const char *seedstr);

/* Comparison function for sorting YENCFILE lists */
extern int yencfile_cmp(const void *p1, const void *p2);

/* Function to create a new YENCFILE structure */
extern YENCFILE *yencfile_create(const char *input_filename, const char *output_dir,
											ysupportfile_t special_file_type, size_t multipart_size);


#endif /* !_YFILE_H */

/* vi:set ts=3: */
