/* @(#)xdr.c,v 1.2 1999/07/11 22:22:47 kim Exp */
#ifdef __SVR4
#include <rpc/rpc.h>
#include <rpcsvc/rusers.h>

bool_t
xdr_utmp(xdrs, objp)
	XDR *xdrs;
	struct ru_utmp *objp;
{
	char *ptr;
	u_int size;

	if (xdrs->x_op == XDR_FREE)
		return (TRUE);

	ptr  = objp->ut_line;
	size = sizeof(objp->ut_line);
	if (!xdr_bytes(xdrs, &ptr, &size, size)) {
		return (FALSE);
	}
	ptr  = objp->ut_name;
	size = sizeof(objp->ut_name);
	if (!xdr_bytes(xdrs, &ptr, &size, size)) {
		return (FALSE);
	}
	ptr  = objp->ut_host;
	size = sizeof(objp->ut_host);
	if (!xdr_bytes(xdrs, &ptr, &size, size)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ut_time)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_utmpptr(xdrs, objpp)
	XDR *xdrs;
	struct ru_utmp **objpp;
{
	if (!xdr_reference(xdrs, (char **) objpp, sizeof (struct ru_utmp), 
			   xdr_utmp)) {
		return (FALSE);
	}
	return (TRUE);
}

#if 0
bool_t
xdr_utmparr(xdrs, objp)
	XDR *xdrs;
	struct utmparr *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->uta_arr, (u_int *)&objp->uta_cnt,
		       MAXUSERS, sizeof(struct utmp *), xdr_utmpptr)) {
		return (FALSE);
	}
	return (TRUE);
}
#endif

bool_t
xdr_utmpidle(xdrs, objp)
	XDR *xdrs;
	struct utmpidle *objp;
{
	if (!xdr_utmp(xdrs, &objp->ui_utmp)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->ui_idle)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_utmpidleptr(xdrs, objpp)
	XDR *xdrs;
	struct utmpidle **objpp;
{
	if (!xdr_reference(xdrs, (char **) objpp, sizeof (struct utmpidle), 
			   xdr_utmpidle)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_utmpidlearr(xdrs, objp)
	XDR *xdrs;
	struct utmpidlearr *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->uia_arr, (u_int *)&objp->uia_cnt,
		       MAXUSERS, sizeof(struct utmpidle *), xdr_utmpidleptr)) {
		return (FALSE);
	}
	return (TRUE);
}
#endif
