#include <stdio.h>
#include "../z80-cpu.h"
#include "../z80-mon.h"

#ifdef  OLD_STYLE
static  FILE  *ports;
static char  buffer[256];
#endif

int
init_port_buffer(void)
{  
#ifdef  OLD_STYLE
   ports= fopen(Z80_PORTS,"r+b");   /* read_writable_binary file */
   if (ports)
      if (256 != fread(buffer,1,256,ports))
      {  fclose(ports), ports= (FILE*)0;  }
   return !ports;
#else
   return 0;
#endif
}


#ifdef  OLD_STYLE
int close_port_buffer(void)
{
   return  ports ? fclose(ports) : 0;
}
#endif


void send_pulse_to_port_buffer(void)
{
#ifdef  OLD_STYLE
   if (!ports)
      ;
   else if (cpu_pin[iorq]  &&  cpu_pin[wr])
   {  int  id= ADDRESS&255, i;
      if (buffer[id] != DATA)
      {  i=fseek(ports,(long)id,SEEK_SET);
         if (i || 1 != fwrite(&DATA,1,1,ports))
            error(i,"hardware malfunction","port write:");
         else
            buffer[id]=DATA;
         fflush(ports);
      }
   }
   else if (cpu_pin[iorq]  &&  cpu_pin[rd])
   {  DATA= buffer[ADDRESS&255];
   }
#endif
}
