/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include <sys/param.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include "ProgressP.h"

#define offset(field) XtOffsetOf(ProgressRec, field)
static XtResource resources[] =
{
  { XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel),
    offset (progress.foreground), XtRString, XtDefaultForeground },
  { XtNfont, XtCFont, XtRFontStruct, sizeof (XFontStruct *),
    offset (progress.font), XtRString, XtDefaultFont },
  { XtNcounter, XtCcounter, XtRPointer, sizeof (unsigned int *),
    offset (progress.counter), XtRPointer, NULL },
  { XtNmax, XtCmax, XtRInt, sizeof (unsigned int),
    offset (progress.max), XtRInt, (void *) 100 },
};

static void Initialize (Widget request, Widget new, ArgList args,
			Cardinal *num_args);
static void Redisplay (Widget gw, XEvent *event, Region region);

ProgressClassRec progressClassRec =
{
  {
    /* core_class fields.  */
    /* superclass		*/	(WidgetClass) &simpleClassRec,
    /* class_name		*/	"Progress",
    /* widget_size		*/	sizeof (ProgressRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber (resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	NULL,
    /* expose			*/	Redisplay,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	NULL,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  /* Simple class fields initialization.  */
  {
    /* change_sensitive		*/	XtInheritChangeSensitive
  },
  /* Content class fields initialization.  */
  {
    /* ignore			*/      0
  }
};
WidgetClass progressWidgetClass = (WidgetClass) &progressClassRec;


/* ARGSUSED */
static void
Initialize (Widget request, Widget new, ArgList args,
	    Cardinal *num_args)
{
  ProgressWidget pw = (ProgressWidget) new;
  XGCValues values;

  values.foreground = pw->progress.foreground;
  values.background = pw->core.background_pixel;
  values.font       = pw->progress.font->fid;
  values.function   = GXcopy;

#if XtSpecificationRelease >= 6
  if (pw->simple.international == True)
    /* Since Xmb/wcDrawString eats the font, I must use XtAllocateGC. */
    pw->progress.normalGC = XtAllocateGC
      ((Widget) pw,
       0,
       (unsigned int) GCForeground | GCBackground | GCFunction,
       &values,
       GCFont,
       0);
  else
#endif
    pw->progress.normalGC = XtGetGC
      ((Widget) pw,
       (unsigned int) GCForeground | GCBackground | GCFunction | GCFont,
       &values);
}


void
progress_update (ProgressWidget pw)
{
  const int w = MIN (80, pw->core.width - 20);
  const int h = MIN (20, pw->core.height - 10);

  XDrawRectangle (XtDisplay (pw),
		  XtWindow (pw),
		  pw->progress.normalGC,
		  (pw->core.width - w) / 2,
		  (pw->core.height - h) / 2,
		  w, h);

  XFillRectangle (XtDisplay (pw),
		  XtWindow (pw),
		  pw->progress.normalGC,
		  (pw->core.width - w) / 2,
		  (pw->core.height - h) / 2,
		  (w * *pw->progress.counter) / pw->progress.max,
		  h);
}


static void
Redisplay (Widget gw, XEvent *event, Region region)
{
  ProgressWidget pw = (ProgressWidget) gw;

  progress_update (pw);
}
