/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include <errno.h>
#include <error.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gd.h"
#include "gdfontl.h"
#include "gdfonts.h"

/* Default size of the generated image.  */
#define XSIZE 640
#define YSIZE 480

/* Defined in libmtest.c.  */
extern int bigerror;


void
write_image (const char *name, double low, double high, double *r, int n)
{
  gdImagePtr im_out;
  int grey, blue, red, green, yellow, black;
  size_t xsize = XSIZE;
  size_t ysize = YSIZE;
  int cnt;
  double maxerror_real = 0.0;
  double maxerror = 1.0;
  double fcnt;
  FILE *outfile;
  char outname[strlen (name) + 5];
  char buf[200];

  /* Determine maximum error.  */
  for (cnt = 0; cnt < n; ++cnt)
    {
      while (fabs (r[2 * cnt + 1]) > maxerror)
	maxerror += 0.5;
      if (fabs (r[2 * cnt + 1]) > maxerror_real)
	maxerror_real = fabs (r[2 * cnt + 1]);
    }

  /* Create output image with the specified size.  */
  im_out = gdImageCreate (xsize, ysize);

  /* First color allocated is background.  */
  grey = gdImageColorAllocate (im_out, 180, 180, 180);

  /* Set transparent color. */
  gdImageColorTransparent (im_out, grey);

  /* These are all the other colors we need (in the moment).  */
  red = gdImageColorAllocate (im_out, 255, 0, 0);
  green = gdImageColorAllocate (im_out, 0, 130, 0);
  blue = gdImageColorAllocate (im_out, 0, 0, 255);
  yellow = gdImageColorAllocate (im_out, 154, 205, 50);
  black = gdImageColorAllocate (im_out, 0, 0, 0);

  /* Draw the pixels.  */
  for (cnt = 0; cnt < n; ++cnt)
    {
      gdImageSetPixel (im_out,
		       35 + (r[2 * cnt] - low) * (xsize - 45) / (high - low),
		       5 + (ysize - 35) / 2 - (r[2 * cnt + 1] * (ysize - 35) / 2 / maxerror),
		       fabs (r[2 * cnt + 1]) >= 0.5 ? red : black);
    }

  gdImageRectangle (im_out, 35, 5, xsize - 10, ysize - 31, blue);
  gdImageLine (im_out, 35, 5 + (ysize - 35) / 2,
	       xsize - 10, 5 + (ysize - 35) / 2, blue);
  gdImageString (im_out, gdFontSmall,
		 10, (ysize - 35) / 2,
		 " 0.0", blue);
  for (fcnt = 0.5; fcnt <= maxerror; fcnt += 0.5)
    {
      gdImageDashedLine (im_out,
			 35,
			 5 + (ysize - 35) / 2 * (1.0 - fcnt / maxerror),
			 xsize - 10,
			 5 + (ysize - 35) / 2 * (1.0 - fcnt / maxerror),
			 blue);

      snprintf (buf, sizeof (buf), "% .1f", fcnt);
      gdImageString (im_out, gdFontSmall,
		     10, (ysize - 35) / 2 * (1.0 - fcnt / maxerror),
		     buf, blue);

      gdImageDashedLine (im_out,
			 35,
			 5 + (ysize - 35) / 2 * (1.0 + fcnt / maxerror),
			 xsize - 10,
			 5 + (ysize - 35) / 2 * (1.0 + fcnt / maxerror),
			 blue);

      snprintf (buf, sizeof (buf), "% .1f", -fcnt);
      gdImageString (im_out, gdFontSmall,
		     10, (ysize - 35) / 2 * (1.0 + fcnt / maxerror),
		     buf, blue);
    }
  if (low < 0.0 && high > 0.0)
    {
      gdImageLine (im_out,
		   35 + (xsize - 45) / 2,
		   5,
		   35 + (xsize - 45) / 2,
		   ysize - 31,
		   blue);
    }
  snprintf (buf, sizeof (buf), "%.2g", low);
  gdImageString (im_out, gdFontSmall,
		 35, ysize - 30, buf, blue);
  snprintf (buf, sizeof (buf), "%.2g", high);
  gdImageString (im_out, gdFontSmall,
		 xsize - 10 - 6 * strlen (buf), ysize - 30, buf, blue);

  snprintf (buf, sizeof (buf),
	    "%s: maximum error: %.2f ulp, # errors > 0.5ulp: %d, samples: %d",
	    name, maxerror_real, bigerror, n);
  gdImageString (im_out, gdFontLarge,
		 35 + ((xsize - 45) - strlen (buf) * 8) / 2, ysize - 20,
		 buf, black);

  /* Write out the result.  */
  strcpy (outname, name);
  strcat (outname, ".gif");
  outfile = fopen (outname, "w");
  if (outfile == NULL)
    error (EXIT_FAILURE, errno, "cannot open output file `%s'", outname);

  gdImageGif (im_out, outfile);

  fclose (outfile);

  gdImageDestroy (im_out);
}
