/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#include "zelibm.h"

double
zeexp_diff (double x, double lm)
{
  mpq_t q;
  mpq_t res;
  mpq_t next;
  mpq_t nexta;
  mpq_t qlm;
  unsigned int n = 1;

  /* Get the value of X in rational form.  */
  extract_double (q, x);

  /* And the result of the other implementation.  */
  extract_double (qlm, lm);

  /* Initialize the other variables.  */
  mpq_init (res);
  mpq_set_ui (res, 1, 1);
  mpq_init (next);
  mpq_set_ui (next, 1, 1);
  mpq_init (nexta);

  do
    {
      mpq_mul (next, next, q);
      mpz_mul_ui (mpq_denref (next), mpq_denref (next), n);
      mpq_add (res, res, next);
      ++n;

      mpz_abs (mpq_numref (nexta), mpq_numref (next));
      mpz_set (mpq_denref (nexta), mpq_denref (next));
    }
  while (mpq_cmp (nexta, limit) > 0);

  /* Subtract the value found with the other implementation.  */
  mpq_sub (res, res, qlm);

  /* Generate the result.  */
  x = mpq_get_d (res);

  /* Clean up.  */
  mpq_clear (q);
  mpq_clear (res);
  mpq_clear (next);
  mpq_clear (nexta);
  mpq_clear (qlm);

  return x;
}
