/* Copyright (C) 1998 Ulrich Drepper, <drepper@cygnus.com>.
   The GPL applies to this file.
   As a special restriction the file must not be used in this or a modified
   form on Microsoft and Be systems.  */

#ifndef _ZELIBM_H
#define _ZELIBM_H	1

#include <gmp.h>

/* Limit of monotonic series.  */
extern mpq_t limit;


/* The math functions.  */
extern double zeexp (double x);
extern double zeexp_diff (double x, double r);

extern double zesin (double x);
extern double zesin_diff (double x, double r);

extern double zecos (double x);
extern double zecos_diff (double x, double r);

extern double zesinh (double x);
extern double zesinh_diff (double x, double r);

extern double zecosh (double x);
extern double zecosh_diff (double x, double r);

extern double zesqrt (double x);
extern double zesqrt_diff (double x, double r);

extern double zetan (double x);
extern double zetan_diff (double x, double r);

extern double zetanh (double x);
extern double zetanh_diff (double x, double r);


/* Helper functions.  */

/* Convert double value to pair of long integers.  */
extern void extract_double (mpq_t r, double d);

/* Generate uniformly distributed value between LOW and HIGH.  */
extern double zerandom (double low, double high);

/* Graphic functions.  */
extern void *create_window (int *pargc, char *argv[], const char *name,
			    double low, double high, volatile double *max,
			    unsigned long int *counter, unsigned long int n);

void display_loop (void *handle, volatile unsigned long int *counter,
		   double *r);


#endif /* zelibm.h */
