/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.base.CaseFormat;
import com.google.common.primitives.Ints;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocNodeImpl;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocLexer;
import com.puppycrawl.tools.checkstyle.grammars.javadoc.JavadocParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class AbstractJavadocCheck
extends Check {
    private static final String PARSE_ERROR_MESSAGE_KEY = "javadoc.parse.error";
    private static final String UNRECOGNIZED_ANTLR_ERROR_MESSAGE_KEY = "javadoc.unrecognized.antlr.error";
    private static final Map<String, ParseStatus> TREE_CACHE = new HashMap<String, ParseStatus>();
    private final DescriptiveErrorListener mErrorListener = new DescriptiveErrorListener();
    private DetailAST mBlockCommentAst;

    public abstract int[] getDefaultJavadocTokens();

    public void beginJavadocTree(DetailNode aRootAst) {
    }

    public void finishJavadocTree(DetailNode aRootAst) {
    }

    public void visitJavadocToken(DetailNode aAst) {
    }

    public void leaveJavadocToken(DetailNode aAst) {
    }

    @Override
    public final int[] getDefaultTokens() {
        return new int[]{152};
    }

    @Override
    public final int[] getAcceptableTokens() {
        return super.getAcceptableTokens();
    }

    @Override
    public final int[] getRequiredTokens() {
        return super.getRequiredTokens();
    }

    @Override
    public final boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public final void beginTree(DetailAST aRootAST) {
        TREE_CACHE.clear();
    }

    @Override
    public final void finishTree(DetailAST aRootAST) {
        TREE_CACHE.clear();
    }

    @Override
    public final void leaveToken(DetailAST aAST) {
    }

    @Override
    public final void visitToken(DetailAST aBlockCommentAst) {
        if (JavadocUtils.isJavadocComment(aBlockCommentAst)) {
            ParseStatus ps;
            this.mBlockCommentAst = aBlockCommentAst;
            String treeCacheKey = aBlockCommentAst.getLineNo() + ":" + aBlockCommentAst.getColumnNo();
            if (TREE_CACHE.containsKey(treeCacheKey)) {
                ps = TREE_CACHE.get(treeCacheKey);
            } else {
                ps = this.parseJavadocAsDetailNode(aBlockCommentAst);
                TREE_CACHE.put(treeCacheKey, ps);
            }
            if (ps.getParseErrorMessage() == null) {
                this.processTree(ps.getTree());
            } else {
                ParseErrorMessage parseErrorMessage = ps.getParseErrorMessage();
                this.log(parseErrorMessage.getLineNumber(), parseErrorMessage.getMessageKey(), parseErrorMessage.getMessageArguments());
            }
        }
    }

    protected DetailAST getBlockCommentAst() {
        return this.mBlockCommentAst;
    }

    private ParseStatus parseJavadocAsDetailNode(DetailAST aJavadocCommentAst) {
        ParseErrorMessage parseErrorMessage;
        ParseTree parseTree;
        ParseStatus result;
        block5: {
            String javadocComment = JavadocUtils.getJavadocCommentContent(aJavadocCommentAst);
            this.mErrorListener.setOffset(aJavadocCommentAst.getLineNo() - 1);
            result = new ParseStatus();
            parseTree = null;
            parseErrorMessage = null;
            try {
                parseTree = this.parseJavadocAsParseTree(javadocComment);
            }
            catch (IOException e) {
                parseErrorMessage = new ParseErrorMessage(aJavadocCommentAst.getLineNo(), PARSE_ERROR_MESSAGE_KEY, aJavadocCommentAst.getColumnNo(), e.getMessage());
            }
            catch (ParseCancellationException e) {
                parseErrorMessage = this.mErrorListener.getErrorMessage();
                if (parseErrorMessage != null) break block5;
                parseErrorMessage = new ParseErrorMessage(aJavadocCommentAst.getLineNo(), UNRECOGNIZED_ANTLR_ERROR_MESSAGE_KEY, aJavadocCommentAst.getColumnNo(), e.getMessage());
            }
        }
        if (parseErrorMessage == null) {
            DetailNode tree = this.convertParseTree2DetailNode(parseTree);
            result.setTree(tree);
        } else {
            result.setParseErrorMessage(parseErrorMessage);
        }
        return result;
    }

    private DetailNode convertParseTree2DetailNode(ParseTree aRootParseTree) {
        ParseTree currentParseTreeNode = aRootParseTree;
        JavadocNodeImpl rootJavadocNode = this.createJavadocNode(currentParseTreeNode, null, -1);
        int childCount = currentParseTreeNode.getChildCount();
        JavadocNodeImpl[] children = (JavadocNodeImpl[])rootJavadocNode.getChildren();
        for (int i = 0; i < childCount; ++i) {
            JavadocNodeImpl child;
            children[i] = child = this.createJavadocNode(currentParseTreeNode.getChild(i), rootJavadocNode, i);
        }
        JavadocNodeImpl currentJavadocParent = rootJavadocNode;
        ParseTree currentParseTreeParent = currentParseTreeNode;
        while (currentJavadocParent != null) {
            children = (JavadocNodeImpl[])currentJavadocParent.getChildren();
            childCount = children.length;
            for (int i = 0; i < childCount; ++i) {
                JavadocNodeImpl currentJavadocNode = children[i];
                ParseTree currentParseTreeNodeChild = currentParseTreeParent.getChild(i);
                JavadocNodeImpl[] subChildren = (JavadocNodeImpl[])currentJavadocNode.getChildren();
                for (int j = 0; j < subChildren.length; ++j) {
                    JavadocNodeImpl child;
                    subChildren[j] = child = this.createJavadocNode(currentParseTreeNodeChild.getChild(j), currentJavadocNode, j);
                }
            }
            if (childCount > 0) {
                currentJavadocParent = children[0];
                currentParseTreeParent = currentParseTreeParent.getChild(0);
                continue;
            }
            JavadocNodeImpl nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(currentJavadocParent);
            ParseTree nextParseTreeSibling = AbstractJavadocCheck.getNextSibling(currentParseTreeParent);
            if (nextJavadocSibling == null) {
                JavadocNodeImpl tempJavadocParent = (JavadocNodeImpl)currentJavadocParent.getParent();
                ParseTree tempParseTreeParent = currentParseTreeParent.getParent();
                while (nextJavadocSibling == null && tempJavadocParent != null) {
                    nextJavadocSibling = (JavadocNodeImpl)JavadocUtils.getNextSibling(tempJavadocParent);
                    nextParseTreeSibling = AbstractJavadocCheck.getNextSibling(tempParseTreeParent);
                    tempJavadocParent = (JavadocNodeImpl)tempJavadocParent.getParent();
                    tempParseTreeParent = tempParseTreeParent.getParent();
                }
            }
            currentJavadocParent = nextJavadocSibling;
            currentParseTreeParent = nextParseTreeSibling;
        }
        return rootJavadocNode;
    }

    private JavadocNodeImpl createJavadocNode(ParseTree aParseTree, DetailNode aParent, int aIndex) {
        JavadocNodeImpl node = new JavadocNodeImpl();
        node.setText(aParseTree.getText());
        node.setColumnNumber(AbstractJavadocCheck.getColumn(aParseTree));
        node.setLineNumber(AbstractJavadocCheck.getLine(aParseTree) + this.mBlockCommentAst.getLineNo());
        node.setIndex(aIndex);
        node.setType(AbstractJavadocCheck.getTokenType(aParseTree));
        node.setParent(aParent);
        node.setChildren(new JavadocNodeImpl[aParseTree.getChildCount()]);
        return node;
    }

    private static ParseTree getNextSibling(ParseTree aNode) {
        if (aNode.getParent() == null) {
            return null;
        }
        ParseTree parent = aNode.getParent();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ParseTree currentNode = parent.getChild(i);
            if (!currentNode.equals(aNode)) continue;
            if (i == childCount - 1) {
                return null;
            }
            return parent.getChild(i + 1);
        }
        return null;
    }

    private static int getTokenType(ParseTree aNode) {
        int tokenType = Integer.MIN_VALUE;
        if (aNode.getChildCount() == 0) {
            tokenType = ((TerminalNode)aNode).getSymbol().getType();
        } else {
            String className = AbstractJavadocCheck.getNodeClassNameWithoutContext(aNode);
            String typeName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, className);
            tokenType = JavadocUtils.getTokenId(typeName);
        }
        return tokenType;
    }

    private static String getNodeClassNameWithoutContext(ParseTree aNode) {
        String className = aNode.getClass().getSimpleName();
        int contextLength = 7;
        return className.substring(0, className.length() - 7);
    }

    private static int getLine(ParseTree aTree) {
        if (aTree instanceof TerminalNode) {
            return ((TerminalNode)aTree).getSymbol().getLine() - 1;
        }
        ParserRuleContext rule = (ParserRuleContext)aTree;
        return rule.start.getLine() - 1;
    }

    private static int getColumn(ParseTree aTree) {
        if (aTree instanceof TerminalNode) {
            return ((TerminalNode)aTree).getSymbol().getCharPositionInLine();
        }
        ParserRuleContext rule = (ParserRuleContext)aTree;
        return rule.start.getCharPositionInLine();
    }

    private ParseTree parseJavadocAsParseTree(String aBlockComment) throws IOException {
        Charset utf8Charset = Charset.forName("UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(aBlockComment.getBytes(utf8Charset));
        ANTLRInputStream input = new ANTLRInputStream((InputStream)in);
        JavadocLexer lexer = new JavadocLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)this.mErrorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JavadocParser parser = new JavadocParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)this.mErrorListener);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        return parser.javadoc();
    }

    private void processTree(DetailNode aRoot) {
        this.beginJavadocTree(aRoot);
        this.walk(aRoot);
        this.finishJavadocTree(aRoot);
    }

    private void walk(DetailNode aRoot) {
        int[] defaultTokenTypes = this.getDefaultJavadocTokens();
        if (defaultTokenTypes == null) {
            return;
        }
        DetailNode curNode = aRoot;
        while (curNode != null) {
            boolean waitsFor = Ints.contains((int[])defaultTokenTypes, (int)curNode.getType());
            if (waitsFor) {
                this.visitJavadocToken(curNode);
            }
            DetailNode toVisit = JavadocUtils.getFirstChild(curNode);
            while (curNode != null && toVisit == null) {
                if (waitsFor) {
                    this.leaveJavadocToken(curNode);
                }
                if ((toVisit = JavadocUtils.getNextSibling(curNode)) != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    private static class ParseErrorMessage {
        private int mLineNumber;
        private String mMessageKey;
        private Object[] mMessageArguments;

        public ParseErrorMessage(int aLineNumber, String aMessageKey, Object ... aMessageArguments) {
            this.mLineNumber = aLineNumber;
            this.mMessageKey = aMessageKey;
            this.mMessageArguments = aMessageArguments;
        }

        public int getLineNumber() {
            return this.mLineNumber;
        }

        public String getMessageKey() {
            return this.mMessageKey;
        }

        public Object[] getMessageArguments() {
            return this.mMessageArguments;
        }
    }

    private static class ParseStatus {
        private DetailNode mTree;
        private ParseErrorMessage mParseErrorMessage;

        private ParseStatus() {
        }

        public DetailNode getTree() {
            return this.mTree;
        }

        public void setTree(DetailNode aTree) {
            this.mTree = aTree;
        }

        public ParseErrorMessage getParseErrorMessage() {
            return this.mParseErrorMessage;
        }

        public void setParseErrorMessage(ParseErrorMessage aParseErrorMessage) {
            this.mParseErrorMessage = aParseErrorMessage;
        }
    }

    class DescriptiveErrorListener
    extends BaseErrorListener {
        private static final String JAVADOC_PARSE_TOKEN_ERROR = "javadoc.parse.token.error";
        private static final String JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
        private static final String JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
        private static final String JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
        private int mOffset;
        private ParseErrorMessage mErrorMessage;

        DescriptiveErrorListener() {
        }

        public ParseErrorMessage getErrorMessage() {
            return this.mErrorMessage;
        }

        public void setOffset(int aOffset) {
            this.mOffset = aOffset;
        }

        public void syntaxError(Recognizer<?, ?> aRecognizer, Object aOffendingSymbol, int aLine, int aCharPositionInLine, String aMsg, RecognitionException aEx) {
            int lineNumber = this.mOffset + aLine;
            Token token = (Token)aOffendingSymbol;
            if (JAVADOC_MISSED_HTML_CLOSE.equals(aMsg)) {
                this.mErrorMessage = new ParseErrorMessage(lineNumber, JAVADOC_MISSED_HTML_CLOSE, aCharPositionInLine, token.getText());
                throw new ParseCancellationException();
            }
            if (JAVADOC_WRONG_SINGLETON_TAG.equals(aMsg)) {
                this.mErrorMessage = new ParseErrorMessage(lineNumber, JAVADOC_WRONG_SINGLETON_TAG, aCharPositionInLine, token.getText());
                throw new ParseCancellationException();
            }
            RuleContext ruleContext = aEx.getCtx();
            if (ruleContext != null) {
                int ruleIndex = aEx.getCtx().getRuleIndex();
                String ruleName = aRecognizer.getRuleNames()[ruleIndex];
                String upperCaseRuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ruleName);
                this.mErrorMessage = new ParseErrorMessage(lineNumber, JAVADOC_PARSE_RULE_ERROR, aCharPositionInLine, aMsg, upperCaseRuleName);
            } else {
                this.mErrorMessage = new ParseErrorMessage(lineNumber, JAVADOC_PARSE_TOKEN_ERROR, aCharPositionInLine, aMsg, aCharPositionInLine);
            }
        }
    }
}

