/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.jute.Record;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnLogTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FileTxnLogTest.class);
    private static final int KB = 1024;

    @Test
    public void testInvalidPreallocSize() {
        Assert.assertEquals((String)"file should not be padded", (long)10240L, (long)FileTxnLog.calculateFileSizeWithPadding((long)7168L, (long)10240L, (long)0L));
        Assert.assertEquals((String)"file should not be padded", (long)10240L, (long)FileTxnLog.calculateFileSizeWithPadding((long)7168L, (long)10240L, (long)-1L));
    }

    @Test
    public void testCalculateFileSizeWithPaddingWhenNotToCurrentSize() {
        Assert.assertEquals((String)"file should not be padded", (long)10240L, (long)FileTxnLog.calculateFileSizeWithPadding((long)5120L, (long)10240L, (long)10240L));
    }

    @Test
    public void testCalculateFileSizeWithPaddingWhenCloseToCurrentSize() {
        Assert.assertEquals((String)"file should be padded an additional 10 KB", (long)20480L, (long)FileTxnLog.calculateFileSizeWithPadding((long)7168L, (long)10240L, (long)10240L));
    }

    @Test
    public void testFileSizeGreaterThanPosition() {
        Assert.assertEquals((String)"file should be padded to 40 KB", (long)40960L, (long)FileTxnLog.calculateFileSizeWithPadding((long)31744L, (long)10240L, (long)10240L));
    }

    @Test
    public void testPreAllocSizeSmallerThanTxnData() throws IOException {
        File logDir = ClientBase.createTmpDir();
        FileTxnLog fileTxnLog = new FileTxnLog(logDir);
        int preAllocSize = 512000;
        FileTxnLog.setPreallocSize((long)512000L);
        byte[] data = new byte[1024000];
        Arrays.fill(data, (byte)-1);
        fileTxnLog.append(new TxnHeader(1L, 1, 1L, 1L, 1), (Record)new CreateTxn("/testPreAllocSizeSmallerThanTxnData1", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0));
        fileTxnLog.commit();
        fileTxnLog.append(new TxnHeader(1L, 1, 2L, 2L, 1), (Record)new CreateTxn("/testPreAllocSizeSmallerThanTxnData2", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, false, 0));
        fileTxnLog.commit();
        fileTxnLog.close();
        FileTxnLog.FileTxnIterator fileTxnIterator = new FileTxnLog.FileTxnIterator(logDir, 0L);
        CreateTxn createTxn = (CreateTxn)fileTxnIterator.getTxn();
        Assert.assertTrue((boolean)Arrays.equals(createTxn.getData(), data));
        fileTxnIterator.next();
        createTxn = (CreateTxn)fileTxnIterator.getTxn();
        Assert.assertTrue((boolean)Arrays.equals(createTxn.getData(), new byte[0]));
    }
}

