/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.util.HashMap;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLEDontCareTest {
    protected static final Logger LOG = LoggerFactory.getLogger(FLEDontCareTest.class);
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    QuorumPeer peer;
    File tmpdir;

    @Before
    public void setUp() throws Exception {
        this.tmpdir = ClientBase.createTmpDir();
        this.peers = new HashMap();
        for (int i = 0; i < 5; ++i) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(Long.valueOf(i).longValue(), "127.0.0.1", Integer.valueOf(PortAssignment.unique()), Integer.valueOf(0), null));
        }
        this.peer = new QuorumPeer(this.peers, this.tmpdir, this.tmpdir, PortAssignment.unique(), 3, 3L, 1000, 2, 2);
    }

    @After
    public void tearDown() {
        this.tmpdir.delete();
    }

    @Test
    public void testDontCare() {
        MockFLE fle = new MockFLE(this.peer, this.peer.createCnxnManager());
        HashMap<Long, Vote> votes = new HashMap<Long, Vote>();
        votes.put(0L, new Vote(1, 4L, ZxidUtils.makeZxid((long)1L, (long)1L), 1L, 2L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(1L, new Vote(1, 4L, ZxidUtils.makeZxid((long)1L, (long)2L), 1L, 2L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(3L, new Vote(1, 4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(4L, new Vote(1, 4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.LEADING));
        Assert.assertTrue((boolean)fle.termPredicate(votes, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.FOLLOWING)));
    }

    @Test
    public void testDontCareVersion() {
        MockFLE fle = new MockFLE(this.peer, this.peer.createCnxnManager());
        HashMap<Long, Vote> votes = new HashMap<Long, Vote>();
        votes.put(0L, new Vote(1, 4L, ZxidUtils.makeZxid((long)1L, (long)1L), 1L, 1L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(1L, new Vote(1, 4L, ZxidUtils.makeZxid((long)1L, (long)1L), 1L, 1L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(3L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.FOLLOWING));
        votes.put(4L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.LEADING));
        Assert.assertTrue((boolean)fle.termPredicate(votes, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.FOLLOWING)));
    }

    @Test
    public void testLookingNormal() {
        MockFLE fle = new MockFLE(this.peer, this.peer.createCnxnManager());
        HashMap<Long, Vote> votes = new HashMap<Long, Vote>();
        votes.put(0L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING));
        votes.put(1L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING));
        votes.put(3L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING));
        votes.put(4L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LEADING));
        Assert.assertTrue((boolean)fle.termPredicate(votes, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING)));
    }

    @Test
    public void testLookingDiffRounds() {
        MockFLE fle = new MockFLE(this.peer, this.peer.createCnxnManager());
        HashMap<Long, Vote> votes = new HashMap<Long, Vote>();
        votes.put(0L, new Vote(4L, ZxidUtils.makeZxid((long)1L, (long)1L), 1L, 1L, QuorumPeer.ServerState.LOOKING));
        votes.put(1L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.LOOKING));
        votes.put(3L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 3L, 2L, QuorumPeer.ServerState.LOOKING));
        votes.put(4L, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 3L, 2L, QuorumPeer.ServerState.LEADING));
        Assert.assertFalse((boolean)fle.termPredicate(votes, new Vote(4L, ZxidUtils.makeZxid((long)2L, (long)1L), 2L, 2L, QuorumPeer.ServerState.LOOKING)));
    }

    FastLeaderElection.Notification genNotification(int version, long leader, long zxid, long electionEpoch, QuorumPeer.ServerState state, long sid, long peerEpoch, HashMap<Long, Vote> outofelection) {
        FastLeaderElection.Notification n = new FastLeaderElection.Notification();
        n.version = version;
        n.leader = leader;
        n.zxid = zxid;
        n.electionEpoch = electionEpoch;
        n.state = state;
        n.sid = sid;
        n.peerEpoch = peerEpoch;
        outofelection.put(n.sid, new Vote(n.version, n.leader, n.zxid, n.electionEpoch, n.peerEpoch, n.state));
        return n;
    }

    @Test
    public void testOutofElection() {
        MockFLE fle = new MockFLE(this.peer, this.peer.createCnxnManager());
        HashMap<Long, Vote> outofelection = new HashMap<Long, Vote>();
        this.genNotification(0, 5L, ZxidUtils.makeZxid((long)15L, (long)0L), 10L, QuorumPeer.ServerState.FOLLOWING, 1L, 23L, outofelection);
        this.genNotification(0, 5L, ZxidUtils.makeZxid((long)15L, (long)0L), 10L, QuorumPeer.ServerState.FOLLOWING, 2L, 23L, outofelection);
        this.genNotification(1, 5L, ZxidUtils.makeZxid((long)15L, (long)0L), 10L, QuorumPeer.ServerState.FOLLOWING, 4L, 24L, outofelection);
        FastLeaderElection.Notification n = this.genNotification(1, 5L, ZxidUtils.makeZxid((long)15L, (long)0L), 10L, QuorumPeer.ServerState.LEADING, 5L, 24L, outofelection);
        fle.logicalclock.set(1L);
        Assert.assertTrue((String)"Termination predicate failed", (boolean)fle.termPredicate(outofelection, new Vote(n.version, n.leader, n.zxid, n.electionEpoch, n.peerEpoch, n.state)));
        Assert.assertTrue((String)"Leader check failed", (boolean)fle.checkLeader(outofelection, n.leader, n.electionEpoch));
        Assert.assertTrue((String)"Out of election predicate failed", (boolean)fle.ooePredicate(outofelection, outofelection, n));
    }

    class MockFLE
    extends FastLeaderElection {
        MockFLE(QuorumPeer peer, QuorumCnxManager cnxManager) {
            super(peer, cnxManager);
        }

        public boolean termPredicate(HashMap<Long, Vote> votes, Vote vote) {
            return super.termPredicate(votes, vote);
        }

        public boolean checkLeader(HashMap<Long, Vote> votes, long leader, long electionEpoch) {
            return super.checkLeader(votes, leader, electionEpoch);
        }

        public boolean ooePredicate(HashMap<Long, Vote> recv, HashMap<Long, Vote> ooe, FastLeaderElection.Notification n) {
            return super.ooePredicate(recv, ooe, n);
        }
    }
}

