/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLTest
extends ZKTestCase
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ACLTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private volatile CountDownLatch startSignal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisconnectedAddAuth() throws Exception {
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            ZooKeeper zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
            try {
                zk.addAuthInfo("digest", "pat:test".getBytes());
                zk.setACL("/", (List)ZooDefs.Ids.CREATOR_ALL_ACL, -1);
            }
            finally {
                zk.close();
            }
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAcls() throws Exception {
        ArrayList<ACL> list;
        Id id;
        ACL acl;
        int j;
        String path;
        ZooKeeper zk;
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        SyncRequestProcessor.setSnapCount((int)1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            LOG.info("starting up the zookeeper server .. waiting");
            Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
            LOG.info("starting creating acls");
            for (int i = 0; i < 100; ++i) {
                path = "/" + i;
                zk.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            Assert.assertTrue((String)"size of the acl map ", (1 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0);
            for (j = 100; j < 200; ++j) {
                path = "/" + j;
                acl = new ACL();
                acl.setPerms(0);
                id = new Id();
                id.setId("1.1.1." + j);
                id.setScheme("ip");
                acl.setId(id);
                list = new ArrayList<ACL>();
                list.add(acl);
                zk.create(path, path.getBytes(), list, CreateMode.PERSISTENT);
            }
            Assert.assertTrue((String)"size of the acl map ", (101 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0);
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
        this.startSignal = new CountDownLatch(1);
        zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        f = ServerCnxnFactory.createFactory((int)PORT, (int)-1);
        f.startup(zks);
        try {
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
            this.startSignal.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)"count == 0", (this.startSignal.getCount() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)"acl map ", (101 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0);
            for (j = 200; j < 205; ++j) {
                path = "/" + j;
                acl = new ACL();
                acl.setPerms(0);
                id = new Id();
                id.setId("1.1.1." + j);
                id.setScheme("ip");
                acl.setId(id);
                list = new ArrayList();
                list.add(acl);
                zk.create(path, path.getBytes(), list, CreateMode.PERSISTENT);
            }
            Assert.assertTrue((String)"acl map ", (106 == zks.getZKDatabase().getAclSize() ? 1 : 0) != 0);
            zk.close();
        }
        finally {
            f.shutdown();
            zks.shutdown();
            Assert.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
    }

    public void process(WatchedEvent event) {
        LOG.info("Event:" + event.getState() + " " + event.getType() + " " + event.getPath());
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            if (this.startSignal != null && this.startSignal.getCount() > 0L) {
                LOG.info("startsignal.countDown()");
                this.startSignal.countDown();
            } else {
                LOG.warn("startsignal " + this.startSignal);
            }
        }
    }
}

