/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Properties;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.system.DuplicateNameException;
import org.apache.zookeeper.test.system.Instance;
import org.apache.zookeeper.test.system.InstanceManager;
import org.apache.zookeeper.test.system.NoAssignmentException;
import org.apache.zookeeper.test.system.NoAvailableContainers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuorumPeerInstance
implements Instance {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumPeerInstance.class);
    private static final File testData = new File(System.getProperty("test.data.dir", "build/test/data"));
    private static final int syncLimit = 3;
    private static final int initLimit = 3;
    private static final int tickTime = 2000;
    String serverHostPort;
    int serverId;
    Instance.Reporter r;
    QuorumPeer peer;
    InetSocketAddress clientAddr;
    InetSocketAddress quorumAddr;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    File snapDir;
    File logDir;

    @Override
    public void setReporter(Instance.Reporter r) {
        this.r = r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuorumPeerInstance() {
        try {
            Properties p;
            File tmpFile = File.createTempFile("test", ".dir", testData);
            File tmpDir = tmpFile.getParentFile();
            tmpFile.delete();
            File zkDirs = new File(tmpDir, "zktmp.cfg");
            this.logDir = tmpDir;
            this.snapDir = tmpDir;
            if (zkDirs.exists()) {
                p = new Properties();
                FileInputStream input = new FileInputStream(zkDirs);
                try {
                    p.load(input);
                }
                finally {
                    input.close();
                }
            } else {
                p = System.getProperties();
            }
            this.logDir = new File(p.getProperty("logDir", tmpDir.getAbsolutePath()));
            this.snapDir = new File(p.getProperty("snapDir", tmpDir.getAbsolutePath()));
            this.logDir = File.createTempFile("zktst", ".dir", this.logDir);
            this.logDir.delete();
            this.logDir.mkdirs();
            this.snapDir = File.createTempFile("zktst", ".dir", this.snapDir);
            this.snapDir.delete();
            this.snapDir.mkdirs();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void configure(String params) {
        int i;
        if (this.clientAddr == null) {
            ServerSocket ss;
            String[] parts = params.split(" ");
            this.serverId = Integer.parseInt(parts[0]);
            if (LOG.isDebugEnabled()) {
                LOG.info("Setting up server " + this.serverId);
            }
            if (parts.length > 1 && parts[1].equals("false")) {
                System.setProperty("zookeeper.leaderServes", "no");
            } else {
                System.setProperty("zookeeper.leaderServes", "yes");
            }
            try {
                ss = new ServerSocket(0, 1, InetAddress.getLocalHost());
                this.clientAddr = (InetSocketAddress)ss.getLocalSocketAddress();
                ss.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                ss = new ServerSocket(0, 1, InetAddress.getLocalHost());
                this.quorumAddr = (InetSocketAddress)ss.getLocalSocketAddress();
                ss.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String report = this.clientAddr.getHostName() + ':' + this.clientAddr.getPort() + ',' + this.quorumAddr.getHostName() + ':' + this.quorumAddr.getPort();
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reporting " + report);
                }
                this.r.report(report);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        int spaceIndex = params.indexOf(32);
        if (spaceIndex == -1) {
            LOG.warn("looking for host:port,... start|stop, but found " + params);
            return;
        }
        String quorumSpecs = params.substring(0, spaceIndex);
        String cmd = params.substring(spaceIndex + 1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running command: " + cmd);
        }
        if (!cmd.equals("start")) {
            if (this.peer != null) {
                this.peer.shutdown();
            }
            this.peer = null;
            try {
                for (int i2 = 0; i2 < 5; ++i2) {
                    Thread.sleep(500L);
                    try {
                        new Socket("127.0.0.1", this.clientAddr.getPort()).close();
                        continue;
                    }
                    catch (IOException e) {
                        break;
                    }
                }
                this.r.report("stopped");
            }
            catch (Exception e) {
                LOG.error("Unhandled error", (Throwable)e);
            }
            return;
        }
        String[] parts = quorumSpecs.split(",");
        this.peers = new HashMap();
        for (i = 0; i < parts.length; ++i) {
            String[] subparts = parts[i].split(":");
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, subparts[0], Integer.valueOf(Integer.parseInt(subparts[1])), Integer.valueOf(0), null));
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting quorumPeer " + this.serverId + " on port " + this.clientAddr.getPort());
            }
            if (this.peer != null) {
                LOG.warn("Peer " + this.serverId + " already started");
                return;
            }
            System.err.println("SnapDir = " + this.snapDir + " LogDir = " + this.logDir);
            this.peer = new QuorumPeer(this.peers, this.snapDir, this.logDir, this.clientAddr.getPort(), 0, (long)this.serverId, 2000, 3, 3);
            this.peer.start();
            for (i = 0; i < 5; ++i) {
                Thread.sleep(500L);
                try {
                    new Socket("127.0.0.1", this.clientAddr.getPort()).close();
                    break;
                }
                catch (IOException iOException) {
                    continue;
                }
            }
            this.r.report("started");
        }
        catch (Exception e) {
            LOG.error("Unhandled exception", (Throwable)e);
        }
    }

    @Override
    public void start() {
    }

    private static void recursiveDelete(File dir) {
        if (!dir.isDirectory()) {
            dir.delete();
            return;
        }
        for (File f : dir.listFiles()) {
            QuorumPeerInstance.recursiveDelete(f);
        }
        dir.delete();
    }

    @Override
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping peer " + this.serverId);
        }
        if (this.peer != null) {
            this.peer.shutdown();
        }
        if (this.logDir != null) {
            QuorumPeerInstance.recursiveDelete(this.logDir);
        }
        if (this.snapDir != null) {
            QuorumPeerInstance.recursiveDelete(this.snapDir);
        }
    }

    public static String[] createServer(InstanceManager im, int i) throws NoAvailableContainers, DuplicateNameException, InterruptedException, KeeperException {
        return QuorumPeerInstance.createServer(im, i, true);
    }

    public static String[] createServer(InstanceManager im, int i, boolean leaderServes) throws NoAvailableContainers, DuplicateNameException, InterruptedException, KeeperException {
        im.assignInstance("server" + i, QuorumPeerInstance.class, Integer.toString(i) + " " + leaderServes, 50);
        return im.getStatus("server" + i, 3000L).split(",");
    }

    public static void startInstance(InstanceManager im, String quorumHostPort, int index) throws InterruptedException, KeeperException, NoAssignmentException {
        im.resetStatus("server" + index);
        im.reconfigureInstance("server" + index, quorumHostPort + " start");
        im.getStatus("server" + index, 5000L);
    }

    public static void stopInstance(InstanceManager im, int index) throws InterruptedException, KeeperException, NoAssignmentException {
        im.resetStatus("server" + index);
        im.reconfigureInstance("server" + index, Integer.toString(index) + " stop");
        im.getStatus("server" + index, 3000L);
    }
}

