/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.graph.filterops;

import org.apache.zookeeper.graph.FilterException;
import org.apache.zookeeper.graph.FilterOp;
import org.apache.zookeeper.graph.LogEntry;
import org.apache.zookeeper.graph.filterops.Arg;

public class LessThanOp
extends FilterOp {
    @Override
    public boolean matches(LogEntry entry) throws FilterException {
        Arg first = (Arg)this.args.get(0);
        if (first != null) {
            FilterOp.ArgType type = first.getType();
            if (type == FilterOp.ArgType.SYMBOL) {
                String key = (String)first.getValue();
                Object v = entry.getAttribute(key);
                if (v instanceof String) {
                    type = FilterOp.ArgType.STRING;
                } else if (v instanceof Double || v instanceof Long || v instanceof Integer || v instanceof Short) {
                    type = FilterOp.ArgType.NUMBER;
                } else {
                    throw new FilterException("LessThanOp: Invalid argument, first argument resolves to neither a String nor a Number");
                }
            }
            Object last = null;
            for (Arg a : this.args) {
                Object v = a.getValue();
                if (a.getType() == FilterOp.ArgType.SYMBOL) {
                    String key = (String)a.getValue();
                    v = entry.getAttribute(key);
                }
                if (last != null && (type == FilterOp.ArgType.STRING ? ((String)last).compareTo((String)v) >= 0 : type == FilterOp.ArgType.NUMBER && ((Number)last).doubleValue() >= ((Number)v).doubleValue())) {
                    return false;
                }
                last = v;
            }
            return true;
        }
        return true;
    }
}

