/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public class WeakReference
extends LispObject {
    java.lang.ref.WeakReference<LispObject> ref;
    private static final Primitive MAKE_WEAK_REFERENCE = new pf_make_weak_reference();
    private static final Primitive WEAK_REFERENCE_VALUE = new pf_weak_reference_value();

    public WeakReference(LispObject ref) {
        this.ref = new java.lang.ref.WeakReference<LispObject>(ref);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.WEAK_REFERENCE;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.WEAK_REFERENCE;
    }

    @Override
    public String printObject() {
        return this.unreadableString("WEAK-REFERENCE " + this.toString());
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.WEAK_REFERENCE) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.WEAK_REFERENCE) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    @DocString(name="make-weak-reference", args="obj", doc="Creates a weak reference to 'obj'.")
    private static final class pf_make_weak_reference
    extends Primitive {
        pf_make_weak_reference() {
            super("make-weak-reference", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject obj) {
            return new WeakReference(obj);
        }
    }

    @DocString(name="weak-reference-value", args="obj", doc="Returns two values, the first being the value of the weak ref,the second T if the reference is valid, or NIL if it hasbeen cleared.")
    private static final class pf_weak_reference_value
    extends Primitive {
        pf_weak_reference_value() {
            super("weak-reference-value", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject obj) {
            if (!(obj instanceof WeakReference)) {
                return Lisp.type_error(obj, Symbol.WEAK_REFERENCE);
            }
            LispObject value = (LispObject)((WeakReference)obj).ref.get();
            return LispThread.currentThread().setValues(value == null ? Lisp.NIL : value, value == null ? Lisp.NIL : Lisp.T);
        }
    }
}

