/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.io.IOException;
import org.caffinitas.ohc.tables.AbstractOffHeapDataOutput;
import org.caffinitas.ohc.tables.Murmur3;
import org.caffinitas.ohc.tables.Uns;

final class HashEntryKeyOutput
extends AbstractOffHeapDataOutput {
    final long keyLen;

    HashEntryKeyOutput(long hashEntryAdr, long keyLen) {
        super(hashEntryAdr, 40L, keyLen);
        this.keyLen = keyLen;
    }

    long hash() {
        long k2;
        long k1;
        long r;
        long o = 40L;
        long h1 = 0L;
        long h2 = 0L;
        for (r = this.keyLen; r >= 16L; r -= 16L) {
            k1 = this.getLong(o);
            k2 = this.getLong(o += 8L);
            o += 8L;
            h1 ^= Murmur3.mixK1(k1);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            h2 ^= Murmur3.mixK2(k2);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        if (r > 0L) {
            k1 = 0L;
            k2 = 0L;
            switch ((int)r) {
                case 15: {
                    k2 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 14L)) << 48;
                }
                case 14: {
                    k2 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 13L)) << 40;
                }
                case 13: {
                    k2 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 12L)) << 32;
                }
                case 12: {
                    k2 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 11L)) << 24;
                }
                case 11: {
                    k2 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 10L)) << 16;
                }
                case 10: {
                    k2 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 9L)) << 8;
                }
                case 9: {
                    k2 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 8L));
                }
                case 8: {
                    k1 ^= this.getLong(o);
                    break;
                }
                case 7: {
                    k1 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 6L)) << 48;
                }
                case 6: {
                    k1 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 5L)) << 40;
                }
                case 5: {
                    k1 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 4L)) << 32;
                }
                case 4: {
                    k1 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 3L)) << 24;
                }
                case 3: {
                    k1 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 2L)) << 16;
                }
                case 2: {
                    k1 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 1L)) << 8;
                }
                case 1: {
                    k1 ^= Murmur3.toLong(Uns.getByte(this.blkAdr, o));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
            h1 ^= Murmur3.mixK1(k1);
            h2 ^= Murmur3.mixK2(k2);
        }
        h1 ^= this.keyLen;
        h1 += (h2 ^= this.keyLen);
        h2 += h1;
        h1 = Murmur3.fmix64(h1);
        h2 = Murmur3.fmix64(h2);
        return h1 += h2;
    }

    private long getLong(long o) {
        long l = Murmur3.toLong(Uns.getByte(this.blkAdr, o + 7L)) << 56;
        l |= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 6L)) << 48;
        l |= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 5L)) << 40;
        l |= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 4L)) << 32;
        l |= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 3L)) << 24;
        l |= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 2L)) << 16;
        l |= Murmur3.toLong(Uns.getByte(this.blkAdr, o + 1L)) << 8;
        return l |= Murmur3.toLong(Uns.getByte(this.blkAdr, o));
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56 & 0xFFL));
        this.write((int)(v >>> 48 & 0xFFL));
        this.write((int)(v >>> 40 & 0xFFL));
        this.write((int)(v >>> 32 & 0xFFL));
        this.write((int)(v >>> 24 & 0xFFL));
        this.write((int)(v >>> 16 & 0xFFL));
        this.write((int)(v >>> 8 & 0xFFL));
        this.write((int)(v & 0xFFL));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }
}

