/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class ReplaceFunctionProcessor
implements Processor {
    private final Processor source;
    private final Processor pattern;
    private final Processor replacement;
    public static final String NAME = "srep";

    public ReplaceFunctionProcessor(Processor source, Processor pattern, Processor replacement) {
        this.source = source;
        this.pattern = pattern;
        this.replacement = replacement;
    }

    public ReplaceFunctionProcessor(StreamInput in) throws IOException {
        this.source = (Processor)in.readNamedWriteable(Processor.class);
        this.pattern = (Processor)in.readNamedWriteable(Processor.class);
        this.replacement = (Processor)in.readNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.source);
        out.writeNamedWriteable((NamedWriteable)this.pattern);
        out.writeNamedWriteable((NamedWriteable)this.replacement);
    }

    @Override
    public Object process(Object input) {
        return ReplaceFunctionProcessor.doProcess(this.source().process(input), this.pattern().process(input), this.replacement().process(input));
    }

    public static Object doProcess(Object source, Object pattern, Object replacement) {
        if (source == null) {
            return null;
        }
        if (!(source instanceof String) && !(source instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", source);
        }
        if (pattern == null || replacement == null) {
            return source;
        }
        if (!(pattern instanceof String) && !(pattern instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", pattern);
        }
        if (!(replacement instanceof String) && !(replacement instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", replacement);
        }
        return Strings.replace((String)(source instanceof Character ? source.toString() : (String)source), (String)(pattern instanceof Character ? pattern.toString() : (String)pattern), (String)(replacement instanceof Character ? replacement.toString() : (String)replacement));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceFunctionProcessor other = (ReplaceFunctionProcessor)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.replacement(), other.replacement());
    }

    public int hashCode() {
        return Objects.hash(this.source(), this.pattern(), this.replacement());
    }

    public Processor source() {
        return this.source;
    }

    public Processor pattern() {
        return this.pattern;
    }

    public Processor replacement() {
        return this.replacement;
    }

    public String getWriteableName() {
        return NAME;
    }
}

